% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{ArrayValidator}
\alias{ArrayValidator}
\title{A validator specifying constraints on an array node.}
\usage{
ArrayValidator(
  contains,
  id,
  itemsValidator,
  maxItems,
  meta,
  minItems,
  uniqueItems
)
}
\arguments{
\item{contains}{An array node is valid if at least one of its items is valid against the \code{contains} schema.}

\item{id}{The identifier for this item.}

\item{itemsValidator}{Another validator node specifying the constraints on all items in the array.}

\item{maxItems}{An array node is valid if its size is less than, or equal to, this value.}

\item{meta}{Metadata associated with this item.}

\item{minItems}{An array node is valid if its size is greater than, or equal to, this value.}

\item{uniqueItems}{A flag to indicate that each value in the array should be unique.}
}
\value{
A \code{list} of class \code{ArrayValidator}
}
\description{
A validator specifying constraints on an array node.
}
\seealso{
\code{\link{Entity}}
}
