% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{PublicationVolume}
\alias{PublicationVolume}
\title{A part of a successively published publication such as a periodical or multi-volume work.}
\usage{
PublicationVolume(
  about,
  alternateNames,
  authors,
  comments,
  content,
  dateAccepted,
  dateCreated,
  dateModified,
  datePublished,
  dateReceived,
  description,
  editors,
  fundedBy,
  funders,
  genre,
  id,
  identifiers,
  images,
  isPartOf,
  keywords,
  licenses,
  maintainers,
  meta,
  name,
  pageEnd,
  pageStart,
  pagination,
  parts,
  publisher,
  references,
  text,
  title,
  url,
  version,
  volumeNumber
)
}
\arguments{
\item{about}{The subject matter of the content.}

\item{alternateNames}{Alternate names (aliases) for the item.}

\item{authors}{The authors of this creative work.}

\item{comments}{Comments about this creative work.}

\item{content}{The structured content of this creative work c.f. property \code{text}.}

\item{dateAccepted}{Date/time of acceptance.}

\item{dateCreated}{Date/time of creation.}

\item{dateModified}{Date/time of most recent modification.}

\item{datePublished}{Date of first publication.}

\item{dateReceived}{Date/time that work was received.}

\item{description}{A description of the item.}

\item{editors}{People who edited the \code{CreativeWork}.}

\item{fundedBy}{Grants that funded the \code{CreativeWork}; reverse of \code{fundedItems}.}

\item{funders}{People or organizations that funded the \code{CreativeWork}.}

\item{genre}{Genre of the creative work, broadcast channel or group.}

\item{id}{The identifier for this item.}

\item{identifiers}{Any kind of identifier for any kind of Thing.}

\item{images}{Images of the item.}

\item{isPartOf}{An item or other CreativeWork that this CreativeWork is a part of.}

\item{keywords}{Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.}

\item{licenses}{License documents that applies to this content, typically indicated by URL.}

\item{maintainers}{The people or organizations who maintain this CreativeWork.}

\item{meta}{Metadata associated with this item.}

\item{name}{The name of the item.}

\item{pageEnd}{The page on which the volume ends; for example "138" or "xvi".}

\item{pageStart}{The page on which the volume starts; for example "135" or "xiii".}

\item{pagination}{Any description of pages that is not separated into pageStart and pageEnd; for example, "1-6, 9, 55".}

\item{parts}{Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.}

\item{publisher}{A publisher of the CreativeWork.}

\item{references}{References to other creative works, such as another publication, web page, scholarly article, etc.}

\item{text}{The textual content of this creative work.}

\item{title}{The title of the creative work.}

\item{url}{The URL of the item.}

\item{version}{The version of the creative work.}

\item{volumeNumber}{Identifies the volume of publication or multi-part work; for example, "iii" or "2".}
}
\value{
A \code{list} of class \code{PublicationVolume}
}
\description{
A part of a successively published publication such as a periodical or multi-volume work.
}
\seealso{
\code{\link{CreativeWork}}
}
