% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithms_2sided.R
\name{rnabox}
\alias{rnabox}
\title{Recursive Neyman Algorithm for Optimal Sample Allocation Under Box Constraints}
\usage{
rnabox(
  n,
  A,
  bounds1 = NULL,
  bounds2 = NULL,
  check_violations1 = .Primitive(">="),
  check_violations2 = .Primitive("<=")
)
}
\arguments{
\item{n}{(\code{number})\cr total sample size. A strictly positive scalar.
If \code{bounds1} is not \code{NULL}, it is then required that \code{n >= sum(bounds1)}
(given that \code{bounds1} are treated as lower bounds) or \code{n <= sum(bounds1)}
(given that \code{bounds1} are treated as upper bounds).
If \code{bounds2} is not \code{NULL}, it is then required that \code{n >= sum(bounds2)}
(given that \code{bounds2} are treated as lower bounds) or \code{n <= sum(bounds2)}
(given that \code{bounds2} are treated as upper bounds).}

\item{A}{(\code{numeric})\cr population constants \eqn{A_1,\ldots,A_H}. Strictly
positive numbers.}

\item{bounds1}{(\code{numeric} or \code{NULL})\cr lower bounds \eqn{m_1,\ldots,m_H},
or upper bounds \eqn{M_1,\ldots,M_H} optionally imposed on sample sizes in
strata. The interpretation of \code{bounds1} depends on the value of
\code{check_violations1}. If no one-sided bounds 1 should be imposed, then
\code{bounds1} must be set to \code{NULL}. If \code{bounds2} is not \code{NULL}, it is then
required that either \code{bounds1 < bounds2} (in case when \code{bounds1} is treated
as lower bounds) or \code{bounds1 > bounds2} (in the opposite case).}

\item{bounds2}{(\code{numeric} or \code{NULL})\cr lower bounds \eqn{m_1,\ldots,m_H},
or upper bounds \eqn{M_1,\ldots,M_H} optionally imposed on sample sizes in
strata. The interpretation of \code{bounds2} depends on the value of
\code{check_violations2}. If no one-sided bounds 2 should be imposed, then
\code{bounds2} must be set to \code{NULL}. If \code{bounds2} is not \code{NULL}, it is then
required that either \code{bounds1 < bounds2} (in case when \code{bounds1} is treated
as lower bounds) or \code{bounds1 > bounds2} (in the opposite case).}

\item{check_violations1}{(\code{function}) \cr 2-arguments binary operator function
that allows the comparison of values in atomic vectors. It must either be
set to \code{.Primitive("<=")} or \code{.Primitive(">=")}.
The first of these choices causes that \code{bounds1} are treated as lower
bounds and the \code{rnabox()} uses the \emph{LRNA} algorithm as in interim
algorithm for the allocation problem with one-sided lower bounds \code{bounds1}.
The latter option causes that \code{bounds1} are treated as upper bounds and the
\code{rnabox()} uses the \emph{RNA} algorithm as in interim algorithm for the
allocation problem with one-sided upper bounds \code{bounds1}.
This parameter is correlated with \code{check_violations2}. That is, these
arguments must be set against each other.
\code{check_violations1} is ignored when \code{bounds1} is set to \code{NULL}.}

\item{check_violations2}{(\code{function}) \cr 2-arguments binary operator function
that allows the comparison of values in atomic vectors. It must either be
set to \code{.Primitive("<=")} or \code{.Primitive(">=")}.
The first of these choices causes that \code{bounds2} are treated as lower
bounds and the \code{rnabox()} uses the \emph{LRNA} algorithm as in interim
algorithm for the allocation problem with one-sided lower bounds \code{bounds2}.
The latter option causes that \code{bounds2} are treated as upper bounds and the
\code{rnabox()} uses the \emph{RNA} algorithm as in interim algorithm for the
allocation problem with one-sided upper bounds \code{bounds2}.
This parameter is correlated with \code{check_violations1}. That is, these
arguments must be set against each other.
\code{check_violations2} is ignored when \code{bounds2} is set to \code{NULL}.}
}
\value{
Numeric vector with optimal sample allocations in strata.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

An internal function that implements the \code{RNABOX} algorithm that solves the
following optimal allocation problem, formulated below in the language of
mathematical optimization.

Minimize
\deqn{f(x_1,\ldots,x_H) = \sum_{h=1}^H \frac{A^2_h}{x_h}}
subject to
\deqn{\sum_{h=1}^H x_h = n}
\deqn{m_h \leq x_h \leq M_h, \quad h = 1,\ldots,H,}
where \eqn{n > 0,\, A_h > 0,\, m_h > 0,\, M_h > 0}, such that
\eqn{m_h < M_h,\, h = 1,\ldots,H}, and
\eqn{\sum_{h=1}^H m_h \leq n \leq \sum_{h=1}^H M_h}, are given numbers.
The minimization is on \eqn{\mathbb R_+^H}.
Inequality constraints are optional and can be skipped.

\code{rnabox()} function should not be called directly by the user. Use \code{\link[=opt]{opt()}}
instead.
}
\examples{
N <- c(454, 10, 116, 2500, 2240, 260, 39, 3000, 2500, 400)
S <- c(0.9, 5000, 32, 0.1, 3, 5, 300, 13, 20, 7)
A <- N * S
m <- c(322, 3, 57, 207, 715, 121, 9, 1246, 1095, 294) # lower bounds
M <- N # upper bounds

# Regular allocation.
n <- 6000
opt_regular <- rnabox(n, A, M, m)

# Vertex allocation.
n <- 4076
opt_vertex <- rnabox(n, A, M, m)
}
\references{
To be added soon.
}
\seealso{
\code{\link[=opt]{opt()}}, \code{\link[=optcost]{optcost()}}, \code{\link[=sga]{sga()}}, \code{\link[=sgaplus]{sgaplus()}}, \code{\link[=coma]{coma()}}.
}
