% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{str_extract}
\alias{str_extract}
\alias{str_extract_all}
\title{Extract the complete match}
\usage{
str_extract(string, pattern, group = NULL)

str_extract_all(string, pattern, simplify = FALSE)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{pattern}{Pattern to look for.

The default interpretation is a regular expression, as described in
\code{vignette("regular-expressions")}. Use \code{\link[=regex]{regex()}} for finer control of the
matching behaviour.

Match a fixed string (i.e. by comparing only bytes), using
\code{\link[=fixed]{fixed()}}. This is fast, but approximate. Generally,
for matching human text, you'll want \code{\link[=coll]{coll()}} which
respects character matching rules for the specified locale.

Match character, word, line and sentence boundaries with
\code{\link[=boundary]{boundary()}}. An empty pattern, "", is equivalent to
\code{boundary("character")}.}

\item{group}{If supplied, instead of returning the complete match, will
return the matched text from the specified capturing group.}

\item{simplify}{A boolean.
\itemize{
\item \code{FALSE} (the default): returns a list of character vectors.
\item \code{TRUE}: returns a character matrix.
}}
}
\value{
\itemize{
\item \code{str_extract()}: an character vector the same length as \code{string}/\code{pattern}.
\item \code{str_extract_all()}: a list of character vectors the same length as
\code{string}/\code{pattern}.
}
}
\description{
\code{str_extract()} extracts the first complete match from each string,
\code{str_extract_all()}extracts all matches from each string.
}
\examples{
shopping_list <- c("apples x4", "bag of flour", "bag of sugar", "milk x2")
str_extract(shopping_list, "\\\\d")
str_extract(shopping_list, "[a-z]+")
str_extract(shopping_list, "[a-z]{1,4}")
str_extract(shopping_list, "\\\\b[a-z]{1,4}\\\\b")

str_extract(shopping_list, "([a-z]+) of ([a-z]+)")
str_extract(shopping_list, "([a-z]+) of ([a-z]+)", group = 1)
str_extract(shopping_list, "([a-z]+) of ([a-z]+)", group = 2)

# Extract all matches
str_extract_all(shopping_list, "[a-z]+")
str_extract_all(shopping_list, "\\\\b[a-z]+\\\\b")
str_extract_all(shopping_list, "\\\\d")

# Simplify results into character matrix
str_extract_all(shopping_list, "\\\\b[a-z]+\\\\b", simplify = TRUE)
str_extract_all(shopping_list, "\\\\d", simplify = TRUE)

# Extract all words
str_extract_all("This is, suprisingly, a sentence.", boundary("word"))
}
\seealso{
\code{\link[=str_match]{str_match()}} to extract matched groups;
\code{\link[stringi:stri_extract]{stringi::stri_extract()}} for the underlying implementation.
}
