% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove.R
\name{str_remove}
\alias{str_remove}
\alias{str_remove_all}
\title{Remove matched patterns}
\usage{
str_remove(string, pattern)

str_remove_all(string, pattern)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{pattern}{Pattern to look for.

The default interpretation is a regular expression, as described in
\code{vignette("regular-expressions")}. Use \code{\link[=regex]{regex()}} for finer control of the
matching behaviour.

Match a fixed string (i.e. by comparing only bytes), using
\code{\link[=fixed]{fixed()}}. This is fast, but approximate. Generally,
for matching human text, you'll want \code{\link[=coll]{coll()}} which
respects character matching rules for the specified locale.

You can not match boundaries, including \code{""}, with this function.}
}
\value{
A character vector the same length as \code{string}/\code{pattern}.
}
\description{
Remove matches, i.e. replace them with \code{""}.
}
\examples{
fruits <- c("one apple", "two pears", "three bananas")
str_remove(fruits, "[aeiou]")
str_remove_all(fruits, "[aeiou]")
}
\seealso{
\code{\link[=str_replace]{str_replace()}} for the underlying implementation.
}
