% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace.R
\name{strs_replace}
\alias{strs_replace}
\title{Replace substring in a string}
\usage{
strs_replace(string, substring, replacement)
}
\arguments{
\item{string}{A character vector where each element is a string in which to
replace \code{substring}.}

\item{substring}{The substring to be replaced.}

\item{replacement}{The string to replace \code{substring} with.}
}
\value{
A character vector of the same length as \code{string}, with \code{substring}
replaced by \code{replacement}.
}
\description{
\code{strs_replace} replaces all occurrences of a specified substring in each
element of a character vector. It is similar to Python's \code{str.replace()}
method.
}
\examples{
strs_replace("hello world", "world", "there")
strs_replace("banana", "na", "mo")
}
\seealso{
\href{https://docs.python.org/3/library/stdtypes.html#str.replace}{Python str.replace() documentation}
}
