% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputs.R
\name{cumhaz}
\alias{cumhaz}
\title{Estimates of cumulative hazard from a survextrap model}
\usage{
cumhaz(
  x,
  newdata = NULL,
  t = NULL,
  tmax = NULL,
  niter = NULL,
  summ_fns = NULL,
  sample = FALSE,
  newdata0 = NULL,
  wane_period = NULL,
  wane_nt = 10
)
}
\arguments{
\item{x}{A fitted model object as returned by \code{\link{survextrap}}}

\item{newdata}{Data frame of covariate values to compute the output for.
If there are covariates in the model and this is not supplied,
the following default is used:

(a) if the only covariate is one factor variable, then the output is computed
for each level of this factor.

(b) if there are multiple covariates, or any numeric covariates, then the output
is computed at the mean of each numeric covariate in the original data, and at the
baseline level of each factor covariate.

Note: caution is required about how treatment groups (for example)
are stored in your data.  If these are coded as numeric (0/1),
then if \code{newdata} is not specified, only one output will be shown.
This relates to the average value of this numeric variable over
the data, which doesn't correspond to either of the treatment
groups.  To avoid this, a treatment group should be stored as a
factor.}

\item{t}{Vector of times at which to compute the estimates.}

\item{tmax}{Maximum time at which to compute the estimates.  If
\code{t} is supplied, then this is ignored.  If \code{t} is not
supplied, then \code{t} is set to a set of 100 equally spaced
time points from 0 to \code{tmax}.  If both \code{tmax} and \code{t}
are not supplied, then \code{tmax} is set to the maximum follow up time
in the data.}

\item{niter}{Number of MCMC iterations to use to compute credible
intervals.  Set to a low value to make this function quicker, at the cost of
some approximation error (which may not be important for plotting or model
development).}

\item{summ_fns}{A list of functions to use to summarise the posterior sample.
This is passed to \code{\link[posterior:summarise_draws]{posterior::summarise_draws}}.
By default this is \code{list(median=median, ~quantile(.x, probs=c(0.025, 0.975)))}.
If the list is named, then the names will be used for the columns of the
output.}

\item{sample}{If \code{TRUE} then the MCMC samples are returned instead
of being summarised as a median and 95\% credible intervals.}

\item{newdata0}{Data frame of covariate values defining the "untreated" group
for use in treatment waning models. See \code{\link{Survmspline_wane}}.}

\item{wane_period}{Vector of two numbers, defining the time period over which
the hazard is interpolated between the hazard of the "treated" group (taken from \code{newdata})
and the hazard of the "untreated" group (taken from \code{newdata0}).  Optional - if
this is not supplied, then no waning is assumed.}

\item{wane_nt}{Number of intervals defining the piecewise constant approximation
to the hazard during the waning period.}
}
\value{
A data frame (tibble) giving posterior summary statistics,
or (if \code{sample=TRUE}) an array giving samples from the
posterior.
}
\description{
Estimates of the cumulative hazard at particular times, from a \code{\link{survextrap}} model
}
