% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svrpath.R
\name{svrpath}
\alias{svrpath}
\title{Fit the entire regularization path for Support Vector Regression}
\usage{
svrpath(x, y, svr.eps = 1, kernel.function = radial.kernel,
  param.kernel = 1, ridge = 1e-08, eps = 1e-08, lambda.min = 1e-08, ...)
}
\arguments{
\item{x}{The data matrix (n x p) with n rows (observations) on p variables (columns)}

\item{y}{The real number valued response variable}

\item{svr.eps}{An epsilon in epsilon-insensitive loss function}

\item{kernel.function}{This is a user-defined function. Provided are \code{poly.kernel} (the default, with parameter set to default to a linear kernel) and \code{radial.kernel}}

\item{param.kernel}{The parameter(s) for the kernel. For this radial kernel, the parameter is known in the fields as "gamma". For the polynomial kernel, it is the "degree"}

\item{ridge}{Sometimes the algorithm encounters singularities; in this case a small value of ridge can help, default is \code{ridge = 1e-8}}

\item{eps}{A small machine number which is used to identify minimal step sizes}

\item{lambda.min}{The smallest value of lambda for termination of the algorithm. Default is \code{lambda = 1e-8}}

\item{...}{Generic compatibility}
}
\value{
A 'svrpath' object is returned, for which there are \code{lambda} values and corresponding values of \code{theta} for each data point.
}
\description{
This algorithm computes the entire regularization path for the support vector regression  with a relatively low cost compared to quadratic programming problem.
}
\examples{
set.seed(1)
n <- 30
p <- 50

x <- matrix(rnorm(n*p), n, p)
e <- rnorm(n, 0, 1)
beta <- c(1, 1, rep(0, p-2))
y <- x \%*\% beta + e
svr.eps <- 1
obj <- svrpath(x, y, svr.eps = svr.eps)
}
\seealso{
\code{\link{predict.svrpath}}, \code{\link{plot.svrpath}},  \code{\link{epspath}}
}
\author{
Do Hyun Kim, Seung Jun Shin
}
