% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wroc.plot.R
\name{wroc.plot}
\alias{wroc.plot}
\title{Estimation of the ROC curve of logistic regression models with complex survey data}
\usage{
wroc.plot(
  x,
  print.auc = TRUE,
  print.cutoff = FALSE,
  col.cutoff = "red",
  cex.text = 0.75,
  round.digits = 4
)
}
\arguments{
\item{x}{An object of class \code{wroc} obtained by means of the function \code{wroc()}.}

\item{print.auc}{A logical value. If \code{TRUE}, the value of the area under the ROCw curve (AUCw) is printed (default \code{print.auc = TRUE}).}

\item{print.cutoff}{A logical value. If \code{TRUE}, the value of the optimal cut-off point, and the corresponding weighted estimates of the sensitivity and specificity parameters are printed (default \code{print.cutoff = TRUE}).}

\item{col.cutoff}{A character string indicating the color in which the cut-off point is depicted. The default option is \code{col.cutoff = "red"}.}

\item{cex.text}{A numeric value indicating the size with which the information of the AUCw and optimal cut-off point is printed. The default option is \code{cex.text = 0.75}.}

\item{round.digits}{A numeric value indicating the number of digits that will be employed when printing the information about the AUCw and optimal cut-off point. The default option is \code{round.digits = 4}.}
}
\value{
a graph
}
\description{
Plot the ROC curve of a logistic regression model
considering sampling weights with complex survey data.
}
\details{
More information is given in the documentation of the \code{wroc()}, \code{wauc{}} and \code{wocp()} functions.
}
\examples{
data(example_data_wroc)

mycurve <- wroc(response.var = "y", phat.var = "phat", weights.var = "weights",
                data = example_data_wroc,
                tag.event = 1, tag.nonevent = 0,
                cutoff.method = "Youden")
wroc.plot(x = mycurve, print.auc = TRUE, print.cutoff = TRUE)

}
