% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrawSyntenyPlot.R
\name{draw.linear}
\alias{draw.linear}
\title{Linear synteny plot}
\usage{
draw.linear(
  output,
  sizefile,
  ...,
  directory = NULL,
  fileformat = "png",
  colours = colours.default,
  w = 13,
  h = 5,
  opacity = 0.5
)
}
\arguments{
\item{output}{output file name}

\item{sizefile}{Chromosome Size file}

\item{...}{synteny files (any number of alignment files can be entered)}

\item{directory}{string containing file path to chosen directory to save image file}

\item{fileformat}{output file format specified using the format \code{fileformat = "pdf"} (the default is "png")}

\item{colours}{concatenated string of chromosome IDs and assigned colours if desired using the format \code{colours = c("1" = "red", "2" = "blue", "3" = "green", "X" = "grey")} if the no colours are assigned default values will be used}

\item{w}{width of output image using the format \code{w = 13} (default)}

\item{h}{height of output image using the format \code{h = 5} (default)}

\item{opacity}{opacity of syntenic bands using the format \code{opacity = .5} (default)}
}
\value{
An image file showing the linear comparison drawings
}
\description{
Draw Linear Synteny Plots
}
\details{
This function draws linear synteny plots.

It requires:
\enumerate{
\item The desired output file name;
\item Tab separated file of all chromosome, scaffold, or contig lengths and the species identifier,
in order from first target species in the alignment files followed by the first reference species in the alignment files
-- top of file -- to the last target species and reference species in the alignment files -- end of file.
in this format:
chromosome ID, chromosome length, species identifier
\item files containing the syntenic blocks - one file per alignment, in order from first target/reference
(most recent species pairwise alignment in ancestral reconstruction data) alignment file
to last target/reference (ancestor pairwise alignment in ancestral reconstruction data) alignment file
following this format:
reference chromosome, reference start position, reference end position, target chromosome,
target start position, target end position, orient, reference species identifier, target species identifier
}

Please separate files by tab and ensure any species identifiers used between length and alignment files are matching (same identifiers and caseing)

There are optional parameters for some customization of this function:
\enumerate{
\item The format for saving the image i.e. png or pdf can be altered by inputting: \code{fileformat = "pdf"} (the default value is "png")
\item The colour of the synteny bands can be altered by inputting a concatenated string of chromosome IDs with assigned colour values which can be found with R colour Pallette
e.g. \code{colours = c("1" = "red", "2" = "blue", "3" = "green","4" = "orange", "5" = "purple","X" = "grey")} if no colours are assigned default values will be used but colours MUST be assigned to all chromosomes
\item The width of the image created can be changed by inputting: \code{w = 13} (default)
\item The height of the image created can be changed by inputting: \code{h = 5} (default)
\item The opacity of the ribbons can be changed by inputting: \code{opacity = .5} (default)
\item The directory where the image file should be saved, as default the image is saved to temporary directory, change by inputting: \code{directory = "path/to/directory"}
}

The function works using the chromosome length file to order the Y axis and provide chromosome lengths to draw chromosome ideograms and the alignment files provides coordinates to draw the alignment bands between ideograms

Example: \code{draw.linear("outputname", "example_lengths.txt", "example_alignment_1.txt", "example_alignment_2.txt", "example_alignment_3.txt", directory = "path/to/directory", fileformat = "pdf")}
}
\examples{

# Create objects containing file paths to external dataset
# (see vignette to follow examples with personal data)

length.file <- system.file("extdata", "example_lengths.txt", package = "syntenyPlotteR")
file1 <- system.file("extdata", "example_alignment_1.txt", package = "syntenyPlotteR")
file2 <- system.file("extdata", "example_alignment_2.txt", package = "syntenyPlotteR")
file3 <- system.file("extdata", "example_alignment_3.txt", package = "syntenyPlotteR")

# -----------------------------------------------------------------------------------

# Run draw.linear function
# To run example and save file to working directory
# add directory parameter and set working directory
# To run example with personal data see vignette

draw.linear("outputName", length.file, file1, file2, file3, fileformat = "pdf")
}
