% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen_WQ.R
\name{data.gen.BUWO}
\alias{data.gen.BUWO}
\title{Generate build-up and wash-off model for water quality modeling}
\usage{
data.gen.BUWO(nobs, k = 0.5, a = 1, m0 = 10, q = 0)
}
\arguments{
\item{nobs}{The data length to be generated.}

\item{k}{build-up coefficient (kg*t-1)}

\item{a}{wash-off rate constant (m-3)}

\item{m0}{threshold at which additional mass does not accumulate on the surface (kg)}

\item{q}{runoff (m3*t-1)}
}
\value{
A list of 2 elements: a vector of build-up mass (x), and a vector of wash-off mass (y) per unit time.
}
\description{
Generate build-up and wash-off model for water quality modeling
}
\examples{
# Build up model
set.seed(101)
sample = 500
#create a gamma shape storm event
q<- seq(0,20, length.out=sample)
p <- pgamma(q, shape=9, rate =2, lower.tail = TRUE)
p <- c(p[1],p[2:sample]-p[1:(sample-1)])

data.tss<-data.gen.BUWO(sample, k=0.5, a=5, m0=10, q=p)
plot.ts(cbind(p, data.tss$x, data.tss$y), ylab=c("Q","Bulid-up","Wash-off"))
}
\references{
Wu, X., Marshall, L., & Sharma, A. (2019). The influence of data transformations in simulating Total Suspended Solids using Bayesian inference. Environmental modelling & software, 121, 104493. doi:https://doi.org/10.1016/j.envsoft.2019.104493

Shaw, S. B., Stedinger, J. R., & Walter, M. T. (2010). Evaluating Urban Pollutant Buildup/Wash-Off Models Using a Madison, Wisconsin Catchment. Journal of Environmental Engineering, 136(2), 194-203. https://doi.org/10.1061/(ASCE)EE.1943-7870.0000142
}
