% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen_SW.R
\name{data.gen.SW}
\alias{data.gen.SW}
\title{Generate predictor and response data: Sinusoidal model}
\usage{
data.gen.SW(nobs = 500, freq = 50, A = 2, phi = pi, mu = 0, sd = 1)
}
\arguments{
\item{nobs}{The data length to be generated.}

\item{freq}{The frequencies in the generated response. Default freq=50.}

\item{A}{The amplitude of the sinusoidal series}

\item{phi}{The phase of the sinusoidal series}

\item{mu}{The mean of Gaussian noise in the variable.}

\item{sd}{The standard deviation of Gaussian noise in the variable.}
}
\value{
A list of time and x.
}
\description{
Generate predictor and response data: Sinusoidal model
}
\examples{
### Sinusoidal model
delta <- 1/12 # sampling rate, assuming monthly
period.max<- 2^5

N = 6*period.max/delta
scales<- 2^(0:5)[c(2,6)] #pick two scales
scales

### scale, period, and frequency
# freq=1/T; T=s/delta so freq = delta/s

tmp <- NULL
for(s in scales){
  tmp <- cbind(tmp, data.gen.SW(nobs=N, freq = delta/s, A = 1, phi = 0, mu=0, sd = 0)$x)
}
x <- rowSums(data.frame(tmp))
plot.ts(cbind(tmp,x), type = 'l', main=NA)
}
\references{
Shumway, R. H., & Stoffer, D. S. (2011). Characteristics of Time Series. In D. S. Stoffer (Ed.), Time series analysis and its applications (pp. 8-14). New York : Springer.
}
