% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_spec.R
\name{filter_spec}
\alias{filter_spec}
\title{Data extract filter specification}
\usage{
filter_spec(
  vars,
  choices = NULL,
  selected = if (inherits(choices, "delayed_data")) NULL else choices[1],
  multiple = length(selected) > 1 || inherits(selected, "multiple_choices"),
  label = "Filter by",
  sep = attr(choices, "sep"),
  drop_keys = FALSE
)
}
\arguments{
\item{vars}{(\code{character} or \code{delayed_data}) object.
Character vector giving the columns to be filtered. These should be
key variables of the data set to be filtered.
\code{delayed_data} objects can be created via \code{\link[=variable_choices]{variable_choices()}}, \code{\link[=value_choices]{value_choices()}},
or \code{\link[=choices_selected]{choices_selected()}}.}

\item{choices}{(\code{character} or \code{numeric} or \code{logical} or (\code{delayed_data}) object.
Named character vector to define the choices of a shiny \code{\link[shiny:selectInput]{shiny::selectInput()}}.
These choices will be used to filter the dataset.

These shall be filter values of the \code{vars} input separated by the separator(\code{sep}). Please
watch out that the filter values have to follow the order of the \code{vars} input. In the following
example we will show how to filter two columns:

\code{vars = c("PARAMCD","AVISIT")} and \code{choices = c("CRP - BASELINE", "ALT - BASELINE")}
will lead to a filtering of
\code{(PARAMCD == "CRP" & AVISIT == "BASELINE") | (PARAMCD == "ALT" & AVISIT == "BASELINE")}.

The \code{sep} input has to be \code{" - "} in this case.

\code{delayed_data} objects can be created via \code{\link[=variable_choices]{variable_choices()}} or \code{\link[=value_choices]{value_choices()}}.}

\item{selected}{(\code{character} or \code{numeric} or \code{logical} or (\code{delayed_data} or \code{delayed_choices}) object.
Named character vector to define the selected values of a shiny \code{\link[shiny:selectInput]{shiny::selectInput()}}
(default values).
This value will be displayed inside the shiny app upon start.
\code{delayed_choices} objects resolve selection when choices become available.}

\item{multiple}{(\code{logical}) Whether multiple values shall be allowed in the
shiny \code{\link[shiny:selectInput]{shiny::selectInput()}}.}

\item{label}{(\code{character}) optional, defines a label on top of this specific
shiny \code{\link[shiny:selectInput]{shiny::selectInput()}}. The default value is \code{"Filter by"}.}

\item{sep}{(\code{character}) A separator string to split the \code{choices} or
\code{selected} inputs into the values of the different columns.}

\item{drop_keys}{(\code{logical}) optional, whether to drop filter column from the
dataset keys, \code{TRUE} on default.}
}
\value{
\code{filter_spec}-S3-class object or \code{delayed_filter_spec}-S3-class object.
}
\description{
It consists in choices and additionally the variable names for the choices.
}
\details{
The \code{filter_spec} is used inside \code{teal} apps to allow filtering datasets
for their key variables. Imagine having an adverse events table. It has
the columns \code{PARAMCD} and \code{CNSR}. \code{PARAMCD} contains the levels
\code{"OS"}, \code{"PFS"}, \code{"EFS"}. \code{CNSR} contains the levels \code{"0"} and \code{"1"}.
The first example should show how a \code{filter_spec} setup will influence
the drop-down menu the app user will see.
}
\examples{
# for Adverse Events table
filter_spec(
  vars = c("PARAMCD", "CNSR"),
  sep = "-",
  choices = c("OS-1" = "OS-1", "OS-0" = "OS-0", "PFS-1" = "PFS-1"),
  selected = "OS-1",
  multiple = FALSE,
  label = "Choose endpoint and Censor"
)

# filtering a single variable
filter_spec(
  vars = c("PARAMCD"),
  sep = "-",
  choices = c("OS", "PFS", "EFS"),
  selected = "OS",
  multiple = FALSE,
  label = "Choose endpoint"
)

# filtering a single variable by multiple levels of the variable
filter_spec(
  vars = c("PARAMCD"),
  sep = "-",
  choices = c("OS", "PFS", "EFS"),
  selected = c("OS", "PFS"),
  multiple = TRUE,
  label = "Choose endpoint"
)

# delayed version
filter_spec(
  vars = variable_choices("ADSL", "SEX"),
  sep = "-",
  choices = value_choices("ADSL", "SEX", "SEX"),
  selected = "F",
  multiple = FALSE,
  label = "Choose endpoint and Censor"
)
# using `choices_selected()`
filter_spec(
  vars = choices_selected(variable_choices("ADSL", subset = c("SEX", "AGE")), "SEX", fixed = FALSE),
  multiple = TRUE
)

filter_spec(
  vars = choices_selected(variable_choices("ADSL"), "SEX", fixed = TRUE),
  multiple = TRUE
)

# choose all choices
adsl_filter <- filter_spec(
  vars = choices_selected(variable_choices("ADSL"), "SEX", fixed = FALSE),
  choices = value_choices("ADSL", "SEX"),
  selected = all_choices()
)
}
