% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_density}
\alias{plot_density}
\title{Circular Density Plot}
\usage{
plot_density(
  x,
  kappa = NULL,
  axial = TRUE,
  n = 512L,
  norm.density = TRUE,
  ...,
  scale = 0,
  shrink = 1,
  add = TRUE,
  main = NULL,
  labels = TRUE,
  at = seq(0, 360 - 45, 45),
  cborder = TRUE,
  grid = FALSE
)
}
\arguments{
\item{x}{numeric. Data to be plotted, i.e. vector containing angles (in degrees).}

\item{kappa}{numeric. Concentration parameter for the von Mises distribution.
Small kappa gives smooth density lines. Will be estimated using \code{\link[=est.kappa]{est.kappa()}} if not provided.}

\item{axial}{Logical. Whether data are uniaxial (\code{axial=FALSE})
or biaxial (\code{TRUE}, the default).}

\item{n}{integer. the number of equally spaced points at which the density is to be estimated.}

\item{norm.density}{logical. Normalize the density?}

\item{...}{Further graphical parameters may also be supplied as arguments.}

\item{scale}{numeric. radius of plotted circle. Default is \code{1.1}.}

\item{shrink}{numeric. parameter that controls the size of the plotted function. Default is 1.}

\item{add}{logical. Add to existing plot? (\code{TRUE} by default).}

\item{main}{Character string specifying the title of the plot.}

\item{labels}{Either a logical value indicating whether to plot labels
next to the tick marks, or a vector of labels for the tick marks.}

\item{at}{Optional vector of angles at which tick marks should be plotted.
Set \code{at=numeric(0)} to suppress tick marks.}

\item{cborder}{logical. Border of rose plot.}

\item{grid}{logical. Whether a grid should be added.}
}
\value{
plot or calculated densities as numeric vector
}
\description{
Plot the multiples of a von Mises density distribution
}
\examples{
# Plot density inside plot only:
rose(san_andreas$azi, grid = TRUE)
plot_density(san_andreas$azi,
  kappa = 100, col = "#51127CFF",
  add = TRUE, lwd = 3
)

# Add density curve outside of main plot:
rose(san_andreas$azi, dots = TRUE, stack = TRUE, dot_cex = 0.5, dot_pch = 21)
plot_density(san_andreas$azi,
  kappa = 100,
  scale = 1.1, shrink = 3, xpd = NA,
  col = "#51127CFF"
)
}
\seealso{
\code{\link[=dvm]{dvm()}}

Other rose-plot: 
\code{\link{plot_points}()},
\code{\link{rose}()},
\code{\link{rose_geom}},
\code{\link{rose_stats}()}
}
\concept{rose-plot}
