% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoom.R
\name{tf_zoom}
\alias{tf_zoom}
\alias{tf_zoom.tfd}
\alias{tf_zoom.tfb}
\alias{tf_zoom.tfb_fpc}
\title{Functions to zoom in/out on functions}
\usage{
tf_zoom(f, begin, end, ...)

\method{tf_zoom}{tfd}(f, begin = tf_domain(f)[1], end = tf_domain(f)[2], ...)

\method{tf_zoom}{tfb}(f, begin = tf_domain(f)[1], end = tf_domain(f)[2], ...)

\method{tf_zoom}{tfb_fpc}(f, begin = tf_domain(f)[1], end = tf_domain(f)[2], ...)
}
\arguments{
\item{f}{a \code{tf}-object}

\item{begin}{numeric vector of length 1 or \code{length(f)}.
Defaults to the lower limit of the domain of \code{f}.}

\item{end}{numeric vector of length 1 or \code{length(f)}.
Defaults to the upper limit of the domain of \code{f}.}

\item{...}{not used}
}
\value{
an object like \code{f} on a new domain (potentially).
Note that regular functional data and functions in basis representation will
be turned into irregular \code{tfd}-objects iff \code{begin} or \code{end} are not scalar.
}
\description{
These are used to redefine or restrict the \code{domain} of \code{tf} objects.
}
\examples{
x <- tf_rgp(10)
plot(x)
tf_zoom(x, 0.5, 0.9)
tf_zoom(x, 0.5, 0.9) |> lines(col = "red")
tf_zoom(x, seq(0, 0.5, length.out = 10), seq(0.5, 1, length.out = 10)) |>
  lines(col = "blue", lty = 3)
}
\seealso{
Other tidyfun utility functions: 
\code{\link{in_range}()},
\code{\link{tf_arg}()}
}
\concept{tidyfun utility functions}
