% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculus.R
\name{tf_integrate}
\alias{tf_integrate}
\alias{tf_integrate.default}
\alias{tf_integrate.tfd}
\alias{tf_integrate.tfb}
\title{Integrals and anti-derivatives of functional data}
\usage{
tf_integrate(f, arg, lower, upper, ...)

\method{tf_integrate}{default}(f, arg, lower, upper, ...)

\method{tf_integrate}{tfd}(
  f,
  arg,
  lower = tf_domain(f)[1],
  upper = tf_domain(f)[2],
  definite = TRUE,
  ...
)

\method{tf_integrate}{tfb}(
  f,
  arg,
  lower = tf_domain(f)[1],
  upper = tf_domain(f)[2],
  definite = TRUE,
  ...
)
}
\arguments{
\item{f}{a \code{tf}-object}

\item{arg}{(optional) grid to use for the quadrature.}

\item{lower}{lower limits of the integration range. For \code{definite=TRUE}, this
can be a vector of the same length as \code{f}.}

\item{upper}{upper limits of the integration range (but see \code{definite} arg /
Description). For \code{definite=TRUE}, this can be a vector of the same length
as \code{f}.}

\item{...}{not used}

\item{definite}{should the definite integral  be returned (default) or the
antiderivative. See Description.}
}
\value{
For \code{definite = TRUE}, the definite integrals of the functions in
\code{f}. For \code{definite = FALSE} and \code{tf}-inputs, a \code{tf} object containing their
anti-derivatives
}
\description{
Integrals of \code{tf}-objects are computed by simple quadrature (trapezoid rule).
By default the scalar definite integral
\eqn{\int^{upper}_{lower}f(s)ds} is returned (option \code{definite = TRUE}),
alternatively for \code{definite = FALSE} the \emph{anti-derivative} on
\verb{[lower, upper]}, e.g. a \code{tfd} or \code{tfb} object representing \eqn{F(t) \approx
\int^{t}_{lower}f(s)ds}, for \eqn{t \in}\verb{[lower, upper]}, is returned.
}
\seealso{
Other tidyfun calculus functions: 
\code{\link{tf_derive}()}
}
\concept{tidyfun calculus functions}
