% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visual_colors.R
\name{visual_colors}
\alias{visual_colors}
\title{Visualize colors in HTML widget}
\usage{
visual_colors(colors, names = NULL, num_per_row = 30, title = NULL)
}
\arguments{
\item{colors}{A character vector of hex color codes.}

\item{names}{Optional. A character vector of names for each color.
Default is \code{NULL}, which means hex color codes will be displayed.
You can pass any labels (e.g., RGB values, custom names) via this parameter.}

\item{num_per_row}{Number of colors per row.
Default is \code{30}.}

\item{title}{Optional title for the visualization.
Default is \code{NULL}.}
}
\value{
An HTML widget.
}
\description{
Display a grid of color swatches with optional names or color codes.
}
\examples{
# Visualize a simple color palette
visual_colors(
  colors = c("#FF0000", "#00FF00", "#0000FF"),
  names = c("Red", "Green", "Blue")
)

visual_colors(
  colors = c("#FF0000", "#00FF00"),
  names = c("(255, 0, 0)", "(0, 255, 0)")
)

visual_colors(thisplot::palette_list$Paired)

# Use with ChineseColors
cc <- ChineseColors()
visual_colors(
  colors = cc$blue[1:60],
  title = "Chinese Blue Colors"
)
}
