% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_electrode_proto.R
\name{new_electrode_prototype}
\alias{new_electrode_prototype}
\title{Create or load new electrode prototype from existing configurations}
\usage{
new_electrode_prototype(base_prototype, modifier = NULL)
}
\arguments{
\item{base_prototype}{base prototype, this can be a string of prototype type
(see \code{\link{list_electrode_prototypes}}), path to the prototype
configuration file, configuration in 'json' format, or an electrode prototype
instance}

\item{modifier}{internally used}
}
\value{
An electrode prototype instance
}
\description{
Create or load new electrode prototype from existing configurations
}
\examples{


available_prototypes <- list_electrode_prototypes()
if("Precision33x31" \%in\% names(available_prototypes)) {

  # Load by type name
  new_electrode_prototype("Precision33x31")

  # load by path
  path <- available_prototypes[["Precision33x31"]]
  new_electrode_prototype(path)

  # load by json string
  json <- readLines(path)
  new_electrode_prototype(json)

}



}
