% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/words.R
\name{from_words}
\alias{from_words}
\title{Resolve Three Identifying Words to a Position}
\usage{
from_words(key, words, ...)
}
\arguments{
\item{key}{an API key obtained from \href{http://developer.what3words.com/}{what3words}.}

\item{words}{either a vector of words, for a single latitude/longitude pair, or a \emph{list} of vectors
for vectorised operations.}

\item{...}{further arguments to pass to httr's GET.}
}
\value{
A list containing the words, positions and language of those words.
}
\description{
\code{from_words} takes a word cluster used by what3words and
converts them back into latitude/longitude pairs.
}
\examples{
\dontrun{
# Ask for a single lat/long pair from the what3words API (note: this requires an API key.
# Don't actually use 'ANAPIKEY'.)
results <- from_words(key = "ANAPIKEY", words = c("turnip","basil","fruit"))
}
}
\seealso{
\code{\link{from_position}} for the opposite operation.
}

