% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise.R
\name{normalise}
\alias{normalise}
\alias{norm_quantile}
\title{The normalise module}
\usage{
normalise(data, ...)

norm_quantile(var)
}
\arguments{
\item{data}{an index table object}

\item{...}{the expression to be evaluated}

\item{var}{used in \code{norm_quantile()}; the variable to be converted}
}
\value{
an index table object
}
\description{
The normalise module takes a probability value from a distribution fit
\code{norm_quantile()} to convert based on the normal quantile function
}
\examples{
library(dplyr)
library(lmomco)
tenterfield |>
  mutate(month = lubridate::month(ym)) |>
  init(id = id, time = ym, group = month) |>
  temporal_aggregate(.agg = temporal_rolling_window(prcp, scale = 12)) |>
  distribution_fit(.fit = dist_gamma(.agg, method = "lmoms")) |>
  normalise(index = norm_quantile(.fit))
}
