% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_download.R
\name{tt_download}
\alias{tt_download}
\title{Download TidyTuesday data}
\usage{
tt_download(tt, files = "All", ..., auth = gh::gh_token())
}
\arguments{
\item{tt}{A \code{tt} object, output from \code{\link[=tt_load_gh]{tt_load_gh()}}.}

\item{files}{Which file names to download. Default "All" downloads all files
for the specified week.}

\item{...}{Additional parameters to pass to the parsing functions. Note:
These arguments will be passed for all filetypes.}

\item{auth}{A GitHub token. See \code{\link[gh:gh_token]{gh::gh_token()}} for more details.}
}
\value{
A list of tibbles from the downloaded files.
}
\description{
Download all or specific files identified in a TidyTuesday dataset.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get the list of files for a week.
tt_output <- tt_load_gh("2019-01-15")

# Download a specific file.
agencies <- tt_download(tt_output, files = "agencies.csv")
\dontshow{\}) # examplesIf}
}
