% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dissolve_cu.R
\name{dissolve_cu}
\alias{dissolve_cu}
\title{Calculate Dissolved Copper Concentration}
\source{
Lytle et al (2018)
}
\usage{
dissolve_cu(water)
}
\arguments{
\item{water}{Source water object of class "water" created by \code{\link{define_water}}. Water must include ph and dic}
}
\value{
\code{dissolve_cu} returns a column containing dissolved copper concentration in mg/L.
}
\description{
This function takes a water defined by defined_water and output a column of dissolved copper. It is an empirical model developed
based on bench-scale copper solubility testing that can be used to predict copper levels as a function of pH, DIC, and orthophosphate.
For a single water, use \code{dissolve_cu}; to apply the model to a dataframe use \code{dissolve_cu_df}.
}
\details{
Dissolved copper is a function of pH, DIC, and PO4. Output units are in mg/L.
}
\examples{

example_cu <- define_water(ph = 7.5, alk = 125, tot_po4 = 2) \%>\%
  dissolve_cu()

}
