% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttest.R
\name{test_equality}
\alias{test_equality}
\title{Compute equality test between correlation coefficient estimates at two time points}
\usage{
test_equality(
  tcor_obj,
  t1 = 1,
  t2 = nrow(tcor_obj),
  test = c("student", "chi2")
)
}
\arguments{
\item{tcor_obj}{the output of a call to \code{\link[=tcor]{tcor()}} with \code{CI = TRUE}.}

\item{t1}{the first time point used by the test (by default, the first time point in the time series).}

\item{t2}{the second time point used by the test (by default, the last time point in the time series).}

\item{test}{a character string indicating which test to use ("student", the default; or "chi2").}
}
\value{
a data.frame with the result of the test, including the effect size (\code{delta_r = r[t2] - r[t1]}).
}
\description{
This function tests whether smoothed correlation values at two time points are equal (H0) or not.
The test is described page 341 in Choi & Shin (2021).
}
\details{
Two different test statistics can be used, one is asymptotically Student-t distributed under H0 and one is chi-square distributed.
In practice, it seems to give very similar results.
}
\examples{
## Simple example

res <- with(stockprice, tcor(x = SP500, y = FTSE100, t = DateID, h = 50, CI = TRUE))
test_equality(res)

## Chi2 instead of Student's t-test

test_equality(res, test = "chi2")


## Time point can be dates or indices (mixing possible) but output as in input data

test_equality(res, t1 = "2000-04-04", t2 = 1000)
res[1000, "t"] ## t2 matches with date in `res`
stockprice[1000, "DateID"] ## t2 does not match with date `stockprice` due to missing values


## It could be useful to use `keep.missing = TRUE` for index to match original data despite NAs

res2 <- with(stockprice, tcor(x = SP500, y = FTSE100, t = DateID,
                              h = 50, CI = TRUE, keep.missing = TRUE))
test_equality(res2, t1 = "2000-04-04", t2 = 1000)
res[1000, "t"] ## t2 matches with date in `res`
stockprice[1000, "DateID"] ## t2 does match with date `stockprice` despite missing values

}
\seealso{
\code{\link[=test_ref]{test_ref()}}, \code{\link[=tcor]{tcor()}}
}
