% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_plausibility.R
\name{assess_plausibility}
\alias{assess_plausibility}
\title{Assess Clinical Plausibility of Imputation Results}
\usage{
assess_plausibility(tipse, verbose = TRUE)
}
\arguments{
\item{tipse}{A \code{tipse} object returned by one of \link{tipping_point_model_free} or \link{tipping_point_model_based}.}

\item{verbose}{Logical. If \code{TRUE}, prints assessment details.}
}
\value{
A character string summarizing the key information to facilitate clinical plausibility assessment based on
the imputation scenario.
}
\description{
This function facilitate the evaluation of clinical plausibility at the tipping point. It provides a text summary comparing event rates,
follow-up duration, or hazard ratios between treatment arms depending on the
imputation method and arm specified.
}
\examples{
cox1 <- survival::coxph(Surv(AVAL, EVENT) ~ TRT01P, data = codebreak200)
result <- tipping_point_model_free(
  dat = codebreak200,
  reason = "Early dropout",
  impute = "docetaxel",
  cox_fit = cox1,
  method = "random sampling"
)

assess_plausibility(result)

}
