% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tipse.R
\name{plot.tipse}
\alias{plot.tipse}
\title{Plot Pooled Kaplan–Meier Curves from Model-Free Tipping Point Analysis}
\usage{
\method{plot}{tipse}(x, type = c("Kaplan-Meier", "Tipping Point"), ...)
}
\arguments{
\item{x}{An S3 object of class \code{"tipse"} returned from \link{tipping_point_model_free} or \link{tipping_point_model_based}.}

\item{type}{Type of plot, either "Kaplan-Meier" or "Tipping Point".}

\item{...}{Additional arguments not used.}
}
\value{
A ggplot2 object displaying pooled Kaplan–Meier curves.
}
\description{
Visualizes averaged (pooled) Kaplan-Meier survival curves across multiple tipping
point parameters, highlighting the tipping point where the upper CL of the hazard ratio crosses 1.
}
\details{
\itemize{
\item If \code{type = Kaplan-Meier}, then the KM curves from multiply imputed datasets were pooled using Rubin’s rules
after complementary log-log transformation as described in Marshall et al. (2009).
it can be of interest to visually assess the scenario that tips the result and the shift it causes to the original KM curve,
although there is no objective measure to assess the robustness of the result.
\item If \verb{type = Tipping Point}, then the HR estimation across the range of tipping point parameters are plotted.
}
}
\examples{
cox1 <- survival::coxph(Surv(AVAL, EVENT) ~ TRT01P, data = codebreak200)
result <- tipping_point_model_based(
  dat = codebreak200,
  reason = "Early dropout",
  impute = "docetaxel",
  imputation_model = "weibull",
  J = 10,
  tipping_range = seq(0.1, 1, by = 0.05),
  cox_fit = cox1,
  verbose = TRUE,
  seed = 12345
)
plot(result, type = "Kaplan-Meier")
plot(result, type = "Tipping Point")
}
\references{
Marshall, A., Altman, D.G., Holder, R.L. et al.
Combining estimates of interest in prognostic modelling studies after multiple imputation: current practice and guidelines.
BMC Med Res Methodol 9, 57 (2009). https://doi.org/10.1186/1471-2288-9-57
}
