% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizations.R
\name{modCorPlot}
\alias{modCorPlot}
\title{Plot a correlation heatmap for modules}
\usage{
modCorPlot(
  modules,
  mset = NULL,
  heatmap_func = pheatmap,
  labels = NULL,
  stat = "jaccard",
  upper.cutoff = NULL,
  ...
)
}
\arguments{
\item{modules}{either a character vector with module IDs from mset, or a list which
contains the module members}

\item{mset}{Which module set to use. Either a character vector ("LI", "DC" or "all", default: all) or an object of class tmod (see "Custom module definitions" below)}

\item{heatmap_func}{function drawing the heatmap}

\item{labels}{Labels for the modules (if NULL, labels will be retrieved from `mset`)}

\item{stat}{Type of statistics to return. 
"jaccard": Jaccard index (default);
"number": number of common genes;
"soerensen": Soerensen-Dice coefficient;
"overlap": Szymkiewicz-Simpson coefficient.}

\item{upper.cutoff}{Specify upper cutoff for the color palette}

\item{...}{Any further parameters are passed to the heatmap function (by
default, [pheatmap()].}
}
\value{
Returns the return value of heatmap_func (by default, a pheatmap object).
}
\description{
Plot a correlation heatmap for modules
}
