% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_authors}
\alias{get_authors}
\title{List All Authors in the Dataset Catalog}
\usage{
get_authors(max_datasets = 1000)
}
\arguments{
\item{max_datasets}{Numeric. Maximum number of datasets to retrieve for author extraction, defaults to 1000.}
}
\value{
A tibble (data frame) with the following columns:
\describe{
\item{name}{Character. Name of the author.}
\item{count}{Numeric. Number of datasets contributed by this author.}
}
}
\description{
Retrieves a list of all authors who have contributed datasets to the catalog
by fetching datasets and extracting unique author information.
}
\examples{
try({
  authors <- get_authors(max_datasets = 100)
  head(authors)
})

}
