% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tongfen_ca.R
\name{get_tongfen_ca_census}
\alias{get_tongfen_ca_census}
\title{Togfen data from several Canadian censuses}
\usage{
get_tongfen_ca_census(
  regions,
  meta,
  level = "CT",
  method = "statcan",
  base_geo = NULL,
  na.rm = FALSE,
  tolerance = 50,
  area_mismatch_cutoff = 0.1,
  quiet = FALSE,
  refresh = FALSE,
  crs = NULL,
  data_transform = function(d) d
)
}
\arguments{
\item{regions}{census region list, should be inclusive list of GeoUIDs across censuses}

\item{meta}{metadata for the census veraiables to aggregate, for example as returned
by \code{meta_for_ca_census_vectors}.}

\item{level}{aggregation level to return data on (default is "CT")}

\item{method}{tongfen method, options are "statcan" (the default), "estimate", "identifier".
* "statcan" method builds up the common geography using Statistics Canada correspondence files, at this point
this method only works for "DB", "DA" and "CT" levels.
* "estimate" uses `estimate_tongfen_correspondence` to build up the common geography from scratch based on geographies.
* "identifier" assumes regions with identical geographic identifier are identical, and builds up the the correspondence for regions with unmatched geographic identifiers.}

\item{base_geo}{base census year to build up common geography from, `NULL` (the default) to not return
any geographi data}

\item{na.rm}{logical, determines how NA values should be treated when aggregating variables}

\item{tolerance}{tolerance for `estimate_tongen_correspondence` in metres, default value is 50 metres,
only used when method is 'estimate' or 'identifier'}

\item{area_mismatch_cutoff}{discard areas returned by `estimate_tongfen_correspondence` with area mismatch (log ratio) greater than cutoff,
only used when method is 'estimate' or 'identifier'}

\item{quiet}{suppress download progress output, default is `FALSE`}

\item{refresh}{optional character, refresh data cache for this call, (default `FALSE`)}

\item{crs}{optional CRS to transform data to, and use for spatial intersections if method is
'identifier' or 'estimate'}

\item{data_transform}{optional transform function to be applied to census data after being returned from cancensus}
}
\value{
dataframe with variables on common geography
}
\description{
\lifecycle{maturing}

Get data from several Candian censuses on a common geography. Requires sf and cancensus package to be available
}
\examples{
# Get rent data for census years 2001 through 2016
\dontrun{
rent_variables <- c(rent_2001="v_CA01_1667",rent_2016="v_CA16_4901",
                    rent_2011="v_CA11N_2292",rent_2006="v_CA06_2050")
meta <- meta_for_ca_census_vectors(rent_variables)

regions=list(CMA="59933")
rent_data <- get_tongfen_ca_census(regions=regions, meta=meta, quiet=TRUE,
                                   method="estimate", level="CT", base_geo = "CA16")

}
}
