% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path.R
\name{getpd}
\alias{getpd}
\title{Get Project Directory}
\usage{
getpd(root.files = c(".git", "DESCRIPTION", "NAMESPACE"))
}
\arguments{
\item{root.files}{if any of these files is found in a parent folder, the path to that folder is returned}
}
\value{
\code{getpd} returns the absolute, normalized project root directory as string. The forward slash is used as path separator (independent of the OS).
}
\description{
Find the project root directory by traversing the current working directory filepath upwards until a given set of files is found.
}
\examples{
local({
     base_pkg_root_dir <- system.file(package = "base")
     base_pkg_R_dir <- file.path(base_pkg_root_dir, "R")
     owd <- setwd(base_pkg_R_dir); on.exit(setwd(owd))
     getpd()
})
}
\keyword{path}
