% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R, R/methods-TxpSlice.R
\docType{class}
\name{TxpSlice-class}
\alias{TxpSlice-class}
\alias{TxpSlice}
\alias{txpValueNames,TxpSlice-method}
\alias{txpValueNames<-,TxpSlice-method}
\alias{txpTransFuncs,TxpSlice-method}
\alias{txpTransFuncs<-,TxpSlice-method}
\alias{length,TxpSlice-method}
\alias{merge,TxpSlice,TxpSlice-method}
\title{ToxPi Slice}
\usage{
TxpSlice(txpValueNames, txpTransFuncs = NULL)

\S4method{txpValueNames}{TxpSlice}(x)

\S4method{txpValueNames}{TxpSlice}(x) <- value

\S4method{txpTransFuncs}{TxpSlice}(x)

\S4method{txpTransFuncs}{TxpSlice}(x) <- value

\S4method{length}{TxpSlice}(x)

\S4method{merge}{TxpSlice,TxpSlice}(x, y)
}
\arguments{
\item{txpValueNames}{Passed to \code{txpValueNames} slot}

\item{txpTransFuncs}{Passed to \code{txpTransFuncs} slot}

\item{x, y}{\code{TxpSlice} object}

\item{value}{Replacement value}
}
\description{
S4 class to store ToxPi slices
}
\details{
If the user supplies \code{txpTransFuncs} a single function/\link{TxpTransFunc} object,
the given function will be recycled for each input with a warning.
}
\section{Functions}{
\itemize{
\item \code{txpValueNames(TxpSlice)}: Return \code{txpValueNames} slot

\item \code{txpTransFuncs(TxpSlice)}: Return \code{txpTransFuncs} slot

\item \code{length(TxpSlice)}: Return number of inputs in slice; shortcut for
\code{length(txpValueNames(x))}

\item \code{merge(x = TxpSlice, y = TxpSlice)}: Merge two \code{TxpSlice} objects into a single
slice

}}
\section{Slots}{

\describe{
\item{\code{txpValueNames}}{\verb{vector(<character>)} specifying the input columns to
include in the slice}

\item{\code{txpTransFuncs}}{\link{TxpTransFuncList} with one function per entry in
\code{txpValueNames} or an object that can be coerced to \code{TxpTransFuncList};
when \code{NULL}, no transformation function applied}
}}

\examples{
## Create TxpSlice object 
# Without transform functions
TxpSlice(txpValueNames = c("sqrData", "expData")) 
# With transform functions
TxpSlice(txpValueNames = c("sqrData", "expData"),
         txpTransFuncs = c(sq = function(x) x^2, log = function(x) log(x)))

# Transformation function recycled with warning when single function given
TxpSlice(txpValueNames = c("sqrData", "expData"), 
         txpTransFuncs = function(x) x^2) 
         

## Access TxpSlice slots
sl <- TxpSlice(txpValueNames = c("sqrData", "expData"),
               txpTransFuncs = c(sq = function(x) x^2, 
                                 log = function(x) log(x)))
txpValueNames(sl)
txpTransFuncs(sl)

## Replacement
txpValueNames(sl)[1] <- "hello"
sl

txpTransFuncs(sl)[[2]](exp(1))
txpTransFuncs(sl)[[2]] <- function(x) sqrt(x)
txpTransFuncs(sl)[[2]](exp(1))

# Note that replacing a single list element does NOT update the name
sl
names(txpTransFuncs(sl))[2] <- "sqrt" 
sl

# Replacing the whole list DOES update the names
txpTransFuncs(sl) <- list(sqrt = function(x) sqrt(x), 
                          log = function(x) log(x))
sl

## length -- returns number of inputs
length(TxpSlice(letters))

## merge
s1 <- TxpSlice("hello")
s2 <- TxpSlice("data")
merge(s1, s2)

# Note, input names still must be unique
\dontrun{merge(s1, s1)} ## produces error
}
