% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.dataset.index_function.R
\name{get.dataset.index}
\alias{get.dataset.index}
\title{Get the index of specific dataset(s)}
\usage{
get.dataset.index(pmid, year = NULL, show.title = FALSE, show.comment = FALSE)
}
\arguments{
\item{pmid}{A scalar or vector with the PMID number(s) of the systematic
reviews found in the database.}

\item{year}{A scalar to define the year of publication.
\code{get.dataset.index} will return all systematic reviews found in the
database under this year.}

\item{show.title}{Logical to indicate whether to show the title of the
selected systematic review(s). The default is \code{FALSE} (do not show).}

\item{show.comment}{Logical to indicate whether to show the comment referring
to extraction notes about the selected systematic review(s). The default is
\code{FALSE} (do not show).}
}
\value{
\code{get.dataset.index} returns a vector (when \code{pmid} is scalar) or a
data-frame (when \code{pmid} is a vector) with the following
characteristics (column names):
\item{nmadb.ID}{The ID number as provided in the archived R package nmadb.}
\item{PMID}{The PMID number.}
\item{First.Author}{The name of the first author.}
\item{Year}{The year of publication.}
\item{Journal.Name}{The abbreviated name of the journal.}
\item{Title}{The title of the systematic review.}
\item{Outcome.Type}{The outcome type as suggested by Turner et al.
  (2012) and distinguished into objective, semi-objective and subjective.}
\item{Intervention.Comparison.Type}{The treatment-comparator type
  as suggested by Turner et al. (2012) and distinguished into
  pharmacological versus placebo, pharmacological versus pharmacological,
  and non-pharmacological versus any.}
\item{Includes.ToC.where}{Whether the extracted study-level
  aggregate characteristics were found in the main article, Appendix or
  both.}
\item{Source.ToC}{The exact location in the systematic review
  where the extracted study-level aggregate characteristics were found, such
  as Table(s) in the main article, and/ or Appendix.}
\item{Comment}{Notes related to the extraction for the selected systematic
  review(s).}
}
\description{
Retrieving the characteristics of one of more systematic
reviews found in the database using their PMID number or year of
publication.
}
\details{
When \code{year} is specified, the argument \code{pmid} should be NULL.
Then, \code{get.dataset.index} returns all systematic reviews found in the
database under this year.
}
\examples{
# For one systematic review with PMID number 25626481.
get.dataset.index(pmid = 25626481)

# For two systematic reviews with PMID numbers 25626481 and 15147585,
# respectively.
get.dataset.index(pmid = c(25626481, 15147585))

# For systematic reviews published during 2010.
get.dataset.index(pmid = NULL, year = 2010)

}
\references{
Papakonstantinou T. nmadb: Network Meta-Analysis Database API.
R package version 1.2.0. 2019. <https://CRAN.R-project.org/package=nmadb>
(archived).

Turner RM, Davey J, Clarke MJ, Thompson SG, Higgins JP. Predicting the extent
of heterogeneity in meta-analysis, using empirical data from the Cochrane
Database of Systematic Reviews.
\emph{Int J Epidemiol} 2012;\bold{41}(3):818--27. doi: 10.1093/ije/dys041.
}
\author{
{Loukia M. Spineli}
}
