% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/usefulPhyloExt.R
\name{extendPhylo}
\alias{extendPhylo}
\alias{getDescs}
\alias{getChildren}
\alias{getDescendants}
\alias{getAncs}
\alias{getNodeDepths}
\alias{getNodesAtDepth}
\alias{getLeaves}
\alias{getSubtrCentr}
\alias{getDistFromRoot}
\alias{getDistFromLeaf}
\alias{getIncEdgeLens}
\alias{getIncEdgeWeights}
\title{Useful extensions to the phylo format}
\usage{
extendPhylo(tree)

getDescs(tree)

getChildren(tree, node, method = "onlyNodes")

getDescendants(tree, node)

getAncs(tree)

getNodeDepths(tree)

getNodesAtDepth(tree, depth)

getLeaves(tree)

getSubtrCentr(tree)

getDistFromRoot(tree)

getDistFromLeaf(tree)

getIncEdgeLens(tree)

getIncEdgeWeights(tree)
}
\arguments{
\item{tree}{A rooted tree in phylo3D format (no special node enumeration 
required, except that nodes are numbered from 1 to |V| = the total number of
nodes). There must be at least 2 nodes, i.e., one edge. The attributes 
'node.coord' and 'edge.weight' are strictly required.}

\item{node}{Numeric/integer value representing a node of the tree.}

\item{method}{A string specifying if only descending nodes or also
descending edges should be returned. Can be one of 'onlyNodes' or 
'alsoEdges'.}

\item{depth}{An integer value representing the depth of interest in the tree.
A depth of 0 indicates the root layer, 1 the layer of its children, and so 
forth.}
}
\value{
\code{extendPhylo} Tree in extended phylo(3D) format, 
i.e., phylo(3D) format with further attributes.

\code{getDescs} Numeric matrix with 2 rows.

\code{getChildren} Depending on the method the function either
returns an integer vector containing the direct descendants of a node
or an integer matrix with two rows, the first containing the direct
descendants and the second the corresponding incoming edges.

\code{getAncs} Integer matrix with 2 rows. The first 
row contains the direct ancestor of each node, the second row the incoming
edge of this node, i.e., the edge that leads to its ancestor.

\code{getNodeDepths} Numeric matrix with 3 rows.

\code{getNodesAtDepth} Integer/numeric vector 
containing all nodes at the desired depth.

\code{getLeaves} Creates a logical vector that indicates if the 
\eqn{i}-th node is a leaf, TRUE for leaf and FALSE for interior node.

\code{getSubtrCentr} Numeric matrix with 2 columns.

\code{getDistFromRoot} Integer/numeric vector containing the length 
of the path from each node to the root.

\code{getDistFromLeaf} Integer/numeric vector containing the length 
of the path from each node to its nearest descendant leaf.

\code{getIncEdgeLens} Numeric vector containing the 
length of the incoming edge of each node, i.e., the length of the
edge from its direct ancestor to the node itself.

\code{getIncEdgeWeights} Numeric vector containing the 
weight of the incoming edge of each node, i.e., the weight of the
edge from its direct ancestor to the node itself.
}
\description{
\code{extendPhylo} - Extends a tree in phylo or phylo3D format, i.e., adds 
or updates several useful attributes of the tree that facilitate various
computations and allow it to be independent of a certain node enumeration.
These are: information on descendants, ancestors, and depths 
as well as on the centroids of all pending subtrees. The latter is 
only computed if the tree is in phylo3D format and as such contains the
attributes 'node.coord' and 'edge.weight'.

\code{getDescs} - Creates a matrix with two rows, the second contains 
in the \eqn{i}-th entry the index of the first row in which the 
descendants of node \eqn{i} start. Use the function \code{getChildren} 
to quickly retrieve the direct descendants of each node.

\code{getChildren} - Creates a vector containing the direct children of a 
node. If the method indicates that also edges should be returned, this 
function will also return the number (identifier) of the incoming edge of 
each child.

\code{getDescendants} - Creates a vector containing all descendants of a 
node.

\code{getAncs} - Creates a matrix that contains the parent (direct ancestor) 
of node \eqn{i} as well as the corresponding edge number in column \eqn{i}.

\code{getNodeDepths} - Creates a matrix with three rows:
The first contains the nodes ordered by increasing depth. The second
contains the indices at which the next depth starts in the first row, i.e.,
these first two rows are similar to the output matrix of \code{getDescs}.
The last row contains the depth of each node.

\code{getNodesAtDepth} - Creates a vector containing the nodes at a certain 
depth.

\code{getLeaves} - Creates a logical vector that indicates if the \eqn{i}-th
node is a leaf.

\code{getSubtrCentr} - Calculates the centroid of each pending subtree. 
Returns a matrix containing the 3D coordinates (3 columns) where row \eqn{i}
gives the position of the centroid of \eqn{T_i}, the pending subtree rooted
in node \eqn{i}.

\code{getDistFromRoot} - Creates a vector containing the length of the path 
from the node to the root, i.e., the sum of the corresponding edge lengths.

\code{getDistFromLeaf} - Creates a vector containing the length of the path 
from the node to the nearest descendant leaf, i.e., the sum of the 
corresponding edge lengths.

\code{getIncEdgeLens} - Returns the length of the incoming edge of every
node as a numeric vector.

\code{getIncEdgeWeights} - Returns the weight of the incoming edge of every
node as a numeric vector.
}
\examples{
tree <- treeDbalance::example3Dtrees$bean09
ext_tree <- extendPhylo(tree)
getDescs(tree)
getChildren(ext_tree, 3, method="alsoEdges")
getDescendants(ext_tree,3)
getAncs(tree)
getNodeDepths(tree)
getNodesAtDepth(tree,4)
getLeaves(tree)
getSubtrCentr(ext_tree)
getDistFromRoot(ext_tree)
getDistFromLeaf(ext_tree)
getIncEdgeLens(tree)
getIncEdgeWeights(tree)
}
\author{
Sophie Kersting
}
