#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
# pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 2072
#define LARGE_STATE_COUNT 445
#define SYMBOL_COUNT 134
#define ALIAS_COUNT 1
#define TOKEN_COUNT 81
#define EXTERNAL_TOKEN_COUNT 14
#define FIELD_COUNT 20
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 57

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_BSLASH = 2,
  anon_sym_function = 3,
  anon_sym_EQ = 4,
  anon_sym_if = 5,
  anon_sym_for = 6,
  anon_sym_in = 7,
  anon_sym_while = 8,
  anon_sym_repeat = 9,
  anon_sym_QMARK = 10,
  anon_sym_TILDE = 11,
  anon_sym_BANG = 12,
  anon_sym_PLUS = 13,
  anon_sym_DASH = 14,
  anon_sym_LT_DASH = 15,
  anon_sym_LT_LT_DASH = 16,
  anon_sym_COLON_EQ = 17,
  anon_sym_DASH_GT = 18,
  anon_sym_DASH_GT_GT = 19,
  anon_sym_PIPE = 20,
  anon_sym_AMP = 21,
  anon_sym_PIPE_PIPE = 22,
  anon_sym_AMP_AMP = 23,
  anon_sym_LT = 24,
  anon_sym_LT_EQ = 25,
  anon_sym_GT = 26,
  anon_sym_GT_EQ = 27,
  anon_sym_EQ_EQ = 28,
  anon_sym_BANG_EQ = 29,
  anon_sym_STAR = 30,
  anon_sym_SLASH = 31,
  anon_sym_STAR_STAR = 32,
  anon_sym_CARET = 33,
  aux_sym_binary_operator_token1 = 34,
  anon_sym_PIPE_GT = 35,
  anon_sym_COLON = 36,
  anon_sym_DOLLAR = 37,
  anon_sym_AT = 38,
  anon_sym_COLON_COLON = 39,
  anon_sym_COLON_COLON_COLON = 40,
  anon_sym_L = 41,
  anon_sym_i = 42,
  sym__hex_literal = 43,
  sym__number_literal = 44,
  anon_sym_SQUOTE = 45,
  anon_sym_DQUOTE = 46,
  aux_sym__single_quoted_string_content_token1 = 47,
  aux_sym__double_quoted_string_content_token1 = 48,
  sym_escape_sequence = 49,
  sym_dots = 50,
  sym_dot_dot_i = 51,
  sym_return = 52,
  sym_next = 53,
  sym_break = 54,
  sym_true = 55,
  sym_false = 56,
  sym_null = 57,
  sym_inf = 58,
  sym_nan = 59,
  anon_sym_NA = 60,
  anon_sym_NA_integer_ = 61,
  anon_sym_NA_real_ = 62,
  anon_sym_NA_complex_ = 63,
  anon_sym_NA_character_ = 64,
  sym_comment = 65,
  sym_comma = 66,
  sym__start = 67,
  sym__newline = 68,
  sym__semicolon = 69,
  sym__raw_string_literal = 70,
  sym__external_else = 71,
  sym__external_open_parenthesis = 72,
  sym__external_close_parenthesis = 73,
  sym__external_open_brace = 74,
  sym__external_close_brace = 75,
  sym__external_open_bracket = 76,
  sym__external_close_bracket = 77,
  sym__external_open_bracket2 = 78,
  sym__external_close_bracket2 = 79,
  sym__error_sentinel = 80,
  sym_program = 81,
  sym_function_definition = 82,
  sym_parameters = 83,
  sym_parameter = 84,
  sym__parameter_with_default = 85,
  sym__parameter_without_default = 86,
  sym__parameter_name = 87,
  sym_if_statement = 88,
  sym_for_statement = 89,
  sym_while_statement = 90,
  sym_repeat_statement = 91,
  sym_braced_expression = 92,
  sym_parenthesized_expression = 93,
  sym_call = 94,
  sym_subset = 95,
  sym_subset2 = 96,
  sym_call_arguments = 97,
  sym_subset_arguments = 98,
  sym_subset2_arguments = 99,
  sym_argument = 100,
  sym__argument_named = 101,
  sym__argument_unnamed = 102,
  sym__argument_value = 103,
  sym_unary_operator = 104,
  sym_binary_operator = 105,
  sym_extract_operator = 106,
  sym_namespace_operator = 107,
  sym_integer = 108,
  sym_complex = 109,
  sym_float = 110,
  sym__float_literal = 111,
  sym_string = 112,
  sym__single_quoted_string = 113,
  sym__double_quoted_string = 114,
  aux_sym__single_quoted_string_content = 115,
  aux_sym__double_quoted_string_content = 116,
  sym__argument_name_string_or_identifier_or_null = 117,
  sym_na = 118,
  sym__expression = 119,
  sym__else = 120,
  sym__open_parenthesis = 121,
  sym__close_parenthesis = 122,
  sym__open_brace = 123,
  sym__close_brace = 124,
  sym__open_bracket = 125,
  sym__close_bracket = 126,
  sym__open_bracket2 = 127,
  sym__close_bracket2 = 128,
  aux_sym_program_repeat1 = 129,
  aux_sym_function_definition_repeat1 = 130,
  aux_sym_parameters_repeat1 = 131,
  aux_sym_braced_expression_repeat1 = 132,
  aux_sym_call_arguments_repeat1 = 133,
  alias_sym_string_content = 134,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_BSLASH] = "\\",
  [anon_sym_function] = "function",
  [anon_sym_EQ] = "=",
  [anon_sym_if] = "if",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_while] = "while",
  [anon_sym_repeat] = "repeat",
  [anon_sym_QMARK] = "\?",
  [anon_sym_TILDE] = "~",
  [anon_sym_BANG] = "!",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_LT_LT_DASH] = "<<-",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_DASH_GT_GT] = "->>",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP] = "&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_CARET] = "^",
  [aux_sym_binary_operator_token1] = "special",
  [anon_sym_PIPE_GT] = "|>",
  [anon_sym_COLON] = ":",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_AT] = "@",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_COLON_COLON_COLON] = ":::",
  [anon_sym_L] = "L",
  [anon_sym_i] = "i",
  [sym__hex_literal] = "_hex_literal",
  [sym__number_literal] = "_number_literal",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym__single_quoted_string_content_token1] = "_single_quoted_string_content_token1",
  [aux_sym__double_quoted_string_content_token1] = "_double_quoted_string_content_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym_dots] = "dots",
  [sym_dot_dot_i] = "dot_dot_i",
  [sym_return] = "return",
  [sym_next] = "next",
  [sym_break] = "break",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_inf] = "inf",
  [sym_nan] = "nan",
  [anon_sym_NA] = "NA",
  [anon_sym_NA_integer_] = "NA_integer_",
  [anon_sym_NA_real_] = "NA_real_",
  [anon_sym_NA_complex_] = "NA_complex_",
  [anon_sym_NA_character_] = "NA_character_",
  [sym_comment] = "comment",
  [sym_comma] = "comma",
  [sym__start] = "_start",
  [sym__newline] = "_newline",
  [sym__semicolon] = "_semicolon",
  [sym__raw_string_literal] = "_raw_string_literal",
  [sym__external_else] = "else",
  [sym__external_open_parenthesis] = "(",
  [sym__external_close_parenthesis] = ")",
  [sym__external_open_brace] = "{",
  [sym__external_close_brace] = "}",
  [sym__external_open_bracket] = "[",
  [sym__external_close_bracket] = "]",
  [sym__external_open_bracket2] = "[[",
  [sym__external_close_bracket2] = "]]",
  [sym__error_sentinel] = "_error_sentinel",
  [sym_program] = "program",
  [sym_function_definition] = "function_definition",
  [sym_parameters] = "parameters",
  [sym_parameter] = "parameter",
  [sym__parameter_with_default] = "_parameter_with_default",
  [sym__parameter_without_default] = "_parameter_without_default",
  [sym__parameter_name] = "_parameter_name",
  [sym_if_statement] = "if_statement",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_repeat_statement] = "repeat_statement",
  [sym_braced_expression] = "braced_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_call] = "call",
  [sym_subset] = "subset",
  [sym_subset2] = "subset2",
  [sym_call_arguments] = "arguments",
  [sym_subset_arguments] = "arguments",
  [sym_subset2_arguments] = "arguments",
  [sym_argument] = "argument",
  [sym__argument_named] = "_argument_named",
  [sym__argument_unnamed] = "_argument_unnamed",
  [sym__argument_value] = "_argument_value",
  [sym_unary_operator] = "unary_operator",
  [sym_binary_operator] = "binary_operator",
  [sym_extract_operator] = "extract_operator",
  [sym_namespace_operator] = "namespace_operator",
  [sym_integer] = "integer",
  [sym_complex] = "complex",
  [sym_float] = "float",
  [sym__float_literal] = "_float_literal",
  [sym_string] = "string",
  [sym__single_quoted_string] = "_single_quoted_string",
  [sym__double_quoted_string] = "_double_quoted_string",
  [aux_sym__single_quoted_string_content] = "_single_quoted_string_content",
  [aux_sym__double_quoted_string_content] = "_double_quoted_string_content",
  [sym__argument_name_string_or_identifier_or_null] = "_argument_name_string_or_identifier_or_null",
  [sym_na] = "na",
  [sym__expression] = "_expression",
  [sym__else] = "_else",
  [sym__open_parenthesis] = "_open_parenthesis",
  [sym__close_parenthesis] = "_close_parenthesis",
  [sym__open_brace] = "_open_brace",
  [sym__close_brace] = "_close_brace",
  [sym__open_bracket] = "_open_bracket",
  [sym__close_bracket] = "_close_bracket",
  [sym__open_bracket2] = "_open_bracket2",
  [sym__close_bracket2] = "_close_bracket2",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_function_definition_repeat1] = "function_definition_repeat1",
  [aux_sym_parameters_repeat1] = "parameters_repeat1",
  [aux_sym_braced_expression_repeat1] = "braced_expression_repeat1",
  [aux_sym_call_arguments_repeat1] = "call_arguments_repeat1",
  [alias_sym_string_content] = "string_content",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_repeat] = anon_sym_repeat,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_LT_LT_DASH] = anon_sym_LT_LT_DASH,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_DASH_GT_GT] = anon_sym_DASH_GT_GT,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_CARET] = anon_sym_CARET,
  [aux_sym_binary_operator_token1] = aux_sym_binary_operator_token1,
  [anon_sym_PIPE_GT] = anon_sym_PIPE_GT,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_COLON_COLON_COLON] = anon_sym_COLON_COLON_COLON,
  [anon_sym_L] = anon_sym_L,
  [anon_sym_i] = anon_sym_i,
  [sym__hex_literal] = sym__hex_literal,
  [sym__number_literal] = sym__number_literal,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym__single_quoted_string_content_token1] = aux_sym__single_quoted_string_content_token1,
  [aux_sym__double_quoted_string_content_token1] = aux_sym__double_quoted_string_content_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_dots] = sym_dots,
  [sym_dot_dot_i] = sym_dot_dot_i,
  [sym_return] = sym_return,
  [sym_next] = sym_next,
  [sym_break] = sym_break,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_inf] = sym_inf,
  [sym_nan] = sym_nan,
  [anon_sym_NA] = anon_sym_NA,
  [anon_sym_NA_integer_] = anon_sym_NA_integer_,
  [anon_sym_NA_real_] = anon_sym_NA_real_,
  [anon_sym_NA_complex_] = anon_sym_NA_complex_,
  [anon_sym_NA_character_] = anon_sym_NA_character_,
  [sym_comment] = sym_comment,
  [sym_comma] = sym_comma,
  [sym__start] = sym__start,
  [sym__newline] = sym__newline,
  [sym__semicolon] = sym__semicolon,
  [sym__raw_string_literal] = sym__raw_string_literal,
  [sym__external_else] = sym__external_else,
  [sym__external_open_parenthesis] = sym__external_open_parenthesis,
  [sym__external_close_parenthesis] = sym__external_close_parenthesis,
  [sym__external_open_brace] = sym__external_open_brace,
  [sym__external_close_brace] = sym__external_close_brace,
  [sym__external_open_bracket] = sym__external_open_bracket,
  [sym__external_close_bracket] = sym__external_close_bracket,
  [sym__external_open_bracket2] = sym__external_open_bracket2,
  [sym__external_close_bracket2] = sym__external_close_bracket2,
  [sym__error_sentinel] = sym__error_sentinel,
  [sym_program] = sym_program,
  [sym_function_definition] = sym_function_definition,
  [sym_parameters] = sym_parameters,
  [sym_parameter] = sym_parameter,
  [sym__parameter_with_default] = sym__parameter_with_default,
  [sym__parameter_without_default] = sym__parameter_without_default,
  [sym__parameter_name] = sym__parameter_name,
  [sym_if_statement] = sym_if_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_repeat_statement] = sym_repeat_statement,
  [sym_braced_expression] = sym_braced_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_call] = sym_call,
  [sym_subset] = sym_subset,
  [sym_subset2] = sym_subset2,
  [sym_call_arguments] = sym_call_arguments,
  [sym_subset_arguments] = sym_call_arguments,
  [sym_subset2_arguments] = sym_call_arguments,
  [sym_argument] = sym_argument,
  [sym__argument_named] = sym__argument_named,
  [sym__argument_unnamed] = sym__argument_unnamed,
  [sym__argument_value] = sym__argument_value,
  [sym_unary_operator] = sym_unary_operator,
  [sym_binary_operator] = sym_binary_operator,
  [sym_extract_operator] = sym_extract_operator,
  [sym_namespace_operator] = sym_namespace_operator,
  [sym_integer] = sym_integer,
  [sym_complex] = sym_complex,
  [sym_float] = sym_float,
  [sym__float_literal] = sym__float_literal,
  [sym_string] = sym_string,
  [sym__single_quoted_string] = sym__single_quoted_string,
  [sym__double_quoted_string] = sym__double_quoted_string,
  [aux_sym__single_quoted_string_content] = aux_sym__single_quoted_string_content,
  [aux_sym__double_quoted_string_content] = aux_sym__double_quoted_string_content,
  [sym__argument_name_string_or_identifier_or_null] = sym__argument_name_string_or_identifier_or_null,
  [sym_na] = sym_na,
  [sym__expression] = sym__expression,
  [sym__else] = sym__else,
  [sym__open_parenthesis] = sym__open_parenthesis,
  [sym__close_parenthesis] = sym__close_parenthesis,
  [sym__open_brace] = sym__open_brace,
  [sym__close_brace] = sym__close_brace,
  [sym__open_bracket] = sym__open_bracket,
  [sym__close_bracket] = sym__close_bracket,
  [sym__open_bracket2] = sym__open_bracket2,
  [sym__close_bracket2] = sym__close_bracket2,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_function_definition_repeat1] = aux_sym_function_definition_repeat1,
  [aux_sym_parameters_repeat1] = aux_sym_parameters_repeat1,
  [aux_sym_braced_expression_repeat1] = aux_sym_braced_expression_repeat1,
  [aux_sym_call_arguments_repeat1] = aux_sym_call_arguments_repeat1,
  [alias_sym_string_content] = alias_sym_string_content,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_repeat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_binary_operator_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_L] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i] = {
    .visible = true,
    .named = false,
  },
  [sym__hex_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__number_literal] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__single_quoted_string_content_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__double_quoted_string_content_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_dots] = {
    .visible = true,
    .named = true,
  },
  [sym_dot_dot_i] = {
    .visible = true,
    .named = true,
  },
  [sym_return] = {
    .visible = true,
    .named = true,
  },
  [sym_next] = {
    .visible = true,
    .named = true,
  },
  [sym_break] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_inf] = {
    .visible = true,
    .named = true,
  },
  [sym_nan] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_NA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_integer_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_real_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_complex_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_character_] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_comma] = {
    .visible = true,
    .named = true,
  },
  [sym__start] = {
    .visible = false,
    .named = true,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym__semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__raw_string_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__external_else] = {
    .visible = true,
    .named = false,
  },
  [sym__external_open_parenthesis] = {
    .visible = true,
    .named = false,
  },
  [sym__external_close_parenthesis] = {
    .visible = true,
    .named = false,
  },
  [sym__external_open_brace] = {
    .visible = true,
    .named = false,
  },
  [sym__external_close_brace] = {
    .visible = true,
    .named = false,
  },
  [sym__external_open_bracket] = {
    .visible = true,
    .named = false,
  },
  [sym__external_close_bracket] = {
    .visible = true,
    .named = false,
  },
  [sym__external_open_bracket2] = {
    .visible = true,
    .named = false,
  },
  [sym__external_close_bracket2] = {
    .visible = true,
    .named = false,
  },
  [sym__error_sentinel] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_with_default] = {
    .visible = false,
    .named = true,
  },
  [sym__parameter_without_default] = {
    .visible = false,
    .named = true,
  },
  [sym__parameter_name] = {
    .visible = false,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_braced_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym_subset] = {
    .visible = true,
    .named = true,
  },
  [sym_subset2] = {
    .visible = true,
    .named = true,
  },
  [sym_call_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_subset_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_subset2_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__argument_named] = {
    .visible = false,
    .named = true,
  },
  [sym__argument_unnamed] = {
    .visible = false,
    .named = true,
  },
  [sym__argument_value] = {
    .visible = false,
    .named = true,
  },
  [sym_unary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_extract_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_complex] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym__float_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym__single_quoted_string] = {
    .visible = false,
    .named = true,
  },
  [sym__double_quoted_string] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__single_quoted_string_content] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__double_quoted_string_content] = {
    .visible = false,
    .named = false,
  },
  [sym__argument_name_string_or_identifier_or_null] = {
    .visible = false,
    .named = true,
  },
  [sym_na] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym__else] = {
    .visible = false,
    .named = true,
  },
  [sym__open_parenthesis] = {
    .visible = false,
    .named = true,
  },
  [sym__close_parenthesis] = {
    .visible = false,
    .named = true,
  },
  [sym__open_brace] = {
    .visible = false,
    .named = true,
  },
  [sym__close_brace] = {
    .visible = false,
    .named = true,
  },
  [sym__open_bracket] = {
    .visible = false,
    .named = true,
  },
  [sym__close_bracket] = {
    .visible = false,
    .named = true,
  },
  [sym__open_bracket2] = {
    .visible = false,
    .named = true,
  },
  [sym__close_bracket2] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_braced_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_call_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_string_content] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alternative = 1,
  field_argument = 2,
  field_arguments = 3,
  field_body = 4,
  field_close = 5,
  field_condition = 6,
  field_consequence = 7,
  field_content = 8,
  field_default = 9,
  field_function = 10,
  field_lhs = 11,
  field_name = 12,
  field_open = 13,
  field_operator = 14,
  field_parameter = 15,
  field_parameters = 16,
  field_rhs = 17,
  field_sequence = 18,
  field_value = 19,
  field_variable = 20,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_close] = "close",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_content] = "content",
  [field_default] = "default",
  [field_function] = "function",
  [field_lhs] = "lhs",
  [field_name] = "name",
  [field_open] = "open",
  [field_operator] = "operator",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_rhs] = "rhs",
  [field_sequence] = "sequence",
  [field_value] = "value",
  [field_variable] = "variable",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 3},
  [2] = {.index = 3, .length = 1},
  [3] = {.index = 4, .length = 2},
  [4] = {.index = 6, .length = 2},
  [5] = {.index = 8, .length = 2},
  [6] = {.index = 10, .length = 2},
  [7] = {.index = 12, .length = 1},
  [8] = {.index = 13, .length = 3},
  [9] = {.index = 16, .length = 1},
  [10] = {.index = 17, .length = 2},
  [11] = {.index = 19, .length = 1},
  [12] = {.index = 20, .length = 1},
  [13] = {.index = 21, .length = 2},
  [14] = {.index = 23, .length = 3},
  [15] = {.index = 26, .length = 3},
  [16] = {.index = 29, .length = 2},
  [17] = {.index = 31, .length = 1},
  [18] = {.index = 32, .length = 1},
  [19] = {.index = 33, .length = 3},
  [20] = {.index = 36, .length = 3},
  [21] = {.index = 39, .length = 2},
  [22] = {.index = 41, .length = 3},
  [23] = {.index = 44, .length = 3},
  [24] = {.index = 47, .length = 3},
  [25] = {.index = 50, .length = 3},
  [26] = {.index = 53, .length = 1},
  [27] = {.index = 54, .length = 3},
  [28] = {.index = 57, .length = 3},
  [29] = {.index = 60, .length = 2},
  [30] = {.index = 62, .length = 1},
  [31] = {.index = 63, .length = 4},
  [32] = {.index = 67, .length = 2},
  [33] = {.index = 69, .length = 2},
  [34] = {.index = 71, .length = 3},
  [35] = {.index = 74, .length = 4},
  [36] = {.index = 78, .length = 4},
  [37] = {.index = 82, .length = 4},
  [38] = {.index = 86, .length = 2},
  [39] = {.index = 88, .length = 4},
  [40] = {.index = 92, .length = 4},
  [41] = {.index = 96, .length = 4},
  [42] = {.index = 100, .length = 4},
  [43] = {.index = 104, .length = 5},
  [44] = {.index = 109, .length = 4},
  [45] = {.index = 113, .length = 5},
  [46] = {.index = 118, .length = 4},
  [47] = {.index = 122, .length = 5},
  [48] = {.index = 127, .length = 5},
  [49] = {.index = 132, .length = 5},
  [50] = {.index = 137, .length = 5},
  [51] = {.index = 142, .length = 5},
  [52] = {.index = 147, .length = 5},
  [53] = {.index = 152, .length = 5},
  [54] = {.index = 157, .length = 5},
  [55] = {.index = 162, .length = 5},
  [56] = {.index = 167, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_close, 0, .inherited = true},
    {field_content, 0, .inherited = true},
    {field_open, 0, .inherited = true},
  [3] =
    {field_body, 1},
  [4] =
    {field_operator, 0},
    {field_rhs, 1},
  [6] =
    {field_close, 1},
    {field_open, 0},
  [8] =
    {field_lhs, 0},
    {field_operator, 1},
  [10] =
    {field_arguments, 1},
    {field_function, 0},
  [12] =
    {field_body, 0},
  [13] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1},
  [16] =
    {field_name, 0},
  [17] =
    {field_default, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [19] =
    {field_name, 0, .inherited = true},
  [20] =
    {field_body, 2},
  [21] =
    {field_operator, 0},
    {field_rhs, 2},
  [23] =
    {field_close, 2},
    {field_content, 1},
    {field_open, 0},
  [26] =
    {field_lhs, 0},
    {field_operator, 1},
    {field_rhs, 2},
  [29] =
    {field_name, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [31] =
    {field_value, 0, .inherited = true},
  [32] =
    {field_value, 0},
  [33] =
    {field_body, 1},
    {field_close, 2},
    {field_open, 0},
  [36] =
    {field_body, 1, .inherited = true},
    {field_close, 2},
    {field_open, 0},
  [39] =
    {field_body, 0, .inherited = true},
    {field_body, 1, .inherited = true},
  [41] =
    {field_body, 3},
    {field_name, 0},
    {field_parameters, 1},
  [44] =
    {field_close, 2},
    {field_open, 0},
    {field_parameter, 1},
  [47] =
    {field_body, 3},
    {field_name, 0},
    {field_parameters, 2},
  [50] =
    {field_lhs, 0},
    {field_operator, 1},
    {field_rhs, 3},
  [53] =
    {field_argument, 1},
  [54] =
    {field_argument, 1},
    {field_close, 2},
    {field_open, 0},
  [57] =
    {field_argument, 1, .inherited = true},
    {field_close, 2},
    {field_open, 0},
  [60] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [62] =
    {field_parameter, 1},
  [63] =
    {field_close, 3},
    {field_open, 0},
    {field_parameter, 1},
    {field_parameter, 2, .inherited = true},
  [67] =
    {field_parameter, 0, .inherited = true},
    {field_parameter, 1, .inherited = true},
  [69] =
    {field_default, 2},
    {field_name, 0, .inherited = true},
  [71] =
    {field_body, 4},
    {field_name, 0},
    {field_parameters, 2},
  [74] =
    {field_close, 3},
    {field_condition, 2},
    {field_consequence, 4},
    {field_open, 1},
  [78] =
    {field_body, 4},
    {field_close, 3},
    {field_condition, 2},
    {field_open, 1},
  [82] =
    {field_argument, 1},
    {field_argument, 2, .inherited = true},
    {field_close, 3},
    {field_open, 0},
  [86] =
    {field_name, 0},
    {field_value, 2, .inherited = true},
  [88] =
    {field_close, 3},
    {field_condition, 2},
    {field_consequence, 5},
    {field_open, 1},
  [92] =
    {field_close, 4},
    {field_condition, 3},
    {field_consequence, 5},
    {field_open, 2},
  [96] =
    {field_body, 5},
    {field_close, 3},
    {field_condition, 2},
    {field_open, 1},
  [100] =
    {field_body, 5},
    {field_close, 4},
    {field_condition, 3},
    {field_open, 2},
  [104] =
    {field_alternative, 6},
    {field_close, 3},
    {field_condition, 2},
    {field_consequence, 4},
    {field_open, 1},
  [109] =
    {field_close, 4},
    {field_condition, 3},
    {field_consequence, 6},
    {field_open, 2},
  [113] =
    {field_body, 6},
    {field_close, 5},
    {field_open, 1},
    {field_sequence, 4},
    {field_variable, 2},
  [118] =
    {field_body, 6},
    {field_close, 4},
    {field_condition, 3},
    {field_open, 2},
  [122] =
    {field_alternative, 7},
    {field_close, 3},
    {field_condition, 2},
    {field_consequence, 4},
    {field_open, 1},
  [127] =
    {field_alternative, 7},
    {field_close, 3},
    {field_condition, 2},
    {field_consequence, 5},
    {field_open, 1},
  [132] =
    {field_alternative, 7},
    {field_close, 4},
    {field_condition, 3},
    {field_consequence, 5},
    {field_open, 2},
  [137] =
    {field_body, 7},
    {field_close, 5},
    {field_open, 1},
    {field_sequence, 4},
    {field_variable, 2},
  [142] =
    {field_body, 7},
    {field_close, 6},
    {field_open, 2},
    {field_sequence, 5},
    {field_variable, 3},
  [147] =
    {field_alternative, 8},
    {field_close, 3},
    {field_condition, 2},
    {field_consequence, 5},
    {field_open, 1},
  [152] =
    {field_alternative, 8},
    {field_close, 4},
    {field_condition, 3},
    {field_consequence, 5},
    {field_open, 2},
  [157] =
    {field_alternative, 8},
    {field_close, 4},
    {field_condition, 3},
    {field_consequence, 6},
    {field_open, 2},
  [162] =
    {field_body, 8},
    {field_close, 6},
    {field_open, 2},
    {field_sequence, 5},
    {field_variable, 3},
  [167] =
    {field_alternative, 9},
    {field_close, 4},
    {field_condition, 3},
    {field_consequence, 6},
    {field_open, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [14] = {
    [1] = alias_sym_string_content,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  aux_sym__single_quoted_string_content, 2,
    aux_sym__single_quoted_string_content,
    alias_sym_string_content,
  aux_sym__double_quoted_string_content, 2,
    aux_sym__double_quoted_string_content,
    alias_sym_string_content,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 2,
  [7] = 5,
  [8] = 3,
  [9] = 4,
  [10] = 4,
  [11] = 2,
  [12] = 5,
  [13] = 3,
  [14] = 4,
  [15] = 2,
  [16] = 5,
  [17] = 3,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 18,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 19,
  [76] = 20,
  [77] = 21,
  [78] = 22,
  [79] = 23,
  [80] = 24,
  [81] = 25,
  [82] = 26,
  [83] = 27,
  [84] = 28,
  [85] = 29,
  [86] = 30,
  [87] = 31,
  [88] = 32,
  [89] = 33,
  [90] = 34,
  [91] = 35,
  [92] = 36,
  [93] = 37,
  [94] = 38,
  [95] = 39,
  [96] = 40,
  [97] = 41,
  [98] = 42,
  [99] = 43,
  [100] = 44,
  [101] = 45,
  [102] = 46,
  [103] = 47,
  [104] = 48,
  [105] = 49,
  [106] = 50,
  [107] = 51,
  [108] = 52,
  [109] = 53,
  [110] = 54,
  [111] = 55,
  [112] = 56,
  [113] = 57,
  [114] = 58,
  [115] = 59,
  [116] = 60,
  [117] = 61,
  [118] = 62,
  [119] = 66,
  [120] = 64,
  [121] = 65,
  [122] = 67,
  [123] = 68,
  [124] = 69,
  [125] = 70,
  [126] = 71,
  [127] = 72,
  [128] = 73,
  [129] = 74,
  [130] = 29,
  [131] = 71,
  [132] = 72,
  [133] = 73,
  [134] = 74,
  [135] = 19,
  [136] = 20,
  [137] = 21,
  [138] = 23,
  [139] = 24,
  [140] = 25,
  [141] = 26,
  [142] = 27,
  [143] = 28,
  [144] = 29,
  [145] = 30,
  [146] = 31,
  [147] = 32,
  [148] = 33,
  [149] = 34,
  [150] = 35,
  [151] = 36,
  [152] = 37,
  [153] = 38,
  [154] = 39,
  [155] = 40,
  [156] = 41,
  [157] = 42,
  [158] = 43,
  [159] = 44,
  [160] = 45,
  [161] = 46,
  [162] = 47,
  [163] = 48,
  [164] = 49,
  [165] = 165,
  [166] = 50,
  [167] = 51,
  [168] = 52,
  [169] = 53,
  [170] = 66,
  [171] = 54,
  [172] = 55,
  [173] = 56,
  [174] = 57,
  [175] = 58,
  [176] = 59,
  [177] = 60,
  [178] = 61,
  [179] = 62,
  [180] = 18,
  [181] = 64,
  [182] = 65,
  [183] = 67,
  [184] = 68,
  [185] = 69,
  [186] = 70,
  [187] = 187,
  [188] = 71,
  [189] = 72,
  [190] = 73,
  [191] = 74,
  [192] = 19,
  [193] = 20,
  [194] = 21,
  [195] = 22,
  [196] = 23,
  [197] = 24,
  [198] = 25,
  [199] = 26,
  [200] = 27,
  [201] = 28,
  [202] = 30,
  [203] = 31,
  [204] = 32,
  [205] = 33,
  [206] = 34,
  [207] = 35,
  [208] = 36,
  [209] = 37,
  [210] = 38,
  [211] = 39,
  [212] = 40,
  [213] = 41,
  [214] = 42,
  [215] = 43,
  [216] = 44,
  [217] = 45,
  [218] = 46,
  [219] = 47,
  [220] = 48,
  [221] = 49,
  [222] = 50,
  [223] = 51,
  [224] = 52,
  [225] = 53,
  [226] = 54,
  [227] = 55,
  [228] = 56,
  [229] = 57,
  [230] = 58,
  [231] = 59,
  [232] = 60,
  [233] = 61,
  [234] = 62,
  [235] = 18,
  [236] = 64,
  [237] = 65,
  [238] = 66,
  [239] = 67,
  [240] = 68,
  [241] = 69,
  [242] = 70,
  [243] = 22,
  [244] = 244,
  [245] = 244,
  [246] = 246,
  [247] = 246,
  [248] = 248,
  [249] = 249,
  [250] = 244,
  [251] = 244,
  [252] = 252,
  [253] = 253,
  [254] = 252,
  [255] = 248,
  [256] = 253,
  [257] = 249,
  [258] = 249,
  [259] = 246,
  [260] = 248,
  [261] = 253,
  [262] = 249,
  [263] = 246,
  [264] = 248,
  [265] = 249,
  [266] = 248,
  [267] = 253,
  [268] = 249,
  [269] = 248,
  [270] = 253,
  [271] = 249,
  [272] = 248,
  [273] = 253,
  [274] = 249,
  [275] = 248,
  [276] = 253,
  [277] = 249,
  [278] = 248,
  [279] = 253,
  [280] = 249,
  [281] = 248,
  [282] = 253,
  [283] = 253,
  [284] = 284,
  [285] = 284,
  [286] = 286,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 286,
  [291] = 287,
  [292] = 288,
  [293] = 289,
  [294] = 294,
  [295] = 295,
  [296] = 294,
  [297] = 295,
  [298] = 298,
  [299] = 299,
  [300] = 252,
  [301] = 298,
  [302] = 299,
  [303] = 252,
  [304] = 287,
  [305] = 284,
  [306] = 295,
  [307] = 307,
  [308] = 288,
  [309] = 289,
  [310] = 310,
  [311] = 294,
  [312] = 310,
  [313] = 284,
  [314] = 286,
  [315] = 287,
  [316] = 288,
  [317] = 289,
  [318] = 307,
  [319] = 298,
  [320] = 299,
  [321] = 294,
  [322] = 295,
  [323] = 286,
  [324] = 310,
  [325] = 298,
  [326] = 299,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 307,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 332,
  [345] = 345,
  [346] = 335,
  [347] = 347,
  [348] = 348,
  [349] = 349,
  [350] = 333,
  [351] = 345,
  [352] = 352,
  [353] = 353,
  [354] = 307,
  [355] = 347,
  [356] = 336,
  [357] = 337,
  [358] = 339,
  [359] = 348,
  [360] = 338,
  [361] = 340,
  [362] = 362,
  [363] = 363,
  [364] = 349,
  [365] = 328,
  [366] = 329,
  [367] = 330,
  [368] = 331,
  [369] = 327,
  [370] = 352,
  [371] = 363,
  [372] = 353,
  [373] = 341,
  [374] = 342,
  [375] = 343,
  [376] = 362,
  [377] = 339,
  [378] = 362,
  [379] = 343,
  [380] = 332,
  [381] = 345,
  [382] = 335,
  [383] = 347,
  [384] = 352,
  [385] = 349,
  [386] = 386,
  [387] = 330,
  [388] = 333,
  [389] = 389,
  [390] = 386,
  [391] = 348,
  [392] = 349,
  [393] = 333,
  [394] = 338,
  [395] = 331,
  [396] = 327,
  [397] = 353,
  [398] = 386,
  [399] = 386,
  [400] = 386,
  [401] = 363,
  [402] = 389,
  [403] = 386,
  [404] = 345,
  [405] = 363,
  [406] = 340,
  [407] = 335,
  [408] = 338,
  [409] = 347,
  [410] = 336,
  [411] = 337,
  [412] = 342,
  [413] = 339,
  [414] = 389,
  [415] = 352,
  [416] = 353,
  [417] = 386,
  [418] = 389,
  [419] = 336,
  [420] = 341,
  [421] = 337,
  [422] = 389,
  [423] = 328,
  [424] = 329,
  [425] = 348,
  [426] = 389,
  [427] = 362,
  [428] = 340,
  [429] = 330,
  [430] = 389,
  [431] = 331,
  [432] = 327,
  [433] = 386,
  [434] = 389,
  [435] = 341,
  [436] = 342,
  [437] = 389,
  [438] = 343,
  [439] = 386,
  [440] = 332,
  [441] = 389,
  [442] = 328,
  [443] = 329,
  [444] = 386,
  [445] = 445,
  [446] = 446,
  [447] = 447,
  [448] = 448,
  [449] = 449,
  [450] = 449,
  [451] = 449,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 469,
  [470] = 470,
  [471] = 471,
  [472] = 472,
  [473] = 473,
  [474] = 474,
  [475] = 475,
  [476] = 476,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 477,
  [485] = 480,
  [486] = 455,
  [487] = 487,
  [488] = 488,
  [489] = 456,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 497,
  [498] = 487,
  [499] = 452,
  [500] = 500,
  [501] = 488,
  [502] = 502,
  [503] = 503,
  [504] = 504,
  [505] = 490,
  [506] = 506,
  [507] = 507,
  [508] = 508,
  [509] = 492,
  [510] = 510,
  [511] = 481,
  [512] = 482,
  [513] = 513,
  [514] = 514,
  [515] = 483,
  [516] = 516,
  [517] = 517,
  [518] = 518,
  [519] = 519,
  [520] = 520,
  [521] = 521,
  [522] = 522,
  [523] = 523,
  [524] = 453,
  [525] = 454,
  [526] = 457,
  [527] = 458,
  [528] = 460,
  [529] = 463,
  [530] = 465,
  [531] = 467,
  [532] = 469,
  [533] = 475,
  [534] = 513,
  [535] = 455,
  [536] = 456,
  [537] = 459,
  [538] = 461,
  [539] = 462,
  [540] = 464,
  [541] = 466,
  [542] = 468,
  [543] = 470,
  [544] = 471,
  [545] = 472,
  [546] = 473,
  [547] = 474,
  [548] = 476,
  [549] = 478,
  [550] = 477,
  [551] = 480,
  [552] = 487,
  [553] = 488,
  [554] = 490,
  [555] = 492,
  [556] = 494,
  [557] = 495,
  [558] = 496,
  [559] = 497,
  [560] = 452,
  [561] = 500,
  [562] = 502,
  [563] = 503,
  [564] = 504,
  [565] = 506,
  [566] = 508,
  [567] = 510,
  [568] = 481,
  [569] = 482,
  [570] = 513,
  [571] = 514,
  [572] = 483,
  [573] = 516,
  [574] = 517,
  [575] = 518,
  [576] = 519,
  [577] = 520,
  [578] = 521,
  [579] = 522,
  [580] = 523,
  [581] = 453,
  [582] = 454,
  [583] = 457,
  [584] = 458,
  [585] = 460,
  [586] = 463,
  [587] = 465,
  [588] = 467,
  [589] = 469,
  [590] = 475,
  [591] = 516,
  [592] = 455,
  [593] = 456,
  [594] = 494,
  [595] = 459,
  [596] = 461,
  [597] = 462,
  [598] = 464,
  [599] = 466,
  [600] = 468,
  [601] = 470,
  [602] = 471,
  [603] = 472,
  [604] = 473,
  [605] = 474,
  [606] = 476,
  [607] = 478,
  [608] = 477,
  [609] = 480,
  [610] = 487,
  [611] = 488,
  [612] = 490,
  [613] = 492,
  [614] = 494,
  [615] = 495,
  [616] = 496,
  [617] = 497,
  [618] = 452,
  [619] = 500,
  [620] = 502,
  [621] = 503,
  [622] = 504,
  [623] = 506,
  [624] = 508,
  [625] = 514,
  [626] = 510,
  [627] = 481,
  [628] = 482,
  [629] = 513,
  [630] = 514,
  [631] = 495,
  [632] = 496,
  [633] = 497,
  [634] = 517,
  [635] = 483,
  [636] = 518,
  [637] = 516,
  [638] = 500,
  [639] = 517,
  [640] = 518,
  [641] = 519,
  [642] = 520,
  [643] = 502,
  [644] = 519,
  [645] = 503,
  [646] = 504,
  [647] = 521,
  [648] = 523,
  [649] = 453,
  [650] = 454,
  [651] = 457,
  [652] = 458,
  [653] = 460,
  [654] = 463,
  [655] = 465,
  [656] = 467,
  [657] = 469,
  [658] = 475,
  [659] = 459,
  [660] = 506,
  [661] = 520,
  [662] = 461,
  [663] = 508,
  [664] = 462,
  [665] = 455,
  [666] = 456,
  [667] = 510,
  [668] = 481,
  [669] = 482,
  [670] = 513,
  [671] = 514,
  [672] = 459,
  [673] = 461,
  [674] = 462,
  [675] = 464,
  [676] = 483,
  [677] = 466,
  [678] = 468,
  [679] = 516,
  [680] = 470,
  [681] = 471,
  [682] = 517,
  [683] = 472,
  [684] = 473,
  [685] = 518,
  [686] = 474,
  [687] = 476,
  [688] = 519,
  [689] = 478,
  [690] = 520,
  [691] = 521,
  [692] = 522,
  [693] = 477,
  [694] = 480,
  [695] = 523,
  [696] = 453,
  [697] = 454,
  [698] = 457,
  [699] = 458,
  [700] = 460,
  [701] = 463,
  [702] = 465,
  [703] = 467,
  [704] = 469,
  [705] = 475,
  [706] = 464,
  [707] = 455,
  [708] = 456,
  [709] = 487,
  [710] = 488,
  [711] = 490,
  [712] = 492,
  [713] = 494,
  [714] = 495,
  [715] = 496,
  [716] = 497,
  [717] = 452,
  [718] = 500,
  [719] = 459,
  [720] = 502,
  [721] = 461,
  [722] = 503,
  [723] = 504,
  [724] = 462,
  [725] = 506,
  [726] = 464,
  [727] = 508,
  [728] = 466,
  [729] = 510,
  [730] = 481,
  [731] = 482,
  [732] = 513,
  [733] = 514,
  [734] = 483,
  [735] = 516,
  [736] = 517,
  [737] = 518,
  [738] = 519,
  [739] = 520,
  [740] = 521,
  [741] = 523,
  [742] = 453,
  [743] = 454,
  [744] = 457,
  [745] = 458,
  [746] = 460,
  [747] = 463,
  [748] = 465,
  [749] = 467,
  [750] = 469,
  [751] = 475,
  [752] = 468,
  [753] = 455,
  [754] = 456,
  [755] = 459,
  [756] = 461,
  [757] = 462,
  [758] = 464,
  [759] = 466,
  [760] = 468,
  [761] = 470,
  [762] = 471,
  [763] = 472,
  [764] = 473,
  [765] = 474,
  [766] = 476,
  [767] = 478,
  [768] = 477,
  [769] = 480,
  [770] = 487,
  [771] = 488,
  [772] = 490,
  [773] = 492,
  [774] = 494,
  [775] = 495,
  [776] = 496,
  [777] = 497,
  [778] = 452,
  [779] = 500,
  [780] = 502,
  [781] = 503,
  [782] = 504,
  [783] = 506,
  [784] = 508,
  [785] = 510,
  [786] = 481,
  [787] = 482,
  [788] = 513,
  [789] = 514,
  [790] = 470,
  [791] = 471,
  [792] = 472,
  [793] = 483,
  [794] = 516,
  [795] = 473,
  [796] = 517,
  [797] = 518,
  [798] = 474,
  [799] = 519,
  [800] = 520,
  [801] = 476,
  [802] = 478,
  [803] = 521,
  [804] = 523,
  [805] = 453,
  [806] = 454,
  [807] = 457,
  [808] = 458,
  [809] = 460,
  [810] = 463,
  [811] = 465,
  [812] = 467,
  [813] = 469,
  [814] = 475,
  [815] = 455,
  [816] = 456,
  [817] = 459,
  [818] = 461,
  [819] = 477,
  [820] = 462,
  [821] = 480,
  [822] = 464,
  [823] = 466,
  [824] = 468,
  [825] = 470,
  [826] = 471,
  [827] = 472,
  [828] = 473,
  [829] = 474,
  [830] = 476,
  [831] = 478,
  [832] = 466,
  [833] = 477,
  [834] = 480,
  [835] = 487,
  [836] = 488,
  [837] = 490,
  [838] = 492,
  [839] = 487,
  [840] = 488,
  [841] = 494,
  [842] = 495,
  [843] = 490,
  [844] = 492,
  [845] = 496,
  [846] = 497,
  [847] = 494,
  [848] = 495,
  [849] = 496,
  [850] = 497,
  [851] = 452,
  [852] = 500,
  [853] = 452,
  [854] = 500,
  [855] = 502,
  [856] = 503,
  [857] = 504,
  [858] = 502,
  [859] = 506,
  [860] = 503,
  [861] = 504,
  [862] = 508,
  [863] = 510,
  [864] = 481,
  [865] = 482,
  [866] = 513,
  [867] = 514,
  [868] = 483,
  [869] = 516,
  [870] = 517,
  [871] = 518,
  [872] = 519,
  [873] = 520,
  [874] = 521,
  [875] = 523,
  [876] = 453,
  [877] = 454,
  [878] = 457,
  [879] = 458,
  [880] = 460,
  [881] = 463,
  [882] = 465,
  [883] = 467,
  [884] = 469,
  [885] = 475,
  [886] = 506,
  [887] = 455,
  [888] = 456,
  [889] = 459,
  [890] = 461,
  [891] = 462,
  [892] = 464,
  [893] = 466,
  [894] = 468,
  [895] = 470,
  [896] = 471,
  [897] = 472,
  [898] = 473,
  [899] = 474,
  [900] = 476,
  [901] = 478,
  [902] = 477,
  [903] = 480,
  [904] = 487,
  [905] = 488,
  [906] = 490,
  [907] = 492,
  [908] = 494,
  [909] = 495,
  [910] = 496,
  [911] = 497,
  [912] = 452,
  [913] = 500,
  [914] = 502,
  [915] = 503,
  [916] = 504,
  [917] = 506,
  [918] = 508,
  [919] = 510,
  [920] = 481,
  [921] = 482,
  [922] = 513,
  [923] = 514,
  [924] = 483,
  [925] = 516,
  [926] = 517,
  [927] = 518,
  [928] = 519,
  [929] = 520,
  [930] = 521,
  [931] = 523,
  [932] = 453,
  [933] = 454,
  [934] = 457,
  [935] = 458,
  [936] = 460,
  [937] = 463,
  [938] = 465,
  [939] = 467,
  [940] = 469,
  [941] = 475,
  [942] = 455,
  [943] = 456,
  [944] = 459,
  [945] = 461,
  [946] = 462,
  [947] = 464,
  [948] = 466,
  [949] = 468,
  [950] = 470,
  [951] = 471,
  [952] = 472,
  [953] = 473,
  [954] = 474,
  [955] = 476,
  [956] = 478,
  [957] = 477,
  [958] = 480,
  [959] = 487,
  [960] = 488,
  [961] = 490,
  [962] = 492,
  [963] = 494,
  [964] = 495,
  [965] = 496,
  [966] = 497,
  [967] = 452,
  [968] = 500,
  [969] = 502,
  [970] = 503,
  [971] = 504,
  [972] = 506,
  [973] = 508,
  [974] = 508,
  [975] = 479,
  [976] = 491,
  [977] = 493,
  [978] = 510,
  [979] = 481,
  [980] = 507,
  [981] = 482,
  [982] = 513,
  [983] = 514,
  [984] = 468,
  [985] = 470,
  [986] = 471,
  [987] = 483,
  [988] = 479,
  [989] = 491,
  [990] = 493,
  [991] = 507,
  [992] = 516,
  [993] = 472,
  [994] = 517,
  [995] = 479,
  [996] = 491,
  [997] = 493,
  [998] = 507,
  [999] = 518,
  [1000] = 473,
  [1001] = 519,
  [1002] = 479,
  [1003] = 491,
  [1004] = 493,
  [1005] = 507,
  [1006] = 510,
  [1007] = 520,
  [1008] = 474,
  [1009] = 521,
  [1010] = 479,
  [1011] = 491,
  [1012] = 493,
  [1013] = 507,
  [1014] = 476,
  [1015] = 522,
  [1016] = 478,
  [1017] = 521,
  [1018] = 479,
  [1019] = 491,
  [1020] = 493,
  [1021] = 507,
  [1022] = 522,
  [1023] = 523,
  [1024] = 453,
  [1025] = 454,
  [1026] = 479,
  [1027] = 491,
  [1028] = 493,
  [1029] = 507,
  [1030] = 457,
  [1031] = 458,
  [1032] = 460,
  [1033] = 463,
  [1034] = 479,
  [1035] = 491,
  [1036] = 493,
  [1037] = 507,
  [1038] = 465,
  [1039] = 467,
  [1040] = 469,
  [1041] = 475,
  [1042] = 479,
  [1043] = 491,
  [1044] = 493,
  [1045] = 507,
  [1046] = 523,
  [1047] = 1047,
  [1048] = 1048,
  [1049] = 1049,
  [1050] = 1050,
  [1051] = 1051,
  [1052] = 1052,
  [1053] = 1053,
  [1054] = 1047,
  [1055] = 1055,
  [1056] = 1051,
  [1057] = 1053,
  [1058] = 1050,
  [1059] = 1048,
  [1060] = 1053,
  [1061] = 1050,
  [1062] = 1048,
  [1063] = 1047,
  [1064] = 1051,
  [1065] = 1053,
  [1066] = 1050,
  [1067] = 1048,
  [1068] = 1047,
  [1069] = 1051,
  [1070] = 1053,
  [1071] = 1050,
  [1072] = 1048,
  [1073] = 1047,
  [1074] = 1051,
  [1075] = 1053,
  [1076] = 1050,
  [1077] = 1048,
  [1078] = 1047,
  [1079] = 1051,
  [1080] = 1053,
  [1081] = 1050,
  [1082] = 1048,
  [1083] = 1047,
  [1084] = 1051,
  [1085] = 1053,
  [1086] = 1050,
  [1087] = 1048,
  [1088] = 1047,
  [1089] = 1051,
  [1090] = 1053,
  [1091] = 1050,
  [1092] = 1048,
  [1093] = 1047,
  [1094] = 1051,
  [1095] = 1053,
  [1096] = 1050,
  [1097] = 1048,
  [1098] = 1047,
  [1099] = 1052,
  [1100] = 1049,
  [1101] = 1052,
  [1102] = 1049,
  [1103] = 1052,
  [1104] = 1049,
  [1105] = 1052,
  [1106] = 1049,
  [1107] = 1052,
  [1108] = 1049,
  [1109] = 1052,
  [1110] = 1049,
  [1111] = 1052,
  [1112] = 1049,
  [1113] = 1052,
  [1114] = 1049,
  [1115] = 1052,
  [1116] = 1049,
  [1117] = 1051,
  [1118] = 246,
  [1119] = 246,
  [1120] = 244,
  [1121] = 246,
  [1122] = 244,
  [1123] = 244,
  [1124] = 244,
  [1125] = 246,
  [1126] = 246,
  [1127] = 246,
  [1128] = 244,
  [1129] = 244,
  [1130] = 252,
  [1131] = 252,
  [1132] = 252,
  [1133] = 307,
  [1134] = 307,
  [1135] = 252,
  [1136] = 252,
  [1137] = 252,
  [1138] = 307,
  [1139] = 3,
  [1140] = 4,
  [1141] = 2,
  [1142] = 5,
  [1143] = 3,
  [1144] = 4,
  [1145] = 307,
  [1146] = 2,
  [1147] = 307,
  [1148] = 307,
  [1149] = 5,
  [1150] = 3,
  [1151] = 2,
  [1152] = 5,
  [1153] = 3,
  [1154] = 4,
  [1155] = 4,
  [1156] = 2,
  [1157] = 5,
  [1158] = 2,
  [1159] = 5,
  [1160] = 3,
  [1161] = 4,
  [1162] = 2,
  [1163] = 5,
  [1164] = 4,
  [1165] = 3,
  [1166] = 21,
  [1167] = 45,
  [1168] = 46,
  [1169] = 47,
  [1170] = 48,
  [1171] = 49,
  [1172] = 50,
  [1173] = 51,
  [1174] = 52,
  [1175] = 53,
  [1176] = 33,
  [1177] = 54,
  [1178] = 55,
  [1179] = 56,
  [1180] = 57,
  [1181] = 58,
  [1182] = 59,
  [1183] = 60,
  [1184] = 61,
  [1185] = 62,
  [1186] = 18,
  [1187] = 64,
  [1188] = 65,
  [1189] = 66,
  [1190] = 67,
  [1191] = 68,
  [1192] = 69,
  [1193] = 70,
  [1194] = 66,
  [1195] = 67,
  [1196] = 71,
  [1197] = 72,
  [1198] = 73,
  [1199] = 74,
  [1200] = 19,
  [1201] = 20,
  [1202] = 34,
  [1203] = 22,
  [1204] = 23,
  [1205] = 24,
  [1206] = 25,
  [1207] = 26,
  [1208] = 27,
  [1209] = 28,
  [1210] = 35,
  [1211] = 29,
  [1212] = 30,
  [1213] = 31,
  [1214] = 32,
  [1215] = 36,
  [1216] = 33,
  [1217] = 37,
  [1218] = 34,
  [1219] = 35,
  [1220] = 36,
  [1221] = 37,
  [1222] = 38,
  [1223] = 39,
  [1224] = 40,
  [1225] = 41,
  [1226] = 42,
  [1227] = 43,
  [1228] = 44,
  [1229] = 45,
  [1230] = 46,
  [1231] = 47,
  [1232] = 48,
  [1233] = 49,
  [1234] = 50,
  [1235] = 51,
  [1236] = 52,
  [1237] = 53,
  [1238] = 54,
  [1239] = 55,
  [1240] = 56,
  [1241] = 57,
  [1242] = 58,
  [1243] = 59,
  [1244] = 60,
  [1245] = 61,
  [1246] = 62,
  [1247] = 18,
  [1248] = 64,
  [1249] = 65,
  [1250] = 38,
  [1251] = 39,
  [1252] = 40,
  [1253] = 41,
  [1254] = 44,
  [1255] = 43,
  [1256] = 44,
  [1257] = 45,
  [1258] = 46,
  [1259] = 47,
  [1260] = 48,
  [1261] = 49,
  [1262] = 50,
  [1263] = 68,
  [1264] = 51,
  [1265] = 52,
  [1266] = 53,
  [1267] = 54,
  [1268] = 69,
  [1269] = 55,
  [1270] = 56,
  [1271] = 57,
  [1272] = 58,
  [1273] = 59,
  [1274] = 60,
  [1275] = 71,
  [1276] = 61,
  [1277] = 62,
  [1278] = 18,
  [1279] = 64,
  [1280] = 65,
  [1281] = 70,
  [1282] = 72,
  [1283] = 73,
  [1284] = 74,
  [1285] = 19,
  [1286] = 20,
  [1287] = 21,
  [1288] = 22,
  [1289] = 23,
  [1290] = 66,
  [1291] = 67,
  [1292] = 68,
  [1293] = 69,
  [1294] = 70,
  [1295] = 24,
  [1296] = 25,
  [1297] = 26,
  [1298] = 27,
  [1299] = 28,
  [1300] = 29,
  [1301] = 71,
  [1302] = 30,
  [1303] = 72,
  [1304] = 73,
  [1305] = 74,
  [1306] = 19,
  [1307] = 20,
  [1308] = 21,
  [1309] = 22,
  [1310] = 23,
  [1311] = 24,
  [1312] = 25,
  [1313] = 26,
  [1314] = 27,
  [1315] = 28,
  [1316] = 31,
  [1317] = 29,
  [1318] = 30,
  [1319] = 31,
  [1320] = 32,
  [1321] = 33,
  [1322] = 32,
  [1323] = 34,
  [1324] = 35,
  [1325] = 36,
  [1326] = 37,
  [1327] = 38,
  [1328] = 39,
  [1329] = 40,
  [1330] = 41,
  [1331] = 42,
  [1332] = 43,
  [1333] = 42,
  [1334] = 68,
  [1335] = 53,
  [1336] = 36,
  [1337] = 37,
  [1338] = 38,
  [1339] = 39,
  [1340] = 40,
  [1341] = 41,
  [1342] = 42,
  [1343] = 43,
  [1344] = 44,
  [1345] = 54,
  [1346] = 45,
  [1347] = 46,
  [1348] = 47,
  [1349] = 48,
  [1350] = 55,
  [1351] = 56,
  [1352] = 57,
  [1353] = 58,
  [1354] = 59,
  [1355] = 60,
  [1356] = 49,
  [1357] = 59,
  [1358] = 50,
  [1359] = 1359,
  [1360] = 52,
  [1361] = 1361,
  [1362] = 23,
  [1363] = 60,
  [1364] = 69,
  [1365] = 54,
  [1366] = 51,
  [1367] = 52,
  [1368] = 53,
  [1369] = 70,
  [1370] = 54,
  [1371] = 1371,
  [1372] = 61,
  [1373] = 55,
  [1374] = 56,
  [1375] = 24,
  [1376] = 62,
  [1377] = 18,
  [1378] = 57,
  [1379] = 58,
  [1380] = 59,
  [1381] = 60,
  [1382] = 61,
  [1383] = 62,
  [1384] = 18,
  [1385] = 64,
  [1386] = 25,
  [1387] = 65,
  [1388] = 55,
  [1389] = 64,
  [1390] = 65,
  [1391] = 56,
  [1392] = 71,
  [1393] = 72,
  [1394] = 73,
  [1395] = 26,
  [1396] = 74,
  [1397] = 19,
  [1398] = 20,
  [1399] = 1399,
  [1400] = 21,
  [1401] = 22,
  [1402] = 1402,
  [1403] = 23,
  [1404] = 24,
  [1405] = 25,
  [1406] = 26,
  [1407] = 27,
  [1408] = 28,
  [1409] = 29,
  [1410] = 61,
  [1411] = 30,
  [1412] = 62,
  [1413] = 57,
  [1414] = 31,
  [1415] = 1415,
  [1416] = 58,
  [1417] = 1417,
  [1418] = 32,
  [1419] = 33,
  [1420] = 27,
  [1421] = 71,
  [1422] = 28,
  [1423] = 29,
  [1424] = 72,
  [1425] = 30,
  [1426] = 73,
  [1427] = 74,
  [1428] = 19,
  [1429] = 31,
  [1430] = 20,
  [1431] = 32,
  [1432] = 21,
  [1433] = 33,
  [1434] = 66,
  [1435] = 22,
  [1436] = 23,
  [1437] = 67,
  [1438] = 66,
  [1439] = 34,
  [1440] = 24,
  [1441] = 35,
  [1442] = 25,
  [1443] = 68,
  [1444] = 26,
  [1445] = 1445,
  [1446] = 27,
  [1447] = 69,
  [1448] = 18,
  [1449] = 67,
  [1450] = 64,
  [1451] = 65,
  [1452] = 1359,
  [1453] = 1371,
  [1454] = 1402,
  [1455] = 36,
  [1456] = 37,
  [1457] = 1457,
  [1458] = 68,
  [1459] = 38,
  [1460] = 39,
  [1461] = 1399,
  [1462] = 40,
  [1463] = 69,
  [1464] = 41,
  [1465] = 42,
  [1466] = 35,
  [1467] = 28,
  [1468] = 43,
  [1469] = 70,
  [1470] = 44,
  [1471] = 1359,
  [1472] = 1371,
  [1473] = 1402,
  [1474] = 1457,
  [1475] = 1399,
  [1476] = 1359,
  [1477] = 1371,
  [1478] = 1402,
  [1479] = 45,
  [1480] = 1457,
  [1481] = 46,
  [1482] = 1399,
  [1483] = 47,
  [1484] = 48,
  [1485] = 1359,
  [1486] = 1371,
  [1487] = 1402,
  [1488] = 1457,
  [1489] = 1399,
  [1490] = 1359,
  [1491] = 1371,
  [1492] = 49,
  [1493] = 1402,
  [1494] = 1457,
  [1495] = 1399,
  [1496] = 50,
  [1497] = 1359,
  [1498] = 1371,
  [1499] = 1402,
  [1500] = 71,
  [1501] = 1457,
  [1502] = 1399,
  [1503] = 72,
  [1504] = 1359,
  [1505] = 1371,
  [1506] = 1402,
  [1507] = 73,
  [1508] = 74,
  [1509] = 1457,
  [1510] = 19,
  [1511] = 1399,
  [1512] = 20,
  [1513] = 1359,
  [1514] = 1371,
  [1515] = 1402,
  [1516] = 34,
  [1517] = 1457,
  [1518] = 1399,
  [1519] = 51,
  [1520] = 52,
  [1521] = 1359,
  [1522] = 1371,
  [1523] = 1402,
  [1524] = 1457,
  [1525] = 1399,
  [1526] = 29,
  [1527] = 35,
  [1528] = 1417,
  [1529] = 70,
  [1530] = 21,
  [1531] = 1415,
  [1532] = 30,
  [1533] = 53,
  [1534] = 22,
  [1535] = 66,
  [1536] = 1457,
  [1537] = 31,
  [1538] = 1417,
  [1539] = 36,
  [1540] = 1415,
  [1541] = 32,
  [1542] = 37,
  [1543] = 38,
  [1544] = 1417,
  [1545] = 33,
  [1546] = 1415,
  [1547] = 39,
  [1548] = 40,
  [1549] = 1417,
  [1550] = 41,
  [1551] = 1415,
  [1552] = 1361,
  [1553] = 42,
  [1554] = 43,
  [1555] = 1417,
  [1556] = 1415,
  [1557] = 44,
  [1558] = 45,
  [1559] = 46,
  [1560] = 1417,
  [1561] = 47,
  [1562] = 1415,
  [1563] = 48,
  [1564] = 1417,
  [1565] = 1415,
  [1566] = 1417,
  [1567] = 1415,
  [1568] = 1417,
  [1569] = 1415,
  [1570] = 49,
  [1571] = 50,
  [1572] = 67,
  [1573] = 34,
  [1574] = 51,
  [1575] = 1361,
  [1576] = 289,
  [1577] = 286,
  [1578] = 287,
  [1579] = 288,
  [1580] = 286,
  [1581] = 298,
  [1582] = 299,
  [1583] = 298,
  [1584] = 299,
  [1585] = 1585,
  [1586] = 294,
  [1587] = 295,
  [1588] = 294,
  [1589] = 295,
  [1590] = 284,
  [1591] = 284,
  [1592] = 286,
  [1593] = 287,
  [1594] = 288,
  [1595] = 289,
  [1596] = 294,
  [1597] = 295,
  [1598] = 299,
  [1599] = 287,
  [1600] = 298,
  [1601] = 284,
  [1602] = 288,
  [1603] = 289,
  [1604] = 288,
  [1605] = 294,
  [1606] = 295,
  [1607] = 286,
  [1608] = 286,
  [1609] = 307,
  [1610] = 287,
  [1611] = 289,
  [1612] = 298,
  [1613] = 298,
  [1614] = 299,
  [1615] = 299,
  [1616] = 284,
  [1617] = 298,
  [1618] = 299,
  [1619] = 286,
  [1620] = 287,
  [1621] = 284,
  [1622] = 294,
  [1623] = 295,
  [1624] = 288,
  [1625] = 289,
  [1626] = 287,
  [1627] = 1627,
  [1628] = 1627,
  [1629] = 288,
  [1630] = 1627,
  [1631] = 295,
  [1632] = 289,
  [1633] = 284,
  [1634] = 294,
  [1635] = 353,
  [1636] = 337,
  [1637] = 340,
  [1638] = 363,
  [1639] = 328,
  [1640] = 329,
  [1641] = 340,
  [1642] = 328,
  [1643] = 341,
  [1644] = 342,
  [1645] = 343,
  [1646] = 341,
  [1647] = 342,
  [1648] = 343,
  [1649] = 332,
  [1650] = 345,
  [1651] = 335,
  [1652] = 347,
  [1653] = 332,
  [1654] = 348,
  [1655] = 349,
  [1656] = 333,
  [1657] = 336,
  [1658] = 341,
  [1659] = 345,
  [1660] = 335,
  [1661] = 347,
  [1662] = 337,
  [1663] = 342,
  [1664] = 343,
  [1665] = 348,
  [1666] = 332,
  [1667] = 345,
  [1668] = 349,
  [1669] = 333,
  [1670] = 335,
  [1671] = 347,
  [1672] = 339,
  [1673] = 329,
  [1674] = 362,
  [1675] = 336,
  [1676] = 349,
  [1677] = 338,
  [1678] = 333,
  [1679] = 330,
  [1680] = 331,
  [1681] = 352,
  [1682] = 327,
  [1683] = 338,
  [1684] = 353,
  [1685] = 330,
  [1686] = 331,
  [1687] = 327,
  [1688] = 363,
  [1689] = 336,
  [1690] = 340,
  [1691] = 337,
  [1692] = 1692,
  [1693] = 339,
  [1694] = 1694,
  [1695] = 362,
  [1696] = 352,
  [1697] = 1697,
  [1698] = 339,
  [1699] = 362,
  [1700] = 352,
  [1701] = 353,
  [1702] = 338,
  [1703] = 363,
  [1704] = 328,
  [1705] = 329,
  [1706] = 330,
  [1707] = 331,
  [1708] = 327,
  [1709] = 348,
  [1710] = 353,
  [1711] = 362,
  [1712] = 341,
  [1713] = 328,
  [1714] = 329,
  [1715] = 340,
  [1716] = 338,
  [1717] = 336,
  [1718] = 362,
  [1719] = 337,
  [1720] = 363,
  [1721] = 329,
  [1722] = 341,
  [1723] = 342,
  [1724] = 343,
  [1725] = 332,
  [1726] = 352,
  [1727] = 345,
  [1728] = 335,
  [1729] = 347,
  [1730] = 353,
  [1731] = 363,
  [1732] = 352,
  [1733] = 330,
  [1734] = 330,
  [1735] = 339,
  [1736] = 353,
  [1737] = 362,
  [1738] = 352,
  [1739] = 331,
  [1740] = 331,
  [1741] = 348,
  [1742] = 338,
  [1743] = 348,
  [1744] = 327,
  [1745] = 349,
  [1746] = 327,
  [1747] = 337,
  [1748] = 345,
  [1749] = 333,
  [1750] = 338,
  [1751] = 328,
  [1752] = 1752,
  [1753] = 327,
  [1754] = 349,
  [1755] = 340,
  [1756] = 333,
  [1757] = 347,
  [1758] = 340,
  [1759] = 342,
  [1760] = 336,
  [1761] = 339,
  [1762] = 337,
  [1763] = 335,
  [1764] = 339,
  [1765] = 363,
  [1766] = 343,
  [1767] = 336,
  [1768] = 328,
  [1769] = 329,
  [1770] = 341,
  [1771] = 342,
  [1772] = 343,
  [1773] = 330,
  [1774] = 332,
  [1775] = 345,
  [1776] = 335,
  [1777] = 347,
  [1778] = 332,
  [1779] = 1752,
  [1780] = 331,
  [1781] = 348,
  [1782] = 349,
  [1783] = 333,
  [1784] = 1752,
  [1785] = 1785,
  [1786] = 1786,
  [1787] = 1787,
  [1788] = 1788,
  [1789] = 1788,
  [1790] = 1787,
  [1791] = 1788,
  [1792] = 1787,
  [1793] = 1788,
  [1794] = 1787,
  [1795] = 1787,
  [1796] = 1788,
  [1797] = 1787,
  [1798] = 1787,
  [1799] = 1788,
  [1800] = 1788,
  [1801] = 1788,
  [1802] = 1787,
  [1803] = 1787,
  [1804] = 1787,
  [1805] = 1788,
  [1806] = 1788,
  [1807] = 1807,
  [1808] = 1808,
  [1809] = 1809,
  [1810] = 1810,
  [1811] = 1811,
  [1812] = 1811,
  [1813] = 1813,
  [1814] = 1813,
  [1815] = 1815,
  [1816] = 1816,
  [1817] = 1817,
  [1818] = 1818,
  [1819] = 1819,
  [1820] = 1808,
  [1821] = 1816,
  [1822] = 1807,
  [1823] = 1823,
  [1824] = 1818,
  [1825] = 1825,
  [1826] = 1826,
  [1827] = 1817,
  [1828] = 1819,
  [1829] = 1825,
  [1830] = 1819,
  [1831] = 1808,
  [1832] = 1811,
  [1833] = 1813,
  [1834] = 1823,
  [1835] = 1816,
  [1836] = 1817,
  [1837] = 1818,
  [1838] = 1809,
  [1839] = 1807,
  [1840] = 1823,
  [1841] = 1811,
  [1842] = 1807,
  [1843] = 1823,
  [1844] = 1811,
  [1845] = 1826,
  [1846] = 1810,
  [1847] = 1826,
  [1848] = 1813,
  [1849] = 1808,
  [1850] = 1808,
  [1851] = 1811,
  [1852] = 1813,
  [1853] = 1810,
  [1854] = 1809,
  [1855] = 1816,
  [1856] = 1817,
  [1857] = 1808,
  [1858] = 1858,
  [1859] = 1818,
  [1860] = 1811,
  [1861] = 1807,
  [1862] = 1823,
  [1863] = 1813,
  [1864] = 1864,
  [1865] = 1826,
  [1866] = 1809,
  [1867] = 1819,
  [1868] = 1816,
  [1869] = 1811,
  [1870] = 1813,
  [1871] = 1810,
  [1872] = 1816,
  [1873] = 1816,
  [1874] = 1817,
  [1875] = 1817,
  [1876] = 1817,
  [1877] = 1877,
  [1878] = 1817,
  [1879] = 1823,
  [1880] = 1880,
  [1881] = 1826,
  [1882] = 1825,
  [1883] = 1813,
  [1884] = 1819,
  [1885] = 1885,
  [1886] = 1807,
  [1887] = 1823,
  [1888] = 1811,
  [1889] = 1818,
  [1890] = 1813,
  [1891] = 1891,
  [1892] = 1819,
  [1893] = 1818,
  [1894] = 1826,
  [1895] = 1807,
  [1896] = 1808,
  [1897] = 1816,
  [1898] = 1817,
  [1899] = 1810,
  [1900] = 1900,
  [1901] = 1810,
  [1902] = 1807,
  [1903] = 1818,
  [1904] = 1818,
  [1905] = 1825,
  [1906] = 1807,
  [1907] = 1825,
  [1908] = 1823,
  [1909] = 1810,
  [1910] = 1811,
  [1911] = 1813,
  [1912] = 1826,
  [1913] = 1913,
  [1914] = 1809,
  [1915] = 1810,
  [1916] = 1819,
  [1917] = 1809,
  [1918] = 1819,
  [1919] = 1808,
  [1920] = 1808,
  [1921] = 1823,
  [1922] = 1809,
  [1923] = 1810,
  [1924] = 1816,
  [1925] = 1819,
  [1926] = 1825,
  [1927] = 1825,
  [1928] = 1818,
  [1929] = 1825,
  [1930] = 1864,
  [1931] = 1825,
  [1932] = 1891,
  [1933] = 1826,
  [1934] = 1826,
  [1935] = 1809,
  [1936] = 1864,
  [1937] = 1810,
  [1938] = 1891,
  [1939] = 1819,
  [1940] = 1864,
  [1941] = 1807,
  [1942] = 1891,
  [1943] = 1808,
  [1944] = 1864,
  [1945] = 1823,
  [1946] = 1891,
  [1947] = 1947,
  [1948] = 1864,
  [1949] = 1891,
  [1950] = 1864,
  [1951] = 1826,
  [1952] = 1891,
  [1953] = 1809,
  [1954] = 1864,
  [1955] = 1818,
  [1956] = 1891,
  [1957] = 1864,
  [1958] = 1816,
  [1959] = 1891,
  [1960] = 1825,
  [1961] = 1864,
  [1962] = 1891,
  [1963] = 1913,
  [1964] = 1809,
  [1965] = 1900,
  [1966] = 1913,
  [1967] = 1900,
  [1968] = 1913,
  [1969] = 1900,
  [1970] = 1913,
  [1971] = 1900,
  [1972] = 1913,
  [1973] = 1900,
  [1974] = 1913,
  [1975] = 1900,
  [1976] = 1913,
  [1977] = 1900,
  [1978] = 1913,
  [1979] = 1900,
  [1980] = 1913,
  [1981] = 1815,
  [1982] = 1900,
  [1983] = 1858,
  [1984] = 1815,
  [1985] = 1858,
  [1986] = 1815,
  [1987] = 1858,
  [1988] = 1815,
  [1989] = 1858,
  [1990] = 1815,
  [1991] = 1858,
  [1992] = 1815,
  [1993] = 1858,
  [1994] = 1815,
  [1995] = 1858,
  [1996] = 1815,
  [1997] = 1858,
  [1998] = 1815,
  [1999] = 1858,
  [2000] = 1817,
  [2001] = 307,
  [2002] = 2002,
  [2003] = 2003,
  [2004] = 2004,
  [2005] = 2004,
  [2006] = 2006,
  [2007] = 2007,
  [2008] = 2003,
  [2009] = 2009,
  [2010] = 2003,
  [2011] = 2009,
  [2012] = 2003,
  [2013] = 2009,
  [2014] = 2014,
  [2015] = 2003,
  [2016] = 2009,
  [2017] = 2004,
  [2018] = 2003,
  [2019] = 2009,
  [2020] = 2003,
  [2021] = 2009,
  [2022] = 2003,
  [2023] = 2009,
  [2024] = 2009,
  [2025] = 2003,
  [2026] = 2009,
  [2027] = 2003,
  [2028] = 2009,
  [2029] = 2029,
  [2030] = 2030,
  [2031] = 2031,
  [2032] = 2032,
  [2033] = 2033,
  [2034] = 2034,
  [2035] = 2031,
  [2036] = 2036,
  [2037] = 2037,
  [2038] = 2037,
  [2039] = 2033,
  [2040] = 2032,
  [2041] = 2037,
  [2042] = 2033,
  [2043] = 2030,
  [2044] = 2044,
  [2045] = 2031,
  [2046] = 2032,
  [2047] = 2030,
  [2048] = 2048,
  [2049] = 2049,
  [2050] = 2048,
  [2051] = 2049,
  [2052] = 2048,
  [2053] = 2053,
  [2054] = 2054,
  [2055] = 2049,
  [2056] = 2049,
  [2057] = 2049,
  [2058] = 2048,
  [2059] = 2054,
  [2060] = 2048,
  [2061] = 2048,
  [2062] = 2049,
  [2063] = 2049,
  [2064] = 2048,
  [2065] = 2048,
  [2066] = 2049,
  [2067] = 2048,
  [2068] = 2049,
  [2069] = 2049,
  [2070] = 2048,
  [2071] = 2054,
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'.', '.'}, {'A', 'Z'}, {'_', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xba, 0xba}, {0xc0, 0xd6}, {0xd8, 0xf6},
  {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x370, 0x374}, {0x376, 0x377}, {0x37b, 0x37d},
  {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481}, {0x48a, 0x52f},
  {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x620, 0x64a}, {0x66e, 0x66f}, {0x671, 0x6d3},
  {0x6d5, 0x6d5}, {0x6e5, 0x6e6}, {0x6ee, 0x6ef}, {0x6fa, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x710}, {0x712, 0x72f}, {0x74d, 0x7a5},
  {0x7b1, 0x7b1}, {0x7ca, 0x7ea}, {0x7f4, 0x7f5}, {0x7fa, 0x7fa}, {0x800, 0x815}, {0x81a, 0x81a}, {0x824, 0x824}, {0x828, 0x828},
  {0x840, 0x858}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x8a0, 0x8c9}, {0x904, 0x939}, {0x93d, 0x93d}, {0x950, 0x950},
  {0x958, 0x961}, {0x971, 0x980}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9},
  {0x9bd, 0x9bd}, {0x9ce, 0x9ce}, {0x9dc, 0x9dd}, {0x9df, 0x9e1}, {0x9f0, 0x9f1}, {0x9fc, 0x9fc}, {0xa05, 0xa0a}, {0xa0f, 0xa10},
  {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa72, 0xa74},
  {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabd, 0xabd}, {0xad0, 0xad0},
  {0xae0, 0xae1}, {0xaf9, 0xaf9}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39},
  {0xb3d, 0xb3d}, {0xb5c, 0xb5d}, {0xb5f, 0xb61}, {0xb71, 0xb71}, {0xb83, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90}, {0xb92, 0xb95},
  {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbd0, 0xbd0}, {0xc05, 0xc0c},
  {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3d, 0xc3d}, {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc61}, {0xc80, 0xc80},
  {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbd, 0xcbd}, {0xcdd, 0xcde}, {0xce0, 0xce1},
  {0xcf1, 0xcf2}, {0xd04, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd3a}, {0xd3d, 0xd3d}, {0xd4e, 0xd4e}, {0xd54, 0xd56}, {0xd5f, 0xd61},
  {0xd7a, 0xd7f}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xe01, 0xe30}, {0xe32, 0xe32},
  {0xe40, 0xe46}, {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xeb0}, {0xeb2, 0xeb2},
  {0xebd, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf40, 0xf47}, {0xf49, 0xf6c}, {0xf88, 0xf8c},
  {0x1000, 0x102a}, {0x103f, 0x103f}, {0x1050, 0x1055}, {0x105a, 0x105d}, {0x1061, 0x1061}, {0x1065, 0x1066}, {0x106e, 0x1070}, {0x1075, 0x1081},
  {0x108e, 0x108e}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256},
  {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0},
  {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd},
  {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1711}, {0x171f, 0x1731}, {0x1740, 0x1751},
  {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dc}, {0x1820, 0x1878}, {0x1880, 0x18a8}, {0x18aa, 0x18aa},
  {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1950, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x1a00, 0x1a16}, {0x1a20, 0x1a54},
  {0x1aa7, 0x1aa7}, {0x1b05, 0x1b33}, {0x1b45, 0x1b4c}, {0x1b83, 0x1ba0}, {0x1bae, 0x1baf}, {0x1bba, 0x1be5}, {0x1c00, 0x1c23}, {0x1c4d, 0x1c4f},
  {0x1c5a, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3}, {0x1cf5, 0x1cf6}, {0x1cfa, 0x1cfa},
  {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b},
  {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3},
  {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2071, 0x2071}, {0x207f, 0x207f}, {0x2090, 0x209c}, {0x2102, 0x2102},
  {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139},
  {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25},
  {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6},
  {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x3005, 0x3007}, {0x3021, 0x3029}, {0x3031, 0x3035},
  {0x3038, 0x303c}, {0x3041, 0x3096}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf},
  {0x31f0, 0x31ff}, {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa61f}, {0xa62a, 0xa62b}, {0xa640, 0xa66e},
  {0xa67f, 0xa69d}, {0xa6a0, 0xa6ef}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9},
  {0xa7f2, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa822}, {0xa840, 0xa873}, {0xa882, 0xa8b3}, {0xa8f2, 0xa8f7}, {0xa8fb, 0xa8fb},
  {0xa8fd, 0xa8fe}, {0xa90a, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, {0xa984, 0xa9b2}, {0xa9cf, 0xa9cf}, {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9ef},
  {0xa9fa, 0xa9fe}, {0xaa00, 0xaa28}, {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa60, 0xaa76}, {0xaa7a, 0xaa7a}, {0xaa7e, 0xaaaf}, {0xaab1, 0xaab1},
  {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaac0, 0xaac0}, {0xaac2, 0xaac2}, {0xaadb, 0xaadd}, {0xaae0, 0xaaea}, {0xaaf2, 0xaaf4}, {0xab01, 0xab06},
  {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69}, {0xab70, 0xabe2}, {0xac00, 0xd7a3},
  {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb1d}, {0xfb1f, 0xfb28},
  {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d},
  {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b},
  {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xff9d}, {0xffa0, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf},
  {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d},
  {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x10375}, {0x10380, 0x1039d},
  {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563},
  {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc},
  {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808},
  {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5},
  {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a00}, {0x10a10, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35},
  {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91},
  {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d23}, {0x10e80, 0x10ea9}, {0x10eb0, 0x10eb1}, {0x10f00, 0x10f1c}, {0x10f27, 0x10f27},
  {0x10f30, 0x10f45}, {0x10f70, 0x10f81}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11003, 0x11037}, {0x11071, 0x11072}, {0x11075, 0x11075}, {0x11083, 0x110af},
  {0x110d0, 0x110e8}, {0x11103, 0x11126}, {0x11144, 0x11144}, {0x11147, 0x11147}, {0x11150, 0x11172}, {0x11176, 0x11176}, {0x11183, 0x111b2}, {0x111c1, 0x111c4},
  {0x111da, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x1122b}, {0x1123f, 0x11240}, {0x11280, 0x11286}, {0x11288, 0x11288}, {0x1128a, 0x1128d},
  {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112de}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333},
  {0x11335, 0x11339}, {0x1133d, 0x1133d}, {0x11350, 0x11350}, {0x1135d, 0x11361}, {0x11400, 0x11434}, {0x11447, 0x1144a}, {0x1145f, 0x11461}, {0x11480, 0x114af},
  {0x114c4, 0x114c5}, {0x114c7, 0x114c7}, {0x11580, 0x115ae}, {0x115d8, 0x115db}, {0x11600, 0x1162f}, {0x11644, 0x11644}, {0x11680, 0x116aa}, {0x116b8, 0x116b8},
  {0x11700, 0x1171a}, {0x11740, 0x11746}, {0x11800, 0x1182b}, {0x118a0, 0x118df}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916},
  {0x11918, 0x1192f}, {0x1193f, 0x1193f}, {0x11941, 0x11941}, {0x119a0, 0x119a7}, {0x119aa, 0x119d0}, {0x119e1, 0x119e1}, {0x119e3, 0x119e3}, {0x11a00, 0x11a00},
  {0x11a0b, 0x11a32}, {0x11a3a, 0x11a3a}, {0x11a50, 0x11a50}, {0x11a5c, 0x11a89}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c2e},
  {0x11c40, 0x11c40}, {0x11c72, 0x11c8f}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, {0x11d46, 0x11d46}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68},
  {0x11d6a, 0x11d89}, {0x11d98, 0x11d98}, {0x11ee0, 0x11ef2}, {0x11f02, 0x11f02}, {0x11f04, 0x11f10}, {0x11f12, 0x11f33}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399},
  {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342f}, {0x13441, 0x13446}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e},
  {0x16a70, 0x16abe}, {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, {0x16b40, 0x16b43}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a},
  {0x16f50, 0x16f50}, {0x16f93, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe3}, {0x17000, 0x187f7}, {0x18800, 0x18cd5}, {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3},
  {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132}, {0x1b150, 0x1b152}, {0x1b155, 0x1b155}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb},
  {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2},
  {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514},
  {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0},
  {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8},
  {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e030, 0x1e06d}, {0x1e100, 0x1e12c}, {0x1e137, 0x1e13d}, {0x1e14e, 0x1e14e},
  {0x1e290, 0x1e2ad}, {0x1e2c0, 0x1e2eb}, {0x1e4d0, 0x1e4eb}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4},
  {0x1e900, 0x1e943}, {0x1e94b, 0x1e94b}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24}, {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32},
  {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49}, {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f},
  {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d}, {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62},
  {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b},
  {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x20000, 0x2a6df}, {0x2a700, 0x2b739}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0},
  {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x323af},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'.', '.'}, {'0', '9'}, {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xb7, 0xb7},
  {0xba, 0xba}, {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee},
  {0x300, 0x374}, {0x376, 0x377}, {0x37b, 0x37d}, {0x37f, 0x37f}, {0x386, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5},
  {0x3f7, 0x481}, {0x483, 0x487}, {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x591, 0x5bd}, {0x5bf, 0x5bf},
  {0x5c1, 0x5c2}, {0x5c4, 0x5c5}, {0x5c7, 0x5c7}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x610, 0x61a}, {0x620, 0x669}, {0x66e, 0x6d3},
  {0x6d5, 0x6dc}, {0x6df, 0x6e8}, {0x6ea, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x74a}, {0x74d, 0x7b1}, {0x7c0, 0x7f5}, {0x7fa, 0x7fa},
  {0x7fd, 0x7fd}, {0x800, 0x82d}, {0x840, 0x85b}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x898, 0x8e1}, {0x8e3, 0x963},
  {0x966, 0x96f}, {0x971, 0x983}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9},
  {0x9bc, 0x9c4}, {0x9c7, 0x9c8}, {0x9cb, 0x9ce}, {0x9d7, 0x9d7}, {0x9dc, 0x9dd}, {0x9df, 0x9e3}, {0x9e6, 0x9f1}, {0x9fc, 0x9fc},
  {0x9fe, 0x9fe}, {0xa01, 0xa03}, {0xa05, 0xa0a}, {0xa0f, 0xa10}, {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36},
  {0xa38, 0xa39}, {0xa3c, 0xa3c}, {0xa3e, 0xa42}, {0xa47, 0xa48}, {0xa4b, 0xa4d}, {0xa51, 0xa51}, {0xa59, 0xa5c}, {0xa5e, 0xa5e},
  {0xa66, 0xa75}, {0xa81, 0xa83}, {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9},
  {0xabc, 0xac5}, {0xac7, 0xac9}, {0xacb, 0xacd}, {0xad0, 0xad0}, {0xae0, 0xae3}, {0xae6, 0xaef}, {0xaf9, 0xaff}, {0xb01, 0xb03},
  {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39}, {0xb3c, 0xb44}, {0xb47, 0xb48},
  {0xb4b, 0xb4d}, {0xb55, 0xb57}, {0xb5c, 0xb5d}, {0xb5f, 0xb63}, {0xb66, 0xb6f}, {0xb71, 0xb71}, {0xb82, 0xb83}, {0xb85, 0xb8a},
  {0xb8e, 0xb90}, {0xb92, 0xb95}, {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9},
  {0xbbe, 0xbc2}, {0xbc6, 0xbc8}, {0xbca, 0xbcd}, {0xbd0, 0xbd0}, {0xbd7, 0xbd7}, {0xbe6, 0xbef}, {0xc00, 0xc0c}, {0xc0e, 0xc10},
  {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3c, 0xc44}, {0xc46, 0xc48}, {0xc4a, 0xc4d}, {0xc55, 0xc56}, {0xc58, 0xc5a}, {0xc5d, 0xc5d},
  {0xc60, 0xc63}, {0xc66, 0xc6f}, {0xc80, 0xc83}, {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9},
  {0xcbc, 0xcc4}, {0xcc6, 0xcc8}, {0xcca, 0xccd}, {0xcd5, 0xcd6}, {0xcdd, 0xcde}, {0xce0, 0xce3}, {0xce6, 0xcef}, {0xcf1, 0xcf3},
  {0xd00, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd44}, {0xd46, 0xd48}, {0xd4a, 0xd4e}, {0xd54, 0xd57}, {0xd5f, 0xd63}, {0xd66, 0xd6f},
  {0xd7a, 0xd7f}, {0xd81, 0xd83}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xdca, 0xdca},
  {0xdcf, 0xdd4}, {0xdd6, 0xdd6}, {0xdd8, 0xddf}, {0xde6, 0xdef}, {0xdf2, 0xdf3}, {0xe01, 0xe3a}, {0xe40, 0xe4e}, {0xe50, 0xe59},
  {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6},
  {0xec8, 0xece}, {0xed0, 0xed9}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf18, 0xf19}, {0xf20, 0xf29}, {0xf35, 0xf35}, {0xf37, 0xf37},
  {0xf39, 0xf39}, {0xf3e, 0xf47}, {0xf49, 0xf6c}, {0xf71, 0xf84}, {0xf86, 0xf97}, {0xf99, 0xfbc}, {0xfc6, 0xfc6}, {0x1000, 0x1049},
  {0x1050, 0x109d}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256},
  {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0},
  {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x135d, 0x135f}, {0x1369, 0x1371}, {0x1380, 0x138f},
  {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1715},
  {0x171f, 0x1734}, {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}, {0x1780, 0x17d3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dd},
  {0x17e0, 0x17e9}, {0x180b, 0x180d}, {0x180f, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1920, 0x192b},
  {0x1930, 0x193b}, {0x1946, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, {0x1a00, 0x1a1b}, {0x1a20, 0x1a5e},
  {0x1a60, 0x1a7c}, {0x1a7f, 0x1a89}, {0x1a90, 0x1a99}, {0x1aa7, 0x1aa7}, {0x1ab0, 0x1abd}, {0x1abf, 0x1ace}, {0x1b00, 0x1b4c}, {0x1b50, 0x1b59},
  {0x1b6b, 0x1b73}, {0x1b80, 0x1bf3}, {0x1c00, 0x1c37}, {0x1c40, 0x1c49}, {0x1c4d, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf},
  {0x1cd0, 0x1cd2}, {0x1cd4, 0x1cfa}, {0x1d00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59},
  {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc},
  {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x200c, 0x200d}, {0x203f, 0x2040}, {0x2054, 0x2054},
  {0x2071, 0x2071}, {0x207f, 0x207f}, {0x2090, 0x209c}, {0x20d0, 0x20dc}, {0x20e1, 0x20e1}, {0x20e5, 0x20f0}, {0x2102, 0x2102}, {0x2107, 0x2107},
  {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139}, {0x213c, 0x213f},
  {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d},
  {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d7f, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6},
  {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2de0, 0x2dff}, {0x3005, 0x3007}, {0x3021, 0x302f}, {0x3031, 0x3035}, {0x3038, 0x303c},
  {0x3041, 0x3096}, {0x3099, 0x309a}, {0x309d, 0x309f}, {0x30a1, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf}, {0x31f0, 0x31ff},
  {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa62b}, {0xa640, 0xa66f}, {0xa674, 0xa67d}, {0xa67f, 0xa6f1},
  {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f2, 0xa827}, {0xa82c, 0xa82c},
  {0xa840, 0xa873}, {0xa880, 0xa8c5}, {0xa8d0, 0xa8d9}, {0xa8e0, 0xa8f7}, {0xa8fb, 0xa8fb}, {0xa8fd, 0xa92d}, {0xa930, 0xa953}, {0xa960, 0xa97c},
  {0xa980, 0xa9c0}, {0xa9cf, 0xa9d9}, {0xa9e0, 0xa9fe}, {0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, {0xaa50, 0xaa59}, {0xaa60, 0xaa76}, {0xaa7a, 0xaac2},
  {0xaadb, 0xaadd}, {0xaae0, 0xaaef}, {0xaaf2, 0xaaf6}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e},
  {0xab30, 0xab5a}, {0xab5c, 0xab69}, {0xab70, 0xabea}, {0xabec, 0xabed}, {0xabf0, 0xabf9}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb},
  {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e},
  {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9},
  {0xfe00, 0xfe0f}, {0xfe20, 0xfe2f}, {0xfe33, 0xfe34}, {0xfe4d, 0xfe4f}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79},
  {0xfe7b, 0xfe7b}, {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff10, 0xff19}, {0xff21, 0xff3a}, {0xff3f, 0xff3f}, {0xff41, 0xff5a}, {0xff65, 0xffbe},
  {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d},
  {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x101fd, 0x101fd}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x102e0, 0x102e0},
  {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x1037a}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d},
  {0x104a0, 0x104a9}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592},
  {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767},
  {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c},
  {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7},
  {0x109be, 0x109bf}, {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a38, 0x10a3a}, {0x10a3f, 0x10a3f},
  {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae6}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91},
  {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d27}, {0x10d30, 0x10d39}, {0x10e80, 0x10ea9}, {0x10eab, 0x10eac}, {0x10eb0, 0x10eb1},
  {0x10efd, 0x10f1c}, {0x10f27, 0x10f27}, {0x10f30, 0x10f50}, {0x10f70, 0x10f85}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11000, 0x11046}, {0x11066, 0x11075},
  {0x1107f, 0x110ba}, {0x110c2, 0x110c2}, {0x110d0, 0x110e8}, {0x110f0, 0x110f9}, {0x11100, 0x11134}, {0x11136, 0x1113f}, {0x11144, 0x11147}, {0x11150, 0x11173},
  {0x11176, 0x11176}, {0x11180, 0x111c4}, {0x111c9, 0x111cc}, {0x111ce, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x11237}, {0x1123e, 0x11241},
  {0x11280, 0x11286}, {0x11288, 0x11288}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112ea}, {0x112f0, 0x112f9}, {0x11300, 0x11303},
  {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133b, 0x11344}, {0x11347, 0x11348},
  {0x1134b, 0x1134d}, {0x11350, 0x11350}, {0x11357, 0x11357}, {0x1135d, 0x11363}, {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11400, 0x1144a}, {0x11450, 0x11459},
  {0x1145e, 0x11461}, {0x11480, 0x114c5}, {0x114c7, 0x114c7}, {0x114d0, 0x114d9}, {0x11580, 0x115b5}, {0x115b8, 0x115c0}, {0x115d8, 0x115dd}, {0x11600, 0x11640},
  {0x11644, 0x11644}, {0x11650, 0x11659}, {0x11680, 0x116b8}, {0x116c0, 0x116c9}, {0x11700, 0x1171a}, {0x1171d, 0x1172b}, {0x11730, 0x11739}, {0x11740, 0x11746},
  {0x11800, 0x1183a}, {0x118a0, 0x118e9}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x11935}, {0x11937, 0x11938},
  {0x1193b, 0x11943}, {0x11950, 0x11959}, {0x119a0, 0x119a7}, {0x119aa, 0x119d7}, {0x119da, 0x119e1}, {0x119e3, 0x119e4}, {0x11a00, 0x11a3e}, {0x11a47, 0x11a47},
  {0x11a50, 0x11a99}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, {0x11c38, 0x11c40}, {0x11c50, 0x11c59}, {0x11c72, 0x11c8f},
  {0x11c92, 0x11ca7}, {0x11ca9, 0x11cb6}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, {0x11d3a, 0x11d3a}, {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d47},
  {0x11d50, 0x11d59}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, {0x11d90, 0x11d91}, {0x11d93, 0x11d98}, {0x11da0, 0x11da9}, {0x11ee0, 0x11ef6},
  {0x11f00, 0x11f10}, {0x11f12, 0x11f3a}, {0x11f3e, 0x11f42}, {0x11f50, 0x11f59}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12480, 0x12543},
  {0x12f90, 0x12ff0}, {0x13000, 0x1342f}, {0x13440, 0x13455}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a60, 0x16a69}, {0x16a70, 0x16abe},
  {0x16ac0, 0x16ac9}, {0x16ad0, 0x16aed}, {0x16af0, 0x16af4}, {0x16b00, 0x16b36}, {0x16b40, 0x16b43}, {0x16b50, 0x16b59}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f},
  {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a}, {0x16f4f, 0x16f87}, {0x16f8f, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe4}, {0x16ff0, 0x16ff1}, {0x17000, 0x187f7},
  {0x18800, 0x18cd5}, {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132}, {0x1b150, 0x1b152},
  {0x1b155, 0x1b155}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1bc9d, 0x1bc9e},
  {0x1cf00, 0x1cf2d}, {0x1cf30, 0x1cf46}, {0x1d165, 0x1d169}, {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244},
  {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb},
  {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544},
  {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734},
  {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1d7ce, 0x1d7ff}, {0x1da00, 0x1da36},
  {0x1da3b, 0x1da6c}, {0x1da75, 0x1da75}, {0x1da84, 0x1da84}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e000, 0x1e006},
  {0x1e008, 0x1e018}, {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, {0x1e030, 0x1e06d}, {0x1e08f, 0x1e08f}, {0x1e100, 0x1e12c}, {0x1e130, 0x1e13d},
  {0x1e140, 0x1e149}, {0x1e14e, 0x1e14e}, {0x1e290, 0x1e2ae}, {0x1e2c0, 0x1e2f9}, {0x1e4d0, 0x1e4f9}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee},
  {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4}, {0x1e8d0, 0x1e8d6}, {0x1e900, 0x1e94b}, {0x1e950, 0x1e959}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22},
  {0x1ee24, 0x1ee24}, {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47},
  {0x1ee49, 0x1ee49}, {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b},
  {0x1ee5d, 0x1ee5d}, {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62}, {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c},
  {0x1ee7e, 0x1ee7e}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1fbf0, 0x1fbf9}, {0x20000, 0x2a6df},
  {0x2a700, 0x2b739}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x323af},
  {0xe0100, 0xe01ef},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(27);
      ADVANCE_MAP(
        '!', 32,
        '"', 73,
        '#', 97,
        '$', 58,
        '%', 5,
        '&', 41,
        '\'', 72,
        '*', 50,
        '+', 33,
        ',', 98,
        '-', 34,
        '.', 94,
        '/', 51,
        '0', 64,
        ':', 56,
        '<', 44,
        '=', 29,
        '>', 46,
        '?', 30,
        '@', 59,
        '\\', 28,
        '^', 53,
        '`', 9,
        '|', 40,
        '~', 31,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(65);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(96);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '!', 7,
        '"', 73,
        '#', 97,
        '$', 58,
        '%', 5,
        '&', 41,
        '\'', 72,
        '*', 50,
        '+', 33,
        ',', 98,
        '-', 34,
        '.', 95,
        '/', 51,
        ':', 57,
        '<', 44,
        '=', 29,
        '>', 46,
        '?', 30,
        '@', 59,
        '^', 53,
        '`', 9,
        '|', 40,
        '~', 31,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(96);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '!', 7,
        '#', 97,
        '$', 58,
        '%', 5,
        '&', 41,
        '*', 50,
        '+', 33,
        ',', 98,
        '-', 34,
        '/', 51,
        ':', 57,
        '<', 44,
        '=', 29,
        '>', 46,
        '?', 30,
        '@', 59,
        '^', 53,
        '`', 9,
        '|', 40,
        '~', 31,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(96);
      END_STATE();
    case 3:
      if (lookahead == '"') ADVANCE(73);
      if (lookahead == '#') ADVANCE(77);
      if (lookahead == '\\') ADVANCE(8);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(78);
      if (lookahead != 0) ADVANCE(79);
      END_STATE();
    case 4:
      if (lookahead == '#') ADVANCE(74);
      if (lookahead == '\'') ADVANCE(72);
      if (lookahead == '\\') ADVANCE(8);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(75);
      if (lookahead != 0) ADVANCE(76);
      END_STATE();
    case 5:
      if (lookahead == '%') ADVANCE(54);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\\') ADVANCE(5);
      END_STATE();
    case 6:
      if (lookahead == '-') ADVANCE(36);
      END_STATE();
    case 7:
      if (lookahead == '=') ADVANCE(49);
      END_STATE();
    case 8:
      if (lookahead == 'U') ADVANCE(10);
      if (lookahead == 'u') ADVANCE(11);
      if (lookahead == 'x') ADVANCE(24);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(82);
      if (lookahead != 0 &&
          (lookahead < '0' || '9' < lookahead)) ADVANCE(80);
      END_STATE();
    case 9:
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == '`') ADVANCE(92);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 10:
      if (lookahead == '{') ADVANCE(23);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(89);
      END_STATE();
    case 11:
      if (lookahead == '{') ADVANCE(25);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(85);
      END_STATE();
    case 12:
      if (lookahead == '}') ADVANCE(80);
      END_STATE();
    case 13:
      if (lookahead == '}') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(12);
      END_STATE();
    case 14:
      if (lookahead == '}') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(13);
      END_STATE();
    case 15:
      if (lookahead == '}') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(14);
      END_STATE();
    case 16:
      if (lookahead == '}') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(15);
      END_STATE();
    case 17:
      if (lookahead == '}') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(16);
      END_STATE();
    case 18:
      if (lookahead == '}') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(17);
      END_STATE();
    case 19:
      if (lookahead == '}') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(18);
      END_STATE();
    case 20:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      END_STATE();
    case 21:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      END_STATE();
    case 22:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      END_STATE();
    case 23:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(19);
      END_STATE();
    case 24:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(83);
      END_STATE();
    case 25:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(15);
      END_STATE();
    case 26:
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(48);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(49);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(38);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_LT_LT_DASH);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      if (lookahead == '>') ADVANCE(39);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_DASH_GT_GT);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '>') ADVANCE(55);
      if (lookahead == '|') ADVANCE(42);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(43);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(35);
      if (lookahead == '<') ADVANCE(6);
      if (lookahead == '=') ADVANCE(45);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(47);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(52);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(aux_sym_binary_operator_token1);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_PIPE_GT);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(60);
      if (lookahead == '=') ADVANCE(37);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(37);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      if (lookahead == ':') ADVANCE(61);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_COLON_COLON_COLON);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym__hex_literal);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(20);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym__hex_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym__number_literal);
      if (lookahead == '.') ADVANCE(68);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(66);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym__number_literal);
      if (lookahead == '.') ADVANCE(68);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(66);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym__number_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(70);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(70);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym__number_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(70);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(71);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(96);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym__number_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(66);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym__number_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(67);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(69);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(96);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym__number_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(70);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym__number_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(71);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(96);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(aux_sym__single_quoted_string_content_token1);
      if (lookahead == '\n') ADVANCE(76);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(74);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(aux_sym__single_quoted_string_content_token1);
      if (lookahead == '#') ADVANCE(74);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(76);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(aux_sym__single_quoted_string_content_token1);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(76);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(aux_sym__double_quoted_string_content_token1);
      if (lookahead == '\n') ADVANCE(79);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(77);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(aux_sym__double_quoted_string_content_token1);
      if (lookahead == '#') ADVANCE(77);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(78);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          lookahead != '\\') ADVANCE(79);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(aux_sym__double_quoted_string_content_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(79);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(80);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(81);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(80);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(83);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(84);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(85);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(86);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(87);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(88);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_dots);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(96);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_dot_dot_i);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(91);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(96);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_identifier);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(90);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(91);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(96);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(69);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(96);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(93);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(96);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_identifier);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(96);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(97);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_comma);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'F', 1,
        'I', 2,
        'L', 3,
        'N', 4,
        'T', 5,
        'b', 6,
        'f', 7,
        'i', 8,
        'n', 9,
        'r', 10,
        'w', 11,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'A') ADVANCE(12);
      END_STATE();
    case 2:
      if (lookahead == 'n') ADVANCE(13);
      END_STATE();
    case 3:
      ACCEPT_TOKEN(anon_sym_L);
      END_STATE();
    case 4:
      if (lookahead == 'A') ADVANCE(14);
      if (lookahead == 'U') ADVANCE(15);
      if (lookahead == 'a') ADVANCE(16);
      END_STATE();
    case 5:
      if (lookahead == 'R') ADVANCE(17);
      END_STATE();
    case 6:
      if (lookahead == 'r') ADVANCE(18);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(19);
      if (lookahead == 'u') ADVANCE(20);
      END_STATE();
    case 8:
      ACCEPT_TOKEN(anon_sym_i);
      if (lookahead == 'f') ADVANCE(21);
      if (lookahead == 'n') ADVANCE(22);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(23);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(24);
      END_STATE();
    case 11:
      if (lookahead == 'h') ADVANCE(25);
      END_STATE();
    case 12:
      if (lookahead == 'L') ADVANCE(26);
      END_STATE();
    case 13:
      if (lookahead == 'f') ADVANCE(27);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_NA);
      if (lookahead == '_') ADVANCE(28);
      END_STATE();
    case 15:
      if (lookahead == 'L') ADVANCE(29);
      END_STATE();
    case 16:
      if (lookahead == 'N') ADVANCE(30);
      END_STATE();
    case 17:
      if (lookahead == 'U') ADVANCE(31);
      END_STATE();
    case 18:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 19:
      if (lookahead == 'r') ADVANCE(33);
      END_STATE();
    case 20:
      if (lookahead == 'n') ADVANCE(34);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 23:
      if (lookahead == 'x') ADVANCE(35);
      END_STATE();
    case 24:
      if (lookahead == 'p') ADVANCE(36);
      if (lookahead == 't') ADVANCE(37);
      END_STATE();
    case 25:
      if (lookahead == 'i') ADVANCE(38);
      END_STATE();
    case 26:
      if (lookahead == 'S') ADVANCE(39);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(sym_inf);
      END_STATE();
    case 28:
      if (lookahead == 'c') ADVANCE(40);
      if (lookahead == 'i') ADVANCE(41);
      if (lookahead == 'r') ADVANCE(42);
      END_STATE();
    case 29:
      if (lookahead == 'L') ADVANCE(43);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(sym_nan);
      END_STATE();
    case 31:
      if (lookahead == 'E') ADVANCE(44);
      END_STATE();
    case 32:
      if (lookahead == 'a') ADVANCE(45);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 34:
      if (lookahead == 'c') ADVANCE(46);
      END_STATE();
    case 35:
      if (lookahead == 't') ADVANCE(47);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 37:
      if (lookahead == 'u') ADVANCE(49);
      END_STATE();
    case 38:
      if (lookahead == 'l') ADVANCE(50);
      END_STATE();
    case 39:
      if (lookahead == 'E') ADVANCE(51);
      END_STATE();
    case 40:
      if (lookahead == 'h') ADVANCE(52);
      if (lookahead == 'o') ADVANCE(53);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(54);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(55);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 45:
      if (lookahead == 'k') ADVANCE(56);
      END_STATE();
    case 46:
      if (lookahead == 't') ADVANCE(57);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_next);
      END_STATE();
    case 48:
      if (lookahead == 'a') ADVANCE(58);
      END_STATE();
    case 49:
      if (lookahead == 'r') ADVANCE(59);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 52:
      if (lookahead == 'a') ADVANCE(61);
      END_STATE();
    case 53:
      if (lookahead == 'm') ADVANCE(62);
      END_STATE();
    case 54:
      if (lookahead == 't') ADVANCE(63);
      END_STATE();
    case 55:
      if (lookahead == 'a') ADVANCE(64);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_break);
      END_STATE();
    case 57:
      if (lookahead == 'i') ADVANCE(65);
      END_STATE();
    case 58:
      if (lookahead == 't') ADVANCE(66);
      END_STATE();
    case 59:
      if (lookahead == 'n') ADVANCE(67);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 61:
      if (lookahead == 'r') ADVANCE(68);
      END_STATE();
    case 62:
      if (lookahead == 'p') ADVANCE(69);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(70);
      END_STATE();
    case 64:
      if (lookahead == 'l') ADVANCE(71);
      END_STATE();
    case 65:
      if (lookahead == 'o') ADVANCE(72);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_repeat);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_return);
      END_STATE();
    case 68:
      if (lookahead == 'a') ADVANCE(73);
      END_STATE();
    case 69:
      if (lookahead == 'l') ADVANCE(74);
      END_STATE();
    case 70:
      if (lookahead == 'g') ADVANCE(75);
      END_STATE();
    case 71:
      if (lookahead == '_') ADVANCE(76);
      END_STATE();
    case 72:
      if (lookahead == 'n') ADVANCE(77);
      END_STATE();
    case 73:
      if (lookahead == 'c') ADVANCE(78);
      END_STATE();
    case 74:
      if (lookahead == 'e') ADVANCE(79);
      END_STATE();
    case 75:
      if (lookahead == 'e') ADVANCE(80);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_NA_real_);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 78:
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 79:
      if (lookahead == 'x') ADVANCE(82);
      END_STATE();
    case 80:
      if (lookahead == 'r') ADVANCE(83);
      END_STATE();
    case 81:
      if (lookahead == 'e') ADVANCE(84);
      END_STATE();
    case 82:
      if (lookahead == '_') ADVANCE(85);
      END_STATE();
    case 83:
      if (lookahead == '_') ADVANCE(86);
      END_STATE();
    case 84:
      if (lookahead == 'r') ADVANCE(87);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_NA_complex_);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_NA_integer_);
      END_STATE();
    case 87:
      if (lookahead == '_') ADVANCE(88);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_NA_character_);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 0, .external_lex_state = 2},
  [2] = {.lex_state = 0, .external_lex_state = 3},
  [3] = {.lex_state = 0, .external_lex_state = 3},
  [4] = {.lex_state = 0, .external_lex_state = 3},
  [5] = {.lex_state = 0, .external_lex_state = 3},
  [6] = {.lex_state = 0, .external_lex_state = 4},
  [7] = {.lex_state = 0, .external_lex_state = 4},
  [8] = {.lex_state = 0, .external_lex_state = 4},
  [9] = {.lex_state = 0, .external_lex_state = 4},
  [10] = {.lex_state = 0, .external_lex_state = 4},
  [11] = {.lex_state = 0, .external_lex_state = 3},
  [12] = {.lex_state = 0, .external_lex_state = 3},
  [13] = {.lex_state = 0, .external_lex_state = 3},
  [14] = {.lex_state = 0, .external_lex_state = 3},
  [15] = {.lex_state = 0, .external_lex_state = 4},
  [16] = {.lex_state = 0, .external_lex_state = 4},
  [17] = {.lex_state = 0, .external_lex_state = 4},
  [18] = {.lex_state = 0, .external_lex_state = 4},
  [19] = {.lex_state = 0, .external_lex_state = 3},
  [20] = {.lex_state = 0, .external_lex_state = 3},
  [21] = {.lex_state = 0, .external_lex_state = 3},
  [22] = {.lex_state = 0, .external_lex_state = 3},
  [23] = {.lex_state = 0, .external_lex_state = 3},
  [24] = {.lex_state = 0, .external_lex_state = 3},
  [25] = {.lex_state = 0, .external_lex_state = 3},
  [26] = {.lex_state = 0, .external_lex_state = 3},
  [27] = {.lex_state = 0, .external_lex_state = 3},
  [28] = {.lex_state = 0, .external_lex_state = 3},
  [29] = {.lex_state = 0, .external_lex_state = 3},
  [30] = {.lex_state = 0, .external_lex_state = 3},
  [31] = {.lex_state = 0, .external_lex_state = 3},
  [32] = {.lex_state = 0, .external_lex_state = 3},
  [33] = {.lex_state = 0, .external_lex_state = 3},
  [34] = {.lex_state = 0, .external_lex_state = 3},
  [35] = {.lex_state = 0, .external_lex_state = 3},
  [36] = {.lex_state = 0, .external_lex_state = 3},
  [37] = {.lex_state = 0, .external_lex_state = 3},
  [38] = {.lex_state = 0, .external_lex_state = 3},
  [39] = {.lex_state = 0, .external_lex_state = 3},
  [40] = {.lex_state = 0, .external_lex_state = 3},
  [41] = {.lex_state = 0, .external_lex_state = 3},
  [42] = {.lex_state = 0, .external_lex_state = 3},
  [43] = {.lex_state = 0, .external_lex_state = 3},
  [44] = {.lex_state = 0, .external_lex_state = 3},
  [45] = {.lex_state = 0, .external_lex_state = 3},
  [46] = {.lex_state = 0, .external_lex_state = 3},
  [47] = {.lex_state = 0, .external_lex_state = 3},
  [48] = {.lex_state = 0, .external_lex_state = 3},
  [49] = {.lex_state = 0, .external_lex_state = 3},
  [50] = {.lex_state = 0, .external_lex_state = 3},
  [51] = {.lex_state = 0, .external_lex_state = 3},
  [52] = {.lex_state = 0, .external_lex_state = 3},
  [53] = {.lex_state = 0, .external_lex_state = 3},
  [54] = {.lex_state = 0, .external_lex_state = 3},
  [55] = {.lex_state = 0, .external_lex_state = 3},
  [56] = {.lex_state = 0, .external_lex_state = 3},
  [57] = {.lex_state = 0, .external_lex_state = 3},
  [58] = {.lex_state = 0, .external_lex_state = 3},
  [59] = {.lex_state = 0, .external_lex_state = 3},
  [60] = {.lex_state = 0, .external_lex_state = 3},
  [61] = {.lex_state = 0, .external_lex_state = 3},
  [62] = {.lex_state = 0, .external_lex_state = 3},
  [63] = {.lex_state = 0, .external_lex_state = 3},
  [64] = {.lex_state = 0, .external_lex_state = 3},
  [65] = {.lex_state = 0, .external_lex_state = 3},
  [66] = {.lex_state = 0, .external_lex_state = 4},
  [67] = {.lex_state = 0, .external_lex_state = 4},
  [68] = {.lex_state = 0, .external_lex_state = 4},
  [69] = {.lex_state = 0, .external_lex_state = 4},
  [70] = {.lex_state = 0, .external_lex_state = 4},
  [71] = {.lex_state = 0, .external_lex_state = 4},
  [72] = {.lex_state = 0, .external_lex_state = 4},
  [73] = {.lex_state = 0, .external_lex_state = 4},
  [74] = {.lex_state = 0, .external_lex_state = 3},
  [75] = {.lex_state = 0, .external_lex_state = 4},
  [76] = {.lex_state = 0, .external_lex_state = 4},
  [77] = {.lex_state = 0, .external_lex_state = 4},
  [78] = {.lex_state = 0, .external_lex_state = 4},
  [79] = {.lex_state = 0, .external_lex_state = 4},
  [80] = {.lex_state = 0, .external_lex_state = 4},
  [81] = {.lex_state = 0, .external_lex_state = 4},
  [82] = {.lex_state = 0, .external_lex_state = 4},
  [83] = {.lex_state = 0, .external_lex_state = 4},
  [84] = {.lex_state = 0, .external_lex_state = 4},
  [85] = {.lex_state = 0, .external_lex_state = 4},
  [86] = {.lex_state = 0, .external_lex_state = 4},
  [87] = {.lex_state = 0, .external_lex_state = 4},
  [88] = {.lex_state = 0, .external_lex_state = 4},
  [89] = {.lex_state = 0, .external_lex_state = 4},
  [90] = {.lex_state = 0, .external_lex_state = 4},
  [91] = {.lex_state = 0, .external_lex_state = 4},
  [92] = {.lex_state = 0, .external_lex_state = 4},
  [93] = {.lex_state = 0, .external_lex_state = 4},
  [94] = {.lex_state = 0, .external_lex_state = 4},
  [95] = {.lex_state = 0, .external_lex_state = 4},
  [96] = {.lex_state = 0, .external_lex_state = 4},
  [97] = {.lex_state = 0, .external_lex_state = 4},
  [98] = {.lex_state = 0, .external_lex_state = 4},
  [99] = {.lex_state = 0, .external_lex_state = 4},
  [100] = {.lex_state = 0, .external_lex_state = 4},
  [101] = {.lex_state = 0, .external_lex_state = 4},
  [102] = {.lex_state = 0, .external_lex_state = 4},
  [103] = {.lex_state = 0, .external_lex_state = 4},
  [104] = {.lex_state = 0, .external_lex_state = 4},
  [105] = {.lex_state = 0, .external_lex_state = 4},
  [106] = {.lex_state = 0, .external_lex_state = 4},
  [107] = {.lex_state = 0, .external_lex_state = 4},
  [108] = {.lex_state = 0, .external_lex_state = 4},
  [109] = {.lex_state = 0, .external_lex_state = 4},
  [110] = {.lex_state = 0, .external_lex_state = 4},
  [111] = {.lex_state = 0, .external_lex_state = 4},
  [112] = {.lex_state = 0, .external_lex_state = 4},
  [113] = {.lex_state = 0, .external_lex_state = 4},
  [114] = {.lex_state = 0, .external_lex_state = 4},
  [115] = {.lex_state = 0, .external_lex_state = 4},
  [116] = {.lex_state = 0, .external_lex_state = 4},
  [117] = {.lex_state = 0, .external_lex_state = 4},
  [118] = {.lex_state = 0, .external_lex_state = 4},
  [119] = {.lex_state = 0, .external_lex_state = 3},
  [120] = {.lex_state = 0, .external_lex_state = 4},
  [121] = {.lex_state = 0, .external_lex_state = 4},
  [122] = {.lex_state = 0, .external_lex_state = 3},
  [123] = {.lex_state = 0, .external_lex_state = 3},
  [124] = {.lex_state = 0, .external_lex_state = 3},
  [125] = {.lex_state = 0, .external_lex_state = 3},
  [126] = {.lex_state = 0, .external_lex_state = 3},
  [127] = {.lex_state = 0, .external_lex_state = 3},
  [128] = {.lex_state = 0, .external_lex_state = 3},
  [129] = {.lex_state = 0, .external_lex_state = 4},
  [130] = {.lex_state = 0, .external_lex_state = 5},
  [131] = {.lex_state = 0, .external_lex_state = 6},
  [132] = {.lex_state = 0, .external_lex_state = 6},
  [133] = {.lex_state = 0, .external_lex_state = 6},
  [134] = {.lex_state = 0, .external_lex_state = 6},
  [135] = {.lex_state = 0, .external_lex_state = 6},
  [136] = {.lex_state = 0, .external_lex_state = 6},
  [137] = {.lex_state = 0, .external_lex_state = 6},
  [138] = {.lex_state = 0, .external_lex_state = 6},
  [139] = {.lex_state = 0, .external_lex_state = 6},
  [140] = {.lex_state = 0, .external_lex_state = 6},
  [141] = {.lex_state = 0, .external_lex_state = 6},
  [142] = {.lex_state = 0, .external_lex_state = 6},
  [143] = {.lex_state = 0, .external_lex_state = 6},
  [144] = {.lex_state = 0, .external_lex_state = 6},
  [145] = {.lex_state = 0, .external_lex_state = 6},
  [146] = {.lex_state = 0, .external_lex_state = 6},
  [147] = {.lex_state = 0, .external_lex_state = 6},
  [148] = {.lex_state = 0, .external_lex_state = 6},
  [149] = {.lex_state = 0, .external_lex_state = 6},
  [150] = {.lex_state = 0, .external_lex_state = 6},
  [151] = {.lex_state = 0, .external_lex_state = 6},
  [152] = {.lex_state = 0, .external_lex_state = 6},
  [153] = {.lex_state = 0, .external_lex_state = 6},
  [154] = {.lex_state = 0, .external_lex_state = 6},
  [155] = {.lex_state = 0, .external_lex_state = 6},
  [156] = {.lex_state = 0, .external_lex_state = 6},
  [157] = {.lex_state = 0, .external_lex_state = 6},
  [158] = {.lex_state = 0, .external_lex_state = 6},
  [159] = {.lex_state = 0, .external_lex_state = 6},
  [160] = {.lex_state = 0, .external_lex_state = 6},
  [161] = {.lex_state = 0, .external_lex_state = 6},
  [162] = {.lex_state = 0, .external_lex_state = 6},
  [163] = {.lex_state = 0, .external_lex_state = 6},
  [164] = {.lex_state = 0, .external_lex_state = 6},
  [165] = {.lex_state = 0, .external_lex_state = 5},
  [166] = {.lex_state = 0, .external_lex_state = 6},
  [167] = {.lex_state = 0, .external_lex_state = 6},
  [168] = {.lex_state = 0, .external_lex_state = 6},
  [169] = {.lex_state = 0, .external_lex_state = 6},
  [170] = {.lex_state = 0, .external_lex_state = 5},
  [171] = {.lex_state = 0, .external_lex_state = 6},
  [172] = {.lex_state = 0, .external_lex_state = 6},
  [173] = {.lex_state = 0, .external_lex_state = 6},
  [174] = {.lex_state = 0, .external_lex_state = 6},
  [175] = {.lex_state = 0, .external_lex_state = 6},
  [176] = {.lex_state = 0, .external_lex_state = 6},
  [177] = {.lex_state = 0, .external_lex_state = 6},
  [178] = {.lex_state = 0, .external_lex_state = 6},
  [179] = {.lex_state = 0, .external_lex_state = 6},
  [180] = {.lex_state = 0, .external_lex_state = 6},
  [181] = {.lex_state = 0, .external_lex_state = 6},
  [182] = {.lex_state = 0, .external_lex_state = 6},
  [183] = {.lex_state = 0, .external_lex_state = 5},
  [184] = {.lex_state = 0, .external_lex_state = 5},
  [185] = {.lex_state = 0, .external_lex_state = 5},
  [186] = {.lex_state = 0, .external_lex_state = 5},
  [187] = {.lex_state = 0, .external_lex_state = 6},
  [188] = {.lex_state = 0, .external_lex_state = 5},
  [189] = {.lex_state = 0, .external_lex_state = 5},
  [190] = {.lex_state = 0, .external_lex_state = 5},
  [191] = {.lex_state = 0, .external_lex_state = 5},
  [192] = {.lex_state = 0, .external_lex_state = 5},
  [193] = {.lex_state = 0, .external_lex_state = 5},
  [194] = {.lex_state = 0, .external_lex_state = 5},
  [195] = {.lex_state = 0, .external_lex_state = 5},
  [196] = {.lex_state = 0, .external_lex_state = 5},
  [197] = {.lex_state = 0, .external_lex_state = 5},
  [198] = {.lex_state = 0, .external_lex_state = 5},
  [199] = {.lex_state = 0, .external_lex_state = 5},
  [200] = {.lex_state = 0, .external_lex_state = 5},
  [201] = {.lex_state = 0, .external_lex_state = 5},
  [202] = {.lex_state = 0, .external_lex_state = 5},
  [203] = {.lex_state = 0, .external_lex_state = 5},
  [204] = {.lex_state = 0, .external_lex_state = 5},
  [205] = {.lex_state = 0, .external_lex_state = 5},
  [206] = {.lex_state = 0, .external_lex_state = 5},
  [207] = {.lex_state = 0, .external_lex_state = 5},
  [208] = {.lex_state = 0, .external_lex_state = 5},
  [209] = {.lex_state = 0, .external_lex_state = 5},
  [210] = {.lex_state = 0, .external_lex_state = 5},
  [211] = {.lex_state = 0, .external_lex_state = 5},
  [212] = {.lex_state = 0, .external_lex_state = 5},
  [213] = {.lex_state = 0, .external_lex_state = 5},
  [214] = {.lex_state = 0, .external_lex_state = 5},
  [215] = {.lex_state = 0, .external_lex_state = 5},
  [216] = {.lex_state = 0, .external_lex_state = 5},
  [217] = {.lex_state = 0, .external_lex_state = 5},
  [218] = {.lex_state = 0, .external_lex_state = 5},
  [219] = {.lex_state = 0, .external_lex_state = 5},
  [220] = {.lex_state = 0, .external_lex_state = 5},
  [221] = {.lex_state = 0, .external_lex_state = 5},
  [222] = {.lex_state = 0, .external_lex_state = 5},
  [223] = {.lex_state = 0, .external_lex_state = 5},
  [224] = {.lex_state = 0, .external_lex_state = 5},
  [225] = {.lex_state = 0, .external_lex_state = 5},
  [226] = {.lex_state = 0, .external_lex_state = 5},
  [227] = {.lex_state = 0, .external_lex_state = 5},
  [228] = {.lex_state = 0, .external_lex_state = 5},
  [229] = {.lex_state = 0, .external_lex_state = 5},
  [230] = {.lex_state = 0, .external_lex_state = 5},
  [231] = {.lex_state = 0, .external_lex_state = 5},
  [232] = {.lex_state = 0, .external_lex_state = 5},
  [233] = {.lex_state = 0, .external_lex_state = 5},
  [234] = {.lex_state = 0, .external_lex_state = 5},
  [235] = {.lex_state = 0, .external_lex_state = 5},
  [236] = {.lex_state = 0, .external_lex_state = 5},
  [237] = {.lex_state = 0, .external_lex_state = 5},
  [238] = {.lex_state = 0, .external_lex_state = 6},
  [239] = {.lex_state = 0, .external_lex_state = 6},
  [240] = {.lex_state = 0, .external_lex_state = 6},
  [241] = {.lex_state = 0, .external_lex_state = 6},
  [242] = {.lex_state = 0, .external_lex_state = 6},
  [243] = {.lex_state = 0, .external_lex_state = 6},
  [244] = {.lex_state = 0, .external_lex_state = 3},
  [245] = {.lex_state = 0, .external_lex_state = 4},
  [246] = {.lex_state = 0, .external_lex_state = 4},
  [247] = {.lex_state = 0, .external_lex_state = 3},
  [248] = {.lex_state = 0, .external_lex_state = 7},
  [249] = {.lex_state = 0, .external_lex_state = 8},
  [250] = {.lex_state = 0, .external_lex_state = 6},
  [251] = {.lex_state = 0, .external_lex_state = 5},
  [252] = {.lex_state = 0, .external_lex_state = 4},
  [253] = {.lex_state = 0, .external_lex_state = 9},
  [254] = {.lex_state = 0, .external_lex_state = 3},
  [255] = {.lex_state = 0, .external_lex_state = 7},
  [256] = {.lex_state = 0, .external_lex_state = 9},
  [257] = {.lex_state = 0, .external_lex_state = 8},
  [258] = {.lex_state = 0, .external_lex_state = 8},
  [259] = {.lex_state = 0, .external_lex_state = 6},
  [260] = {.lex_state = 0, .external_lex_state = 7},
  [261] = {.lex_state = 0, .external_lex_state = 9},
  [262] = {.lex_state = 0, .external_lex_state = 8},
  [263] = {.lex_state = 0, .external_lex_state = 5},
  [264] = {.lex_state = 0, .external_lex_state = 7},
  [265] = {.lex_state = 0, .external_lex_state = 8},
  [266] = {.lex_state = 0, .external_lex_state = 7},
  [267] = {.lex_state = 0, .external_lex_state = 9},
  [268] = {.lex_state = 0, .external_lex_state = 8},
  [269] = {.lex_state = 0, .external_lex_state = 7},
  [270] = {.lex_state = 0, .external_lex_state = 9},
  [271] = {.lex_state = 0, .external_lex_state = 8},
  [272] = {.lex_state = 0, .external_lex_state = 7},
  [273] = {.lex_state = 0, .external_lex_state = 9},
  [274] = {.lex_state = 0, .external_lex_state = 8},
  [275] = {.lex_state = 0, .external_lex_state = 7},
  [276] = {.lex_state = 0, .external_lex_state = 9},
  [277] = {.lex_state = 0, .external_lex_state = 8},
  [278] = {.lex_state = 0, .external_lex_state = 7},
  [279] = {.lex_state = 0, .external_lex_state = 9},
  [280] = {.lex_state = 0, .external_lex_state = 8},
  [281] = {.lex_state = 0, .external_lex_state = 7},
  [282] = {.lex_state = 0, .external_lex_state = 9},
  [283] = {.lex_state = 0, .external_lex_state = 9},
  [284] = {.lex_state = 0, .external_lex_state = 4},
  [285] = {.lex_state = 0, .external_lex_state = 3},
  [286] = {.lex_state = 0, .external_lex_state = 3},
  [287] = {.lex_state = 0, .external_lex_state = 3},
  [288] = {.lex_state = 0, .external_lex_state = 3},
  [289] = {.lex_state = 0, .external_lex_state = 3},
  [290] = {.lex_state = 0, .external_lex_state = 4},
  [291] = {.lex_state = 0, .external_lex_state = 4},
  [292] = {.lex_state = 0, .external_lex_state = 4},
  [293] = {.lex_state = 0, .external_lex_state = 4},
  [294] = {.lex_state = 0, .external_lex_state = 4},
  [295] = {.lex_state = 0, .external_lex_state = 4},
  [296] = {.lex_state = 0, .external_lex_state = 3},
  [297] = {.lex_state = 0, .external_lex_state = 3},
  [298] = {.lex_state = 0, .external_lex_state = 4},
  [299] = {.lex_state = 0, .external_lex_state = 4},
  [300] = {.lex_state = 0, .external_lex_state = 5},
  [301] = {.lex_state = 0, .external_lex_state = 3},
  [302] = {.lex_state = 0, .external_lex_state = 3},
  [303] = {.lex_state = 0, .external_lex_state = 6},
  [304] = {.lex_state = 0, .external_lex_state = 5},
  [305] = {.lex_state = 0, .external_lex_state = 5},
  [306] = {.lex_state = 0, .external_lex_state = 5},
  [307] = {.lex_state = 0, .external_lex_state = 3},
  [308] = {.lex_state = 0, .external_lex_state = 5},
  [309] = {.lex_state = 0, .external_lex_state = 5},
  [310] = {.lex_state = 0, .external_lex_state = 7},
  [311] = {.lex_state = 0, .external_lex_state = 5},
  [312] = {.lex_state = 0, .external_lex_state = 9},
  [313] = {.lex_state = 0, .external_lex_state = 6},
  [314] = {.lex_state = 0, .external_lex_state = 6},
  [315] = {.lex_state = 0, .external_lex_state = 6},
  [316] = {.lex_state = 0, .external_lex_state = 6},
  [317] = {.lex_state = 0, .external_lex_state = 6},
  [318] = {.lex_state = 0, .external_lex_state = 4},
  [319] = {.lex_state = 0, .external_lex_state = 6},
  [320] = {.lex_state = 0, .external_lex_state = 6},
  [321] = {.lex_state = 0, .external_lex_state = 6},
  [322] = {.lex_state = 0, .external_lex_state = 6},
  [323] = {.lex_state = 0, .external_lex_state = 5},
  [324] = {.lex_state = 0, .external_lex_state = 8},
  [325] = {.lex_state = 0, .external_lex_state = 5},
  [326] = {.lex_state = 0, .external_lex_state = 5},
  [327] = {.lex_state = 0, .external_lex_state = 4},
  [328] = {.lex_state = 0, .external_lex_state = 4},
  [329] = {.lex_state = 0, .external_lex_state = 4},
  [330] = {.lex_state = 0, .external_lex_state = 4},
  [331] = {.lex_state = 0, .external_lex_state = 4},
  [332] = {.lex_state = 0, .external_lex_state = 3},
  [333] = {.lex_state = 0, .external_lex_state = 3},
  [334] = {.lex_state = 0, .external_lex_state = 6},
  [335] = {.lex_state = 0, .external_lex_state = 3},
  [336] = {.lex_state = 0, .external_lex_state = 4},
  [337] = {.lex_state = 0, .external_lex_state = 4},
  [338] = {.lex_state = 0, .external_lex_state = 4},
  [339] = {.lex_state = 0, .external_lex_state = 4},
  [340] = {.lex_state = 0, .external_lex_state = 3},
  [341] = {.lex_state = 0, .external_lex_state = 4},
  [342] = {.lex_state = 0, .external_lex_state = 4},
  [343] = {.lex_state = 0, .external_lex_state = 4},
  [344] = {.lex_state = 0, .external_lex_state = 4},
  [345] = {.lex_state = 0, .external_lex_state = 4},
  [346] = {.lex_state = 0, .external_lex_state = 4},
  [347] = {.lex_state = 0, .external_lex_state = 4},
  [348] = {.lex_state = 0, .external_lex_state = 4},
  [349] = {.lex_state = 0, .external_lex_state = 4},
  [350] = {.lex_state = 0, .external_lex_state = 4},
  [351] = {.lex_state = 0, .external_lex_state = 3},
  [352] = {.lex_state = 0, .external_lex_state = 4},
  [353] = {.lex_state = 0, .external_lex_state = 4},
  [354] = {.lex_state = 0, .external_lex_state = 5},
  [355] = {.lex_state = 0, .external_lex_state = 3},
  [356] = {.lex_state = 0, .external_lex_state = 3},
  [357] = {.lex_state = 0, .external_lex_state = 3},
  [358] = {.lex_state = 0, .external_lex_state = 3},
  [359] = {.lex_state = 0, .external_lex_state = 3},
  [360] = {.lex_state = 0, .external_lex_state = 3},
  [361] = {.lex_state = 0, .external_lex_state = 4},
  [362] = {.lex_state = 0, .external_lex_state = 3},
  [363] = {.lex_state = 0, .external_lex_state = 3},
  [364] = {.lex_state = 0, .external_lex_state = 3},
  [365] = {.lex_state = 0, .external_lex_state = 3},
  [366] = {.lex_state = 0, .external_lex_state = 3},
  [367] = {.lex_state = 0, .external_lex_state = 3},
  [368] = {.lex_state = 0, .external_lex_state = 3},
  [369] = {.lex_state = 0, .external_lex_state = 3},
  [370] = {.lex_state = 0, .external_lex_state = 3},
  [371] = {.lex_state = 0, .external_lex_state = 4},
  [372] = {.lex_state = 0, .external_lex_state = 3},
  [373] = {.lex_state = 0, .external_lex_state = 3},
  [374] = {.lex_state = 0, .external_lex_state = 3},
  [375] = {.lex_state = 0, .external_lex_state = 3},
  [376] = {.lex_state = 0, .external_lex_state = 4},
  [377] = {.lex_state = 0, .external_lex_state = 5},
  [378] = {.lex_state = 0, .external_lex_state = 5},
  [379] = {.lex_state = 0, .external_lex_state = 5},
  [380] = {.lex_state = 0, .external_lex_state = 5},
  [381] = {.lex_state = 0, .external_lex_state = 5},
  [382] = {.lex_state = 0, .external_lex_state = 5},
  [383] = {.lex_state = 0, .external_lex_state = 5},
  [384] = {.lex_state = 0, .external_lex_state = 5},
  [385] = {.lex_state = 0, .external_lex_state = 6},
  [386] = {.lex_state = 0, .external_lex_state = 10},
  [387] = {.lex_state = 0, .external_lex_state = 5},
  [388] = {.lex_state = 0, .external_lex_state = 6},
  [389] = {.lex_state = 0, .external_lex_state = 10},
  [390] = {.lex_state = 0, .external_lex_state = 10},
  [391] = {.lex_state = 0, .external_lex_state = 5},
  [392] = {.lex_state = 0, .external_lex_state = 5},
  [393] = {.lex_state = 0, .external_lex_state = 5},
  [394] = {.lex_state = 0, .external_lex_state = 6},
  [395] = {.lex_state = 0, .external_lex_state = 5},
  [396] = {.lex_state = 0, .external_lex_state = 5},
  [397] = {.lex_state = 0, .external_lex_state = 5},
  [398] = {.lex_state = 0, .external_lex_state = 10},
  [399] = {.lex_state = 0, .external_lex_state = 10},
  [400] = {.lex_state = 0, .external_lex_state = 10},
  [401] = {.lex_state = 0, .external_lex_state = 5},
  [402] = {.lex_state = 0, .external_lex_state = 10},
  [403] = {.lex_state = 0, .external_lex_state = 10},
  [404] = {.lex_state = 0, .external_lex_state = 6},
  [405] = {.lex_state = 0, .external_lex_state = 6},
  [406] = {.lex_state = 0, .external_lex_state = 6},
  [407] = {.lex_state = 0, .external_lex_state = 6},
  [408] = {.lex_state = 0, .external_lex_state = 5},
  [409] = {.lex_state = 0, .external_lex_state = 6},
  [410] = {.lex_state = 0, .external_lex_state = 6},
  [411] = {.lex_state = 0, .external_lex_state = 6},
  [412] = {.lex_state = 0, .external_lex_state = 5},
  [413] = {.lex_state = 0, .external_lex_state = 6},
  [414] = {.lex_state = 0, .external_lex_state = 10},
  [415] = {.lex_state = 0, .external_lex_state = 6},
  [416] = {.lex_state = 0, .external_lex_state = 6},
  [417] = {.lex_state = 0, .external_lex_state = 10},
  [418] = {.lex_state = 0, .external_lex_state = 10},
  [419] = {.lex_state = 0, .external_lex_state = 5},
  [420] = {.lex_state = 0, .external_lex_state = 5},
  [421] = {.lex_state = 0, .external_lex_state = 5},
  [422] = {.lex_state = 0, .external_lex_state = 10},
  [423] = {.lex_state = 0, .external_lex_state = 6},
  [424] = {.lex_state = 0, .external_lex_state = 6},
  [425] = {.lex_state = 0, .external_lex_state = 6},
  [426] = {.lex_state = 0, .external_lex_state = 10},
  [427] = {.lex_state = 0, .external_lex_state = 6},
  [428] = {.lex_state = 0, .external_lex_state = 5},
  [429] = {.lex_state = 0, .external_lex_state = 6},
  [430] = {.lex_state = 0, .external_lex_state = 10},
  [431] = {.lex_state = 0, .external_lex_state = 6},
  [432] = {.lex_state = 0, .external_lex_state = 6},
  [433] = {.lex_state = 0, .external_lex_state = 10},
  [434] = {.lex_state = 0, .external_lex_state = 10},
  [435] = {.lex_state = 0, .external_lex_state = 6},
  [436] = {.lex_state = 0, .external_lex_state = 6},
  [437] = {.lex_state = 0, .external_lex_state = 10},
  [438] = {.lex_state = 0, .external_lex_state = 6},
  [439] = {.lex_state = 0, .external_lex_state = 10},
  [440] = {.lex_state = 0, .external_lex_state = 6},
  [441] = {.lex_state = 0, .external_lex_state = 10},
  [442] = {.lex_state = 0, .external_lex_state = 5},
  [443] = {.lex_state = 0, .external_lex_state = 5},
  [444] = {.lex_state = 0, .external_lex_state = 10},
  [445] = {.lex_state = 0, .external_lex_state = 10},
  [446] = {.lex_state = 0, .external_lex_state = 11},
  [447] = {.lex_state = 0, .external_lex_state = 11},
  [448] = {.lex_state = 0, .external_lex_state = 11},
  [449] = {.lex_state = 0, .external_lex_state = 7},
  [450] = {.lex_state = 0, .external_lex_state = 9},
  [451] = {.lex_state = 0, .external_lex_state = 8},
  [452] = {.lex_state = 0, .external_lex_state = 12},
  [453] = {.lex_state = 0, .external_lex_state = 12},
  [454] = {.lex_state = 0, .external_lex_state = 12},
  [455] = {.lex_state = 0, .external_lex_state = 12},
  [456] = {.lex_state = 0, .external_lex_state = 12},
  [457] = {.lex_state = 0, .external_lex_state = 12},
  [458] = {.lex_state = 0, .external_lex_state = 12},
  [459] = {.lex_state = 0, .external_lex_state = 12},
  [460] = {.lex_state = 0, .external_lex_state = 12},
  [461] = {.lex_state = 0, .external_lex_state = 12},
  [462] = {.lex_state = 0, .external_lex_state = 12},
  [463] = {.lex_state = 0, .external_lex_state = 12},
  [464] = {.lex_state = 0, .external_lex_state = 12},
  [465] = {.lex_state = 0, .external_lex_state = 12},
  [466] = {.lex_state = 0, .external_lex_state = 12},
  [467] = {.lex_state = 0, .external_lex_state = 12},
  [468] = {.lex_state = 0, .external_lex_state = 12},
  [469] = {.lex_state = 0, .external_lex_state = 12},
  [470] = {.lex_state = 0, .external_lex_state = 12},
  [471] = {.lex_state = 0, .external_lex_state = 12},
  [472] = {.lex_state = 0, .external_lex_state = 12},
  [473] = {.lex_state = 0, .external_lex_state = 12},
  [474] = {.lex_state = 0, .external_lex_state = 12},
  [475] = {.lex_state = 0, .external_lex_state = 12},
  [476] = {.lex_state = 0, .external_lex_state = 12},
  [477] = {.lex_state = 0, .external_lex_state = 12},
  [478] = {.lex_state = 0, .external_lex_state = 12},
  [479] = {.lex_state = 0, .external_lex_state = 12},
  [480] = {.lex_state = 0, .external_lex_state = 12},
  [481] = {.lex_state = 0, .external_lex_state = 12},
  [482] = {.lex_state = 0, .external_lex_state = 12},
  [483] = {.lex_state = 0, .external_lex_state = 12},
  [484] = {.lex_state = 0, .external_lex_state = 12},
  [485] = {.lex_state = 0, .external_lex_state = 12},
  [486] = {.lex_state = 0, .external_lex_state = 12},
  [487] = {.lex_state = 0, .external_lex_state = 12},
  [488] = {.lex_state = 0, .external_lex_state = 12},
  [489] = {.lex_state = 0, .external_lex_state = 12},
  [490] = {.lex_state = 0, .external_lex_state = 12},
  [491] = {.lex_state = 0, .external_lex_state = 12},
  [492] = {.lex_state = 0, .external_lex_state = 12},
  [493] = {.lex_state = 0, .external_lex_state = 12},
  [494] = {.lex_state = 0, .external_lex_state = 12},
  [495] = {.lex_state = 0, .external_lex_state = 12},
  [496] = {.lex_state = 0, .external_lex_state = 12},
  [497] = {.lex_state = 0, .external_lex_state = 12},
  [498] = {.lex_state = 0, .external_lex_state = 12},
  [499] = {.lex_state = 0, .external_lex_state = 12},
  [500] = {.lex_state = 0, .external_lex_state = 12},
  [501] = {.lex_state = 0, .external_lex_state = 12},
  [502] = {.lex_state = 0, .external_lex_state = 12},
  [503] = {.lex_state = 0, .external_lex_state = 12},
  [504] = {.lex_state = 0, .external_lex_state = 12},
  [505] = {.lex_state = 0, .external_lex_state = 12},
  [506] = {.lex_state = 0, .external_lex_state = 12},
  [507] = {.lex_state = 0, .external_lex_state = 12},
  [508] = {.lex_state = 0, .external_lex_state = 12},
  [509] = {.lex_state = 0, .external_lex_state = 12},
  [510] = {.lex_state = 0, .external_lex_state = 12},
  [511] = {.lex_state = 0, .external_lex_state = 12},
  [512] = {.lex_state = 0, .external_lex_state = 12},
  [513] = {.lex_state = 0, .external_lex_state = 12},
  [514] = {.lex_state = 0, .external_lex_state = 12},
  [515] = {.lex_state = 0, .external_lex_state = 12},
  [516] = {.lex_state = 0, .external_lex_state = 12},
  [517] = {.lex_state = 0, .external_lex_state = 12},
  [518] = {.lex_state = 0, .external_lex_state = 12},
  [519] = {.lex_state = 0, .external_lex_state = 12},
  [520] = {.lex_state = 0, .external_lex_state = 12},
  [521] = {.lex_state = 0, .external_lex_state = 12},
  [522] = {.lex_state = 0, .external_lex_state = 12},
  [523] = {.lex_state = 0, .external_lex_state = 12},
  [524] = {.lex_state = 0, .external_lex_state = 12},
  [525] = {.lex_state = 0, .external_lex_state = 12},
  [526] = {.lex_state = 0, .external_lex_state = 12},
  [527] = {.lex_state = 0, .external_lex_state = 12},
  [528] = {.lex_state = 0, .external_lex_state = 12},
  [529] = {.lex_state = 0, .external_lex_state = 12},
  [530] = {.lex_state = 0, .external_lex_state = 12},
  [531] = {.lex_state = 0, .external_lex_state = 12},
  [532] = {.lex_state = 0, .external_lex_state = 12},
  [533] = {.lex_state = 0, .external_lex_state = 12},
  [534] = {.lex_state = 0, .external_lex_state = 12},
  [535] = {.lex_state = 0, .external_lex_state = 12},
  [536] = {.lex_state = 0, .external_lex_state = 12},
  [537] = {.lex_state = 0, .external_lex_state = 12},
  [538] = {.lex_state = 0, .external_lex_state = 12},
  [539] = {.lex_state = 0, .external_lex_state = 12},
  [540] = {.lex_state = 0, .external_lex_state = 12},
  [541] = {.lex_state = 0, .external_lex_state = 12},
  [542] = {.lex_state = 0, .external_lex_state = 12},
  [543] = {.lex_state = 0, .external_lex_state = 12},
  [544] = {.lex_state = 0, .external_lex_state = 12},
  [545] = {.lex_state = 0, .external_lex_state = 12},
  [546] = {.lex_state = 0, .external_lex_state = 12},
  [547] = {.lex_state = 0, .external_lex_state = 12},
  [548] = {.lex_state = 0, .external_lex_state = 12},
  [549] = {.lex_state = 0, .external_lex_state = 12},
  [550] = {.lex_state = 0, .external_lex_state = 12},
  [551] = {.lex_state = 0, .external_lex_state = 12},
  [552] = {.lex_state = 0, .external_lex_state = 12},
  [553] = {.lex_state = 0, .external_lex_state = 12},
  [554] = {.lex_state = 0, .external_lex_state = 12},
  [555] = {.lex_state = 0, .external_lex_state = 12},
  [556] = {.lex_state = 0, .external_lex_state = 12},
  [557] = {.lex_state = 0, .external_lex_state = 12},
  [558] = {.lex_state = 0, .external_lex_state = 12},
  [559] = {.lex_state = 0, .external_lex_state = 12},
  [560] = {.lex_state = 0, .external_lex_state = 12},
  [561] = {.lex_state = 0, .external_lex_state = 12},
  [562] = {.lex_state = 0, .external_lex_state = 12},
  [563] = {.lex_state = 0, .external_lex_state = 12},
  [564] = {.lex_state = 0, .external_lex_state = 12},
  [565] = {.lex_state = 0, .external_lex_state = 12},
  [566] = {.lex_state = 0, .external_lex_state = 12},
  [567] = {.lex_state = 0, .external_lex_state = 12},
  [568] = {.lex_state = 0, .external_lex_state = 12},
  [569] = {.lex_state = 0, .external_lex_state = 12},
  [570] = {.lex_state = 0, .external_lex_state = 12},
  [571] = {.lex_state = 0, .external_lex_state = 12},
  [572] = {.lex_state = 0, .external_lex_state = 12},
  [573] = {.lex_state = 0, .external_lex_state = 12},
  [574] = {.lex_state = 0, .external_lex_state = 12},
  [575] = {.lex_state = 0, .external_lex_state = 12},
  [576] = {.lex_state = 0, .external_lex_state = 12},
  [577] = {.lex_state = 0, .external_lex_state = 12},
  [578] = {.lex_state = 0, .external_lex_state = 12},
  [579] = {.lex_state = 0, .external_lex_state = 12},
  [580] = {.lex_state = 0, .external_lex_state = 12},
  [581] = {.lex_state = 0, .external_lex_state = 12},
  [582] = {.lex_state = 0, .external_lex_state = 12},
  [583] = {.lex_state = 0, .external_lex_state = 12},
  [584] = {.lex_state = 0, .external_lex_state = 12},
  [585] = {.lex_state = 0, .external_lex_state = 12},
  [586] = {.lex_state = 0, .external_lex_state = 12},
  [587] = {.lex_state = 0, .external_lex_state = 12},
  [588] = {.lex_state = 0, .external_lex_state = 12},
  [589] = {.lex_state = 0, .external_lex_state = 12},
  [590] = {.lex_state = 0, .external_lex_state = 12},
  [591] = {.lex_state = 0, .external_lex_state = 12},
  [592] = {.lex_state = 0, .external_lex_state = 12},
  [593] = {.lex_state = 0, .external_lex_state = 12},
  [594] = {.lex_state = 0, .external_lex_state = 12},
  [595] = {.lex_state = 0, .external_lex_state = 12},
  [596] = {.lex_state = 0, .external_lex_state = 12},
  [597] = {.lex_state = 0, .external_lex_state = 12},
  [598] = {.lex_state = 0, .external_lex_state = 12},
  [599] = {.lex_state = 0, .external_lex_state = 12},
  [600] = {.lex_state = 0, .external_lex_state = 12},
  [601] = {.lex_state = 0, .external_lex_state = 12},
  [602] = {.lex_state = 0, .external_lex_state = 12},
  [603] = {.lex_state = 0, .external_lex_state = 12},
  [604] = {.lex_state = 0, .external_lex_state = 12},
  [605] = {.lex_state = 0, .external_lex_state = 12},
  [606] = {.lex_state = 0, .external_lex_state = 12},
  [607] = {.lex_state = 0, .external_lex_state = 12},
  [608] = {.lex_state = 0, .external_lex_state = 12},
  [609] = {.lex_state = 0, .external_lex_state = 12},
  [610] = {.lex_state = 0, .external_lex_state = 12},
  [611] = {.lex_state = 0, .external_lex_state = 12},
  [612] = {.lex_state = 0, .external_lex_state = 12},
  [613] = {.lex_state = 0, .external_lex_state = 12},
  [614] = {.lex_state = 0, .external_lex_state = 12},
  [615] = {.lex_state = 0, .external_lex_state = 12},
  [616] = {.lex_state = 0, .external_lex_state = 12},
  [617] = {.lex_state = 0, .external_lex_state = 12},
  [618] = {.lex_state = 0, .external_lex_state = 12},
  [619] = {.lex_state = 0, .external_lex_state = 12},
  [620] = {.lex_state = 0, .external_lex_state = 12},
  [621] = {.lex_state = 0, .external_lex_state = 12},
  [622] = {.lex_state = 0, .external_lex_state = 12},
  [623] = {.lex_state = 0, .external_lex_state = 12},
  [624] = {.lex_state = 0, .external_lex_state = 12},
  [625] = {.lex_state = 0, .external_lex_state = 12},
  [626] = {.lex_state = 0, .external_lex_state = 12},
  [627] = {.lex_state = 0, .external_lex_state = 12},
  [628] = {.lex_state = 0, .external_lex_state = 12},
  [629] = {.lex_state = 0, .external_lex_state = 12},
  [630] = {.lex_state = 0, .external_lex_state = 12},
  [631] = {.lex_state = 0, .external_lex_state = 12},
  [632] = {.lex_state = 0, .external_lex_state = 12},
  [633] = {.lex_state = 0, .external_lex_state = 12},
  [634] = {.lex_state = 0, .external_lex_state = 12},
  [635] = {.lex_state = 0, .external_lex_state = 12},
  [636] = {.lex_state = 0, .external_lex_state = 12},
  [637] = {.lex_state = 0, .external_lex_state = 12},
  [638] = {.lex_state = 0, .external_lex_state = 12},
  [639] = {.lex_state = 0, .external_lex_state = 12},
  [640] = {.lex_state = 0, .external_lex_state = 12},
  [641] = {.lex_state = 0, .external_lex_state = 12},
  [642] = {.lex_state = 0, .external_lex_state = 12},
  [643] = {.lex_state = 0, .external_lex_state = 12},
  [644] = {.lex_state = 0, .external_lex_state = 12},
  [645] = {.lex_state = 0, .external_lex_state = 12},
  [646] = {.lex_state = 0, .external_lex_state = 12},
  [647] = {.lex_state = 0, .external_lex_state = 12},
  [648] = {.lex_state = 0, .external_lex_state = 12},
  [649] = {.lex_state = 0, .external_lex_state = 12},
  [650] = {.lex_state = 0, .external_lex_state = 12},
  [651] = {.lex_state = 0, .external_lex_state = 12},
  [652] = {.lex_state = 0, .external_lex_state = 12},
  [653] = {.lex_state = 0, .external_lex_state = 12},
  [654] = {.lex_state = 0, .external_lex_state = 12},
  [655] = {.lex_state = 0, .external_lex_state = 12},
  [656] = {.lex_state = 0, .external_lex_state = 12},
  [657] = {.lex_state = 0, .external_lex_state = 12},
  [658] = {.lex_state = 0, .external_lex_state = 12},
  [659] = {.lex_state = 0, .external_lex_state = 12},
  [660] = {.lex_state = 0, .external_lex_state = 12},
  [661] = {.lex_state = 0, .external_lex_state = 12},
  [662] = {.lex_state = 0, .external_lex_state = 12},
  [663] = {.lex_state = 0, .external_lex_state = 12},
  [664] = {.lex_state = 0, .external_lex_state = 12},
  [665] = {.lex_state = 0, .external_lex_state = 12},
  [666] = {.lex_state = 0, .external_lex_state = 12},
  [667] = {.lex_state = 0, .external_lex_state = 12},
  [668] = {.lex_state = 0, .external_lex_state = 12},
  [669] = {.lex_state = 0, .external_lex_state = 12},
  [670] = {.lex_state = 0, .external_lex_state = 12},
  [671] = {.lex_state = 0, .external_lex_state = 12},
  [672] = {.lex_state = 0, .external_lex_state = 12},
  [673] = {.lex_state = 0, .external_lex_state = 12},
  [674] = {.lex_state = 0, .external_lex_state = 12},
  [675] = {.lex_state = 0, .external_lex_state = 12},
  [676] = {.lex_state = 0, .external_lex_state = 12},
  [677] = {.lex_state = 0, .external_lex_state = 12},
  [678] = {.lex_state = 0, .external_lex_state = 12},
  [679] = {.lex_state = 0, .external_lex_state = 12},
  [680] = {.lex_state = 0, .external_lex_state = 12},
  [681] = {.lex_state = 0, .external_lex_state = 12},
  [682] = {.lex_state = 0, .external_lex_state = 12},
  [683] = {.lex_state = 0, .external_lex_state = 12},
  [684] = {.lex_state = 0, .external_lex_state = 12},
  [685] = {.lex_state = 0, .external_lex_state = 12},
  [686] = {.lex_state = 0, .external_lex_state = 12},
  [687] = {.lex_state = 0, .external_lex_state = 12},
  [688] = {.lex_state = 0, .external_lex_state = 12},
  [689] = {.lex_state = 0, .external_lex_state = 12},
  [690] = {.lex_state = 0, .external_lex_state = 12},
  [691] = {.lex_state = 0, .external_lex_state = 12},
  [692] = {.lex_state = 0, .external_lex_state = 12},
  [693] = {.lex_state = 0, .external_lex_state = 12},
  [694] = {.lex_state = 0, .external_lex_state = 12},
  [695] = {.lex_state = 0, .external_lex_state = 12},
  [696] = {.lex_state = 0, .external_lex_state = 12},
  [697] = {.lex_state = 0, .external_lex_state = 12},
  [698] = {.lex_state = 0, .external_lex_state = 12},
  [699] = {.lex_state = 0, .external_lex_state = 12},
  [700] = {.lex_state = 0, .external_lex_state = 12},
  [701] = {.lex_state = 0, .external_lex_state = 12},
  [702] = {.lex_state = 0, .external_lex_state = 12},
  [703] = {.lex_state = 0, .external_lex_state = 12},
  [704] = {.lex_state = 0, .external_lex_state = 12},
  [705] = {.lex_state = 0, .external_lex_state = 12},
  [706] = {.lex_state = 0, .external_lex_state = 12},
  [707] = {.lex_state = 0, .external_lex_state = 12},
  [708] = {.lex_state = 0, .external_lex_state = 12},
  [709] = {.lex_state = 0, .external_lex_state = 12},
  [710] = {.lex_state = 0, .external_lex_state = 12},
  [711] = {.lex_state = 0, .external_lex_state = 12},
  [712] = {.lex_state = 0, .external_lex_state = 12},
  [713] = {.lex_state = 0, .external_lex_state = 12},
  [714] = {.lex_state = 0, .external_lex_state = 12},
  [715] = {.lex_state = 0, .external_lex_state = 12},
  [716] = {.lex_state = 0, .external_lex_state = 12},
  [717] = {.lex_state = 0, .external_lex_state = 12},
  [718] = {.lex_state = 0, .external_lex_state = 12},
  [719] = {.lex_state = 0, .external_lex_state = 12},
  [720] = {.lex_state = 0, .external_lex_state = 12},
  [721] = {.lex_state = 0, .external_lex_state = 12},
  [722] = {.lex_state = 0, .external_lex_state = 12},
  [723] = {.lex_state = 0, .external_lex_state = 12},
  [724] = {.lex_state = 0, .external_lex_state = 12},
  [725] = {.lex_state = 0, .external_lex_state = 12},
  [726] = {.lex_state = 0, .external_lex_state = 12},
  [727] = {.lex_state = 0, .external_lex_state = 12},
  [728] = {.lex_state = 0, .external_lex_state = 12},
  [729] = {.lex_state = 0, .external_lex_state = 12},
  [730] = {.lex_state = 0, .external_lex_state = 12},
  [731] = {.lex_state = 0, .external_lex_state = 12},
  [732] = {.lex_state = 0, .external_lex_state = 12},
  [733] = {.lex_state = 0, .external_lex_state = 12},
  [734] = {.lex_state = 0, .external_lex_state = 12},
  [735] = {.lex_state = 0, .external_lex_state = 12},
  [736] = {.lex_state = 0, .external_lex_state = 12},
  [737] = {.lex_state = 0, .external_lex_state = 12},
  [738] = {.lex_state = 0, .external_lex_state = 12},
  [739] = {.lex_state = 0, .external_lex_state = 12},
  [740] = {.lex_state = 0, .external_lex_state = 12},
  [741] = {.lex_state = 0, .external_lex_state = 12},
  [742] = {.lex_state = 0, .external_lex_state = 12},
  [743] = {.lex_state = 0, .external_lex_state = 12},
  [744] = {.lex_state = 0, .external_lex_state = 12},
  [745] = {.lex_state = 0, .external_lex_state = 12},
  [746] = {.lex_state = 0, .external_lex_state = 12},
  [747] = {.lex_state = 0, .external_lex_state = 12},
  [748] = {.lex_state = 0, .external_lex_state = 12},
  [749] = {.lex_state = 0, .external_lex_state = 12},
  [750] = {.lex_state = 0, .external_lex_state = 12},
  [751] = {.lex_state = 0, .external_lex_state = 12},
  [752] = {.lex_state = 0, .external_lex_state = 12},
  [753] = {.lex_state = 0, .external_lex_state = 12},
  [754] = {.lex_state = 0, .external_lex_state = 12},
  [755] = {.lex_state = 0, .external_lex_state = 12},
  [756] = {.lex_state = 0, .external_lex_state = 12},
  [757] = {.lex_state = 0, .external_lex_state = 12},
  [758] = {.lex_state = 0, .external_lex_state = 12},
  [759] = {.lex_state = 0, .external_lex_state = 12},
  [760] = {.lex_state = 0, .external_lex_state = 12},
  [761] = {.lex_state = 0, .external_lex_state = 12},
  [762] = {.lex_state = 0, .external_lex_state = 12},
  [763] = {.lex_state = 0, .external_lex_state = 12},
  [764] = {.lex_state = 0, .external_lex_state = 12},
  [765] = {.lex_state = 0, .external_lex_state = 12},
  [766] = {.lex_state = 0, .external_lex_state = 12},
  [767] = {.lex_state = 0, .external_lex_state = 12},
  [768] = {.lex_state = 0, .external_lex_state = 12},
  [769] = {.lex_state = 0, .external_lex_state = 12},
  [770] = {.lex_state = 0, .external_lex_state = 12},
  [771] = {.lex_state = 0, .external_lex_state = 12},
  [772] = {.lex_state = 0, .external_lex_state = 12},
  [773] = {.lex_state = 0, .external_lex_state = 12},
  [774] = {.lex_state = 0, .external_lex_state = 12},
  [775] = {.lex_state = 0, .external_lex_state = 12},
  [776] = {.lex_state = 0, .external_lex_state = 12},
  [777] = {.lex_state = 0, .external_lex_state = 12},
  [778] = {.lex_state = 0, .external_lex_state = 12},
  [779] = {.lex_state = 0, .external_lex_state = 12},
  [780] = {.lex_state = 0, .external_lex_state = 12},
  [781] = {.lex_state = 0, .external_lex_state = 12},
  [782] = {.lex_state = 0, .external_lex_state = 12},
  [783] = {.lex_state = 0, .external_lex_state = 12},
  [784] = {.lex_state = 0, .external_lex_state = 12},
  [785] = {.lex_state = 0, .external_lex_state = 12},
  [786] = {.lex_state = 0, .external_lex_state = 12},
  [787] = {.lex_state = 0, .external_lex_state = 12},
  [788] = {.lex_state = 0, .external_lex_state = 12},
  [789] = {.lex_state = 0, .external_lex_state = 12},
  [790] = {.lex_state = 0, .external_lex_state = 12},
  [791] = {.lex_state = 0, .external_lex_state = 12},
  [792] = {.lex_state = 0, .external_lex_state = 12},
  [793] = {.lex_state = 0, .external_lex_state = 12},
  [794] = {.lex_state = 0, .external_lex_state = 12},
  [795] = {.lex_state = 0, .external_lex_state = 12},
  [796] = {.lex_state = 0, .external_lex_state = 12},
  [797] = {.lex_state = 0, .external_lex_state = 12},
  [798] = {.lex_state = 0, .external_lex_state = 12},
  [799] = {.lex_state = 0, .external_lex_state = 12},
  [800] = {.lex_state = 0, .external_lex_state = 12},
  [801] = {.lex_state = 0, .external_lex_state = 12},
  [802] = {.lex_state = 0, .external_lex_state = 12},
  [803] = {.lex_state = 0, .external_lex_state = 12},
  [804] = {.lex_state = 0, .external_lex_state = 12},
  [805] = {.lex_state = 0, .external_lex_state = 12},
  [806] = {.lex_state = 0, .external_lex_state = 12},
  [807] = {.lex_state = 0, .external_lex_state = 12},
  [808] = {.lex_state = 0, .external_lex_state = 12},
  [809] = {.lex_state = 0, .external_lex_state = 12},
  [810] = {.lex_state = 0, .external_lex_state = 12},
  [811] = {.lex_state = 0, .external_lex_state = 12},
  [812] = {.lex_state = 0, .external_lex_state = 12},
  [813] = {.lex_state = 0, .external_lex_state = 12},
  [814] = {.lex_state = 0, .external_lex_state = 12},
  [815] = {.lex_state = 0, .external_lex_state = 12},
  [816] = {.lex_state = 0, .external_lex_state = 12},
  [817] = {.lex_state = 0, .external_lex_state = 12},
  [818] = {.lex_state = 0, .external_lex_state = 12},
  [819] = {.lex_state = 0, .external_lex_state = 12},
  [820] = {.lex_state = 0, .external_lex_state = 12},
  [821] = {.lex_state = 0, .external_lex_state = 12},
  [822] = {.lex_state = 0, .external_lex_state = 12},
  [823] = {.lex_state = 0, .external_lex_state = 12},
  [824] = {.lex_state = 0, .external_lex_state = 12},
  [825] = {.lex_state = 0, .external_lex_state = 12},
  [826] = {.lex_state = 0, .external_lex_state = 12},
  [827] = {.lex_state = 0, .external_lex_state = 12},
  [828] = {.lex_state = 0, .external_lex_state = 12},
  [829] = {.lex_state = 0, .external_lex_state = 12},
  [830] = {.lex_state = 0, .external_lex_state = 12},
  [831] = {.lex_state = 0, .external_lex_state = 12},
  [832] = {.lex_state = 0, .external_lex_state = 12},
  [833] = {.lex_state = 0, .external_lex_state = 12},
  [834] = {.lex_state = 0, .external_lex_state = 12},
  [835] = {.lex_state = 0, .external_lex_state = 12},
  [836] = {.lex_state = 0, .external_lex_state = 12},
  [837] = {.lex_state = 0, .external_lex_state = 12},
  [838] = {.lex_state = 0, .external_lex_state = 12},
  [839] = {.lex_state = 0, .external_lex_state = 12},
  [840] = {.lex_state = 0, .external_lex_state = 12},
  [841] = {.lex_state = 0, .external_lex_state = 12},
  [842] = {.lex_state = 0, .external_lex_state = 12},
  [843] = {.lex_state = 0, .external_lex_state = 12},
  [844] = {.lex_state = 0, .external_lex_state = 12},
  [845] = {.lex_state = 0, .external_lex_state = 12},
  [846] = {.lex_state = 0, .external_lex_state = 12},
  [847] = {.lex_state = 0, .external_lex_state = 12},
  [848] = {.lex_state = 0, .external_lex_state = 12},
  [849] = {.lex_state = 0, .external_lex_state = 12},
  [850] = {.lex_state = 0, .external_lex_state = 12},
  [851] = {.lex_state = 0, .external_lex_state = 12},
  [852] = {.lex_state = 0, .external_lex_state = 12},
  [853] = {.lex_state = 0, .external_lex_state = 12},
  [854] = {.lex_state = 0, .external_lex_state = 12},
  [855] = {.lex_state = 0, .external_lex_state = 12},
  [856] = {.lex_state = 0, .external_lex_state = 12},
  [857] = {.lex_state = 0, .external_lex_state = 12},
  [858] = {.lex_state = 0, .external_lex_state = 12},
  [859] = {.lex_state = 0, .external_lex_state = 12},
  [860] = {.lex_state = 0, .external_lex_state = 12},
  [861] = {.lex_state = 0, .external_lex_state = 12},
  [862] = {.lex_state = 0, .external_lex_state = 12},
  [863] = {.lex_state = 0, .external_lex_state = 12},
  [864] = {.lex_state = 0, .external_lex_state = 12},
  [865] = {.lex_state = 0, .external_lex_state = 12},
  [866] = {.lex_state = 0, .external_lex_state = 12},
  [867] = {.lex_state = 0, .external_lex_state = 12},
  [868] = {.lex_state = 0, .external_lex_state = 12},
  [869] = {.lex_state = 0, .external_lex_state = 12},
  [870] = {.lex_state = 0, .external_lex_state = 12},
  [871] = {.lex_state = 0, .external_lex_state = 12},
  [872] = {.lex_state = 0, .external_lex_state = 12},
  [873] = {.lex_state = 0, .external_lex_state = 12},
  [874] = {.lex_state = 0, .external_lex_state = 12},
  [875] = {.lex_state = 0, .external_lex_state = 12},
  [876] = {.lex_state = 0, .external_lex_state = 12},
  [877] = {.lex_state = 0, .external_lex_state = 12},
  [878] = {.lex_state = 0, .external_lex_state = 12},
  [879] = {.lex_state = 0, .external_lex_state = 12},
  [880] = {.lex_state = 0, .external_lex_state = 12},
  [881] = {.lex_state = 0, .external_lex_state = 12},
  [882] = {.lex_state = 0, .external_lex_state = 12},
  [883] = {.lex_state = 0, .external_lex_state = 12},
  [884] = {.lex_state = 0, .external_lex_state = 12},
  [885] = {.lex_state = 0, .external_lex_state = 12},
  [886] = {.lex_state = 0, .external_lex_state = 12},
  [887] = {.lex_state = 0, .external_lex_state = 12},
  [888] = {.lex_state = 0, .external_lex_state = 12},
  [889] = {.lex_state = 0, .external_lex_state = 12},
  [890] = {.lex_state = 0, .external_lex_state = 12},
  [891] = {.lex_state = 0, .external_lex_state = 12},
  [892] = {.lex_state = 0, .external_lex_state = 12},
  [893] = {.lex_state = 0, .external_lex_state = 12},
  [894] = {.lex_state = 0, .external_lex_state = 12},
  [895] = {.lex_state = 0, .external_lex_state = 12},
  [896] = {.lex_state = 0, .external_lex_state = 12},
  [897] = {.lex_state = 0, .external_lex_state = 12},
  [898] = {.lex_state = 0, .external_lex_state = 12},
  [899] = {.lex_state = 0, .external_lex_state = 12},
  [900] = {.lex_state = 0, .external_lex_state = 12},
  [901] = {.lex_state = 0, .external_lex_state = 12},
  [902] = {.lex_state = 0, .external_lex_state = 12},
  [903] = {.lex_state = 0, .external_lex_state = 12},
  [904] = {.lex_state = 0, .external_lex_state = 12},
  [905] = {.lex_state = 0, .external_lex_state = 12},
  [906] = {.lex_state = 0, .external_lex_state = 12},
  [907] = {.lex_state = 0, .external_lex_state = 12},
  [908] = {.lex_state = 0, .external_lex_state = 12},
  [909] = {.lex_state = 0, .external_lex_state = 12},
  [910] = {.lex_state = 0, .external_lex_state = 12},
  [911] = {.lex_state = 0, .external_lex_state = 12},
  [912] = {.lex_state = 0, .external_lex_state = 12},
  [913] = {.lex_state = 0, .external_lex_state = 12},
  [914] = {.lex_state = 0, .external_lex_state = 12},
  [915] = {.lex_state = 0, .external_lex_state = 12},
  [916] = {.lex_state = 0, .external_lex_state = 12},
  [917] = {.lex_state = 0, .external_lex_state = 12},
  [918] = {.lex_state = 0, .external_lex_state = 12},
  [919] = {.lex_state = 0, .external_lex_state = 12},
  [920] = {.lex_state = 0, .external_lex_state = 12},
  [921] = {.lex_state = 0, .external_lex_state = 12},
  [922] = {.lex_state = 0, .external_lex_state = 12},
  [923] = {.lex_state = 0, .external_lex_state = 12},
  [924] = {.lex_state = 0, .external_lex_state = 12},
  [925] = {.lex_state = 0, .external_lex_state = 12},
  [926] = {.lex_state = 0, .external_lex_state = 12},
  [927] = {.lex_state = 0, .external_lex_state = 12},
  [928] = {.lex_state = 0, .external_lex_state = 12},
  [929] = {.lex_state = 0, .external_lex_state = 12},
  [930] = {.lex_state = 0, .external_lex_state = 12},
  [931] = {.lex_state = 0, .external_lex_state = 12},
  [932] = {.lex_state = 0, .external_lex_state = 12},
  [933] = {.lex_state = 0, .external_lex_state = 12},
  [934] = {.lex_state = 0, .external_lex_state = 12},
  [935] = {.lex_state = 0, .external_lex_state = 12},
  [936] = {.lex_state = 0, .external_lex_state = 12},
  [937] = {.lex_state = 0, .external_lex_state = 12},
  [938] = {.lex_state = 0, .external_lex_state = 12},
  [939] = {.lex_state = 0, .external_lex_state = 12},
  [940] = {.lex_state = 0, .external_lex_state = 12},
  [941] = {.lex_state = 0, .external_lex_state = 12},
  [942] = {.lex_state = 0, .external_lex_state = 12},
  [943] = {.lex_state = 0, .external_lex_state = 12},
  [944] = {.lex_state = 0, .external_lex_state = 12},
  [945] = {.lex_state = 0, .external_lex_state = 12},
  [946] = {.lex_state = 0, .external_lex_state = 12},
  [947] = {.lex_state = 0, .external_lex_state = 12},
  [948] = {.lex_state = 0, .external_lex_state = 12},
  [949] = {.lex_state = 0, .external_lex_state = 12},
  [950] = {.lex_state = 0, .external_lex_state = 12},
  [951] = {.lex_state = 0, .external_lex_state = 12},
  [952] = {.lex_state = 0, .external_lex_state = 12},
  [953] = {.lex_state = 0, .external_lex_state = 12},
  [954] = {.lex_state = 0, .external_lex_state = 12},
  [955] = {.lex_state = 0, .external_lex_state = 12},
  [956] = {.lex_state = 0, .external_lex_state = 12},
  [957] = {.lex_state = 0, .external_lex_state = 12},
  [958] = {.lex_state = 0, .external_lex_state = 12},
  [959] = {.lex_state = 0, .external_lex_state = 12},
  [960] = {.lex_state = 0, .external_lex_state = 12},
  [961] = {.lex_state = 0, .external_lex_state = 12},
  [962] = {.lex_state = 0, .external_lex_state = 12},
  [963] = {.lex_state = 0, .external_lex_state = 12},
  [964] = {.lex_state = 0, .external_lex_state = 12},
  [965] = {.lex_state = 0, .external_lex_state = 12},
  [966] = {.lex_state = 0, .external_lex_state = 12},
  [967] = {.lex_state = 0, .external_lex_state = 12},
  [968] = {.lex_state = 0, .external_lex_state = 12},
  [969] = {.lex_state = 0, .external_lex_state = 12},
  [970] = {.lex_state = 0, .external_lex_state = 12},
  [971] = {.lex_state = 0, .external_lex_state = 12},
  [972] = {.lex_state = 0, .external_lex_state = 12},
  [973] = {.lex_state = 0, .external_lex_state = 12},
  [974] = {.lex_state = 0, .external_lex_state = 12},
  [975] = {.lex_state = 0, .external_lex_state = 12},
  [976] = {.lex_state = 0, .external_lex_state = 12},
  [977] = {.lex_state = 0, .external_lex_state = 12},
  [978] = {.lex_state = 0, .external_lex_state = 12},
  [979] = {.lex_state = 0, .external_lex_state = 12},
  [980] = {.lex_state = 0, .external_lex_state = 12},
  [981] = {.lex_state = 0, .external_lex_state = 12},
  [982] = {.lex_state = 0, .external_lex_state = 12},
  [983] = {.lex_state = 0, .external_lex_state = 12},
  [984] = {.lex_state = 0, .external_lex_state = 12},
  [985] = {.lex_state = 0, .external_lex_state = 12},
  [986] = {.lex_state = 0, .external_lex_state = 12},
  [987] = {.lex_state = 0, .external_lex_state = 12},
  [988] = {.lex_state = 0, .external_lex_state = 12},
  [989] = {.lex_state = 0, .external_lex_state = 12},
  [990] = {.lex_state = 0, .external_lex_state = 12},
  [991] = {.lex_state = 0, .external_lex_state = 12},
  [992] = {.lex_state = 0, .external_lex_state = 12},
  [993] = {.lex_state = 0, .external_lex_state = 12},
  [994] = {.lex_state = 0, .external_lex_state = 12},
  [995] = {.lex_state = 0, .external_lex_state = 12},
  [996] = {.lex_state = 0, .external_lex_state = 12},
  [997] = {.lex_state = 0, .external_lex_state = 12},
  [998] = {.lex_state = 0, .external_lex_state = 12},
  [999] = {.lex_state = 0, .external_lex_state = 12},
  [1000] = {.lex_state = 0, .external_lex_state = 12},
  [1001] = {.lex_state = 0, .external_lex_state = 12},
  [1002] = {.lex_state = 0, .external_lex_state = 12},
  [1003] = {.lex_state = 0, .external_lex_state = 12},
  [1004] = {.lex_state = 0, .external_lex_state = 12},
  [1005] = {.lex_state = 0, .external_lex_state = 12},
  [1006] = {.lex_state = 0, .external_lex_state = 12},
  [1007] = {.lex_state = 0, .external_lex_state = 12},
  [1008] = {.lex_state = 0, .external_lex_state = 12},
  [1009] = {.lex_state = 0, .external_lex_state = 12},
  [1010] = {.lex_state = 0, .external_lex_state = 12},
  [1011] = {.lex_state = 0, .external_lex_state = 12},
  [1012] = {.lex_state = 0, .external_lex_state = 12},
  [1013] = {.lex_state = 0, .external_lex_state = 12},
  [1014] = {.lex_state = 0, .external_lex_state = 12},
  [1015] = {.lex_state = 0, .external_lex_state = 12},
  [1016] = {.lex_state = 0, .external_lex_state = 12},
  [1017] = {.lex_state = 0, .external_lex_state = 12},
  [1018] = {.lex_state = 0, .external_lex_state = 12},
  [1019] = {.lex_state = 0, .external_lex_state = 12},
  [1020] = {.lex_state = 0, .external_lex_state = 12},
  [1021] = {.lex_state = 0, .external_lex_state = 12},
  [1022] = {.lex_state = 0, .external_lex_state = 12},
  [1023] = {.lex_state = 0, .external_lex_state = 12},
  [1024] = {.lex_state = 0, .external_lex_state = 12},
  [1025] = {.lex_state = 0, .external_lex_state = 12},
  [1026] = {.lex_state = 0, .external_lex_state = 12},
  [1027] = {.lex_state = 0, .external_lex_state = 12},
  [1028] = {.lex_state = 0, .external_lex_state = 12},
  [1029] = {.lex_state = 0, .external_lex_state = 12},
  [1030] = {.lex_state = 0, .external_lex_state = 12},
  [1031] = {.lex_state = 0, .external_lex_state = 12},
  [1032] = {.lex_state = 0, .external_lex_state = 12},
  [1033] = {.lex_state = 0, .external_lex_state = 12},
  [1034] = {.lex_state = 0, .external_lex_state = 12},
  [1035] = {.lex_state = 0, .external_lex_state = 12},
  [1036] = {.lex_state = 0, .external_lex_state = 12},
  [1037] = {.lex_state = 0, .external_lex_state = 12},
  [1038] = {.lex_state = 0, .external_lex_state = 12},
  [1039] = {.lex_state = 0, .external_lex_state = 12},
  [1040] = {.lex_state = 0, .external_lex_state = 12},
  [1041] = {.lex_state = 0, .external_lex_state = 12},
  [1042] = {.lex_state = 0, .external_lex_state = 12},
  [1043] = {.lex_state = 0, .external_lex_state = 12},
  [1044] = {.lex_state = 0, .external_lex_state = 12},
  [1045] = {.lex_state = 0, .external_lex_state = 12},
  [1046] = {.lex_state = 0, .external_lex_state = 12},
  [1047] = {.lex_state = 0, .external_lex_state = 13},
  [1048] = {.lex_state = 0, .external_lex_state = 13},
  [1049] = {.lex_state = 0, .external_lex_state = 13},
  [1050] = {.lex_state = 0, .external_lex_state = 13},
  [1051] = {.lex_state = 0, .external_lex_state = 13},
  [1052] = {.lex_state = 0, .external_lex_state = 13},
  [1053] = {.lex_state = 0, .external_lex_state = 13},
  [1054] = {.lex_state = 0, .external_lex_state = 13},
  [1055] = {.lex_state = 0, .external_lex_state = 13},
  [1056] = {.lex_state = 0, .external_lex_state = 13},
  [1057] = {.lex_state = 0, .external_lex_state = 13},
  [1058] = {.lex_state = 0, .external_lex_state = 13},
  [1059] = {.lex_state = 0, .external_lex_state = 13},
  [1060] = {.lex_state = 0, .external_lex_state = 13},
  [1061] = {.lex_state = 0, .external_lex_state = 13},
  [1062] = {.lex_state = 0, .external_lex_state = 13},
  [1063] = {.lex_state = 0, .external_lex_state = 13},
  [1064] = {.lex_state = 0, .external_lex_state = 13},
  [1065] = {.lex_state = 0, .external_lex_state = 13},
  [1066] = {.lex_state = 0, .external_lex_state = 13},
  [1067] = {.lex_state = 0, .external_lex_state = 13},
  [1068] = {.lex_state = 0, .external_lex_state = 13},
  [1069] = {.lex_state = 0, .external_lex_state = 13},
  [1070] = {.lex_state = 0, .external_lex_state = 13},
  [1071] = {.lex_state = 0, .external_lex_state = 13},
  [1072] = {.lex_state = 0, .external_lex_state = 13},
  [1073] = {.lex_state = 0, .external_lex_state = 13},
  [1074] = {.lex_state = 0, .external_lex_state = 13},
  [1075] = {.lex_state = 0, .external_lex_state = 13},
  [1076] = {.lex_state = 0, .external_lex_state = 13},
  [1077] = {.lex_state = 0, .external_lex_state = 13},
  [1078] = {.lex_state = 0, .external_lex_state = 13},
  [1079] = {.lex_state = 0, .external_lex_state = 13},
  [1080] = {.lex_state = 0, .external_lex_state = 13},
  [1081] = {.lex_state = 0, .external_lex_state = 13},
  [1082] = {.lex_state = 0, .external_lex_state = 13},
  [1083] = {.lex_state = 0, .external_lex_state = 13},
  [1084] = {.lex_state = 0, .external_lex_state = 13},
  [1085] = {.lex_state = 0, .external_lex_state = 13},
  [1086] = {.lex_state = 0, .external_lex_state = 13},
  [1087] = {.lex_state = 0, .external_lex_state = 13},
  [1088] = {.lex_state = 0, .external_lex_state = 13},
  [1089] = {.lex_state = 0, .external_lex_state = 13},
  [1090] = {.lex_state = 0, .external_lex_state = 13},
  [1091] = {.lex_state = 0, .external_lex_state = 13},
  [1092] = {.lex_state = 0, .external_lex_state = 13},
  [1093] = {.lex_state = 0, .external_lex_state = 13},
  [1094] = {.lex_state = 0, .external_lex_state = 13},
  [1095] = {.lex_state = 0, .external_lex_state = 13},
  [1096] = {.lex_state = 0, .external_lex_state = 13},
  [1097] = {.lex_state = 0, .external_lex_state = 13},
  [1098] = {.lex_state = 0, .external_lex_state = 13},
  [1099] = {.lex_state = 0, .external_lex_state = 13},
  [1100] = {.lex_state = 0, .external_lex_state = 13},
  [1101] = {.lex_state = 0, .external_lex_state = 13},
  [1102] = {.lex_state = 0, .external_lex_state = 13},
  [1103] = {.lex_state = 0, .external_lex_state = 13},
  [1104] = {.lex_state = 0, .external_lex_state = 13},
  [1105] = {.lex_state = 0, .external_lex_state = 13},
  [1106] = {.lex_state = 0, .external_lex_state = 13},
  [1107] = {.lex_state = 0, .external_lex_state = 13},
  [1108] = {.lex_state = 0, .external_lex_state = 13},
  [1109] = {.lex_state = 0, .external_lex_state = 13},
  [1110] = {.lex_state = 0, .external_lex_state = 13},
  [1111] = {.lex_state = 0, .external_lex_state = 13},
  [1112] = {.lex_state = 0, .external_lex_state = 13},
  [1113] = {.lex_state = 0, .external_lex_state = 13},
  [1114] = {.lex_state = 0, .external_lex_state = 13},
  [1115] = {.lex_state = 0, .external_lex_state = 13},
  [1116] = {.lex_state = 0, .external_lex_state = 13},
  [1117] = {.lex_state = 0, .external_lex_state = 13},
  [1118] = {.lex_state = 1, .external_lex_state = 14},
  [1119] = {.lex_state = 1, .external_lex_state = 15},
  [1120] = {.lex_state = 1, .external_lex_state = 15},
  [1121] = {.lex_state = 1, .external_lex_state = 16},
  [1122] = {.lex_state = 1, .external_lex_state = 16},
  [1123] = {.lex_state = 1, .external_lex_state = 14},
  [1124] = {.lex_state = 1, .external_lex_state = 17},
  [1125] = {.lex_state = 1, .external_lex_state = 17},
  [1126] = {.lex_state = 1, .external_lex_state = 18},
  [1127] = {.lex_state = 1, .external_lex_state = 19},
  [1128] = {.lex_state = 1, .external_lex_state = 18},
  [1129] = {.lex_state = 1, .external_lex_state = 19},
  [1130] = {.lex_state = 1, .external_lex_state = 20},
  [1131] = {.lex_state = 1, .external_lex_state = 21},
  [1132] = {.lex_state = 1, .external_lex_state = 22},
  [1133] = {.lex_state = 1, .external_lex_state = 14},
  [1134] = {.lex_state = 1, .external_lex_state = 16},
  [1135] = {.lex_state = 1, .external_lex_state = 23},
  [1136] = {.lex_state = 1, .external_lex_state = 24},
  [1137] = {.lex_state = 1, .external_lex_state = 25},
  [1138] = {.lex_state = 1, .external_lex_state = 15},
  [1139] = {.lex_state = 0, .external_lex_state = 26},
  [1140] = {.lex_state = 0, .external_lex_state = 27},
  [1141] = {.lex_state = 0, .external_lex_state = 27},
  [1142] = {.lex_state = 0, .external_lex_state = 27},
  [1143] = {.lex_state = 0, .external_lex_state = 27},
  [1144] = {.lex_state = 0, .external_lex_state = 27},
  [1145] = {.lex_state = 1, .external_lex_state = 18},
  [1146] = {.lex_state = 0, .external_lex_state = 28},
  [1147] = {.lex_state = 1, .external_lex_state = 17},
  [1148] = {.lex_state = 1, .external_lex_state = 19},
  [1149] = {.lex_state = 0, .external_lex_state = 28},
  [1150] = {.lex_state = 0, .external_lex_state = 28},
  [1151] = {.lex_state = 0, .external_lex_state = 26},
  [1152] = {.lex_state = 0, .external_lex_state = 26},
  [1153] = {.lex_state = 0, .external_lex_state = 26},
  [1154] = {.lex_state = 0, .external_lex_state = 26},
  [1155] = {.lex_state = 0, .external_lex_state = 28},
  [1156] = {.lex_state = 0, .external_lex_state = 28},
  [1157] = {.lex_state = 0, .external_lex_state = 28},
  [1158] = {.lex_state = 0, .external_lex_state = 26},
  [1159] = {.lex_state = 0, .external_lex_state = 26},
  [1160] = {.lex_state = 0, .external_lex_state = 28},
  [1161] = {.lex_state = 0, .external_lex_state = 26},
  [1162] = {.lex_state = 0, .external_lex_state = 27},
  [1163] = {.lex_state = 0, .external_lex_state = 27},
  [1164] = {.lex_state = 0, .external_lex_state = 28},
  [1165] = {.lex_state = 0, .external_lex_state = 27},
  [1166] = {.lex_state = 0, .external_lex_state = 27},
  [1167] = {.lex_state = 0, .external_lex_state = 28},
  [1168] = {.lex_state = 0, .external_lex_state = 28},
  [1169] = {.lex_state = 0, .external_lex_state = 28},
  [1170] = {.lex_state = 0, .external_lex_state = 28},
  [1171] = {.lex_state = 0, .external_lex_state = 28},
  [1172] = {.lex_state = 0, .external_lex_state = 28},
  [1173] = {.lex_state = 0, .external_lex_state = 28},
  [1174] = {.lex_state = 0, .external_lex_state = 28},
  [1175] = {.lex_state = 0, .external_lex_state = 28},
  [1176] = {.lex_state = 0, .external_lex_state = 26},
  [1177] = {.lex_state = 0, .external_lex_state = 28},
  [1178] = {.lex_state = 0, .external_lex_state = 28},
  [1179] = {.lex_state = 0, .external_lex_state = 28},
  [1180] = {.lex_state = 0, .external_lex_state = 28},
  [1181] = {.lex_state = 0, .external_lex_state = 28},
  [1182] = {.lex_state = 0, .external_lex_state = 28},
  [1183] = {.lex_state = 0, .external_lex_state = 28},
  [1184] = {.lex_state = 0, .external_lex_state = 28},
  [1185] = {.lex_state = 0, .external_lex_state = 28},
  [1186] = {.lex_state = 0, .external_lex_state = 28},
  [1187] = {.lex_state = 0, .external_lex_state = 28},
  [1188] = {.lex_state = 0, .external_lex_state = 28},
  [1189] = {.lex_state = 0, .external_lex_state = 27},
  [1190] = {.lex_state = 0, .external_lex_state = 27},
  [1191] = {.lex_state = 0, .external_lex_state = 27},
  [1192] = {.lex_state = 0, .external_lex_state = 27},
  [1193] = {.lex_state = 0, .external_lex_state = 27},
  [1194] = {.lex_state = 0, .external_lex_state = 26},
  [1195] = {.lex_state = 0, .external_lex_state = 26},
  [1196] = {.lex_state = 0, .external_lex_state = 27},
  [1197] = {.lex_state = 0, .external_lex_state = 27},
  [1198] = {.lex_state = 0, .external_lex_state = 27},
  [1199] = {.lex_state = 0, .external_lex_state = 27},
  [1200] = {.lex_state = 0, .external_lex_state = 27},
  [1201] = {.lex_state = 0, .external_lex_state = 27},
  [1202] = {.lex_state = 0, .external_lex_state = 26},
  [1203] = {.lex_state = 0, .external_lex_state = 27},
  [1204] = {.lex_state = 0, .external_lex_state = 27},
  [1205] = {.lex_state = 0, .external_lex_state = 27},
  [1206] = {.lex_state = 0, .external_lex_state = 27},
  [1207] = {.lex_state = 0, .external_lex_state = 27},
  [1208] = {.lex_state = 0, .external_lex_state = 27},
  [1209] = {.lex_state = 0, .external_lex_state = 27},
  [1210] = {.lex_state = 0, .external_lex_state = 26},
  [1211] = {.lex_state = 0, .external_lex_state = 27},
  [1212] = {.lex_state = 0, .external_lex_state = 27},
  [1213] = {.lex_state = 0, .external_lex_state = 27},
  [1214] = {.lex_state = 0, .external_lex_state = 27},
  [1215] = {.lex_state = 0, .external_lex_state = 26},
  [1216] = {.lex_state = 0, .external_lex_state = 27},
  [1217] = {.lex_state = 0, .external_lex_state = 26},
  [1218] = {.lex_state = 0, .external_lex_state = 27},
  [1219] = {.lex_state = 0, .external_lex_state = 27},
  [1220] = {.lex_state = 0, .external_lex_state = 27},
  [1221] = {.lex_state = 0, .external_lex_state = 27},
  [1222] = {.lex_state = 0, .external_lex_state = 27},
  [1223] = {.lex_state = 0, .external_lex_state = 27},
  [1224] = {.lex_state = 0, .external_lex_state = 27},
  [1225] = {.lex_state = 0, .external_lex_state = 27},
  [1226] = {.lex_state = 0, .external_lex_state = 27},
  [1227] = {.lex_state = 0, .external_lex_state = 27},
  [1228] = {.lex_state = 0, .external_lex_state = 27},
  [1229] = {.lex_state = 0, .external_lex_state = 27},
  [1230] = {.lex_state = 0, .external_lex_state = 27},
  [1231] = {.lex_state = 0, .external_lex_state = 27},
  [1232] = {.lex_state = 0, .external_lex_state = 27},
  [1233] = {.lex_state = 0, .external_lex_state = 27},
  [1234] = {.lex_state = 0, .external_lex_state = 27},
  [1235] = {.lex_state = 0, .external_lex_state = 27},
  [1236] = {.lex_state = 0, .external_lex_state = 27},
  [1237] = {.lex_state = 0, .external_lex_state = 27},
  [1238] = {.lex_state = 0, .external_lex_state = 27},
  [1239] = {.lex_state = 0, .external_lex_state = 27},
  [1240] = {.lex_state = 0, .external_lex_state = 27},
  [1241] = {.lex_state = 0, .external_lex_state = 27},
  [1242] = {.lex_state = 0, .external_lex_state = 27},
  [1243] = {.lex_state = 0, .external_lex_state = 27},
  [1244] = {.lex_state = 0, .external_lex_state = 27},
  [1245] = {.lex_state = 0, .external_lex_state = 27},
  [1246] = {.lex_state = 0, .external_lex_state = 27},
  [1247] = {.lex_state = 0, .external_lex_state = 27},
  [1248] = {.lex_state = 0, .external_lex_state = 27},
  [1249] = {.lex_state = 0, .external_lex_state = 27},
  [1250] = {.lex_state = 0, .external_lex_state = 26},
  [1251] = {.lex_state = 0, .external_lex_state = 26},
  [1252] = {.lex_state = 0, .external_lex_state = 26},
  [1253] = {.lex_state = 0, .external_lex_state = 26},
  [1254] = {.lex_state = 0, .external_lex_state = 28},
  [1255] = {.lex_state = 0, .external_lex_state = 26},
  [1256] = {.lex_state = 0, .external_lex_state = 26},
  [1257] = {.lex_state = 0, .external_lex_state = 26},
  [1258] = {.lex_state = 0, .external_lex_state = 26},
  [1259] = {.lex_state = 0, .external_lex_state = 26},
  [1260] = {.lex_state = 0, .external_lex_state = 26},
  [1261] = {.lex_state = 0, .external_lex_state = 26},
  [1262] = {.lex_state = 0, .external_lex_state = 26},
  [1263] = {.lex_state = 0, .external_lex_state = 26},
  [1264] = {.lex_state = 0, .external_lex_state = 26},
  [1265] = {.lex_state = 0, .external_lex_state = 26},
  [1266] = {.lex_state = 0, .external_lex_state = 26},
  [1267] = {.lex_state = 0, .external_lex_state = 26},
  [1268] = {.lex_state = 0, .external_lex_state = 26},
  [1269] = {.lex_state = 0, .external_lex_state = 26},
  [1270] = {.lex_state = 0, .external_lex_state = 26},
  [1271] = {.lex_state = 0, .external_lex_state = 26},
  [1272] = {.lex_state = 0, .external_lex_state = 26},
  [1273] = {.lex_state = 0, .external_lex_state = 26},
  [1274] = {.lex_state = 0, .external_lex_state = 26},
  [1275] = {.lex_state = 0, .external_lex_state = 26},
  [1276] = {.lex_state = 0, .external_lex_state = 26},
  [1277] = {.lex_state = 0, .external_lex_state = 26},
  [1278] = {.lex_state = 0, .external_lex_state = 26},
  [1279] = {.lex_state = 0, .external_lex_state = 26},
  [1280] = {.lex_state = 0, .external_lex_state = 26},
  [1281] = {.lex_state = 0, .external_lex_state = 26},
  [1282] = {.lex_state = 0, .external_lex_state = 26},
  [1283] = {.lex_state = 0, .external_lex_state = 26},
  [1284] = {.lex_state = 0, .external_lex_state = 26},
  [1285] = {.lex_state = 0, .external_lex_state = 26},
  [1286] = {.lex_state = 0, .external_lex_state = 26},
  [1287] = {.lex_state = 0, .external_lex_state = 26},
  [1288] = {.lex_state = 0, .external_lex_state = 26},
  [1289] = {.lex_state = 0, .external_lex_state = 26},
  [1290] = {.lex_state = 0, .external_lex_state = 28},
  [1291] = {.lex_state = 0, .external_lex_state = 28},
  [1292] = {.lex_state = 0, .external_lex_state = 28},
  [1293] = {.lex_state = 0, .external_lex_state = 28},
  [1294] = {.lex_state = 0, .external_lex_state = 28},
  [1295] = {.lex_state = 0, .external_lex_state = 26},
  [1296] = {.lex_state = 0, .external_lex_state = 26},
  [1297] = {.lex_state = 0, .external_lex_state = 26},
  [1298] = {.lex_state = 0, .external_lex_state = 26},
  [1299] = {.lex_state = 0, .external_lex_state = 26},
  [1300] = {.lex_state = 0, .external_lex_state = 26},
  [1301] = {.lex_state = 0, .external_lex_state = 28},
  [1302] = {.lex_state = 0, .external_lex_state = 26},
  [1303] = {.lex_state = 0, .external_lex_state = 28},
  [1304] = {.lex_state = 0, .external_lex_state = 28},
  [1305] = {.lex_state = 0, .external_lex_state = 28},
  [1306] = {.lex_state = 0, .external_lex_state = 28},
  [1307] = {.lex_state = 0, .external_lex_state = 28},
  [1308] = {.lex_state = 0, .external_lex_state = 28},
  [1309] = {.lex_state = 0, .external_lex_state = 28},
  [1310] = {.lex_state = 0, .external_lex_state = 28},
  [1311] = {.lex_state = 0, .external_lex_state = 28},
  [1312] = {.lex_state = 0, .external_lex_state = 28},
  [1313] = {.lex_state = 0, .external_lex_state = 28},
  [1314] = {.lex_state = 0, .external_lex_state = 28},
  [1315] = {.lex_state = 0, .external_lex_state = 28},
  [1316] = {.lex_state = 0, .external_lex_state = 26},
  [1317] = {.lex_state = 0, .external_lex_state = 28},
  [1318] = {.lex_state = 0, .external_lex_state = 28},
  [1319] = {.lex_state = 0, .external_lex_state = 28},
  [1320] = {.lex_state = 0, .external_lex_state = 28},
  [1321] = {.lex_state = 0, .external_lex_state = 28},
  [1322] = {.lex_state = 0, .external_lex_state = 26},
  [1323] = {.lex_state = 0, .external_lex_state = 28},
  [1324] = {.lex_state = 0, .external_lex_state = 28},
  [1325] = {.lex_state = 0, .external_lex_state = 28},
  [1326] = {.lex_state = 0, .external_lex_state = 28},
  [1327] = {.lex_state = 0, .external_lex_state = 28},
  [1328] = {.lex_state = 0, .external_lex_state = 28},
  [1329] = {.lex_state = 0, .external_lex_state = 28},
  [1330] = {.lex_state = 0, .external_lex_state = 28},
  [1331] = {.lex_state = 0, .external_lex_state = 28},
  [1332] = {.lex_state = 0, .external_lex_state = 28},
  [1333] = {.lex_state = 0, .external_lex_state = 26},
  [1334] = {.lex_state = 0, .external_lex_state = 29},
  [1335] = {.lex_state = 0, .external_lex_state = 30},
  [1336] = {.lex_state = 0, .external_lex_state = 29},
  [1337] = {.lex_state = 0, .external_lex_state = 29},
  [1338] = {.lex_state = 0, .external_lex_state = 29},
  [1339] = {.lex_state = 0, .external_lex_state = 29},
  [1340] = {.lex_state = 0, .external_lex_state = 29},
  [1341] = {.lex_state = 0, .external_lex_state = 29},
  [1342] = {.lex_state = 0, .external_lex_state = 29},
  [1343] = {.lex_state = 0, .external_lex_state = 29},
  [1344] = {.lex_state = 0, .external_lex_state = 29},
  [1345] = {.lex_state = 0, .external_lex_state = 30},
  [1346] = {.lex_state = 0, .external_lex_state = 29},
  [1347] = {.lex_state = 0, .external_lex_state = 29},
  [1348] = {.lex_state = 0, .external_lex_state = 29},
  [1349] = {.lex_state = 0, .external_lex_state = 29},
  [1350] = {.lex_state = 0, .external_lex_state = 30},
  [1351] = {.lex_state = 0, .external_lex_state = 30},
  [1352] = {.lex_state = 0, .external_lex_state = 30},
  [1353] = {.lex_state = 0, .external_lex_state = 30},
  [1354] = {.lex_state = 0, .external_lex_state = 30},
  [1355] = {.lex_state = 0, .external_lex_state = 30},
  [1356] = {.lex_state = 0, .external_lex_state = 29},
  [1357] = {.lex_state = 0, .external_lex_state = 31},
  [1358] = {.lex_state = 0, .external_lex_state = 29},
  [1359] = {.lex_state = 0, .external_lex_state = 30},
  [1360] = {.lex_state = 0, .external_lex_state = 30},
  [1361] = {.lex_state = 0, .external_lex_state = 30},
  [1362] = {.lex_state = 0, .external_lex_state = 30},
  [1363] = {.lex_state = 0, .external_lex_state = 31},
  [1364] = {.lex_state = 0, .external_lex_state = 29},
  [1365] = {.lex_state = 0, .external_lex_state = 31},
  [1366] = {.lex_state = 0, .external_lex_state = 29},
  [1367] = {.lex_state = 0, .external_lex_state = 29},
  [1368] = {.lex_state = 0, .external_lex_state = 29},
  [1369] = {.lex_state = 0, .external_lex_state = 29},
  [1370] = {.lex_state = 0, .external_lex_state = 29},
  [1371] = {.lex_state = 0, .external_lex_state = 30},
  [1372] = {.lex_state = 0, .external_lex_state = 31},
  [1373] = {.lex_state = 0, .external_lex_state = 29},
  [1374] = {.lex_state = 0, .external_lex_state = 29},
  [1375] = {.lex_state = 0, .external_lex_state = 30},
  [1376] = {.lex_state = 0, .external_lex_state = 31},
  [1377] = {.lex_state = 0, .external_lex_state = 31},
  [1378] = {.lex_state = 0, .external_lex_state = 29},
  [1379] = {.lex_state = 0, .external_lex_state = 29},
  [1380] = {.lex_state = 0, .external_lex_state = 29},
  [1381] = {.lex_state = 0, .external_lex_state = 29},
  [1382] = {.lex_state = 0, .external_lex_state = 29},
  [1383] = {.lex_state = 0, .external_lex_state = 29},
  [1384] = {.lex_state = 0, .external_lex_state = 29},
  [1385] = {.lex_state = 0, .external_lex_state = 29},
  [1386] = {.lex_state = 0, .external_lex_state = 30},
  [1387] = {.lex_state = 0, .external_lex_state = 29},
  [1388] = {.lex_state = 0, .external_lex_state = 31},
  [1389] = {.lex_state = 0, .external_lex_state = 31},
  [1390] = {.lex_state = 0, .external_lex_state = 31},
  [1391] = {.lex_state = 0, .external_lex_state = 31},
  [1392] = {.lex_state = 0, .external_lex_state = 31},
  [1393] = {.lex_state = 0, .external_lex_state = 31},
  [1394] = {.lex_state = 0, .external_lex_state = 31},
  [1395] = {.lex_state = 0, .external_lex_state = 30},
  [1396] = {.lex_state = 0, .external_lex_state = 31},
  [1397] = {.lex_state = 0, .external_lex_state = 31},
  [1398] = {.lex_state = 0, .external_lex_state = 31},
  [1399] = {.lex_state = 0, .external_lex_state = 30},
  [1400] = {.lex_state = 0, .external_lex_state = 31},
  [1401] = {.lex_state = 0, .external_lex_state = 31},
  [1402] = {.lex_state = 0, .external_lex_state = 30},
  [1403] = {.lex_state = 0, .external_lex_state = 31},
  [1404] = {.lex_state = 0, .external_lex_state = 31},
  [1405] = {.lex_state = 0, .external_lex_state = 31},
  [1406] = {.lex_state = 0, .external_lex_state = 31},
  [1407] = {.lex_state = 0, .external_lex_state = 31},
  [1408] = {.lex_state = 0, .external_lex_state = 31},
  [1409] = {.lex_state = 0, .external_lex_state = 31},
  [1410] = {.lex_state = 0, .external_lex_state = 30},
  [1411] = {.lex_state = 0, .external_lex_state = 31},
  [1412] = {.lex_state = 0, .external_lex_state = 30},
  [1413] = {.lex_state = 0, .external_lex_state = 31},
  [1414] = {.lex_state = 0, .external_lex_state = 31},
  [1415] = {.lex_state = 0, .external_lex_state = 30},
  [1416] = {.lex_state = 0, .external_lex_state = 31},
  [1417] = {.lex_state = 0, .external_lex_state = 30},
  [1418] = {.lex_state = 0, .external_lex_state = 31},
  [1419] = {.lex_state = 0, .external_lex_state = 31},
  [1420] = {.lex_state = 0, .external_lex_state = 30},
  [1421] = {.lex_state = 0, .external_lex_state = 29},
  [1422] = {.lex_state = 0, .external_lex_state = 30},
  [1423] = {.lex_state = 0, .external_lex_state = 30},
  [1424] = {.lex_state = 0, .external_lex_state = 29},
  [1425] = {.lex_state = 0, .external_lex_state = 30},
  [1426] = {.lex_state = 0, .external_lex_state = 29},
  [1427] = {.lex_state = 0, .external_lex_state = 29},
  [1428] = {.lex_state = 0, .external_lex_state = 29},
  [1429] = {.lex_state = 0, .external_lex_state = 30},
  [1430] = {.lex_state = 0, .external_lex_state = 29},
  [1431] = {.lex_state = 0, .external_lex_state = 30},
  [1432] = {.lex_state = 0, .external_lex_state = 29},
  [1433] = {.lex_state = 0, .external_lex_state = 30},
  [1434] = {.lex_state = 0, .external_lex_state = 31},
  [1435] = {.lex_state = 0, .external_lex_state = 29},
  [1436] = {.lex_state = 0, .external_lex_state = 29},
  [1437] = {.lex_state = 0, .external_lex_state = 31},
  [1438] = {.lex_state = 0, .external_lex_state = 30},
  [1439] = {.lex_state = 0, .external_lex_state = 31},
  [1440] = {.lex_state = 0, .external_lex_state = 29},
  [1441] = {.lex_state = 0, .external_lex_state = 31},
  [1442] = {.lex_state = 0, .external_lex_state = 29},
  [1443] = {.lex_state = 0, .external_lex_state = 31},
  [1444] = {.lex_state = 0, .external_lex_state = 29},
  [1445] = {.lex_state = 0, .external_lex_state = 30},
  [1446] = {.lex_state = 0, .external_lex_state = 29},
  [1447] = {.lex_state = 0, .external_lex_state = 31},
  [1448] = {.lex_state = 0, .external_lex_state = 30},
  [1449] = {.lex_state = 0, .external_lex_state = 30},
  [1450] = {.lex_state = 0, .external_lex_state = 30},
  [1451] = {.lex_state = 0, .external_lex_state = 30},
  [1452] = {.lex_state = 0, .external_lex_state = 30},
  [1453] = {.lex_state = 0, .external_lex_state = 30},
  [1454] = {.lex_state = 0, .external_lex_state = 30},
  [1455] = {.lex_state = 0, .external_lex_state = 31},
  [1456] = {.lex_state = 0, .external_lex_state = 31},
  [1457] = {.lex_state = 0, .external_lex_state = 30},
  [1458] = {.lex_state = 0, .external_lex_state = 30},
  [1459] = {.lex_state = 0, .external_lex_state = 31},
  [1460] = {.lex_state = 0, .external_lex_state = 31},
  [1461] = {.lex_state = 0, .external_lex_state = 30},
  [1462] = {.lex_state = 0, .external_lex_state = 31},
  [1463] = {.lex_state = 0, .external_lex_state = 30},
  [1464] = {.lex_state = 0, .external_lex_state = 31},
  [1465] = {.lex_state = 0, .external_lex_state = 31},
  [1466] = {.lex_state = 0, .external_lex_state = 29},
  [1467] = {.lex_state = 0, .external_lex_state = 29},
  [1468] = {.lex_state = 0, .external_lex_state = 31},
  [1469] = {.lex_state = 0, .external_lex_state = 30},
  [1470] = {.lex_state = 0, .external_lex_state = 31},
  [1471] = {.lex_state = 0, .external_lex_state = 30},
  [1472] = {.lex_state = 0, .external_lex_state = 30},
  [1473] = {.lex_state = 0, .external_lex_state = 30},
  [1474] = {.lex_state = 0, .external_lex_state = 30},
  [1475] = {.lex_state = 0, .external_lex_state = 30},
  [1476] = {.lex_state = 0, .external_lex_state = 30},
  [1477] = {.lex_state = 0, .external_lex_state = 30},
  [1478] = {.lex_state = 0, .external_lex_state = 30},
  [1479] = {.lex_state = 0, .external_lex_state = 31},
  [1480] = {.lex_state = 0, .external_lex_state = 30},
  [1481] = {.lex_state = 0, .external_lex_state = 31},
  [1482] = {.lex_state = 0, .external_lex_state = 30},
  [1483] = {.lex_state = 0, .external_lex_state = 31},
  [1484] = {.lex_state = 0, .external_lex_state = 31},
  [1485] = {.lex_state = 0, .external_lex_state = 30},
  [1486] = {.lex_state = 0, .external_lex_state = 30},
  [1487] = {.lex_state = 0, .external_lex_state = 30},
  [1488] = {.lex_state = 0, .external_lex_state = 30},
  [1489] = {.lex_state = 0, .external_lex_state = 30},
  [1490] = {.lex_state = 0, .external_lex_state = 30},
  [1491] = {.lex_state = 0, .external_lex_state = 30},
  [1492] = {.lex_state = 0, .external_lex_state = 31},
  [1493] = {.lex_state = 0, .external_lex_state = 30},
  [1494] = {.lex_state = 0, .external_lex_state = 30},
  [1495] = {.lex_state = 0, .external_lex_state = 30},
  [1496] = {.lex_state = 0, .external_lex_state = 31},
  [1497] = {.lex_state = 0, .external_lex_state = 30},
  [1498] = {.lex_state = 0, .external_lex_state = 30},
  [1499] = {.lex_state = 0, .external_lex_state = 30},
  [1500] = {.lex_state = 0, .external_lex_state = 30},
  [1501] = {.lex_state = 0, .external_lex_state = 30},
  [1502] = {.lex_state = 0, .external_lex_state = 30},
  [1503] = {.lex_state = 0, .external_lex_state = 30},
  [1504] = {.lex_state = 0, .external_lex_state = 30},
  [1505] = {.lex_state = 0, .external_lex_state = 30},
  [1506] = {.lex_state = 0, .external_lex_state = 30},
  [1507] = {.lex_state = 0, .external_lex_state = 30},
  [1508] = {.lex_state = 0, .external_lex_state = 30},
  [1509] = {.lex_state = 0, .external_lex_state = 30},
  [1510] = {.lex_state = 0, .external_lex_state = 30},
  [1511] = {.lex_state = 0, .external_lex_state = 30},
  [1512] = {.lex_state = 0, .external_lex_state = 30},
  [1513] = {.lex_state = 0, .external_lex_state = 30},
  [1514] = {.lex_state = 0, .external_lex_state = 30},
  [1515] = {.lex_state = 0, .external_lex_state = 30},
  [1516] = {.lex_state = 0, .external_lex_state = 30},
  [1517] = {.lex_state = 0, .external_lex_state = 30},
  [1518] = {.lex_state = 0, .external_lex_state = 30},
  [1519] = {.lex_state = 0, .external_lex_state = 31},
  [1520] = {.lex_state = 0, .external_lex_state = 31},
  [1521] = {.lex_state = 0, .external_lex_state = 30},
  [1522] = {.lex_state = 0, .external_lex_state = 30},
  [1523] = {.lex_state = 0, .external_lex_state = 30},
  [1524] = {.lex_state = 0, .external_lex_state = 30},
  [1525] = {.lex_state = 0, .external_lex_state = 30},
  [1526] = {.lex_state = 0, .external_lex_state = 29},
  [1527] = {.lex_state = 0, .external_lex_state = 30},
  [1528] = {.lex_state = 0, .external_lex_state = 30},
  [1529] = {.lex_state = 0, .external_lex_state = 31},
  [1530] = {.lex_state = 0, .external_lex_state = 30},
  [1531] = {.lex_state = 0, .external_lex_state = 30},
  [1532] = {.lex_state = 0, .external_lex_state = 29},
  [1533] = {.lex_state = 0, .external_lex_state = 31},
  [1534] = {.lex_state = 0, .external_lex_state = 30},
  [1535] = {.lex_state = 0, .external_lex_state = 29},
  [1536] = {.lex_state = 0, .external_lex_state = 30},
  [1537] = {.lex_state = 0, .external_lex_state = 29},
  [1538] = {.lex_state = 0, .external_lex_state = 30},
  [1539] = {.lex_state = 0, .external_lex_state = 30},
  [1540] = {.lex_state = 0, .external_lex_state = 30},
  [1541] = {.lex_state = 0, .external_lex_state = 29},
  [1542] = {.lex_state = 0, .external_lex_state = 30},
  [1543] = {.lex_state = 0, .external_lex_state = 30},
  [1544] = {.lex_state = 0, .external_lex_state = 30},
  [1545] = {.lex_state = 0, .external_lex_state = 29},
  [1546] = {.lex_state = 0, .external_lex_state = 30},
  [1547] = {.lex_state = 0, .external_lex_state = 30},
  [1548] = {.lex_state = 0, .external_lex_state = 30},
  [1549] = {.lex_state = 0, .external_lex_state = 30},
  [1550] = {.lex_state = 0, .external_lex_state = 30},
  [1551] = {.lex_state = 0, .external_lex_state = 30},
  [1552] = {.lex_state = 0, .external_lex_state = 29},
  [1553] = {.lex_state = 0, .external_lex_state = 30},
  [1554] = {.lex_state = 0, .external_lex_state = 30},
  [1555] = {.lex_state = 0, .external_lex_state = 30},
  [1556] = {.lex_state = 0, .external_lex_state = 30},
  [1557] = {.lex_state = 0, .external_lex_state = 30},
  [1558] = {.lex_state = 0, .external_lex_state = 30},
  [1559] = {.lex_state = 0, .external_lex_state = 30},
  [1560] = {.lex_state = 0, .external_lex_state = 30},
  [1561] = {.lex_state = 0, .external_lex_state = 30},
  [1562] = {.lex_state = 0, .external_lex_state = 30},
  [1563] = {.lex_state = 0, .external_lex_state = 30},
  [1564] = {.lex_state = 0, .external_lex_state = 30},
  [1565] = {.lex_state = 0, .external_lex_state = 30},
  [1566] = {.lex_state = 0, .external_lex_state = 30},
  [1567] = {.lex_state = 0, .external_lex_state = 30},
  [1568] = {.lex_state = 0, .external_lex_state = 30},
  [1569] = {.lex_state = 0, .external_lex_state = 30},
  [1570] = {.lex_state = 0, .external_lex_state = 30},
  [1571] = {.lex_state = 0, .external_lex_state = 30},
  [1572] = {.lex_state = 0, .external_lex_state = 29},
  [1573] = {.lex_state = 0, .external_lex_state = 29},
  [1574] = {.lex_state = 0, .external_lex_state = 30},
  [1575] = {.lex_state = 0, .external_lex_state = 31},
  [1576] = {.lex_state = 0, .external_lex_state = 28},
  [1577] = {.lex_state = 0, .external_lex_state = 28},
  [1578] = {.lex_state = 2, .external_lex_state = 28},
  [1579] = {.lex_state = 0, .external_lex_state = 28},
  [1580] = {.lex_state = 0, .external_lex_state = 26},
  [1581] = {.lex_state = 0, .external_lex_state = 26},
  [1582] = {.lex_state = 0, .external_lex_state = 26},
  [1583] = {.lex_state = 0, .external_lex_state = 28},
  [1584] = {.lex_state = 0, .external_lex_state = 28},
  [1585] = {.lex_state = 0, .external_lex_state = 10},
  [1586] = {.lex_state = 0, .external_lex_state = 26},
  [1587] = {.lex_state = 0, .external_lex_state = 26},
  [1588] = {.lex_state = 0, .external_lex_state = 28},
  [1589] = {.lex_state = 0, .external_lex_state = 28},
  [1590] = {.lex_state = 0, .external_lex_state = 28},
  [1591] = {.lex_state = 0, .external_lex_state = 27},
  [1592] = {.lex_state = 0, .external_lex_state = 27},
  [1593] = {.lex_state = 2, .external_lex_state = 27},
  [1594] = {.lex_state = 0, .external_lex_state = 27},
  [1595] = {.lex_state = 0, .external_lex_state = 27},
  [1596] = {.lex_state = 0, .external_lex_state = 27},
  [1597] = {.lex_state = 0, .external_lex_state = 27},
  [1598] = {.lex_state = 0, .external_lex_state = 27},
  [1599] = {.lex_state = 2, .external_lex_state = 26},
  [1600] = {.lex_state = 0, .external_lex_state = 27},
  [1601] = {.lex_state = 0, .external_lex_state = 26},
  [1602] = {.lex_state = 0, .external_lex_state = 26},
  [1603] = {.lex_state = 0, .external_lex_state = 26},
  [1604] = {.lex_state = 0, .external_lex_state = 29},
  [1605] = {.lex_state = 0, .external_lex_state = 29},
  [1606] = {.lex_state = 0, .external_lex_state = 30},
  [1607] = {.lex_state = 0, .external_lex_state = 29},
  [1608] = {.lex_state = 0, .external_lex_state = 31},
  [1609] = {.lex_state = 0, .external_lex_state = 12},
  [1610] = {.lex_state = 2, .external_lex_state = 29},
  [1611] = {.lex_state = 0, .external_lex_state = 31},
  [1612] = {.lex_state = 0, .external_lex_state = 30},
  [1613] = {.lex_state = 0, .external_lex_state = 31},
  [1614] = {.lex_state = 0, .external_lex_state = 30},
  [1615] = {.lex_state = 0, .external_lex_state = 31},
  [1616] = {.lex_state = 0, .external_lex_state = 30},
  [1617] = {.lex_state = 0, .external_lex_state = 29},
  [1618] = {.lex_state = 0, .external_lex_state = 29},
  [1619] = {.lex_state = 0, .external_lex_state = 30},
  [1620] = {.lex_state = 2, .external_lex_state = 30},
  [1621] = {.lex_state = 0, .external_lex_state = 31},
  [1622] = {.lex_state = 0, .external_lex_state = 31},
  [1623] = {.lex_state = 0, .external_lex_state = 31},
  [1624] = {.lex_state = 0, .external_lex_state = 30},
  [1625] = {.lex_state = 0, .external_lex_state = 30},
  [1626] = {.lex_state = 2, .external_lex_state = 31},
  [1627] = {.lex_state = 0, .external_lex_state = 29},
  [1628] = {.lex_state = 0, .external_lex_state = 31},
  [1629] = {.lex_state = 0, .external_lex_state = 31},
  [1630] = {.lex_state = 0, .external_lex_state = 30},
  [1631] = {.lex_state = 0, .external_lex_state = 29},
  [1632] = {.lex_state = 0, .external_lex_state = 29},
  [1633] = {.lex_state = 0, .external_lex_state = 29},
  [1634] = {.lex_state = 0, .external_lex_state = 30},
  [1635] = {.lex_state = 0, .external_lex_state = 28},
  [1636] = {.lex_state = 0, .external_lex_state = 26},
  [1637] = {.lex_state = 0, .external_lex_state = 28},
  [1638] = {.lex_state = 0, .external_lex_state = 27},
  [1639] = {.lex_state = 0, .external_lex_state = 26},
  [1640] = {.lex_state = 0, .external_lex_state = 26},
  [1641] = {.lex_state = 0, .external_lex_state = 26},
  [1642] = {.lex_state = 0, .external_lex_state = 27},
  [1643] = {.lex_state = 0, .external_lex_state = 26},
  [1644] = {.lex_state = 0, .external_lex_state = 26},
  [1645] = {.lex_state = 0, .external_lex_state = 26},
  [1646] = {.lex_state = 0, .external_lex_state = 28},
  [1647] = {.lex_state = 0, .external_lex_state = 28},
  [1648] = {.lex_state = 0, .external_lex_state = 28},
  [1649] = {.lex_state = 0, .external_lex_state = 28},
  [1650] = {.lex_state = 0, .external_lex_state = 28},
  [1651] = {.lex_state = 0, .external_lex_state = 28},
  [1652] = {.lex_state = 0, .external_lex_state = 28},
  [1653] = {.lex_state = 0, .external_lex_state = 26},
  [1654] = {.lex_state = 0, .external_lex_state = 28},
  [1655] = {.lex_state = 0, .external_lex_state = 28},
  [1656] = {.lex_state = 0, .external_lex_state = 28},
  [1657] = {.lex_state = 0, .external_lex_state = 28},
  [1658] = {.lex_state = 0, .external_lex_state = 27},
  [1659] = {.lex_state = 0, .external_lex_state = 26},
  [1660] = {.lex_state = 0, .external_lex_state = 26},
  [1661] = {.lex_state = 0, .external_lex_state = 26},
  [1662] = {.lex_state = 0, .external_lex_state = 28},
  [1663] = {.lex_state = 0, .external_lex_state = 27},
  [1664] = {.lex_state = 0, .external_lex_state = 27},
  [1665] = {.lex_state = 0, .external_lex_state = 26},
  [1666] = {.lex_state = 0, .external_lex_state = 27},
  [1667] = {.lex_state = 0, .external_lex_state = 27},
  [1668] = {.lex_state = 0, .external_lex_state = 26},
  [1669] = {.lex_state = 0, .external_lex_state = 26},
  [1670] = {.lex_state = 0, .external_lex_state = 27},
  [1671] = {.lex_state = 0, .external_lex_state = 27},
  [1672] = {.lex_state = 0, .external_lex_state = 26},
  [1673] = {.lex_state = 0, .external_lex_state = 27},
  [1674] = {.lex_state = 0, .external_lex_state = 26},
  [1675] = {.lex_state = 0, .external_lex_state = 26},
  [1676] = {.lex_state = 0, .external_lex_state = 27},
  [1677] = {.lex_state = 0, .external_lex_state = 27},
  [1678] = {.lex_state = 0, .external_lex_state = 27},
  [1679] = {.lex_state = 0, .external_lex_state = 27},
  [1680] = {.lex_state = 0, .external_lex_state = 27},
  [1681] = {.lex_state = 0, .external_lex_state = 26},
  [1682] = {.lex_state = 0, .external_lex_state = 27},
  [1683] = {.lex_state = 0, .external_lex_state = 26},
  [1684] = {.lex_state = 0, .external_lex_state = 26},
  [1685] = {.lex_state = 0, .external_lex_state = 26},
  [1686] = {.lex_state = 0, .external_lex_state = 26},
  [1687] = {.lex_state = 0, .external_lex_state = 26},
  [1688] = {.lex_state = 0, .external_lex_state = 26},
  [1689] = {.lex_state = 0, .external_lex_state = 27},
  [1690] = {.lex_state = 0, .external_lex_state = 27},
  [1691] = {.lex_state = 0, .external_lex_state = 27},
  [1692] = {.lex_state = 0, .external_lex_state = 12},
  [1693] = {.lex_state = 0, .external_lex_state = 28},
  [1694] = {.lex_state = 0, .external_lex_state = 12},
  [1695] = {.lex_state = 0, .external_lex_state = 28},
  [1696] = {.lex_state = 0, .external_lex_state = 28},
  [1697] = {.lex_state = 0, .external_lex_state = 12},
  [1698] = {.lex_state = 0, .external_lex_state = 27},
  [1699] = {.lex_state = 0, .external_lex_state = 27},
  [1700] = {.lex_state = 0, .external_lex_state = 27},
  [1701] = {.lex_state = 0, .external_lex_state = 27},
  [1702] = {.lex_state = 0, .external_lex_state = 28},
  [1703] = {.lex_state = 0, .external_lex_state = 28},
  [1704] = {.lex_state = 0, .external_lex_state = 28},
  [1705] = {.lex_state = 0, .external_lex_state = 28},
  [1706] = {.lex_state = 0, .external_lex_state = 28},
  [1707] = {.lex_state = 0, .external_lex_state = 28},
  [1708] = {.lex_state = 0, .external_lex_state = 28},
  [1709] = {.lex_state = 0, .external_lex_state = 27},
  [1710] = {.lex_state = 0, .external_lex_state = 30},
  [1711] = {.lex_state = 0, .external_lex_state = 31},
  [1712] = {.lex_state = 0, .external_lex_state = 29},
  [1713] = {.lex_state = 0, .external_lex_state = 30},
  [1714] = {.lex_state = 0, .external_lex_state = 30},
  [1715] = {.lex_state = 0, .external_lex_state = 29},
  [1716] = {.lex_state = 0, .external_lex_state = 30},
  [1717] = {.lex_state = 0, .external_lex_state = 30},
  [1718] = {.lex_state = 0, .external_lex_state = 29},
  [1719] = {.lex_state = 0, .external_lex_state = 30},
  [1720] = {.lex_state = 0, .external_lex_state = 31},
  [1721] = {.lex_state = 0, .external_lex_state = 31},
  [1722] = {.lex_state = 0, .external_lex_state = 31},
  [1723] = {.lex_state = 0, .external_lex_state = 31},
  [1724] = {.lex_state = 0, .external_lex_state = 31},
  [1725] = {.lex_state = 0, .external_lex_state = 31},
  [1726] = {.lex_state = 0, .external_lex_state = 31},
  [1727] = {.lex_state = 0, .external_lex_state = 31},
  [1728] = {.lex_state = 0, .external_lex_state = 31},
  [1729] = {.lex_state = 0, .external_lex_state = 31},
  [1730] = {.lex_state = 0, .external_lex_state = 31},
  [1731] = {.lex_state = 0, .external_lex_state = 30},
  [1732] = {.lex_state = 0, .external_lex_state = 29},
  [1733] = {.lex_state = 0, .external_lex_state = 31},
  [1734] = {.lex_state = 0, .external_lex_state = 30},
  [1735] = {.lex_state = 0, .external_lex_state = 30},
  [1736] = {.lex_state = 0, .external_lex_state = 29},
  [1737] = {.lex_state = 0, .external_lex_state = 30},
  [1738] = {.lex_state = 0, .external_lex_state = 30},
  [1739] = {.lex_state = 0, .external_lex_state = 31},
  [1740] = {.lex_state = 0, .external_lex_state = 30},
  [1741] = {.lex_state = 0, .external_lex_state = 29},
  [1742] = {.lex_state = 0, .external_lex_state = 29},
  [1743] = {.lex_state = 0, .external_lex_state = 31},
  [1744] = {.lex_state = 0, .external_lex_state = 29},
  [1745] = {.lex_state = 0, .external_lex_state = 31},
  [1746] = {.lex_state = 0, .external_lex_state = 31},
  [1747] = {.lex_state = 0, .external_lex_state = 31},
  [1748] = {.lex_state = 0, .external_lex_state = 29},
  [1749] = {.lex_state = 0, .external_lex_state = 31},
  [1750] = {.lex_state = 0, .external_lex_state = 31},
  [1751] = {.lex_state = 0, .external_lex_state = 31},
  [1752] = {.lex_state = 0, .external_lex_state = 30},
  [1753] = {.lex_state = 0, .external_lex_state = 30},
  [1754] = {.lex_state = 0, .external_lex_state = 29},
  [1755] = {.lex_state = 0, .external_lex_state = 30},
  [1756] = {.lex_state = 0, .external_lex_state = 29},
  [1757] = {.lex_state = 0, .external_lex_state = 29},
  [1758] = {.lex_state = 0, .external_lex_state = 31},
  [1759] = {.lex_state = 0, .external_lex_state = 29},
  [1760] = {.lex_state = 0, .external_lex_state = 29},
  [1761] = {.lex_state = 0, .external_lex_state = 31},
  [1762] = {.lex_state = 0, .external_lex_state = 29},
  [1763] = {.lex_state = 0, .external_lex_state = 29},
  [1764] = {.lex_state = 0, .external_lex_state = 29},
  [1765] = {.lex_state = 0, .external_lex_state = 29},
  [1766] = {.lex_state = 0, .external_lex_state = 29},
  [1767] = {.lex_state = 0, .external_lex_state = 31},
  [1768] = {.lex_state = 0, .external_lex_state = 29},
  [1769] = {.lex_state = 0, .external_lex_state = 29},
  [1770] = {.lex_state = 0, .external_lex_state = 30},
  [1771] = {.lex_state = 0, .external_lex_state = 30},
  [1772] = {.lex_state = 0, .external_lex_state = 30},
  [1773] = {.lex_state = 0, .external_lex_state = 29},
  [1774] = {.lex_state = 0, .external_lex_state = 30},
  [1775] = {.lex_state = 0, .external_lex_state = 30},
  [1776] = {.lex_state = 0, .external_lex_state = 30},
  [1777] = {.lex_state = 0, .external_lex_state = 30},
  [1778] = {.lex_state = 0, .external_lex_state = 29},
  [1779] = {.lex_state = 0, .external_lex_state = 31},
  [1780] = {.lex_state = 0, .external_lex_state = 29},
  [1781] = {.lex_state = 0, .external_lex_state = 30},
  [1782] = {.lex_state = 0, .external_lex_state = 30},
  [1783] = {.lex_state = 0, .external_lex_state = 30},
  [1784] = {.lex_state = 0, .external_lex_state = 29},
  [1785] = {.lex_state = 1, .external_lex_state = 32},
  [1786] = {.lex_state = 1},
  [1787] = {.lex_state = 0, .external_lex_state = 33},
  [1788] = {.lex_state = 0, .external_lex_state = 33},
  [1789] = {.lex_state = 0, .external_lex_state = 33},
  [1790] = {.lex_state = 0, .external_lex_state = 33},
  [1791] = {.lex_state = 0, .external_lex_state = 33},
  [1792] = {.lex_state = 0, .external_lex_state = 33},
  [1793] = {.lex_state = 0, .external_lex_state = 33},
  [1794] = {.lex_state = 0, .external_lex_state = 33},
  [1795] = {.lex_state = 0, .external_lex_state = 33},
  [1796] = {.lex_state = 0, .external_lex_state = 33},
  [1797] = {.lex_state = 0, .external_lex_state = 33},
  [1798] = {.lex_state = 0, .external_lex_state = 33},
  [1799] = {.lex_state = 0, .external_lex_state = 33},
  [1800] = {.lex_state = 0, .external_lex_state = 33},
  [1801] = {.lex_state = 0, .external_lex_state = 33},
  [1802] = {.lex_state = 0, .external_lex_state = 33},
  [1803] = {.lex_state = 0, .external_lex_state = 33},
  [1804] = {.lex_state = 0, .external_lex_state = 33},
  [1805] = {.lex_state = 0, .external_lex_state = 33},
  [1806] = {.lex_state = 0, .external_lex_state = 33},
  [1807] = {.lex_state = 0, .external_lex_state = 32},
  [1808] = {.lex_state = 0, .external_lex_state = 34},
  [1809] = {.lex_state = 0, .external_lex_state = 35},
  [1810] = {.lex_state = 0, .external_lex_state = 35},
  [1811] = {.lex_state = 4},
  [1812] = {.lex_state = 4},
  [1813] = {.lex_state = 3},
  [1814] = {.lex_state = 3},
  [1815] = {.lex_state = 0, .external_lex_state = 33},
  [1816] = {.lex_state = 4},
  [1817] = {.lex_state = 3},
  [1818] = {.lex_state = 0, .external_lex_state = 35},
  [1819] = {.lex_state = 0, .external_lex_state = 34},
  [1820] = {.lex_state = 0, .external_lex_state = 34},
  [1821] = {.lex_state = 4},
  [1822] = {.lex_state = 0, .external_lex_state = 32},
  [1823] = {.lex_state = 0, .external_lex_state = 32},
  [1824] = {.lex_state = 0, .external_lex_state = 35},
  [1825] = {.lex_state = 0, .external_lex_state = 34},
  [1826] = {.lex_state = 0, .external_lex_state = 32},
  [1827] = {.lex_state = 3},
  [1828] = {.lex_state = 0, .external_lex_state = 34},
  [1829] = {.lex_state = 0, .external_lex_state = 34},
  [1830] = {.lex_state = 0, .external_lex_state = 34},
  [1831] = {.lex_state = 0, .external_lex_state = 34},
  [1832] = {.lex_state = 4},
  [1833] = {.lex_state = 3},
  [1834] = {.lex_state = 0, .external_lex_state = 32},
  [1835] = {.lex_state = 4},
  [1836] = {.lex_state = 3},
  [1837] = {.lex_state = 0, .external_lex_state = 35},
  [1838] = {.lex_state = 0, .external_lex_state = 35},
  [1839] = {.lex_state = 0, .external_lex_state = 32},
  [1840] = {.lex_state = 0, .external_lex_state = 32},
  [1841] = {.lex_state = 4},
  [1842] = {.lex_state = 0, .external_lex_state = 32},
  [1843] = {.lex_state = 0, .external_lex_state = 32},
  [1844] = {.lex_state = 4},
  [1845] = {.lex_state = 0, .external_lex_state = 32},
  [1846] = {.lex_state = 0, .external_lex_state = 35},
  [1847] = {.lex_state = 0, .external_lex_state = 32},
  [1848] = {.lex_state = 3},
  [1849] = {.lex_state = 0, .external_lex_state = 34},
  [1850] = {.lex_state = 0, .external_lex_state = 34},
  [1851] = {.lex_state = 4},
  [1852] = {.lex_state = 3},
  [1853] = {.lex_state = 0, .external_lex_state = 35},
  [1854] = {.lex_state = 0, .external_lex_state = 35},
  [1855] = {.lex_state = 4},
  [1856] = {.lex_state = 3},
  [1857] = {.lex_state = 0, .external_lex_state = 34},
  [1858] = {.lex_state = 0, .external_lex_state = 33},
  [1859] = {.lex_state = 0, .external_lex_state = 35},
  [1860] = {.lex_state = 4},
  [1861] = {.lex_state = 0, .external_lex_state = 32},
  [1862] = {.lex_state = 0, .external_lex_state = 32},
  [1863] = {.lex_state = 3},
  [1864] = {.lex_state = 0, .external_lex_state = 33},
  [1865] = {.lex_state = 0, .external_lex_state = 32},
  [1866] = {.lex_state = 0, .external_lex_state = 35},
  [1867] = {.lex_state = 0, .external_lex_state = 34},
  [1868] = {.lex_state = 4},
  [1869] = {.lex_state = 4},
  [1870] = {.lex_state = 3},
  [1871] = {.lex_state = 0, .external_lex_state = 35},
  [1872] = {.lex_state = 4},
  [1873] = {.lex_state = 4},
  [1874] = {.lex_state = 3},
  [1875] = {.lex_state = 3},
  [1876] = {.lex_state = 3},
  [1877] = {.lex_state = 0, .external_lex_state = 32},
  [1878] = {.lex_state = 3},
  [1879] = {.lex_state = 0, .external_lex_state = 32},
  [1880] = {.lex_state = 4},
  [1881] = {.lex_state = 0, .external_lex_state = 32},
  [1882] = {.lex_state = 0, .external_lex_state = 34},
  [1883] = {.lex_state = 3},
  [1884] = {.lex_state = 0, .external_lex_state = 34},
  [1885] = {.lex_state = 3},
  [1886] = {.lex_state = 0, .external_lex_state = 32},
  [1887] = {.lex_state = 0, .external_lex_state = 32},
  [1888] = {.lex_state = 4},
  [1889] = {.lex_state = 0, .external_lex_state = 35},
  [1890] = {.lex_state = 3},
  [1891] = {.lex_state = 0, .external_lex_state = 33},
  [1892] = {.lex_state = 0, .external_lex_state = 34},
  [1893] = {.lex_state = 0, .external_lex_state = 35},
  [1894] = {.lex_state = 0, .external_lex_state = 32},
  [1895] = {.lex_state = 0, .external_lex_state = 32},
  [1896] = {.lex_state = 0, .external_lex_state = 34},
  [1897] = {.lex_state = 4},
  [1898] = {.lex_state = 3},
  [1899] = {.lex_state = 0, .external_lex_state = 35},
  [1900] = {.lex_state = 0, .external_lex_state = 33},
  [1901] = {.lex_state = 0, .external_lex_state = 35},
  [1902] = {.lex_state = 0, .external_lex_state = 32},
  [1903] = {.lex_state = 0, .external_lex_state = 35},
  [1904] = {.lex_state = 0, .external_lex_state = 35},
  [1905] = {.lex_state = 0, .external_lex_state = 34},
  [1906] = {.lex_state = 0, .external_lex_state = 32},
  [1907] = {.lex_state = 0, .external_lex_state = 34},
  [1908] = {.lex_state = 0, .external_lex_state = 32},
  [1909] = {.lex_state = 0, .external_lex_state = 35},
  [1910] = {.lex_state = 4},
  [1911] = {.lex_state = 3},
  [1912] = {.lex_state = 0, .external_lex_state = 32},
  [1913] = {.lex_state = 0, .external_lex_state = 33},
  [1914] = {.lex_state = 0, .external_lex_state = 35},
  [1915] = {.lex_state = 0, .external_lex_state = 35},
  [1916] = {.lex_state = 0, .external_lex_state = 34},
  [1917] = {.lex_state = 0, .external_lex_state = 35},
  [1918] = {.lex_state = 0, .external_lex_state = 34},
  [1919] = {.lex_state = 0, .external_lex_state = 34},
  [1920] = {.lex_state = 0, .external_lex_state = 34},
  [1921] = {.lex_state = 0, .external_lex_state = 32},
  [1922] = {.lex_state = 0, .external_lex_state = 35},
  [1923] = {.lex_state = 0, .external_lex_state = 35},
  [1924] = {.lex_state = 4},
  [1925] = {.lex_state = 0, .external_lex_state = 34},
  [1926] = {.lex_state = 0, .external_lex_state = 34},
  [1927] = {.lex_state = 0, .external_lex_state = 34},
  [1928] = {.lex_state = 0, .external_lex_state = 35},
  [1929] = {.lex_state = 0, .external_lex_state = 34},
  [1930] = {.lex_state = 0, .external_lex_state = 33},
  [1931] = {.lex_state = 0, .external_lex_state = 34},
  [1932] = {.lex_state = 0, .external_lex_state = 33},
  [1933] = {.lex_state = 0, .external_lex_state = 32},
  [1934] = {.lex_state = 0, .external_lex_state = 32},
  [1935] = {.lex_state = 0, .external_lex_state = 35},
  [1936] = {.lex_state = 0, .external_lex_state = 33},
  [1937] = {.lex_state = 0, .external_lex_state = 35},
  [1938] = {.lex_state = 0, .external_lex_state = 33},
  [1939] = {.lex_state = 0, .external_lex_state = 34},
  [1940] = {.lex_state = 0, .external_lex_state = 33},
  [1941] = {.lex_state = 0, .external_lex_state = 32},
  [1942] = {.lex_state = 0, .external_lex_state = 33},
  [1943] = {.lex_state = 0, .external_lex_state = 34},
  [1944] = {.lex_state = 0, .external_lex_state = 33},
  [1945] = {.lex_state = 0, .external_lex_state = 32},
  [1946] = {.lex_state = 0, .external_lex_state = 33},
  [1947] = {.lex_state = 0, .external_lex_state = 32},
  [1948] = {.lex_state = 0, .external_lex_state = 33},
  [1949] = {.lex_state = 0, .external_lex_state = 33},
  [1950] = {.lex_state = 0, .external_lex_state = 33},
  [1951] = {.lex_state = 0, .external_lex_state = 32},
  [1952] = {.lex_state = 0, .external_lex_state = 33},
  [1953] = {.lex_state = 0, .external_lex_state = 35},
  [1954] = {.lex_state = 0, .external_lex_state = 33},
  [1955] = {.lex_state = 0, .external_lex_state = 35},
  [1956] = {.lex_state = 0, .external_lex_state = 33},
  [1957] = {.lex_state = 0, .external_lex_state = 33},
  [1958] = {.lex_state = 4},
  [1959] = {.lex_state = 0, .external_lex_state = 33},
  [1960] = {.lex_state = 0, .external_lex_state = 34},
  [1961] = {.lex_state = 0, .external_lex_state = 33},
  [1962] = {.lex_state = 0, .external_lex_state = 33},
  [1963] = {.lex_state = 0, .external_lex_state = 33},
  [1964] = {.lex_state = 0, .external_lex_state = 35},
  [1965] = {.lex_state = 0, .external_lex_state = 33},
  [1966] = {.lex_state = 0, .external_lex_state = 33},
  [1967] = {.lex_state = 0, .external_lex_state = 33},
  [1968] = {.lex_state = 0, .external_lex_state = 33},
  [1969] = {.lex_state = 0, .external_lex_state = 33},
  [1970] = {.lex_state = 0, .external_lex_state = 33},
  [1971] = {.lex_state = 0, .external_lex_state = 33},
  [1972] = {.lex_state = 0, .external_lex_state = 33},
  [1973] = {.lex_state = 0, .external_lex_state = 33},
  [1974] = {.lex_state = 0, .external_lex_state = 33},
  [1975] = {.lex_state = 0, .external_lex_state = 33},
  [1976] = {.lex_state = 0, .external_lex_state = 33},
  [1977] = {.lex_state = 0, .external_lex_state = 33},
  [1978] = {.lex_state = 0, .external_lex_state = 33},
  [1979] = {.lex_state = 0, .external_lex_state = 33},
  [1980] = {.lex_state = 0, .external_lex_state = 33},
  [1981] = {.lex_state = 0, .external_lex_state = 33},
  [1982] = {.lex_state = 0, .external_lex_state = 33},
  [1983] = {.lex_state = 0, .external_lex_state = 33},
  [1984] = {.lex_state = 0, .external_lex_state = 33},
  [1985] = {.lex_state = 0, .external_lex_state = 33},
  [1986] = {.lex_state = 0, .external_lex_state = 33},
  [1987] = {.lex_state = 0, .external_lex_state = 33},
  [1988] = {.lex_state = 0, .external_lex_state = 33},
  [1989] = {.lex_state = 0, .external_lex_state = 33},
  [1990] = {.lex_state = 0, .external_lex_state = 33},
  [1991] = {.lex_state = 0, .external_lex_state = 33},
  [1992] = {.lex_state = 0, .external_lex_state = 33},
  [1993] = {.lex_state = 0, .external_lex_state = 33},
  [1994] = {.lex_state = 0, .external_lex_state = 33},
  [1995] = {.lex_state = 0, .external_lex_state = 33},
  [1996] = {.lex_state = 0, .external_lex_state = 33},
  [1997] = {.lex_state = 0, .external_lex_state = 33},
  [1998] = {.lex_state = 0, .external_lex_state = 33},
  [1999] = {.lex_state = 0, .external_lex_state = 33},
  [2000] = {.lex_state = 3},
  [2001] = {.lex_state = 0, .external_lex_state = 33},
  [2002] = {.lex_state = 0, .external_lex_state = 32},
  [2003] = {.lex_state = 1},
  [2004] = {.lex_state = 0, .external_lex_state = 32},
  [2005] = {.lex_state = 0, .external_lex_state = 34},
  [2006] = {.lex_state = 0, .external_lex_state = 32},
  [2007] = {.lex_state = 3},
  [2008] = {.lex_state = 1},
  [2009] = {.lex_state = 1},
  [2010] = {.lex_state = 1},
  [2011] = {.lex_state = 1},
  [2012] = {.lex_state = 1},
  [2013] = {.lex_state = 1},
  [2014] = {.lex_state = 4},
  [2015] = {.lex_state = 1},
  [2016] = {.lex_state = 1},
  [2017] = {.lex_state = 0, .external_lex_state = 35},
  [2018] = {.lex_state = 1},
  [2019] = {.lex_state = 1},
  [2020] = {.lex_state = 1},
  [2021] = {.lex_state = 1},
  [2022] = {.lex_state = 1},
  [2023] = {.lex_state = 1},
  [2024] = {.lex_state = 1},
  [2025] = {.lex_state = 1},
  [2026] = {.lex_state = 1},
  [2027] = {.lex_state = 1},
  [2028] = {.lex_state = 1},
  [2029] = {.lex_state = 0, .external_lex_state = 32},
  [2030] = {.lex_state = 0, .external_lex_state = 32},
  [2031] = {.lex_state = 0, .external_lex_state = 32},
  [2032] = {.lex_state = 0, .external_lex_state = 35},
  [2033] = {.lex_state = 0, .external_lex_state = 34},
  [2034] = {.lex_state = 0, .external_lex_state = 32},
  [2035] = {.lex_state = 0, .external_lex_state = 34},
  [2036] = {.lex_state = 0, .external_lex_state = 32},
  [2037] = {.lex_state = 0, .external_lex_state = 32},
  [2038] = {.lex_state = 0, .external_lex_state = 34},
  [2039] = {.lex_state = 0, .external_lex_state = 32},
  [2040] = {.lex_state = 0, .external_lex_state = 34},
  [2041] = {.lex_state = 0, .external_lex_state = 35},
  [2042] = {.lex_state = 0, .external_lex_state = 35},
  [2043] = {.lex_state = 0, .external_lex_state = 35},
  [2044] = {.lex_state = 0, .external_lex_state = 32},
  [2045] = {.lex_state = 0, .external_lex_state = 35},
  [2046] = {.lex_state = 0, .external_lex_state = 32},
  [2047] = {.lex_state = 0, .external_lex_state = 34},
  [2048] = {.lex_state = 2},
  [2049] = {.lex_state = 2},
  [2050] = {.lex_state = 2},
  [2051] = {.lex_state = 2},
  [2052] = {.lex_state = 2},
  [2053] = {.lex_state = 0},
  [2054] = {.lex_state = 0},
  [2055] = {.lex_state = 2},
  [2056] = {.lex_state = 2},
  [2057] = {.lex_state = 2},
  [2058] = {.lex_state = 2},
  [2059] = {.lex_state = 0},
  [2060] = {.lex_state = 2},
  [2061] = {.lex_state = 2},
  [2062] = {.lex_state = 2},
  [2063] = {.lex_state = 2},
  [2064] = {.lex_state = 2},
  [2065] = {.lex_state = 2},
  [2066] = {.lex_state = 2},
  [2067] = {.lex_state = 2},
  [2068] = {.lex_state = 2},
  [2069] = {.lex_state = 2},
  [2070] = {.lex_state = 2},
  [2071] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_repeat] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_LT_DASH] = ACTIONS(1),
    [anon_sym_LT_LT_DASH] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_DASH_GT_GT] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [aux_sym_binary_operator_token1] = ACTIONS(1),
    [anon_sym_PIPE_GT] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(1),
    [anon_sym_L] = ACTIONS(1),
    [anon_sym_i] = ACTIONS(1),
    [sym__hex_literal] = ACTIONS(1),
    [sym__number_literal] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_dots] = ACTIONS(1),
    [sym_dot_dot_i] = ACTIONS(1),
    [sym_return] = ACTIONS(1),
    [sym_next] = ACTIONS(1),
    [sym_break] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_inf] = ACTIONS(1),
    [sym_nan] = ACTIONS(1),
    [anon_sym_NA] = ACTIONS(1),
    [anon_sym_NA_integer_] = ACTIONS(1),
    [anon_sym_NA_real_] = ACTIONS(1),
    [anon_sym_NA_complex_] = ACTIONS(1),
    [anon_sym_NA_character_] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(1),
    [sym__start] = ACTIONS(1),
    [sym__newline] = ACTIONS(1),
    [sym__semicolon] = ACTIONS(1),
    [sym__raw_string_literal] = ACTIONS(1),
    [sym__external_else] = ACTIONS(1),
    [sym__external_open_parenthesis] = ACTIONS(1),
    [sym__external_close_parenthesis] = ACTIONS(1),
    [sym__external_open_brace] = ACTIONS(1),
    [sym__external_close_brace] = ACTIONS(1),
    [sym__external_open_bracket] = ACTIONS(1),
    [sym__external_close_bracket] = ACTIONS(1),
    [sym__external_open_bracket2] = ACTIONS(1),
    [sym__external_close_bracket2] = ACTIONS(1),
    [sym__error_sentinel] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(2053),
    [sym_comment] = ACTIONS(3),
    [sym__start] = ACTIONS(5),
  },
  [2] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__else] = STATE(505),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(9),
    [anon_sym_for] = ACTIONS(9),
    [anon_sym_while] = ACTIONS(9),
    [anon_sym_repeat] = ACTIONS(9),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(7),
    [sym__number_literal] = ACTIONS(9),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [sym_dots] = ACTIONS(9),
    [sym_dot_dot_i] = ACTIONS(9),
    [sym_return] = ACTIONS(9),
    [sym_next] = ACTIONS(9),
    [sym_break] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_inf] = ACTIONS(9),
    [sym_nan] = ACTIONS(9),
    [anon_sym_NA] = ACTIONS(9),
    [anon_sym_NA_integer_] = ACTIONS(9),
    [anon_sym_NA_real_] = ACTIONS(9),
    [anon_sym_NA_complex_] = ACTIONS(9),
    [anon_sym_NA_character_] = ACTIONS(9),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(7),
    [sym__semicolon] = ACTIONS(7),
    [sym__raw_string_literal] = ACTIONS(7),
    [sym__external_else] = ACTIONS(49),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(7),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [3] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__else] = STATE(633),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(57),
    [sym_identifier] = ACTIONS(59),
    [anon_sym_BSLASH] = ACTIONS(57),
    [anon_sym_function] = ACTIONS(59),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(59),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_QMARK] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(57),
    [sym__number_literal] = ACTIONS(59),
    [anon_sym_SQUOTE] = ACTIONS(57),
    [anon_sym_DQUOTE] = ACTIONS(57),
    [sym_dots] = ACTIONS(59),
    [sym_dot_dot_i] = ACTIONS(59),
    [sym_return] = ACTIONS(59),
    [sym_next] = ACTIONS(59),
    [sym_break] = ACTIONS(59),
    [sym_true] = ACTIONS(59),
    [sym_false] = ACTIONS(59),
    [sym_null] = ACTIONS(59),
    [sym_inf] = ACTIONS(59),
    [sym_nan] = ACTIONS(59),
    [anon_sym_NA] = ACTIONS(59),
    [anon_sym_NA_integer_] = ACTIONS(59),
    [anon_sym_NA_real_] = ACTIONS(59),
    [anon_sym_NA_complex_] = ACTIONS(59),
    [anon_sym_NA_character_] = ACTIONS(59),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(57),
    [sym__semicolon] = ACTIONS(57),
    [sym__raw_string_literal] = ACTIONS(57),
    [sym__external_else] = ACTIONS(61),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(57),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [4] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__else] = STATE(646),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(63),
    [sym_identifier] = ACTIONS(65),
    [anon_sym_BSLASH] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(65),
    [anon_sym_QMARK] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(63),
    [sym__number_literal] = ACTIONS(65),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [sym_dots] = ACTIONS(65),
    [sym_dot_dot_i] = ACTIONS(65),
    [sym_return] = ACTIONS(65),
    [sym_next] = ACTIONS(65),
    [sym_break] = ACTIONS(65),
    [sym_true] = ACTIONS(65),
    [sym_false] = ACTIONS(65),
    [sym_null] = ACTIONS(65),
    [sym_inf] = ACTIONS(65),
    [sym_nan] = ACTIONS(65),
    [anon_sym_NA] = ACTIONS(65),
    [anon_sym_NA_integer_] = ACTIONS(65),
    [anon_sym_NA_real_] = ACTIONS(65),
    [anon_sym_NA_complex_] = ACTIONS(65),
    [anon_sym_NA_character_] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(63),
    [sym__semicolon] = ACTIONS(63),
    [sym__raw_string_literal] = ACTIONS(63),
    [sym__external_else] = ACTIONS(67),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(63),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [5] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__else] = STATE(632),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(69),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_BSLASH] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(71),
    [anon_sym_while] = ACTIONS(71),
    [anon_sym_repeat] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(69),
    [sym__number_literal] = ACTIONS(71),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_dots] = ACTIONS(71),
    [sym_dot_dot_i] = ACTIONS(71),
    [sym_return] = ACTIONS(71),
    [sym_next] = ACTIONS(71),
    [sym_break] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_null] = ACTIONS(71),
    [sym_inf] = ACTIONS(71),
    [sym_nan] = ACTIONS(71),
    [anon_sym_NA] = ACTIONS(71),
    [anon_sym_NA_integer_] = ACTIONS(71),
    [anon_sym_NA_real_] = ACTIONS(71),
    [anon_sym_NA_complex_] = ACTIONS(71),
    [anon_sym_NA_character_] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(69),
    [sym__semicolon] = ACTIONS(69),
    [sym__raw_string_literal] = ACTIONS(69),
    [sym__external_else] = ACTIONS(73),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(69),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [6] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__else] = STATE(490),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(9),
    [anon_sym_for] = ACTIONS(9),
    [anon_sym_while] = ACTIONS(9),
    [anon_sym_repeat] = ACTIONS(9),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(7),
    [sym__number_literal] = ACTIONS(9),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [sym_dots] = ACTIONS(9),
    [sym_dot_dot_i] = ACTIONS(9),
    [sym_return] = ACTIONS(9),
    [sym_next] = ACTIONS(9),
    [sym_break] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_inf] = ACTIONS(9),
    [sym_nan] = ACTIONS(9),
    [anon_sym_NA] = ACTIONS(9),
    [anon_sym_NA_integer_] = ACTIONS(9),
    [anon_sym_NA_real_] = ACTIONS(9),
    [anon_sym_NA_complex_] = ACTIONS(9),
    [anon_sym_NA_character_] = ACTIONS(9),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(7),
    [sym__semicolon] = ACTIONS(7),
    [sym__raw_string_literal] = ACTIONS(7),
    [sym__external_else] = ACTIONS(113),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(7),
    [sym__external_close_brace] = ACTIONS(7),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [7] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__else] = STATE(496),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_BSLASH] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(71),
    [anon_sym_while] = ACTIONS(71),
    [anon_sym_repeat] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(69),
    [sym__number_literal] = ACTIONS(71),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_dots] = ACTIONS(71),
    [sym_dot_dot_i] = ACTIONS(71),
    [sym_return] = ACTIONS(71),
    [sym_next] = ACTIONS(71),
    [sym_break] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_null] = ACTIONS(71),
    [sym_inf] = ACTIONS(71),
    [sym_nan] = ACTIONS(71),
    [anon_sym_NA] = ACTIONS(71),
    [anon_sym_NA_integer_] = ACTIONS(71),
    [anon_sym_NA_real_] = ACTIONS(71),
    [anon_sym_NA_complex_] = ACTIONS(71),
    [anon_sym_NA_character_] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(69),
    [sym__semicolon] = ACTIONS(69),
    [sym__raw_string_literal] = ACTIONS(69),
    [sym__external_else] = ACTIONS(121),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(69),
    [sym__external_close_brace] = ACTIONS(69),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [8] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__else] = STATE(497),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(59),
    [anon_sym_BSLASH] = ACTIONS(57),
    [anon_sym_function] = ACTIONS(59),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(59),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_QMARK] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(57),
    [sym__number_literal] = ACTIONS(59),
    [anon_sym_SQUOTE] = ACTIONS(57),
    [anon_sym_DQUOTE] = ACTIONS(57),
    [sym_dots] = ACTIONS(59),
    [sym_dot_dot_i] = ACTIONS(59),
    [sym_return] = ACTIONS(59),
    [sym_next] = ACTIONS(59),
    [sym_break] = ACTIONS(59),
    [sym_true] = ACTIONS(59),
    [sym_false] = ACTIONS(59),
    [sym_null] = ACTIONS(59),
    [sym_inf] = ACTIONS(59),
    [sym_nan] = ACTIONS(59),
    [anon_sym_NA] = ACTIONS(59),
    [anon_sym_NA_integer_] = ACTIONS(59),
    [anon_sym_NA_real_] = ACTIONS(59),
    [anon_sym_NA_complex_] = ACTIONS(59),
    [anon_sym_NA_character_] = ACTIONS(59),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(57),
    [sym__semicolon] = ACTIONS(57),
    [sym__raw_string_literal] = ACTIONS(57),
    [sym__external_else] = ACTIONS(123),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(57),
    [sym__external_close_brace] = ACTIONS(57),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [9] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__else] = STATE(504),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(65),
    [anon_sym_BSLASH] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(65),
    [anon_sym_QMARK] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(63),
    [sym__number_literal] = ACTIONS(65),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [sym_dots] = ACTIONS(65),
    [sym_dot_dot_i] = ACTIONS(65),
    [sym_return] = ACTIONS(65),
    [sym_next] = ACTIONS(65),
    [sym_break] = ACTIONS(65),
    [sym_true] = ACTIONS(65),
    [sym_false] = ACTIONS(65),
    [sym_null] = ACTIONS(65),
    [sym_inf] = ACTIONS(65),
    [sym_nan] = ACTIONS(65),
    [anon_sym_NA] = ACTIONS(65),
    [anon_sym_NA_integer_] = ACTIONS(65),
    [anon_sym_NA_real_] = ACTIONS(65),
    [anon_sym_NA_complex_] = ACTIONS(65),
    [anon_sym_NA_character_] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(63),
    [sym__semicolon] = ACTIONS(63),
    [sym__raw_string_literal] = ACTIONS(63),
    [sym__external_else] = ACTIONS(125),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(63),
    [sym__external_close_brace] = ACTIONS(63),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [10] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__else] = STATE(857),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(65),
    [anon_sym_BSLASH] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(65),
    [anon_sym_QMARK] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(63),
    [sym__number_literal] = ACTIONS(65),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [sym_dots] = ACTIONS(65),
    [sym_dot_dot_i] = ACTIONS(65),
    [sym_return] = ACTIONS(65),
    [sym_next] = ACTIONS(65),
    [sym_break] = ACTIONS(65),
    [sym_true] = ACTIONS(65),
    [sym_false] = ACTIONS(65),
    [sym_null] = ACTIONS(65),
    [sym_inf] = ACTIONS(65),
    [sym_nan] = ACTIONS(65),
    [anon_sym_NA] = ACTIONS(65),
    [anon_sym_NA_integer_] = ACTIONS(65),
    [anon_sym_NA_real_] = ACTIONS(65),
    [anon_sym_NA_complex_] = ACTIONS(65),
    [anon_sym_NA_character_] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(63),
    [sym__semicolon] = ACTIONS(63),
    [sym__raw_string_literal] = ACTIONS(63),
    [sym__external_else] = ACTIONS(127),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(63),
    [sym__external_close_brace] = ACTIONS(63),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [11] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__else] = STATE(711),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(9),
    [anon_sym_for] = ACTIONS(9),
    [anon_sym_while] = ACTIONS(9),
    [anon_sym_repeat] = ACTIONS(9),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(7),
    [sym__number_literal] = ACTIONS(9),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [sym_dots] = ACTIONS(9),
    [sym_dot_dot_i] = ACTIONS(9),
    [sym_return] = ACTIONS(9),
    [sym_next] = ACTIONS(9),
    [sym_break] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_inf] = ACTIONS(9),
    [sym_nan] = ACTIONS(9),
    [anon_sym_NA] = ACTIONS(9),
    [anon_sym_NA_integer_] = ACTIONS(9),
    [anon_sym_NA_real_] = ACTIONS(9),
    [anon_sym_NA_complex_] = ACTIONS(9),
    [anon_sym_NA_character_] = ACTIONS(9),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(7),
    [sym__semicolon] = ACTIONS(7),
    [sym__raw_string_literal] = ACTIONS(7),
    [sym__external_else] = ACTIONS(129),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(7),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [12] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__else] = STATE(715),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(69),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_BSLASH] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(71),
    [anon_sym_while] = ACTIONS(71),
    [anon_sym_repeat] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(69),
    [sym__number_literal] = ACTIONS(71),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_dots] = ACTIONS(71),
    [sym_dot_dot_i] = ACTIONS(71),
    [sym_return] = ACTIONS(71),
    [sym_next] = ACTIONS(71),
    [sym_break] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_null] = ACTIONS(71),
    [sym_inf] = ACTIONS(71),
    [sym_nan] = ACTIONS(71),
    [anon_sym_NA] = ACTIONS(71),
    [anon_sym_NA_integer_] = ACTIONS(71),
    [anon_sym_NA_real_] = ACTIONS(71),
    [anon_sym_NA_complex_] = ACTIONS(71),
    [anon_sym_NA_character_] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(69),
    [sym__semicolon] = ACTIONS(69),
    [sym__raw_string_literal] = ACTIONS(69),
    [sym__external_else] = ACTIONS(131),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(69),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [13] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__else] = STATE(716),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(57),
    [sym_identifier] = ACTIONS(59),
    [anon_sym_BSLASH] = ACTIONS(57),
    [anon_sym_function] = ACTIONS(59),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(59),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_QMARK] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(57),
    [sym__number_literal] = ACTIONS(59),
    [anon_sym_SQUOTE] = ACTIONS(57),
    [anon_sym_DQUOTE] = ACTIONS(57),
    [sym_dots] = ACTIONS(59),
    [sym_dot_dot_i] = ACTIONS(59),
    [sym_return] = ACTIONS(59),
    [sym_next] = ACTIONS(59),
    [sym_break] = ACTIONS(59),
    [sym_true] = ACTIONS(59),
    [sym_false] = ACTIONS(59),
    [sym_null] = ACTIONS(59),
    [sym_inf] = ACTIONS(59),
    [sym_nan] = ACTIONS(59),
    [anon_sym_NA] = ACTIONS(59),
    [anon_sym_NA_integer_] = ACTIONS(59),
    [anon_sym_NA_real_] = ACTIONS(59),
    [anon_sym_NA_complex_] = ACTIONS(59),
    [anon_sym_NA_character_] = ACTIONS(59),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(57),
    [sym__semicolon] = ACTIONS(57),
    [sym__raw_string_literal] = ACTIONS(57),
    [sym__external_else] = ACTIONS(133),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(57),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [14] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__else] = STATE(723),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(63),
    [sym_identifier] = ACTIONS(65),
    [anon_sym_BSLASH] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_repeat] = ACTIONS(65),
    [anon_sym_QMARK] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(63),
    [sym__number_literal] = ACTIONS(65),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [sym_dots] = ACTIONS(65),
    [sym_dot_dot_i] = ACTIONS(65),
    [sym_return] = ACTIONS(65),
    [sym_next] = ACTIONS(65),
    [sym_break] = ACTIONS(65),
    [sym_true] = ACTIONS(65),
    [sym_false] = ACTIONS(65),
    [sym_null] = ACTIONS(65),
    [sym_inf] = ACTIONS(65),
    [sym_nan] = ACTIONS(65),
    [anon_sym_NA] = ACTIONS(65),
    [anon_sym_NA_integer_] = ACTIONS(65),
    [anon_sym_NA_real_] = ACTIONS(65),
    [anon_sym_NA_complex_] = ACTIONS(65),
    [anon_sym_NA_character_] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(63),
    [sym__semicolon] = ACTIONS(63),
    [sym__raw_string_literal] = ACTIONS(63),
    [sym__external_else] = ACTIONS(135),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(63),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [15] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__else] = STATE(843),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(9),
    [anon_sym_for] = ACTIONS(9),
    [anon_sym_while] = ACTIONS(9),
    [anon_sym_repeat] = ACTIONS(9),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(7),
    [sym__number_literal] = ACTIONS(9),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [sym_dots] = ACTIONS(9),
    [sym_dot_dot_i] = ACTIONS(9),
    [sym_return] = ACTIONS(9),
    [sym_next] = ACTIONS(9),
    [sym_break] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_inf] = ACTIONS(9),
    [sym_nan] = ACTIONS(9),
    [anon_sym_NA] = ACTIONS(9),
    [anon_sym_NA_integer_] = ACTIONS(9),
    [anon_sym_NA_real_] = ACTIONS(9),
    [anon_sym_NA_complex_] = ACTIONS(9),
    [anon_sym_NA_character_] = ACTIONS(9),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(7),
    [sym__semicolon] = ACTIONS(7),
    [sym__raw_string_literal] = ACTIONS(7),
    [sym__external_else] = ACTIONS(137),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(7),
    [sym__external_close_brace] = ACTIONS(7),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [16] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__else] = STATE(849),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(71),
    [anon_sym_BSLASH] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(71),
    [anon_sym_while] = ACTIONS(71),
    [anon_sym_repeat] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(69),
    [sym__number_literal] = ACTIONS(71),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_dots] = ACTIONS(71),
    [sym_dot_dot_i] = ACTIONS(71),
    [sym_return] = ACTIONS(71),
    [sym_next] = ACTIONS(71),
    [sym_break] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_null] = ACTIONS(71),
    [sym_inf] = ACTIONS(71),
    [sym_nan] = ACTIONS(71),
    [anon_sym_NA] = ACTIONS(71),
    [anon_sym_NA_integer_] = ACTIONS(71),
    [anon_sym_NA_real_] = ACTIONS(71),
    [anon_sym_NA_complex_] = ACTIONS(71),
    [anon_sym_NA_character_] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(69),
    [sym__semicolon] = ACTIONS(69),
    [sym__raw_string_literal] = ACTIONS(69),
    [sym__external_else] = ACTIONS(139),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(69),
    [sym__external_close_brace] = ACTIONS(69),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [17] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__else] = STATE(850),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(59),
    [anon_sym_BSLASH] = ACTIONS(57),
    [anon_sym_function] = ACTIONS(59),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(59),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_QMARK] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(57),
    [sym__number_literal] = ACTIONS(59),
    [anon_sym_SQUOTE] = ACTIONS(57),
    [anon_sym_DQUOTE] = ACTIONS(57),
    [sym_dots] = ACTIONS(59),
    [sym_dot_dot_i] = ACTIONS(59),
    [sym_return] = ACTIONS(59),
    [sym_next] = ACTIONS(59),
    [sym_break] = ACTIONS(59),
    [sym_true] = ACTIONS(59),
    [sym_false] = ACTIONS(59),
    [sym_null] = ACTIONS(59),
    [sym_inf] = ACTIONS(59),
    [sym_nan] = ACTIONS(59),
    [anon_sym_NA] = ACTIONS(59),
    [anon_sym_NA_integer_] = ACTIONS(59),
    [anon_sym_NA_real_] = ACTIONS(59),
    [anon_sym_NA_complex_] = ACTIONS(59),
    [anon_sym_NA_character_] = ACTIONS(59),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(57),
    [sym__semicolon] = ACTIONS(57),
    [sym__raw_string_literal] = ACTIONS(57),
    [sym__external_else] = ACTIONS(141),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(57),
    [sym__external_close_brace] = ACTIONS(57),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [18] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(143),
    [anon_sym_BSLASH] = ACTIONS(145),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_repeat] = ACTIONS(143),
    [anon_sym_QMARK] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(143),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(145),
    [sym__number_literal] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [anon_sym_DQUOTE] = ACTIONS(145),
    [sym_dots] = ACTIONS(143),
    [sym_dot_dot_i] = ACTIONS(143),
    [sym_return] = ACTIONS(143),
    [sym_next] = ACTIONS(143),
    [sym_break] = ACTIONS(143),
    [sym_true] = ACTIONS(143),
    [sym_false] = ACTIONS(143),
    [sym_null] = ACTIONS(143),
    [sym_inf] = ACTIONS(143),
    [sym_nan] = ACTIONS(143),
    [anon_sym_NA] = ACTIONS(143),
    [anon_sym_NA_integer_] = ACTIONS(143),
    [anon_sym_NA_real_] = ACTIONS(143),
    [anon_sym_NA_complex_] = ACTIONS(143),
    [anon_sym_NA_character_] = ACTIONS(143),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(145),
    [sym__semicolon] = ACTIONS(145),
    [sym__raw_string_literal] = ACTIONS(145),
    [sym__external_else] = ACTIONS(145),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(145),
    [sym__external_close_brace] = ACTIONS(145),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [19] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(147),
    [sym_identifier] = ACTIONS(149),
    [anon_sym_BSLASH] = ACTIONS(147),
    [anon_sym_function] = ACTIONS(149),
    [anon_sym_EQ] = ACTIONS(149),
    [anon_sym_if] = ACTIONS(149),
    [anon_sym_for] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(149),
    [anon_sym_repeat] = ACTIONS(149),
    [anon_sym_QMARK] = ACTIONS(147),
    [anon_sym_TILDE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(147),
    [anon_sym_LT_LT_DASH] = ACTIONS(147),
    [anon_sym_COLON_EQ] = ACTIONS(147),
    [anon_sym_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_GT] = ACTIONS(147),
    [anon_sym_PIPE] = ACTIONS(149),
    [anon_sym_AMP] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(147),
    [anon_sym_AMP_AMP] = ACTIONS(147),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(147),
    [sym__number_literal] = ACTIONS(149),
    [anon_sym_SQUOTE] = ACTIONS(147),
    [anon_sym_DQUOTE] = ACTIONS(147),
    [sym_dots] = ACTIONS(149),
    [sym_dot_dot_i] = ACTIONS(149),
    [sym_return] = ACTIONS(149),
    [sym_next] = ACTIONS(149),
    [sym_break] = ACTIONS(149),
    [sym_true] = ACTIONS(149),
    [sym_false] = ACTIONS(149),
    [sym_null] = ACTIONS(149),
    [sym_inf] = ACTIONS(149),
    [sym_nan] = ACTIONS(149),
    [anon_sym_NA] = ACTIONS(149),
    [anon_sym_NA_integer_] = ACTIONS(149),
    [anon_sym_NA_real_] = ACTIONS(149),
    [anon_sym_NA_complex_] = ACTIONS(149),
    [anon_sym_NA_character_] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(147),
    [sym__semicolon] = ACTIONS(147),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(147),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(147),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [20] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(147),
    [sym_identifier] = ACTIONS(149),
    [anon_sym_BSLASH] = ACTIONS(147),
    [anon_sym_function] = ACTIONS(149),
    [anon_sym_EQ] = ACTIONS(149),
    [anon_sym_if] = ACTIONS(149),
    [anon_sym_for] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(149),
    [anon_sym_repeat] = ACTIONS(149),
    [anon_sym_QMARK] = ACTIONS(147),
    [anon_sym_TILDE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_PLUS] = ACTIONS(147),
    [anon_sym_DASH] = ACTIONS(149),
    [anon_sym_LT_DASH] = ACTIONS(147),
    [anon_sym_LT_LT_DASH] = ACTIONS(147),
    [anon_sym_COLON_EQ] = ACTIONS(147),
    [anon_sym_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_GT] = ACTIONS(147),
    [anon_sym_PIPE] = ACTIONS(149),
    [anon_sym_AMP] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(147),
    [anon_sym_AMP_AMP] = ACTIONS(147),
    [anon_sym_LT] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(147),
    [anon_sym_GT] = ACTIONS(149),
    [anon_sym_GT_EQ] = ACTIONS(147),
    [anon_sym_EQ_EQ] = ACTIONS(147),
    [anon_sym_BANG_EQ] = ACTIONS(147),
    [anon_sym_STAR] = ACTIONS(149),
    [anon_sym_SLASH] = ACTIONS(147),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(147),
    [anon_sym_PIPE_GT] = ACTIONS(147),
    [anon_sym_COLON] = ACTIONS(149),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(147),
    [sym__number_literal] = ACTIONS(149),
    [anon_sym_SQUOTE] = ACTIONS(147),
    [anon_sym_DQUOTE] = ACTIONS(147),
    [sym_dots] = ACTIONS(149),
    [sym_dot_dot_i] = ACTIONS(149),
    [sym_return] = ACTIONS(149),
    [sym_next] = ACTIONS(149),
    [sym_break] = ACTIONS(149),
    [sym_true] = ACTIONS(149),
    [sym_false] = ACTIONS(149),
    [sym_null] = ACTIONS(149),
    [sym_inf] = ACTIONS(149),
    [sym_nan] = ACTIONS(149),
    [anon_sym_NA] = ACTIONS(149),
    [anon_sym_NA_integer_] = ACTIONS(149),
    [anon_sym_NA_real_] = ACTIONS(149),
    [anon_sym_NA_complex_] = ACTIONS(149),
    [anon_sym_NA_character_] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(147),
    [sym__semicolon] = ACTIONS(147),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(147),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(147),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [21] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [22] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [23] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [24] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [25] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [26] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [27] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [28] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [29] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [30] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(151),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [31] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(151),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(151),
    [anon_sym_PIPE_GT] = ACTIONS(151),
    [anon_sym_COLON] = ACTIONS(153),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [32] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(151),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(151),
    [anon_sym_PIPE_GT] = ACTIONS(151),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [33] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(151),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(151),
    [anon_sym_PIPE_GT] = ACTIONS(151),
    [anon_sym_COLON] = ACTIONS(153),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [34] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(155),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_BSLASH] = ACTIONS(155),
    [anon_sym_function] = ACTIONS(157),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(157),
    [anon_sym_repeat] = ACTIONS(157),
    [anon_sym_QMARK] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(155),
    [sym__number_literal] = ACTIONS(157),
    [anon_sym_SQUOTE] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(155),
    [sym_dots] = ACTIONS(157),
    [sym_dot_dot_i] = ACTIONS(157),
    [sym_return] = ACTIONS(157),
    [sym_next] = ACTIONS(157),
    [sym_break] = ACTIONS(157),
    [sym_true] = ACTIONS(157),
    [sym_false] = ACTIONS(157),
    [sym_null] = ACTIONS(157),
    [sym_inf] = ACTIONS(157),
    [sym_nan] = ACTIONS(157),
    [anon_sym_NA] = ACTIONS(157),
    [anon_sym_NA_integer_] = ACTIONS(157),
    [anon_sym_NA_real_] = ACTIONS(157),
    [anon_sym_NA_complex_] = ACTIONS(157),
    [anon_sym_NA_character_] = ACTIONS(157),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(155),
    [sym__semicolon] = ACTIONS(155),
    [sym__raw_string_literal] = ACTIONS(155),
    [sym__external_else] = ACTIONS(155),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(155),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [35] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(159),
    [sym_identifier] = ACTIONS(161),
    [anon_sym_BSLASH] = ACTIONS(159),
    [anon_sym_function] = ACTIONS(161),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_while] = ACTIONS(161),
    [anon_sym_repeat] = ACTIONS(161),
    [anon_sym_QMARK] = ACTIONS(159),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(159),
    [sym__number_literal] = ACTIONS(161),
    [anon_sym_SQUOTE] = ACTIONS(159),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [sym_dots] = ACTIONS(161),
    [sym_dot_dot_i] = ACTIONS(161),
    [sym_return] = ACTIONS(161),
    [sym_next] = ACTIONS(161),
    [sym_break] = ACTIONS(161),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [sym_null] = ACTIONS(161),
    [sym_inf] = ACTIONS(161),
    [sym_nan] = ACTIONS(161),
    [anon_sym_NA] = ACTIONS(161),
    [anon_sym_NA_integer_] = ACTIONS(161),
    [anon_sym_NA_real_] = ACTIONS(161),
    [anon_sym_NA_complex_] = ACTIONS(161),
    [anon_sym_NA_character_] = ACTIONS(161),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(159),
    [sym__semicolon] = ACTIONS(159),
    [sym__raw_string_literal] = ACTIONS(159),
    [sym__external_else] = ACTIONS(159),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(159),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [36] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [37] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [38] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [39] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(165),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(165),
    [anon_sym_LT_EQ] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(165),
    [anon_sym_GT_EQ] = ACTIONS(163),
    [anon_sym_EQ_EQ] = ACTIONS(163),
    [anon_sym_BANG_EQ] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [40] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [41] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [42] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [43] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [44] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(165),
    [anon_sym_LT_EQ] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(165),
    [anon_sym_GT_EQ] = ACTIONS(163),
    [anon_sym_EQ_EQ] = ACTIONS(163),
    [anon_sym_BANG_EQ] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [45] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(165),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(165),
    [anon_sym_LT_EQ] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(165),
    [anon_sym_GT_EQ] = ACTIONS(163),
    [anon_sym_EQ_EQ] = ACTIONS(163),
    [anon_sym_BANG_EQ] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(165),
    [anon_sym_SLASH] = ACTIONS(163),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [46] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(165),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(165),
    [anon_sym_LT_EQ] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(165),
    [anon_sym_GT_EQ] = ACTIONS(163),
    [anon_sym_EQ_EQ] = ACTIONS(163),
    [anon_sym_BANG_EQ] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(165),
    [anon_sym_SLASH] = ACTIONS(163),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(163),
    [anon_sym_PIPE_GT] = ACTIONS(163),
    [anon_sym_COLON] = ACTIONS(165),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [47] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(165),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(165),
    [anon_sym_LT_EQ] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(165),
    [anon_sym_GT_EQ] = ACTIONS(163),
    [anon_sym_EQ_EQ] = ACTIONS(163),
    [anon_sym_BANG_EQ] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(165),
    [anon_sym_SLASH] = ACTIONS(163),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(163),
    [anon_sym_PIPE_GT] = ACTIONS(163),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [48] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(165),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(165),
    [anon_sym_LT_EQ] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(165),
    [anon_sym_GT_EQ] = ACTIONS(163),
    [anon_sym_EQ_EQ] = ACTIONS(163),
    [anon_sym_BANG_EQ] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(165),
    [anon_sym_SLASH] = ACTIONS(163),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(163),
    [anon_sym_PIPE_GT] = ACTIONS(163),
    [anon_sym_COLON] = ACTIONS(165),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [49] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(167),
    [sym_identifier] = ACTIONS(169),
    [anon_sym_BSLASH] = ACTIONS(167),
    [anon_sym_function] = ACTIONS(169),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_repeat] = ACTIONS(169),
    [anon_sym_QMARK] = ACTIONS(167),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(169),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(167),
    [sym__number_literal] = ACTIONS(169),
    [anon_sym_SQUOTE] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(167),
    [sym_dots] = ACTIONS(169),
    [sym_dot_dot_i] = ACTIONS(169),
    [sym_return] = ACTIONS(169),
    [sym_next] = ACTIONS(169),
    [sym_break] = ACTIONS(169),
    [sym_true] = ACTIONS(169),
    [sym_false] = ACTIONS(169),
    [sym_null] = ACTIONS(169),
    [sym_inf] = ACTIONS(169),
    [sym_nan] = ACTIONS(169),
    [anon_sym_NA] = ACTIONS(169),
    [anon_sym_NA_integer_] = ACTIONS(169),
    [anon_sym_NA_real_] = ACTIONS(169),
    [anon_sym_NA_complex_] = ACTIONS(169),
    [anon_sym_NA_character_] = ACTIONS(169),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(167),
    [sym__semicolon] = ACTIONS(167),
    [sym__raw_string_literal] = ACTIONS(167),
    [sym__external_else] = ACTIONS(167),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(167),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [50] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(171),
    [sym_identifier] = ACTIONS(173),
    [anon_sym_BSLASH] = ACTIONS(171),
    [anon_sym_function] = ACTIONS(173),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_while] = ACTIONS(173),
    [anon_sym_repeat] = ACTIONS(173),
    [anon_sym_QMARK] = ACTIONS(171),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(173),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(171),
    [sym__number_literal] = ACTIONS(173),
    [anon_sym_SQUOTE] = ACTIONS(171),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [sym_dots] = ACTIONS(173),
    [sym_dot_dot_i] = ACTIONS(173),
    [sym_return] = ACTIONS(173),
    [sym_next] = ACTIONS(173),
    [sym_break] = ACTIONS(173),
    [sym_true] = ACTIONS(173),
    [sym_false] = ACTIONS(173),
    [sym_null] = ACTIONS(173),
    [sym_inf] = ACTIONS(173),
    [sym_nan] = ACTIONS(173),
    [anon_sym_NA] = ACTIONS(173),
    [anon_sym_NA_integer_] = ACTIONS(173),
    [anon_sym_NA_real_] = ACTIONS(173),
    [anon_sym_NA_complex_] = ACTIONS(173),
    [anon_sym_NA_character_] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(171),
    [sym__semicolon] = ACTIONS(171),
    [sym__raw_string_literal] = ACTIONS(171),
    [sym__external_else] = ACTIONS(171),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(171),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [51] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(175),
    [sym_identifier] = ACTIONS(177),
    [anon_sym_BSLASH] = ACTIONS(175),
    [anon_sym_function] = ACTIONS(177),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(177),
    [anon_sym_for] = ACTIONS(177),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_repeat] = ACTIONS(177),
    [anon_sym_QMARK] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(177),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(175),
    [sym__number_literal] = ACTIONS(177),
    [anon_sym_SQUOTE] = ACTIONS(175),
    [anon_sym_DQUOTE] = ACTIONS(175),
    [sym_dots] = ACTIONS(177),
    [sym_dot_dot_i] = ACTIONS(177),
    [sym_return] = ACTIONS(177),
    [sym_next] = ACTIONS(177),
    [sym_break] = ACTIONS(177),
    [sym_true] = ACTIONS(177),
    [sym_false] = ACTIONS(177),
    [sym_null] = ACTIONS(177),
    [sym_inf] = ACTIONS(177),
    [sym_nan] = ACTIONS(177),
    [anon_sym_NA] = ACTIONS(177),
    [anon_sym_NA_integer_] = ACTIONS(177),
    [anon_sym_NA_real_] = ACTIONS(177),
    [anon_sym_NA_complex_] = ACTIONS(177),
    [anon_sym_NA_character_] = ACTIONS(177),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(175),
    [sym__semicolon] = ACTIONS(175),
    [sym__raw_string_literal] = ACTIONS(175),
    [sym__external_else] = ACTIONS(175),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(175),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [52] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(179),
    [sym_identifier] = ACTIONS(181),
    [anon_sym_BSLASH] = ACTIONS(179),
    [anon_sym_function] = ACTIONS(181),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(181),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_repeat] = ACTIONS(181),
    [anon_sym_QMARK] = ACTIONS(179),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(181),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(179),
    [sym__number_literal] = ACTIONS(181),
    [anon_sym_SQUOTE] = ACTIONS(179),
    [anon_sym_DQUOTE] = ACTIONS(179),
    [sym_dots] = ACTIONS(181),
    [sym_dot_dot_i] = ACTIONS(181),
    [sym_return] = ACTIONS(181),
    [sym_next] = ACTIONS(181),
    [sym_break] = ACTIONS(181),
    [sym_true] = ACTIONS(181),
    [sym_false] = ACTIONS(181),
    [sym_null] = ACTIONS(181),
    [sym_inf] = ACTIONS(181),
    [sym_nan] = ACTIONS(181),
    [anon_sym_NA] = ACTIONS(181),
    [anon_sym_NA_integer_] = ACTIONS(181),
    [anon_sym_NA_real_] = ACTIONS(181),
    [anon_sym_NA_complex_] = ACTIONS(181),
    [anon_sym_NA_character_] = ACTIONS(181),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(179),
    [sym__semicolon] = ACTIONS(179),
    [sym__raw_string_literal] = ACTIONS(179),
    [sym__external_else] = ACTIONS(179),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(179),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [53] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(183),
    [sym_identifier] = ACTIONS(185),
    [anon_sym_BSLASH] = ACTIONS(183),
    [anon_sym_function] = ACTIONS(185),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(185),
    [anon_sym_for] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(185),
    [anon_sym_repeat] = ACTIONS(185),
    [anon_sym_QMARK] = ACTIONS(183),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(185),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(183),
    [sym__number_literal] = ACTIONS(185),
    [anon_sym_SQUOTE] = ACTIONS(183),
    [anon_sym_DQUOTE] = ACTIONS(183),
    [sym_dots] = ACTIONS(185),
    [sym_dot_dot_i] = ACTIONS(185),
    [sym_return] = ACTIONS(185),
    [sym_next] = ACTIONS(185),
    [sym_break] = ACTIONS(185),
    [sym_true] = ACTIONS(185),
    [sym_false] = ACTIONS(185),
    [sym_null] = ACTIONS(185),
    [sym_inf] = ACTIONS(185),
    [sym_nan] = ACTIONS(185),
    [anon_sym_NA] = ACTIONS(185),
    [anon_sym_NA_integer_] = ACTIONS(185),
    [anon_sym_NA_real_] = ACTIONS(185),
    [anon_sym_NA_complex_] = ACTIONS(185),
    [anon_sym_NA_character_] = ACTIONS(185),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(183),
    [sym__semicolon] = ACTIONS(183),
    [sym__raw_string_literal] = ACTIONS(183),
    [sym__external_else] = ACTIONS(183),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(183),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [54] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(187),
    [sym_identifier] = ACTIONS(189),
    [anon_sym_BSLASH] = ACTIONS(187),
    [anon_sym_function] = ACTIONS(189),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(189),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(189),
    [anon_sym_repeat] = ACTIONS(189),
    [anon_sym_QMARK] = ACTIONS(187),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(189),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(187),
    [sym__number_literal] = ACTIONS(189),
    [anon_sym_SQUOTE] = ACTIONS(187),
    [anon_sym_DQUOTE] = ACTIONS(187),
    [sym_dots] = ACTIONS(189),
    [sym_dot_dot_i] = ACTIONS(189),
    [sym_return] = ACTIONS(189),
    [sym_next] = ACTIONS(189),
    [sym_break] = ACTIONS(189),
    [sym_true] = ACTIONS(189),
    [sym_false] = ACTIONS(189),
    [sym_null] = ACTIONS(189),
    [sym_inf] = ACTIONS(189),
    [sym_nan] = ACTIONS(189),
    [anon_sym_NA] = ACTIONS(189),
    [anon_sym_NA_integer_] = ACTIONS(189),
    [anon_sym_NA_real_] = ACTIONS(189),
    [anon_sym_NA_complex_] = ACTIONS(189),
    [anon_sym_NA_character_] = ACTIONS(189),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(187),
    [sym__semicolon] = ACTIONS(187),
    [sym__raw_string_literal] = ACTIONS(187),
    [sym__external_else] = ACTIONS(187),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(187),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [55] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(191),
    [sym_identifier] = ACTIONS(193),
    [anon_sym_BSLASH] = ACTIONS(191),
    [anon_sym_function] = ACTIONS(193),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(193),
    [anon_sym_for] = ACTIONS(193),
    [anon_sym_while] = ACTIONS(193),
    [anon_sym_repeat] = ACTIONS(193),
    [anon_sym_QMARK] = ACTIONS(191),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(193),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(191),
    [sym__number_literal] = ACTIONS(193),
    [anon_sym_SQUOTE] = ACTIONS(191),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_dots] = ACTIONS(193),
    [sym_dot_dot_i] = ACTIONS(193),
    [sym_return] = ACTIONS(193),
    [sym_next] = ACTIONS(193),
    [sym_break] = ACTIONS(193),
    [sym_true] = ACTIONS(193),
    [sym_false] = ACTIONS(193),
    [sym_null] = ACTIONS(193),
    [sym_inf] = ACTIONS(193),
    [sym_nan] = ACTIONS(193),
    [anon_sym_NA] = ACTIONS(193),
    [anon_sym_NA_integer_] = ACTIONS(193),
    [anon_sym_NA_real_] = ACTIONS(193),
    [anon_sym_NA_complex_] = ACTIONS(193),
    [anon_sym_NA_character_] = ACTIONS(193),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(191),
    [sym__semicolon] = ACTIONS(191),
    [sym__raw_string_literal] = ACTIONS(191),
    [sym__external_else] = ACTIONS(191),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(191),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [56] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(195),
    [sym_identifier] = ACTIONS(197),
    [anon_sym_BSLASH] = ACTIONS(195),
    [anon_sym_function] = ACTIONS(197),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_for] = ACTIONS(197),
    [anon_sym_while] = ACTIONS(197),
    [anon_sym_repeat] = ACTIONS(197),
    [anon_sym_QMARK] = ACTIONS(195),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(197),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(195),
    [sym__number_literal] = ACTIONS(197),
    [anon_sym_SQUOTE] = ACTIONS(195),
    [anon_sym_DQUOTE] = ACTIONS(195),
    [sym_dots] = ACTIONS(197),
    [sym_dot_dot_i] = ACTIONS(197),
    [sym_return] = ACTIONS(197),
    [sym_next] = ACTIONS(197),
    [sym_break] = ACTIONS(197),
    [sym_true] = ACTIONS(197),
    [sym_false] = ACTIONS(197),
    [sym_null] = ACTIONS(197),
    [sym_inf] = ACTIONS(197),
    [sym_nan] = ACTIONS(197),
    [anon_sym_NA] = ACTIONS(197),
    [anon_sym_NA_integer_] = ACTIONS(197),
    [anon_sym_NA_real_] = ACTIONS(197),
    [anon_sym_NA_complex_] = ACTIONS(197),
    [anon_sym_NA_character_] = ACTIONS(197),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(195),
    [sym__semicolon] = ACTIONS(195),
    [sym__raw_string_literal] = ACTIONS(195),
    [sym__external_else] = ACTIONS(195),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(195),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [57] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(199),
    [sym_identifier] = ACTIONS(201),
    [anon_sym_BSLASH] = ACTIONS(199),
    [anon_sym_function] = ACTIONS(201),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(201),
    [anon_sym_for] = ACTIONS(201),
    [anon_sym_while] = ACTIONS(201),
    [anon_sym_repeat] = ACTIONS(201),
    [anon_sym_QMARK] = ACTIONS(199),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(199),
    [sym__number_literal] = ACTIONS(201),
    [anon_sym_SQUOTE] = ACTIONS(199),
    [anon_sym_DQUOTE] = ACTIONS(199),
    [sym_dots] = ACTIONS(201),
    [sym_dot_dot_i] = ACTIONS(201),
    [sym_return] = ACTIONS(201),
    [sym_next] = ACTIONS(201),
    [sym_break] = ACTIONS(201),
    [sym_true] = ACTIONS(201),
    [sym_false] = ACTIONS(201),
    [sym_null] = ACTIONS(201),
    [sym_inf] = ACTIONS(201),
    [sym_nan] = ACTIONS(201),
    [anon_sym_NA] = ACTIONS(201),
    [anon_sym_NA_integer_] = ACTIONS(201),
    [anon_sym_NA_real_] = ACTIONS(201),
    [anon_sym_NA_complex_] = ACTIONS(201),
    [anon_sym_NA_character_] = ACTIONS(201),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(199),
    [sym__semicolon] = ACTIONS(199),
    [sym__raw_string_literal] = ACTIONS(199),
    [sym__external_else] = ACTIONS(199),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(199),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [58] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(203),
    [sym_identifier] = ACTIONS(205),
    [anon_sym_BSLASH] = ACTIONS(203),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(205),
    [anon_sym_while] = ACTIONS(205),
    [anon_sym_repeat] = ACTIONS(205),
    [anon_sym_QMARK] = ACTIONS(203),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(205),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(203),
    [sym__number_literal] = ACTIONS(205),
    [anon_sym_SQUOTE] = ACTIONS(203),
    [anon_sym_DQUOTE] = ACTIONS(203),
    [sym_dots] = ACTIONS(205),
    [sym_dot_dot_i] = ACTIONS(205),
    [sym_return] = ACTIONS(205),
    [sym_next] = ACTIONS(205),
    [sym_break] = ACTIONS(205),
    [sym_true] = ACTIONS(205),
    [sym_false] = ACTIONS(205),
    [sym_null] = ACTIONS(205),
    [sym_inf] = ACTIONS(205),
    [sym_nan] = ACTIONS(205),
    [anon_sym_NA] = ACTIONS(205),
    [anon_sym_NA_integer_] = ACTIONS(205),
    [anon_sym_NA_real_] = ACTIONS(205),
    [anon_sym_NA_complex_] = ACTIONS(205),
    [anon_sym_NA_character_] = ACTIONS(205),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(203),
    [sym__semicolon] = ACTIONS(203),
    [sym__raw_string_literal] = ACTIONS(203),
    [sym__external_else] = ACTIONS(203),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(203),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [59] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(207),
    [sym_identifier] = ACTIONS(209),
    [anon_sym_BSLASH] = ACTIONS(207),
    [anon_sym_function] = ACTIONS(209),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(209),
    [anon_sym_for] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(209),
    [anon_sym_repeat] = ACTIONS(209),
    [anon_sym_QMARK] = ACTIONS(207),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(207),
    [sym__number_literal] = ACTIONS(209),
    [anon_sym_SQUOTE] = ACTIONS(207),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [sym_dots] = ACTIONS(209),
    [sym_dot_dot_i] = ACTIONS(209),
    [sym_return] = ACTIONS(209),
    [sym_next] = ACTIONS(209),
    [sym_break] = ACTIONS(209),
    [sym_true] = ACTIONS(209),
    [sym_false] = ACTIONS(209),
    [sym_null] = ACTIONS(209),
    [sym_inf] = ACTIONS(209),
    [sym_nan] = ACTIONS(209),
    [anon_sym_NA] = ACTIONS(209),
    [anon_sym_NA_integer_] = ACTIONS(209),
    [anon_sym_NA_real_] = ACTIONS(209),
    [anon_sym_NA_complex_] = ACTIONS(209),
    [anon_sym_NA_character_] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(207),
    [sym__semicolon] = ACTIONS(207),
    [sym__raw_string_literal] = ACTIONS(207),
    [sym__external_else] = ACTIONS(207),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [60] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(211),
    [sym_identifier] = ACTIONS(213),
    [anon_sym_BSLASH] = ACTIONS(211),
    [anon_sym_function] = ACTIONS(213),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(213),
    [anon_sym_while] = ACTIONS(213),
    [anon_sym_repeat] = ACTIONS(213),
    [anon_sym_QMARK] = ACTIONS(211),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(211),
    [sym__number_literal] = ACTIONS(213),
    [anon_sym_SQUOTE] = ACTIONS(211),
    [anon_sym_DQUOTE] = ACTIONS(211),
    [sym_dots] = ACTIONS(213),
    [sym_dot_dot_i] = ACTIONS(213),
    [sym_return] = ACTIONS(213),
    [sym_next] = ACTIONS(213),
    [sym_break] = ACTIONS(213),
    [sym_true] = ACTIONS(213),
    [sym_false] = ACTIONS(213),
    [sym_null] = ACTIONS(213),
    [sym_inf] = ACTIONS(213),
    [sym_nan] = ACTIONS(213),
    [anon_sym_NA] = ACTIONS(213),
    [anon_sym_NA_integer_] = ACTIONS(213),
    [anon_sym_NA_real_] = ACTIONS(213),
    [anon_sym_NA_complex_] = ACTIONS(213),
    [anon_sym_NA_character_] = ACTIONS(213),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(211),
    [sym__semicolon] = ACTIONS(211),
    [sym__raw_string_literal] = ACTIONS(211),
    [sym__external_else] = ACTIONS(211),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(211),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [61] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(215),
    [sym_identifier] = ACTIONS(217),
    [anon_sym_BSLASH] = ACTIONS(215),
    [anon_sym_function] = ACTIONS(217),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(217),
    [anon_sym_for] = ACTIONS(217),
    [anon_sym_while] = ACTIONS(217),
    [anon_sym_repeat] = ACTIONS(217),
    [anon_sym_QMARK] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(217),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(215),
    [sym__number_literal] = ACTIONS(217),
    [anon_sym_SQUOTE] = ACTIONS(215),
    [anon_sym_DQUOTE] = ACTIONS(215),
    [sym_dots] = ACTIONS(217),
    [sym_dot_dot_i] = ACTIONS(217),
    [sym_return] = ACTIONS(217),
    [sym_next] = ACTIONS(217),
    [sym_break] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_inf] = ACTIONS(217),
    [sym_nan] = ACTIONS(217),
    [anon_sym_NA] = ACTIONS(217),
    [anon_sym_NA_integer_] = ACTIONS(217),
    [anon_sym_NA_real_] = ACTIONS(217),
    [anon_sym_NA_complex_] = ACTIONS(217),
    [anon_sym_NA_character_] = ACTIONS(217),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(215),
    [sym__semicolon] = ACTIONS(215),
    [sym__raw_string_literal] = ACTIONS(215),
    [sym__external_else] = ACTIONS(215),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(215),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [62] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(219),
    [sym_identifier] = ACTIONS(221),
    [anon_sym_BSLASH] = ACTIONS(219),
    [anon_sym_function] = ACTIONS(221),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(221),
    [anon_sym_for] = ACTIONS(221),
    [anon_sym_while] = ACTIONS(221),
    [anon_sym_repeat] = ACTIONS(221),
    [anon_sym_QMARK] = ACTIONS(219),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(219),
    [sym__number_literal] = ACTIONS(221),
    [anon_sym_SQUOTE] = ACTIONS(219),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_dots] = ACTIONS(221),
    [sym_dot_dot_i] = ACTIONS(221),
    [sym_return] = ACTIONS(221),
    [sym_next] = ACTIONS(221),
    [sym_break] = ACTIONS(221),
    [sym_true] = ACTIONS(221),
    [sym_false] = ACTIONS(221),
    [sym_null] = ACTIONS(221),
    [sym_inf] = ACTIONS(221),
    [sym_nan] = ACTIONS(221),
    [anon_sym_NA] = ACTIONS(221),
    [anon_sym_NA_integer_] = ACTIONS(221),
    [anon_sym_NA_real_] = ACTIONS(221),
    [anon_sym_NA_complex_] = ACTIONS(221),
    [anon_sym_NA_character_] = ACTIONS(221),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(219),
    [sym__semicolon] = ACTIONS(219),
    [sym__raw_string_literal] = ACTIONS(219),
    [sym__external_else] = ACTIONS(219),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(219),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [63] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(145),
    [sym_identifier] = ACTIONS(143),
    [anon_sym_BSLASH] = ACTIONS(145),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_repeat] = ACTIONS(143),
    [anon_sym_QMARK] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(143),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(145),
    [sym__number_literal] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [anon_sym_DQUOTE] = ACTIONS(145),
    [sym_dots] = ACTIONS(143),
    [sym_dot_dot_i] = ACTIONS(143),
    [sym_return] = ACTIONS(143),
    [sym_next] = ACTIONS(143),
    [sym_break] = ACTIONS(143),
    [sym_true] = ACTIONS(143),
    [sym_false] = ACTIONS(143),
    [sym_null] = ACTIONS(143),
    [sym_inf] = ACTIONS(143),
    [sym_nan] = ACTIONS(143),
    [anon_sym_NA] = ACTIONS(143),
    [anon_sym_NA_integer_] = ACTIONS(143),
    [anon_sym_NA_real_] = ACTIONS(143),
    [anon_sym_NA_complex_] = ACTIONS(143),
    [anon_sym_NA_character_] = ACTIONS(143),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(145),
    [sym__semicolon] = ACTIONS(145),
    [sym__raw_string_literal] = ACTIONS(145),
    [sym__external_else] = ACTIONS(145),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(145),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [64] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(223),
    [sym_identifier] = ACTIONS(225),
    [anon_sym_BSLASH] = ACTIONS(223),
    [anon_sym_function] = ACTIONS(225),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(225),
    [anon_sym_for] = ACTIONS(225),
    [anon_sym_while] = ACTIONS(225),
    [anon_sym_repeat] = ACTIONS(225),
    [anon_sym_QMARK] = ACTIONS(223),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(223),
    [sym__number_literal] = ACTIONS(225),
    [anon_sym_SQUOTE] = ACTIONS(223),
    [anon_sym_DQUOTE] = ACTIONS(223),
    [sym_dots] = ACTIONS(225),
    [sym_dot_dot_i] = ACTIONS(225),
    [sym_return] = ACTIONS(225),
    [sym_next] = ACTIONS(225),
    [sym_break] = ACTIONS(225),
    [sym_true] = ACTIONS(225),
    [sym_false] = ACTIONS(225),
    [sym_null] = ACTIONS(225),
    [sym_inf] = ACTIONS(225),
    [sym_nan] = ACTIONS(225),
    [anon_sym_NA] = ACTIONS(225),
    [anon_sym_NA_integer_] = ACTIONS(225),
    [anon_sym_NA_real_] = ACTIONS(225),
    [anon_sym_NA_complex_] = ACTIONS(225),
    [anon_sym_NA_character_] = ACTIONS(225),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(223),
    [sym__semicolon] = ACTIONS(223),
    [sym__raw_string_literal] = ACTIONS(223),
    [sym__external_else] = ACTIONS(223),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(223),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [65] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(227),
    [sym_identifier] = ACTIONS(229),
    [anon_sym_BSLASH] = ACTIONS(227),
    [anon_sym_function] = ACTIONS(229),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(229),
    [anon_sym_for] = ACTIONS(229),
    [anon_sym_while] = ACTIONS(229),
    [anon_sym_repeat] = ACTIONS(229),
    [anon_sym_QMARK] = ACTIONS(227),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(229),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(227),
    [sym__number_literal] = ACTIONS(229),
    [anon_sym_SQUOTE] = ACTIONS(227),
    [anon_sym_DQUOTE] = ACTIONS(227),
    [sym_dots] = ACTIONS(229),
    [sym_dot_dot_i] = ACTIONS(229),
    [sym_return] = ACTIONS(229),
    [sym_next] = ACTIONS(229),
    [sym_break] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_inf] = ACTIONS(229),
    [sym_nan] = ACTIONS(229),
    [anon_sym_NA] = ACTIONS(229),
    [anon_sym_NA_integer_] = ACTIONS(229),
    [anon_sym_NA_real_] = ACTIONS(229),
    [anon_sym_NA_complex_] = ACTIONS(229),
    [anon_sym_NA_character_] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(227),
    [sym__semicolon] = ACTIONS(227),
    [sym__raw_string_literal] = ACTIONS(227),
    [sym__external_else] = ACTIONS(227),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(227),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [66] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(231),
    [anon_sym_BSLASH] = ACTIONS(233),
    [anon_sym_function] = ACTIONS(231),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(231),
    [anon_sym_for] = ACTIONS(231),
    [anon_sym_while] = ACTIONS(231),
    [anon_sym_repeat] = ACTIONS(231),
    [anon_sym_QMARK] = ACTIONS(233),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(231),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(233),
    [sym__number_literal] = ACTIONS(231),
    [anon_sym_SQUOTE] = ACTIONS(233),
    [anon_sym_DQUOTE] = ACTIONS(233),
    [sym_dots] = ACTIONS(231),
    [sym_dot_dot_i] = ACTIONS(231),
    [sym_return] = ACTIONS(231),
    [sym_next] = ACTIONS(231),
    [sym_break] = ACTIONS(231),
    [sym_true] = ACTIONS(231),
    [sym_false] = ACTIONS(231),
    [sym_null] = ACTIONS(231),
    [sym_inf] = ACTIONS(231),
    [sym_nan] = ACTIONS(231),
    [anon_sym_NA] = ACTIONS(231),
    [anon_sym_NA_integer_] = ACTIONS(231),
    [anon_sym_NA_real_] = ACTIONS(231),
    [anon_sym_NA_complex_] = ACTIONS(231),
    [anon_sym_NA_character_] = ACTIONS(231),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(233),
    [sym__semicolon] = ACTIONS(233),
    [sym__raw_string_literal] = ACTIONS(233),
    [sym__external_else] = ACTIONS(233),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(233),
    [sym__external_close_brace] = ACTIONS(233),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [67] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(235),
    [anon_sym_BSLASH] = ACTIONS(237),
    [anon_sym_function] = ACTIONS(235),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(235),
    [anon_sym_for] = ACTIONS(235),
    [anon_sym_while] = ACTIONS(235),
    [anon_sym_repeat] = ACTIONS(235),
    [anon_sym_QMARK] = ACTIONS(237),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(235),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(237),
    [sym__number_literal] = ACTIONS(235),
    [anon_sym_SQUOTE] = ACTIONS(237),
    [anon_sym_DQUOTE] = ACTIONS(237),
    [sym_dots] = ACTIONS(235),
    [sym_dot_dot_i] = ACTIONS(235),
    [sym_return] = ACTIONS(235),
    [sym_next] = ACTIONS(235),
    [sym_break] = ACTIONS(235),
    [sym_true] = ACTIONS(235),
    [sym_false] = ACTIONS(235),
    [sym_null] = ACTIONS(235),
    [sym_inf] = ACTIONS(235),
    [sym_nan] = ACTIONS(235),
    [anon_sym_NA] = ACTIONS(235),
    [anon_sym_NA_integer_] = ACTIONS(235),
    [anon_sym_NA_real_] = ACTIONS(235),
    [anon_sym_NA_complex_] = ACTIONS(235),
    [anon_sym_NA_character_] = ACTIONS(235),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(237),
    [sym__semicolon] = ACTIONS(237),
    [sym__raw_string_literal] = ACTIONS(237),
    [sym__external_else] = ACTIONS(237),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(237),
    [sym__external_close_brace] = ACTIONS(237),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [68] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(235),
    [anon_sym_BSLASH] = ACTIONS(237),
    [anon_sym_function] = ACTIONS(235),
    [anon_sym_EQ] = ACTIONS(235),
    [anon_sym_if] = ACTIONS(235),
    [anon_sym_for] = ACTIONS(235),
    [anon_sym_while] = ACTIONS(235),
    [anon_sym_repeat] = ACTIONS(235),
    [anon_sym_QMARK] = ACTIONS(237),
    [anon_sym_TILDE] = ACTIONS(237),
    [anon_sym_BANG] = ACTIONS(235),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(237),
    [anon_sym_LT_LT_DASH] = ACTIONS(237),
    [anon_sym_COLON_EQ] = ACTIONS(237),
    [anon_sym_DASH_GT] = ACTIONS(235),
    [anon_sym_DASH_GT_GT] = ACTIONS(237),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(237),
    [sym__number_literal] = ACTIONS(235),
    [anon_sym_SQUOTE] = ACTIONS(237),
    [anon_sym_DQUOTE] = ACTIONS(237),
    [sym_dots] = ACTIONS(235),
    [sym_dot_dot_i] = ACTIONS(235),
    [sym_return] = ACTIONS(235),
    [sym_next] = ACTIONS(235),
    [sym_break] = ACTIONS(235),
    [sym_true] = ACTIONS(235),
    [sym_false] = ACTIONS(235),
    [sym_null] = ACTIONS(235),
    [sym_inf] = ACTIONS(235),
    [sym_nan] = ACTIONS(235),
    [anon_sym_NA] = ACTIONS(235),
    [anon_sym_NA_integer_] = ACTIONS(235),
    [anon_sym_NA_real_] = ACTIONS(235),
    [anon_sym_NA_complex_] = ACTIONS(235),
    [anon_sym_NA_character_] = ACTIONS(235),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(237),
    [sym__semicolon] = ACTIONS(237),
    [sym__raw_string_literal] = ACTIONS(237),
    [sym__external_else] = ACTIONS(237),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(237),
    [sym__external_close_brace] = ACTIONS(237),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [69] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(235),
    [anon_sym_BSLASH] = ACTIONS(237),
    [anon_sym_function] = ACTIONS(235),
    [anon_sym_EQ] = ACTIONS(235),
    [anon_sym_if] = ACTIONS(235),
    [anon_sym_for] = ACTIONS(235),
    [anon_sym_while] = ACTIONS(235),
    [anon_sym_repeat] = ACTIONS(235),
    [anon_sym_QMARK] = ACTIONS(237),
    [anon_sym_TILDE] = ACTIONS(237),
    [anon_sym_BANG] = ACTIONS(235),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(237),
    [anon_sym_LT_LT_DASH] = ACTIONS(237),
    [anon_sym_COLON_EQ] = ACTIONS(237),
    [anon_sym_DASH_GT] = ACTIONS(235),
    [anon_sym_DASH_GT_GT] = ACTIONS(237),
    [anon_sym_PIPE] = ACTIONS(235),
    [anon_sym_AMP] = ACTIONS(235),
    [anon_sym_PIPE_PIPE] = ACTIONS(237),
    [anon_sym_AMP_AMP] = ACTIONS(237),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(237),
    [sym__number_literal] = ACTIONS(235),
    [anon_sym_SQUOTE] = ACTIONS(237),
    [anon_sym_DQUOTE] = ACTIONS(237),
    [sym_dots] = ACTIONS(235),
    [sym_dot_dot_i] = ACTIONS(235),
    [sym_return] = ACTIONS(235),
    [sym_next] = ACTIONS(235),
    [sym_break] = ACTIONS(235),
    [sym_true] = ACTIONS(235),
    [sym_false] = ACTIONS(235),
    [sym_null] = ACTIONS(235),
    [sym_inf] = ACTIONS(235),
    [sym_nan] = ACTIONS(235),
    [anon_sym_NA] = ACTIONS(235),
    [anon_sym_NA_integer_] = ACTIONS(235),
    [anon_sym_NA_real_] = ACTIONS(235),
    [anon_sym_NA_complex_] = ACTIONS(235),
    [anon_sym_NA_character_] = ACTIONS(235),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(237),
    [sym__semicolon] = ACTIONS(237),
    [sym__raw_string_literal] = ACTIONS(237),
    [sym__external_else] = ACTIONS(237),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(237),
    [sym__external_close_brace] = ACTIONS(237),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [70] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(235),
    [anon_sym_BSLASH] = ACTIONS(237),
    [anon_sym_function] = ACTIONS(235),
    [anon_sym_EQ] = ACTIONS(235),
    [anon_sym_if] = ACTIONS(235),
    [anon_sym_for] = ACTIONS(235),
    [anon_sym_while] = ACTIONS(235),
    [anon_sym_repeat] = ACTIONS(235),
    [anon_sym_QMARK] = ACTIONS(237),
    [anon_sym_TILDE] = ACTIONS(237),
    [anon_sym_BANG] = ACTIONS(235),
    [anon_sym_PLUS] = ACTIONS(237),
    [anon_sym_DASH] = ACTIONS(235),
    [anon_sym_LT_DASH] = ACTIONS(237),
    [anon_sym_LT_LT_DASH] = ACTIONS(237),
    [anon_sym_COLON_EQ] = ACTIONS(237),
    [anon_sym_DASH_GT] = ACTIONS(235),
    [anon_sym_DASH_GT_GT] = ACTIONS(237),
    [anon_sym_PIPE] = ACTIONS(235),
    [anon_sym_AMP] = ACTIONS(235),
    [anon_sym_PIPE_PIPE] = ACTIONS(237),
    [anon_sym_AMP_AMP] = ACTIONS(237),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(235),
    [anon_sym_SLASH] = ACTIONS(237),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(237),
    [anon_sym_PIPE_GT] = ACTIONS(237),
    [anon_sym_COLON] = ACTIONS(235),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(237),
    [sym__number_literal] = ACTIONS(235),
    [anon_sym_SQUOTE] = ACTIONS(237),
    [anon_sym_DQUOTE] = ACTIONS(237),
    [sym_dots] = ACTIONS(235),
    [sym_dot_dot_i] = ACTIONS(235),
    [sym_return] = ACTIONS(235),
    [sym_next] = ACTIONS(235),
    [sym_break] = ACTIONS(235),
    [sym_true] = ACTIONS(235),
    [sym_false] = ACTIONS(235),
    [sym_null] = ACTIONS(235),
    [sym_inf] = ACTIONS(235),
    [sym_nan] = ACTIONS(235),
    [anon_sym_NA] = ACTIONS(235),
    [anon_sym_NA_integer_] = ACTIONS(235),
    [anon_sym_NA_real_] = ACTIONS(235),
    [anon_sym_NA_complex_] = ACTIONS(235),
    [anon_sym_NA_character_] = ACTIONS(235),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(237),
    [sym__semicolon] = ACTIONS(237),
    [sym__raw_string_literal] = ACTIONS(237),
    [sym__external_else] = ACTIONS(237),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(237),
    [sym__external_close_brace] = ACTIONS(237),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [71] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(239),
    [anon_sym_BSLASH] = ACTIONS(241),
    [anon_sym_function] = ACTIONS(239),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(239),
    [anon_sym_for] = ACTIONS(239),
    [anon_sym_while] = ACTIONS(239),
    [anon_sym_repeat] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(239),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(241),
    [sym__number_literal] = ACTIONS(239),
    [anon_sym_SQUOTE] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(241),
    [sym_dots] = ACTIONS(239),
    [sym_dot_dot_i] = ACTIONS(239),
    [sym_return] = ACTIONS(239),
    [sym_next] = ACTIONS(239),
    [sym_break] = ACTIONS(239),
    [sym_true] = ACTIONS(239),
    [sym_false] = ACTIONS(239),
    [sym_null] = ACTIONS(239),
    [sym_inf] = ACTIONS(239),
    [sym_nan] = ACTIONS(239),
    [anon_sym_NA] = ACTIONS(239),
    [anon_sym_NA_integer_] = ACTIONS(239),
    [anon_sym_NA_real_] = ACTIONS(239),
    [anon_sym_NA_complex_] = ACTIONS(239),
    [anon_sym_NA_character_] = ACTIONS(239),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(241),
    [sym__semicolon] = ACTIONS(241),
    [sym__raw_string_literal] = ACTIONS(241),
    [sym__external_else] = ACTIONS(241),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(241),
    [sym__external_close_brace] = ACTIONS(241),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [72] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(243),
    [anon_sym_BSLASH] = ACTIONS(245),
    [anon_sym_function] = ACTIONS(243),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(243),
    [anon_sym_for] = ACTIONS(243),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_repeat] = ACTIONS(243),
    [anon_sym_QMARK] = ACTIONS(245),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(243),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(245),
    [sym__number_literal] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [anon_sym_DQUOTE] = ACTIONS(245),
    [sym_dots] = ACTIONS(243),
    [sym_dot_dot_i] = ACTIONS(243),
    [sym_return] = ACTIONS(243),
    [sym_next] = ACTIONS(243),
    [sym_break] = ACTIONS(243),
    [sym_true] = ACTIONS(243),
    [sym_false] = ACTIONS(243),
    [sym_null] = ACTIONS(243),
    [sym_inf] = ACTIONS(243),
    [sym_nan] = ACTIONS(243),
    [anon_sym_NA] = ACTIONS(243),
    [anon_sym_NA_integer_] = ACTIONS(243),
    [anon_sym_NA_real_] = ACTIONS(243),
    [anon_sym_NA_complex_] = ACTIONS(243),
    [anon_sym_NA_character_] = ACTIONS(243),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(245),
    [sym__semicolon] = ACTIONS(245),
    [sym__raw_string_literal] = ACTIONS(245),
    [sym__external_else] = ACTIONS(245),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(245),
    [sym__external_close_brace] = ACTIONS(245),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [73] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(149),
    [anon_sym_BSLASH] = ACTIONS(147),
    [anon_sym_function] = ACTIONS(149),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(149),
    [anon_sym_for] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(149),
    [anon_sym_repeat] = ACTIONS(149),
    [anon_sym_QMARK] = ACTIONS(147),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(147),
    [sym__number_literal] = ACTIONS(149),
    [anon_sym_SQUOTE] = ACTIONS(147),
    [anon_sym_DQUOTE] = ACTIONS(147),
    [sym_dots] = ACTIONS(149),
    [sym_dot_dot_i] = ACTIONS(149),
    [sym_return] = ACTIONS(149),
    [sym_next] = ACTIONS(149),
    [sym_break] = ACTIONS(149),
    [sym_true] = ACTIONS(149),
    [sym_false] = ACTIONS(149),
    [sym_null] = ACTIONS(149),
    [sym_inf] = ACTIONS(149),
    [sym_nan] = ACTIONS(149),
    [anon_sym_NA] = ACTIONS(149),
    [anon_sym_NA_integer_] = ACTIONS(149),
    [anon_sym_NA_real_] = ACTIONS(149),
    [anon_sym_NA_complex_] = ACTIONS(149),
    [anon_sym_NA_character_] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(147),
    [sym__semicolon] = ACTIONS(147),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(147),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(147),
    [sym__external_close_brace] = ACTIONS(147),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [74] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(147),
    [sym_identifier] = ACTIONS(149),
    [anon_sym_BSLASH] = ACTIONS(147),
    [anon_sym_function] = ACTIONS(149),
    [anon_sym_EQ] = ACTIONS(149),
    [anon_sym_if] = ACTIONS(149),
    [anon_sym_for] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(149),
    [anon_sym_repeat] = ACTIONS(149),
    [anon_sym_QMARK] = ACTIONS(147),
    [anon_sym_TILDE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(147),
    [anon_sym_LT_LT_DASH] = ACTIONS(147),
    [anon_sym_COLON_EQ] = ACTIONS(147),
    [anon_sym_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_GT] = ACTIONS(147),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(147),
    [sym__number_literal] = ACTIONS(149),
    [anon_sym_SQUOTE] = ACTIONS(147),
    [anon_sym_DQUOTE] = ACTIONS(147),
    [sym_dots] = ACTIONS(149),
    [sym_dot_dot_i] = ACTIONS(149),
    [sym_return] = ACTIONS(149),
    [sym_next] = ACTIONS(149),
    [sym_break] = ACTIONS(149),
    [sym_true] = ACTIONS(149),
    [sym_false] = ACTIONS(149),
    [sym_null] = ACTIONS(149),
    [sym_inf] = ACTIONS(149),
    [sym_nan] = ACTIONS(149),
    [anon_sym_NA] = ACTIONS(149),
    [anon_sym_NA_integer_] = ACTIONS(149),
    [anon_sym_NA_real_] = ACTIONS(149),
    [anon_sym_NA_complex_] = ACTIONS(149),
    [anon_sym_NA_character_] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(147),
    [sym__semicolon] = ACTIONS(147),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(147),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(147),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [75] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(149),
    [anon_sym_BSLASH] = ACTIONS(147),
    [anon_sym_function] = ACTIONS(149),
    [anon_sym_EQ] = ACTIONS(149),
    [anon_sym_if] = ACTIONS(149),
    [anon_sym_for] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(149),
    [anon_sym_repeat] = ACTIONS(149),
    [anon_sym_QMARK] = ACTIONS(147),
    [anon_sym_TILDE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(147),
    [anon_sym_LT_LT_DASH] = ACTIONS(147),
    [anon_sym_COLON_EQ] = ACTIONS(147),
    [anon_sym_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_GT] = ACTIONS(147),
    [anon_sym_PIPE] = ACTIONS(149),
    [anon_sym_AMP] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(147),
    [anon_sym_AMP_AMP] = ACTIONS(147),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(147),
    [sym__number_literal] = ACTIONS(149),
    [anon_sym_SQUOTE] = ACTIONS(147),
    [anon_sym_DQUOTE] = ACTIONS(147),
    [sym_dots] = ACTIONS(149),
    [sym_dot_dot_i] = ACTIONS(149),
    [sym_return] = ACTIONS(149),
    [sym_next] = ACTIONS(149),
    [sym_break] = ACTIONS(149),
    [sym_true] = ACTIONS(149),
    [sym_false] = ACTIONS(149),
    [sym_null] = ACTIONS(149),
    [sym_inf] = ACTIONS(149),
    [sym_nan] = ACTIONS(149),
    [anon_sym_NA] = ACTIONS(149),
    [anon_sym_NA_integer_] = ACTIONS(149),
    [anon_sym_NA_real_] = ACTIONS(149),
    [anon_sym_NA_complex_] = ACTIONS(149),
    [anon_sym_NA_character_] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(147),
    [sym__semicolon] = ACTIONS(147),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(147),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(147),
    [sym__external_close_brace] = ACTIONS(147),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [76] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(149),
    [anon_sym_BSLASH] = ACTIONS(147),
    [anon_sym_function] = ACTIONS(149),
    [anon_sym_EQ] = ACTIONS(149),
    [anon_sym_if] = ACTIONS(149),
    [anon_sym_for] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(149),
    [anon_sym_repeat] = ACTIONS(149),
    [anon_sym_QMARK] = ACTIONS(147),
    [anon_sym_TILDE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_PLUS] = ACTIONS(147),
    [anon_sym_DASH] = ACTIONS(149),
    [anon_sym_LT_DASH] = ACTIONS(147),
    [anon_sym_LT_LT_DASH] = ACTIONS(147),
    [anon_sym_COLON_EQ] = ACTIONS(147),
    [anon_sym_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_GT] = ACTIONS(147),
    [anon_sym_PIPE] = ACTIONS(149),
    [anon_sym_AMP] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(147),
    [anon_sym_AMP_AMP] = ACTIONS(147),
    [anon_sym_LT] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(147),
    [anon_sym_GT] = ACTIONS(149),
    [anon_sym_GT_EQ] = ACTIONS(147),
    [anon_sym_EQ_EQ] = ACTIONS(147),
    [anon_sym_BANG_EQ] = ACTIONS(147),
    [anon_sym_STAR] = ACTIONS(149),
    [anon_sym_SLASH] = ACTIONS(147),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(147),
    [anon_sym_PIPE_GT] = ACTIONS(147),
    [anon_sym_COLON] = ACTIONS(149),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(147),
    [sym__number_literal] = ACTIONS(149),
    [anon_sym_SQUOTE] = ACTIONS(147),
    [anon_sym_DQUOTE] = ACTIONS(147),
    [sym_dots] = ACTIONS(149),
    [sym_dot_dot_i] = ACTIONS(149),
    [sym_return] = ACTIONS(149),
    [sym_next] = ACTIONS(149),
    [sym_break] = ACTIONS(149),
    [sym_true] = ACTIONS(149),
    [sym_false] = ACTIONS(149),
    [sym_null] = ACTIONS(149),
    [sym_inf] = ACTIONS(149),
    [sym_nan] = ACTIONS(149),
    [anon_sym_NA] = ACTIONS(149),
    [anon_sym_NA_integer_] = ACTIONS(149),
    [anon_sym_NA_real_] = ACTIONS(149),
    [anon_sym_NA_complex_] = ACTIONS(149),
    [anon_sym_NA_character_] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(147),
    [sym__semicolon] = ACTIONS(147),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(147),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(147),
    [sym__external_close_brace] = ACTIONS(147),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [77] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [78] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [79] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [80] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [81] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [82] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [83] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [84] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [85] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [86] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(151),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [87] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(151),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(151),
    [anon_sym_PIPE_GT] = ACTIONS(151),
    [anon_sym_COLON] = ACTIONS(153),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [88] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(151),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(151),
    [anon_sym_PIPE_GT] = ACTIONS(151),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [89] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(151),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(151),
    [anon_sym_PIPE_GT] = ACTIONS(151),
    [anon_sym_COLON] = ACTIONS(153),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [90] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_BSLASH] = ACTIONS(155),
    [anon_sym_function] = ACTIONS(157),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(157),
    [anon_sym_repeat] = ACTIONS(157),
    [anon_sym_QMARK] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(155),
    [sym__number_literal] = ACTIONS(157),
    [anon_sym_SQUOTE] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(155),
    [sym_dots] = ACTIONS(157),
    [sym_dot_dot_i] = ACTIONS(157),
    [sym_return] = ACTIONS(157),
    [sym_next] = ACTIONS(157),
    [sym_break] = ACTIONS(157),
    [sym_true] = ACTIONS(157),
    [sym_false] = ACTIONS(157),
    [sym_null] = ACTIONS(157),
    [sym_inf] = ACTIONS(157),
    [sym_nan] = ACTIONS(157),
    [anon_sym_NA] = ACTIONS(157),
    [anon_sym_NA_integer_] = ACTIONS(157),
    [anon_sym_NA_real_] = ACTIONS(157),
    [anon_sym_NA_complex_] = ACTIONS(157),
    [anon_sym_NA_character_] = ACTIONS(157),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(155),
    [sym__semicolon] = ACTIONS(155),
    [sym__raw_string_literal] = ACTIONS(155),
    [sym__external_else] = ACTIONS(155),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(155),
    [sym__external_close_brace] = ACTIONS(155),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [91] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(161),
    [anon_sym_BSLASH] = ACTIONS(159),
    [anon_sym_function] = ACTIONS(161),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_while] = ACTIONS(161),
    [anon_sym_repeat] = ACTIONS(161),
    [anon_sym_QMARK] = ACTIONS(159),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(159),
    [sym__number_literal] = ACTIONS(161),
    [anon_sym_SQUOTE] = ACTIONS(159),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [sym_dots] = ACTIONS(161),
    [sym_dot_dot_i] = ACTIONS(161),
    [sym_return] = ACTIONS(161),
    [sym_next] = ACTIONS(161),
    [sym_break] = ACTIONS(161),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [sym_null] = ACTIONS(161),
    [sym_inf] = ACTIONS(161),
    [sym_nan] = ACTIONS(161),
    [anon_sym_NA] = ACTIONS(161),
    [anon_sym_NA_integer_] = ACTIONS(161),
    [anon_sym_NA_real_] = ACTIONS(161),
    [anon_sym_NA_complex_] = ACTIONS(161),
    [anon_sym_NA_character_] = ACTIONS(161),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(159),
    [sym__semicolon] = ACTIONS(159),
    [sym__raw_string_literal] = ACTIONS(159),
    [sym__external_else] = ACTIONS(159),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(159),
    [sym__external_close_brace] = ACTIONS(159),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [92] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [93] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [94] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [95] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(165),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(165),
    [anon_sym_LT_EQ] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(165),
    [anon_sym_GT_EQ] = ACTIONS(163),
    [anon_sym_EQ_EQ] = ACTIONS(163),
    [anon_sym_BANG_EQ] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [96] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [97] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [98] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [99] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [100] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(165),
    [anon_sym_LT_EQ] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(165),
    [anon_sym_GT_EQ] = ACTIONS(163),
    [anon_sym_EQ_EQ] = ACTIONS(163),
    [anon_sym_BANG_EQ] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [101] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(165),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(165),
    [anon_sym_LT_EQ] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(165),
    [anon_sym_GT_EQ] = ACTIONS(163),
    [anon_sym_EQ_EQ] = ACTIONS(163),
    [anon_sym_BANG_EQ] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(165),
    [anon_sym_SLASH] = ACTIONS(163),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [102] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(165),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(165),
    [anon_sym_LT_EQ] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(165),
    [anon_sym_GT_EQ] = ACTIONS(163),
    [anon_sym_EQ_EQ] = ACTIONS(163),
    [anon_sym_BANG_EQ] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(165),
    [anon_sym_SLASH] = ACTIONS(163),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(163),
    [anon_sym_PIPE_GT] = ACTIONS(163),
    [anon_sym_COLON] = ACTIONS(165),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [103] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(165),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(165),
    [anon_sym_LT_EQ] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(165),
    [anon_sym_GT_EQ] = ACTIONS(163),
    [anon_sym_EQ_EQ] = ACTIONS(163),
    [anon_sym_BANG_EQ] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(165),
    [anon_sym_SLASH] = ACTIONS(163),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(163),
    [anon_sym_PIPE_GT] = ACTIONS(163),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [104] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(165),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(165),
    [anon_sym_LT_EQ] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(165),
    [anon_sym_GT_EQ] = ACTIONS(163),
    [anon_sym_EQ_EQ] = ACTIONS(163),
    [anon_sym_BANG_EQ] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(165),
    [anon_sym_SLASH] = ACTIONS(163),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(163),
    [anon_sym_PIPE_GT] = ACTIONS(163),
    [anon_sym_COLON] = ACTIONS(165),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_else] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [105] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(169),
    [anon_sym_BSLASH] = ACTIONS(167),
    [anon_sym_function] = ACTIONS(169),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_repeat] = ACTIONS(169),
    [anon_sym_QMARK] = ACTIONS(167),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(169),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(167),
    [sym__number_literal] = ACTIONS(169),
    [anon_sym_SQUOTE] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(167),
    [sym_dots] = ACTIONS(169),
    [sym_dot_dot_i] = ACTIONS(169),
    [sym_return] = ACTIONS(169),
    [sym_next] = ACTIONS(169),
    [sym_break] = ACTIONS(169),
    [sym_true] = ACTIONS(169),
    [sym_false] = ACTIONS(169),
    [sym_null] = ACTIONS(169),
    [sym_inf] = ACTIONS(169),
    [sym_nan] = ACTIONS(169),
    [anon_sym_NA] = ACTIONS(169),
    [anon_sym_NA_integer_] = ACTIONS(169),
    [anon_sym_NA_real_] = ACTIONS(169),
    [anon_sym_NA_complex_] = ACTIONS(169),
    [anon_sym_NA_character_] = ACTIONS(169),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(167),
    [sym__semicolon] = ACTIONS(167),
    [sym__raw_string_literal] = ACTIONS(167),
    [sym__external_else] = ACTIONS(167),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(167),
    [sym__external_close_brace] = ACTIONS(167),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [106] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(173),
    [anon_sym_BSLASH] = ACTIONS(171),
    [anon_sym_function] = ACTIONS(173),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_while] = ACTIONS(173),
    [anon_sym_repeat] = ACTIONS(173),
    [anon_sym_QMARK] = ACTIONS(171),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(173),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(171),
    [sym__number_literal] = ACTIONS(173),
    [anon_sym_SQUOTE] = ACTIONS(171),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [sym_dots] = ACTIONS(173),
    [sym_dot_dot_i] = ACTIONS(173),
    [sym_return] = ACTIONS(173),
    [sym_next] = ACTIONS(173),
    [sym_break] = ACTIONS(173),
    [sym_true] = ACTIONS(173),
    [sym_false] = ACTIONS(173),
    [sym_null] = ACTIONS(173),
    [sym_inf] = ACTIONS(173),
    [sym_nan] = ACTIONS(173),
    [anon_sym_NA] = ACTIONS(173),
    [anon_sym_NA_integer_] = ACTIONS(173),
    [anon_sym_NA_real_] = ACTIONS(173),
    [anon_sym_NA_complex_] = ACTIONS(173),
    [anon_sym_NA_character_] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(171),
    [sym__semicolon] = ACTIONS(171),
    [sym__raw_string_literal] = ACTIONS(171),
    [sym__external_else] = ACTIONS(171),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(171),
    [sym__external_close_brace] = ACTIONS(171),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [107] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(177),
    [anon_sym_BSLASH] = ACTIONS(175),
    [anon_sym_function] = ACTIONS(177),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(177),
    [anon_sym_for] = ACTIONS(177),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_repeat] = ACTIONS(177),
    [anon_sym_QMARK] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(177),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(175),
    [sym__number_literal] = ACTIONS(177),
    [anon_sym_SQUOTE] = ACTIONS(175),
    [anon_sym_DQUOTE] = ACTIONS(175),
    [sym_dots] = ACTIONS(177),
    [sym_dot_dot_i] = ACTIONS(177),
    [sym_return] = ACTIONS(177),
    [sym_next] = ACTIONS(177),
    [sym_break] = ACTIONS(177),
    [sym_true] = ACTIONS(177),
    [sym_false] = ACTIONS(177),
    [sym_null] = ACTIONS(177),
    [sym_inf] = ACTIONS(177),
    [sym_nan] = ACTIONS(177),
    [anon_sym_NA] = ACTIONS(177),
    [anon_sym_NA_integer_] = ACTIONS(177),
    [anon_sym_NA_real_] = ACTIONS(177),
    [anon_sym_NA_complex_] = ACTIONS(177),
    [anon_sym_NA_character_] = ACTIONS(177),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(175),
    [sym__semicolon] = ACTIONS(175),
    [sym__raw_string_literal] = ACTIONS(175),
    [sym__external_else] = ACTIONS(175),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(175),
    [sym__external_close_brace] = ACTIONS(175),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [108] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(181),
    [anon_sym_BSLASH] = ACTIONS(179),
    [anon_sym_function] = ACTIONS(181),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(181),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_repeat] = ACTIONS(181),
    [anon_sym_QMARK] = ACTIONS(179),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(181),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(179),
    [sym__number_literal] = ACTIONS(181),
    [anon_sym_SQUOTE] = ACTIONS(179),
    [anon_sym_DQUOTE] = ACTIONS(179),
    [sym_dots] = ACTIONS(181),
    [sym_dot_dot_i] = ACTIONS(181),
    [sym_return] = ACTIONS(181),
    [sym_next] = ACTIONS(181),
    [sym_break] = ACTIONS(181),
    [sym_true] = ACTIONS(181),
    [sym_false] = ACTIONS(181),
    [sym_null] = ACTIONS(181),
    [sym_inf] = ACTIONS(181),
    [sym_nan] = ACTIONS(181),
    [anon_sym_NA] = ACTIONS(181),
    [anon_sym_NA_integer_] = ACTIONS(181),
    [anon_sym_NA_real_] = ACTIONS(181),
    [anon_sym_NA_complex_] = ACTIONS(181),
    [anon_sym_NA_character_] = ACTIONS(181),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(179),
    [sym__semicolon] = ACTIONS(179),
    [sym__raw_string_literal] = ACTIONS(179),
    [sym__external_else] = ACTIONS(179),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(179),
    [sym__external_close_brace] = ACTIONS(179),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [109] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(185),
    [anon_sym_BSLASH] = ACTIONS(183),
    [anon_sym_function] = ACTIONS(185),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(185),
    [anon_sym_for] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(185),
    [anon_sym_repeat] = ACTIONS(185),
    [anon_sym_QMARK] = ACTIONS(183),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(185),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(183),
    [sym__number_literal] = ACTIONS(185),
    [anon_sym_SQUOTE] = ACTIONS(183),
    [anon_sym_DQUOTE] = ACTIONS(183),
    [sym_dots] = ACTIONS(185),
    [sym_dot_dot_i] = ACTIONS(185),
    [sym_return] = ACTIONS(185),
    [sym_next] = ACTIONS(185),
    [sym_break] = ACTIONS(185),
    [sym_true] = ACTIONS(185),
    [sym_false] = ACTIONS(185),
    [sym_null] = ACTIONS(185),
    [sym_inf] = ACTIONS(185),
    [sym_nan] = ACTIONS(185),
    [anon_sym_NA] = ACTIONS(185),
    [anon_sym_NA_integer_] = ACTIONS(185),
    [anon_sym_NA_real_] = ACTIONS(185),
    [anon_sym_NA_complex_] = ACTIONS(185),
    [anon_sym_NA_character_] = ACTIONS(185),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(183),
    [sym__semicolon] = ACTIONS(183),
    [sym__raw_string_literal] = ACTIONS(183),
    [sym__external_else] = ACTIONS(183),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(183),
    [sym__external_close_brace] = ACTIONS(183),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [110] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(189),
    [anon_sym_BSLASH] = ACTIONS(187),
    [anon_sym_function] = ACTIONS(189),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(189),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(189),
    [anon_sym_repeat] = ACTIONS(189),
    [anon_sym_QMARK] = ACTIONS(187),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(189),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(187),
    [sym__number_literal] = ACTIONS(189),
    [anon_sym_SQUOTE] = ACTIONS(187),
    [anon_sym_DQUOTE] = ACTIONS(187),
    [sym_dots] = ACTIONS(189),
    [sym_dot_dot_i] = ACTIONS(189),
    [sym_return] = ACTIONS(189),
    [sym_next] = ACTIONS(189),
    [sym_break] = ACTIONS(189),
    [sym_true] = ACTIONS(189),
    [sym_false] = ACTIONS(189),
    [sym_null] = ACTIONS(189),
    [sym_inf] = ACTIONS(189),
    [sym_nan] = ACTIONS(189),
    [anon_sym_NA] = ACTIONS(189),
    [anon_sym_NA_integer_] = ACTIONS(189),
    [anon_sym_NA_real_] = ACTIONS(189),
    [anon_sym_NA_complex_] = ACTIONS(189),
    [anon_sym_NA_character_] = ACTIONS(189),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(187),
    [sym__semicolon] = ACTIONS(187),
    [sym__raw_string_literal] = ACTIONS(187),
    [sym__external_else] = ACTIONS(187),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(187),
    [sym__external_close_brace] = ACTIONS(187),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [111] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(193),
    [anon_sym_BSLASH] = ACTIONS(191),
    [anon_sym_function] = ACTIONS(193),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(193),
    [anon_sym_for] = ACTIONS(193),
    [anon_sym_while] = ACTIONS(193),
    [anon_sym_repeat] = ACTIONS(193),
    [anon_sym_QMARK] = ACTIONS(191),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(193),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(191),
    [sym__number_literal] = ACTIONS(193),
    [anon_sym_SQUOTE] = ACTIONS(191),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_dots] = ACTIONS(193),
    [sym_dot_dot_i] = ACTIONS(193),
    [sym_return] = ACTIONS(193),
    [sym_next] = ACTIONS(193),
    [sym_break] = ACTIONS(193),
    [sym_true] = ACTIONS(193),
    [sym_false] = ACTIONS(193),
    [sym_null] = ACTIONS(193),
    [sym_inf] = ACTIONS(193),
    [sym_nan] = ACTIONS(193),
    [anon_sym_NA] = ACTIONS(193),
    [anon_sym_NA_integer_] = ACTIONS(193),
    [anon_sym_NA_real_] = ACTIONS(193),
    [anon_sym_NA_complex_] = ACTIONS(193),
    [anon_sym_NA_character_] = ACTIONS(193),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(191),
    [sym__semicolon] = ACTIONS(191),
    [sym__raw_string_literal] = ACTIONS(191),
    [sym__external_else] = ACTIONS(191),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(191),
    [sym__external_close_brace] = ACTIONS(191),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [112] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(197),
    [anon_sym_BSLASH] = ACTIONS(195),
    [anon_sym_function] = ACTIONS(197),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_for] = ACTIONS(197),
    [anon_sym_while] = ACTIONS(197),
    [anon_sym_repeat] = ACTIONS(197),
    [anon_sym_QMARK] = ACTIONS(195),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(197),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(195),
    [sym__number_literal] = ACTIONS(197),
    [anon_sym_SQUOTE] = ACTIONS(195),
    [anon_sym_DQUOTE] = ACTIONS(195),
    [sym_dots] = ACTIONS(197),
    [sym_dot_dot_i] = ACTIONS(197),
    [sym_return] = ACTIONS(197),
    [sym_next] = ACTIONS(197),
    [sym_break] = ACTIONS(197),
    [sym_true] = ACTIONS(197),
    [sym_false] = ACTIONS(197),
    [sym_null] = ACTIONS(197),
    [sym_inf] = ACTIONS(197),
    [sym_nan] = ACTIONS(197),
    [anon_sym_NA] = ACTIONS(197),
    [anon_sym_NA_integer_] = ACTIONS(197),
    [anon_sym_NA_real_] = ACTIONS(197),
    [anon_sym_NA_complex_] = ACTIONS(197),
    [anon_sym_NA_character_] = ACTIONS(197),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(195),
    [sym__semicolon] = ACTIONS(195),
    [sym__raw_string_literal] = ACTIONS(195),
    [sym__external_else] = ACTIONS(195),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(195),
    [sym__external_close_brace] = ACTIONS(195),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [113] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(201),
    [anon_sym_BSLASH] = ACTIONS(199),
    [anon_sym_function] = ACTIONS(201),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(201),
    [anon_sym_for] = ACTIONS(201),
    [anon_sym_while] = ACTIONS(201),
    [anon_sym_repeat] = ACTIONS(201),
    [anon_sym_QMARK] = ACTIONS(199),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(199),
    [sym__number_literal] = ACTIONS(201),
    [anon_sym_SQUOTE] = ACTIONS(199),
    [anon_sym_DQUOTE] = ACTIONS(199),
    [sym_dots] = ACTIONS(201),
    [sym_dot_dot_i] = ACTIONS(201),
    [sym_return] = ACTIONS(201),
    [sym_next] = ACTIONS(201),
    [sym_break] = ACTIONS(201),
    [sym_true] = ACTIONS(201),
    [sym_false] = ACTIONS(201),
    [sym_null] = ACTIONS(201),
    [sym_inf] = ACTIONS(201),
    [sym_nan] = ACTIONS(201),
    [anon_sym_NA] = ACTIONS(201),
    [anon_sym_NA_integer_] = ACTIONS(201),
    [anon_sym_NA_real_] = ACTIONS(201),
    [anon_sym_NA_complex_] = ACTIONS(201),
    [anon_sym_NA_character_] = ACTIONS(201),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(199),
    [sym__semicolon] = ACTIONS(199),
    [sym__raw_string_literal] = ACTIONS(199),
    [sym__external_else] = ACTIONS(199),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(199),
    [sym__external_close_brace] = ACTIONS(199),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [114] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(205),
    [anon_sym_BSLASH] = ACTIONS(203),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(205),
    [anon_sym_while] = ACTIONS(205),
    [anon_sym_repeat] = ACTIONS(205),
    [anon_sym_QMARK] = ACTIONS(203),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(205),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(203),
    [sym__number_literal] = ACTIONS(205),
    [anon_sym_SQUOTE] = ACTIONS(203),
    [anon_sym_DQUOTE] = ACTIONS(203),
    [sym_dots] = ACTIONS(205),
    [sym_dot_dot_i] = ACTIONS(205),
    [sym_return] = ACTIONS(205),
    [sym_next] = ACTIONS(205),
    [sym_break] = ACTIONS(205),
    [sym_true] = ACTIONS(205),
    [sym_false] = ACTIONS(205),
    [sym_null] = ACTIONS(205),
    [sym_inf] = ACTIONS(205),
    [sym_nan] = ACTIONS(205),
    [anon_sym_NA] = ACTIONS(205),
    [anon_sym_NA_integer_] = ACTIONS(205),
    [anon_sym_NA_real_] = ACTIONS(205),
    [anon_sym_NA_complex_] = ACTIONS(205),
    [anon_sym_NA_character_] = ACTIONS(205),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(203),
    [sym__semicolon] = ACTIONS(203),
    [sym__raw_string_literal] = ACTIONS(203),
    [sym__external_else] = ACTIONS(203),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(203),
    [sym__external_close_brace] = ACTIONS(203),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [115] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(209),
    [anon_sym_BSLASH] = ACTIONS(207),
    [anon_sym_function] = ACTIONS(209),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(209),
    [anon_sym_for] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(209),
    [anon_sym_repeat] = ACTIONS(209),
    [anon_sym_QMARK] = ACTIONS(207),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(207),
    [sym__number_literal] = ACTIONS(209),
    [anon_sym_SQUOTE] = ACTIONS(207),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [sym_dots] = ACTIONS(209),
    [sym_dot_dot_i] = ACTIONS(209),
    [sym_return] = ACTIONS(209),
    [sym_next] = ACTIONS(209),
    [sym_break] = ACTIONS(209),
    [sym_true] = ACTIONS(209),
    [sym_false] = ACTIONS(209),
    [sym_null] = ACTIONS(209),
    [sym_inf] = ACTIONS(209),
    [sym_nan] = ACTIONS(209),
    [anon_sym_NA] = ACTIONS(209),
    [anon_sym_NA_integer_] = ACTIONS(209),
    [anon_sym_NA_real_] = ACTIONS(209),
    [anon_sym_NA_complex_] = ACTIONS(209),
    [anon_sym_NA_character_] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(207),
    [sym__semicolon] = ACTIONS(207),
    [sym__raw_string_literal] = ACTIONS(207),
    [sym__external_else] = ACTIONS(207),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_close_brace] = ACTIONS(207),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [116] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(213),
    [anon_sym_BSLASH] = ACTIONS(211),
    [anon_sym_function] = ACTIONS(213),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(213),
    [anon_sym_while] = ACTIONS(213),
    [anon_sym_repeat] = ACTIONS(213),
    [anon_sym_QMARK] = ACTIONS(211),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(211),
    [sym__number_literal] = ACTIONS(213),
    [anon_sym_SQUOTE] = ACTIONS(211),
    [anon_sym_DQUOTE] = ACTIONS(211),
    [sym_dots] = ACTIONS(213),
    [sym_dot_dot_i] = ACTIONS(213),
    [sym_return] = ACTIONS(213),
    [sym_next] = ACTIONS(213),
    [sym_break] = ACTIONS(213),
    [sym_true] = ACTIONS(213),
    [sym_false] = ACTIONS(213),
    [sym_null] = ACTIONS(213),
    [sym_inf] = ACTIONS(213),
    [sym_nan] = ACTIONS(213),
    [anon_sym_NA] = ACTIONS(213),
    [anon_sym_NA_integer_] = ACTIONS(213),
    [anon_sym_NA_real_] = ACTIONS(213),
    [anon_sym_NA_complex_] = ACTIONS(213),
    [anon_sym_NA_character_] = ACTIONS(213),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(211),
    [sym__semicolon] = ACTIONS(211),
    [sym__raw_string_literal] = ACTIONS(211),
    [sym__external_else] = ACTIONS(211),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(211),
    [sym__external_close_brace] = ACTIONS(211),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [117] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(217),
    [anon_sym_BSLASH] = ACTIONS(215),
    [anon_sym_function] = ACTIONS(217),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(217),
    [anon_sym_for] = ACTIONS(217),
    [anon_sym_while] = ACTIONS(217),
    [anon_sym_repeat] = ACTIONS(217),
    [anon_sym_QMARK] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(217),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(215),
    [sym__number_literal] = ACTIONS(217),
    [anon_sym_SQUOTE] = ACTIONS(215),
    [anon_sym_DQUOTE] = ACTIONS(215),
    [sym_dots] = ACTIONS(217),
    [sym_dot_dot_i] = ACTIONS(217),
    [sym_return] = ACTIONS(217),
    [sym_next] = ACTIONS(217),
    [sym_break] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_inf] = ACTIONS(217),
    [sym_nan] = ACTIONS(217),
    [anon_sym_NA] = ACTIONS(217),
    [anon_sym_NA_integer_] = ACTIONS(217),
    [anon_sym_NA_real_] = ACTIONS(217),
    [anon_sym_NA_complex_] = ACTIONS(217),
    [anon_sym_NA_character_] = ACTIONS(217),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(215),
    [sym__semicolon] = ACTIONS(215),
    [sym__raw_string_literal] = ACTIONS(215),
    [sym__external_else] = ACTIONS(215),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(215),
    [sym__external_close_brace] = ACTIONS(215),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [118] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(221),
    [anon_sym_BSLASH] = ACTIONS(219),
    [anon_sym_function] = ACTIONS(221),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(221),
    [anon_sym_for] = ACTIONS(221),
    [anon_sym_while] = ACTIONS(221),
    [anon_sym_repeat] = ACTIONS(221),
    [anon_sym_QMARK] = ACTIONS(219),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(219),
    [sym__number_literal] = ACTIONS(221),
    [anon_sym_SQUOTE] = ACTIONS(219),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_dots] = ACTIONS(221),
    [sym_dot_dot_i] = ACTIONS(221),
    [sym_return] = ACTIONS(221),
    [sym_next] = ACTIONS(221),
    [sym_break] = ACTIONS(221),
    [sym_true] = ACTIONS(221),
    [sym_false] = ACTIONS(221),
    [sym_null] = ACTIONS(221),
    [sym_inf] = ACTIONS(221),
    [sym_nan] = ACTIONS(221),
    [anon_sym_NA] = ACTIONS(221),
    [anon_sym_NA_integer_] = ACTIONS(221),
    [anon_sym_NA_real_] = ACTIONS(221),
    [anon_sym_NA_complex_] = ACTIONS(221),
    [anon_sym_NA_character_] = ACTIONS(221),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(219),
    [sym__semicolon] = ACTIONS(219),
    [sym__raw_string_literal] = ACTIONS(219),
    [sym__external_else] = ACTIONS(219),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(219),
    [sym__external_close_brace] = ACTIONS(219),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [119] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(233),
    [sym_identifier] = ACTIONS(231),
    [anon_sym_BSLASH] = ACTIONS(233),
    [anon_sym_function] = ACTIONS(231),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(231),
    [anon_sym_for] = ACTIONS(231),
    [anon_sym_while] = ACTIONS(231),
    [anon_sym_repeat] = ACTIONS(231),
    [anon_sym_QMARK] = ACTIONS(233),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(231),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(233),
    [sym__number_literal] = ACTIONS(231),
    [anon_sym_SQUOTE] = ACTIONS(233),
    [anon_sym_DQUOTE] = ACTIONS(233),
    [sym_dots] = ACTIONS(231),
    [sym_dot_dot_i] = ACTIONS(231),
    [sym_return] = ACTIONS(231),
    [sym_next] = ACTIONS(231),
    [sym_break] = ACTIONS(231),
    [sym_true] = ACTIONS(231),
    [sym_false] = ACTIONS(231),
    [sym_null] = ACTIONS(231),
    [sym_inf] = ACTIONS(231),
    [sym_nan] = ACTIONS(231),
    [anon_sym_NA] = ACTIONS(231),
    [anon_sym_NA_integer_] = ACTIONS(231),
    [anon_sym_NA_real_] = ACTIONS(231),
    [anon_sym_NA_complex_] = ACTIONS(231),
    [anon_sym_NA_character_] = ACTIONS(231),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(233),
    [sym__semicolon] = ACTIONS(233),
    [sym__raw_string_literal] = ACTIONS(233),
    [sym__external_else] = ACTIONS(233),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(233),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [120] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(225),
    [anon_sym_BSLASH] = ACTIONS(223),
    [anon_sym_function] = ACTIONS(225),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(225),
    [anon_sym_for] = ACTIONS(225),
    [anon_sym_while] = ACTIONS(225),
    [anon_sym_repeat] = ACTIONS(225),
    [anon_sym_QMARK] = ACTIONS(223),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(223),
    [sym__number_literal] = ACTIONS(225),
    [anon_sym_SQUOTE] = ACTIONS(223),
    [anon_sym_DQUOTE] = ACTIONS(223),
    [sym_dots] = ACTIONS(225),
    [sym_dot_dot_i] = ACTIONS(225),
    [sym_return] = ACTIONS(225),
    [sym_next] = ACTIONS(225),
    [sym_break] = ACTIONS(225),
    [sym_true] = ACTIONS(225),
    [sym_false] = ACTIONS(225),
    [sym_null] = ACTIONS(225),
    [sym_inf] = ACTIONS(225),
    [sym_nan] = ACTIONS(225),
    [anon_sym_NA] = ACTIONS(225),
    [anon_sym_NA_integer_] = ACTIONS(225),
    [anon_sym_NA_real_] = ACTIONS(225),
    [anon_sym_NA_complex_] = ACTIONS(225),
    [anon_sym_NA_character_] = ACTIONS(225),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(223),
    [sym__semicolon] = ACTIONS(223),
    [sym__raw_string_literal] = ACTIONS(223),
    [sym__external_else] = ACTIONS(223),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(223),
    [sym__external_close_brace] = ACTIONS(223),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [121] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(229),
    [anon_sym_BSLASH] = ACTIONS(227),
    [anon_sym_function] = ACTIONS(229),
    [anon_sym_EQ] = ACTIONS(75),
    [anon_sym_if] = ACTIONS(229),
    [anon_sym_for] = ACTIONS(229),
    [anon_sym_while] = ACTIONS(229),
    [anon_sym_repeat] = ACTIONS(229),
    [anon_sym_QMARK] = ACTIONS(227),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(229),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(83),
    [anon_sym_LT_LT_DASH] = ACTIONS(83),
    [anon_sym_COLON_EQ] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_DASH_GT_GT] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(227),
    [sym__number_literal] = ACTIONS(229),
    [anon_sym_SQUOTE] = ACTIONS(227),
    [anon_sym_DQUOTE] = ACTIONS(227),
    [sym_dots] = ACTIONS(229),
    [sym_dot_dot_i] = ACTIONS(229),
    [sym_return] = ACTIONS(229),
    [sym_next] = ACTIONS(229),
    [sym_break] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_inf] = ACTIONS(229),
    [sym_nan] = ACTIONS(229),
    [anon_sym_NA] = ACTIONS(229),
    [anon_sym_NA_integer_] = ACTIONS(229),
    [anon_sym_NA_real_] = ACTIONS(229),
    [anon_sym_NA_complex_] = ACTIONS(229),
    [anon_sym_NA_character_] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(227),
    [sym__semicolon] = ACTIONS(227),
    [sym__raw_string_literal] = ACTIONS(227),
    [sym__external_else] = ACTIONS(227),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(227),
    [sym__external_close_brace] = ACTIONS(227),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [122] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(237),
    [sym_identifier] = ACTIONS(235),
    [anon_sym_BSLASH] = ACTIONS(237),
    [anon_sym_function] = ACTIONS(235),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(235),
    [anon_sym_for] = ACTIONS(235),
    [anon_sym_while] = ACTIONS(235),
    [anon_sym_repeat] = ACTIONS(235),
    [anon_sym_QMARK] = ACTIONS(237),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(235),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(237),
    [sym__number_literal] = ACTIONS(235),
    [anon_sym_SQUOTE] = ACTIONS(237),
    [anon_sym_DQUOTE] = ACTIONS(237),
    [sym_dots] = ACTIONS(235),
    [sym_dot_dot_i] = ACTIONS(235),
    [sym_return] = ACTIONS(235),
    [sym_next] = ACTIONS(235),
    [sym_break] = ACTIONS(235),
    [sym_true] = ACTIONS(235),
    [sym_false] = ACTIONS(235),
    [sym_null] = ACTIONS(235),
    [sym_inf] = ACTIONS(235),
    [sym_nan] = ACTIONS(235),
    [anon_sym_NA] = ACTIONS(235),
    [anon_sym_NA_integer_] = ACTIONS(235),
    [anon_sym_NA_real_] = ACTIONS(235),
    [anon_sym_NA_complex_] = ACTIONS(235),
    [anon_sym_NA_character_] = ACTIONS(235),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(237),
    [sym__semicolon] = ACTIONS(237),
    [sym__raw_string_literal] = ACTIONS(237),
    [sym__external_else] = ACTIONS(237),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(237),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [123] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(237),
    [sym_identifier] = ACTIONS(235),
    [anon_sym_BSLASH] = ACTIONS(237),
    [anon_sym_function] = ACTIONS(235),
    [anon_sym_EQ] = ACTIONS(235),
    [anon_sym_if] = ACTIONS(235),
    [anon_sym_for] = ACTIONS(235),
    [anon_sym_while] = ACTIONS(235),
    [anon_sym_repeat] = ACTIONS(235),
    [anon_sym_QMARK] = ACTIONS(237),
    [anon_sym_TILDE] = ACTIONS(237),
    [anon_sym_BANG] = ACTIONS(235),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(237),
    [anon_sym_LT_LT_DASH] = ACTIONS(237),
    [anon_sym_COLON_EQ] = ACTIONS(237),
    [anon_sym_DASH_GT] = ACTIONS(235),
    [anon_sym_DASH_GT_GT] = ACTIONS(237),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(237),
    [sym__number_literal] = ACTIONS(235),
    [anon_sym_SQUOTE] = ACTIONS(237),
    [anon_sym_DQUOTE] = ACTIONS(237),
    [sym_dots] = ACTIONS(235),
    [sym_dot_dot_i] = ACTIONS(235),
    [sym_return] = ACTIONS(235),
    [sym_next] = ACTIONS(235),
    [sym_break] = ACTIONS(235),
    [sym_true] = ACTIONS(235),
    [sym_false] = ACTIONS(235),
    [sym_null] = ACTIONS(235),
    [sym_inf] = ACTIONS(235),
    [sym_nan] = ACTIONS(235),
    [anon_sym_NA] = ACTIONS(235),
    [anon_sym_NA_integer_] = ACTIONS(235),
    [anon_sym_NA_real_] = ACTIONS(235),
    [anon_sym_NA_complex_] = ACTIONS(235),
    [anon_sym_NA_character_] = ACTIONS(235),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(237),
    [sym__semicolon] = ACTIONS(237),
    [sym__raw_string_literal] = ACTIONS(237),
    [sym__external_else] = ACTIONS(237),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(237),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [124] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(237),
    [sym_identifier] = ACTIONS(235),
    [anon_sym_BSLASH] = ACTIONS(237),
    [anon_sym_function] = ACTIONS(235),
    [anon_sym_EQ] = ACTIONS(235),
    [anon_sym_if] = ACTIONS(235),
    [anon_sym_for] = ACTIONS(235),
    [anon_sym_while] = ACTIONS(235),
    [anon_sym_repeat] = ACTIONS(235),
    [anon_sym_QMARK] = ACTIONS(237),
    [anon_sym_TILDE] = ACTIONS(237),
    [anon_sym_BANG] = ACTIONS(235),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(237),
    [anon_sym_LT_LT_DASH] = ACTIONS(237),
    [anon_sym_COLON_EQ] = ACTIONS(237),
    [anon_sym_DASH_GT] = ACTIONS(235),
    [anon_sym_DASH_GT_GT] = ACTIONS(237),
    [anon_sym_PIPE] = ACTIONS(235),
    [anon_sym_AMP] = ACTIONS(235),
    [anon_sym_PIPE_PIPE] = ACTIONS(237),
    [anon_sym_AMP_AMP] = ACTIONS(237),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(237),
    [sym__number_literal] = ACTIONS(235),
    [anon_sym_SQUOTE] = ACTIONS(237),
    [anon_sym_DQUOTE] = ACTIONS(237),
    [sym_dots] = ACTIONS(235),
    [sym_dot_dot_i] = ACTIONS(235),
    [sym_return] = ACTIONS(235),
    [sym_next] = ACTIONS(235),
    [sym_break] = ACTIONS(235),
    [sym_true] = ACTIONS(235),
    [sym_false] = ACTIONS(235),
    [sym_null] = ACTIONS(235),
    [sym_inf] = ACTIONS(235),
    [sym_nan] = ACTIONS(235),
    [anon_sym_NA] = ACTIONS(235),
    [anon_sym_NA_integer_] = ACTIONS(235),
    [anon_sym_NA_real_] = ACTIONS(235),
    [anon_sym_NA_complex_] = ACTIONS(235),
    [anon_sym_NA_character_] = ACTIONS(235),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(237),
    [sym__semicolon] = ACTIONS(237),
    [sym__raw_string_literal] = ACTIONS(237),
    [sym__external_else] = ACTIONS(237),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(237),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [125] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(237),
    [sym_identifier] = ACTIONS(235),
    [anon_sym_BSLASH] = ACTIONS(237),
    [anon_sym_function] = ACTIONS(235),
    [anon_sym_EQ] = ACTIONS(235),
    [anon_sym_if] = ACTIONS(235),
    [anon_sym_for] = ACTIONS(235),
    [anon_sym_while] = ACTIONS(235),
    [anon_sym_repeat] = ACTIONS(235),
    [anon_sym_QMARK] = ACTIONS(237),
    [anon_sym_TILDE] = ACTIONS(237),
    [anon_sym_BANG] = ACTIONS(235),
    [anon_sym_PLUS] = ACTIONS(237),
    [anon_sym_DASH] = ACTIONS(235),
    [anon_sym_LT_DASH] = ACTIONS(237),
    [anon_sym_LT_LT_DASH] = ACTIONS(237),
    [anon_sym_COLON_EQ] = ACTIONS(237),
    [anon_sym_DASH_GT] = ACTIONS(235),
    [anon_sym_DASH_GT_GT] = ACTIONS(237),
    [anon_sym_PIPE] = ACTIONS(235),
    [anon_sym_AMP] = ACTIONS(235),
    [anon_sym_PIPE_PIPE] = ACTIONS(237),
    [anon_sym_AMP_AMP] = ACTIONS(237),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(235),
    [anon_sym_SLASH] = ACTIONS(237),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(237),
    [anon_sym_PIPE_GT] = ACTIONS(237),
    [anon_sym_COLON] = ACTIONS(235),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(237),
    [sym__number_literal] = ACTIONS(235),
    [anon_sym_SQUOTE] = ACTIONS(237),
    [anon_sym_DQUOTE] = ACTIONS(237),
    [sym_dots] = ACTIONS(235),
    [sym_dot_dot_i] = ACTIONS(235),
    [sym_return] = ACTIONS(235),
    [sym_next] = ACTIONS(235),
    [sym_break] = ACTIONS(235),
    [sym_true] = ACTIONS(235),
    [sym_false] = ACTIONS(235),
    [sym_null] = ACTIONS(235),
    [sym_inf] = ACTIONS(235),
    [sym_nan] = ACTIONS(235),
    [anon_sym_NA] = ACTIONS(235),
    [anon_sym_NA_integer_] = ACTIONS(235),
    [anon_sym_NA_real_] = ACTIONS(235),
    [anon_sym_NA_complex_] = ACTIONS(235),
    [anon_sym_NA_character_] = ACTIONS(235),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(237),
    [sym__semicolon] = ACTIONS(237),
    [sym__raw_string_literal] = ACTIONS(237),
    [sym__external_else] = ACTIONS(237),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(237),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [126] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(241),
    [sym_identifier] = ACTIONS(239),
    [anon_sym_BSLASH] = ACTIONS(241),
    [anon_sym_function] = ACTIONS(239),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(239),
    [anon_sym_for] = ACTIONS(239),
    [anon_sym_while] = ACTIONS(239),
    [anon_sym_repeat] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(239),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(241),
    [sym__number_literal] = ACTIONS(239),
    [anon_sym_SQUOTE] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(241),
    [sym_dots] = ACTIONS(239),
    [sym_dot_dot_i] = ACTIONS(239),
    [sym_return] = ACTIONS(239),
    [sym_next] = ACTIONS(239),
    [sym_break] = ACTIONS(239),
    [sym_true] = ACTIONS(239),
    [sym_false] = ACTIONS(239),
    [sym_null] = ACTIONS(239),
    [sym_inf] = ACTIONS(239),
    [sym_nan] = ACTIONS(239),
    [anon_sym_NA] = ACTIONS(239),
    [anon_sym_NA_integer_] = ACTIONS(239),
    [anon_sym_NA_real_] = ACTIONS(239),
    [anon_sym_NA_complex_] = ACTIONS(239),
    [anon_sym_NA_character_] = ACTIONS(239),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(241),
    [sym__semicolon] = ACTIONS(241),
    [sym__raw_string_literal] = ACTIONS(241),
    [sym__external_else] = ACTIONS(241),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(241),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [127] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(245),
    [sym_identifier] = ACTIONS(243),
    [anon_sym_BSLASH] = ACTIONS(245),
    [anon_sym_function] = ACTIONS(243),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(243),
    [anon_sym_for] = ACTIONS(243),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_repeat] = ACTIONS(243),
    [anon_sym_QMARK] = ACTIONS(245),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(243),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(245),
    [sym__number_literal] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [anon_sym_DQUOTE] = ACTIONS(245),
    [sym_dots] = ACTIONS(243),
    [sym_dot_dot_i] = ACTIONS(243),
    [sym_return] = ACTIONS(243),
    [sym_next] = ACTIONS(243),
    [sym_break] = ACTIONS(243),
    [sym_true] = ACTIONS(243),
    [sym_false] = ACTIONS(243),
    [sym_null] = ACTIONS(243),
    [sym_inf] = ACTIONS(243),
    [sym_nan] = ACTIONS(243),
    [anon_sym_NA] = ACTIONS(243),
    [anon_sym_NA_integer_] = ACTIONS(243),
    [anon_sym_NA_real_] = ACTIONS(243),
    [anon_sym_NA_complex_] = ACTIONS(243),
    [anon_sym_NA_character_] = ACTIONS(243),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(245),
    [sym__semicolon] = ACTIONS(245),
    [sym__raw_string_literal] = ACTIONS(245),
    [sym__external_else] = ACTIONS(245),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(245),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [128] = {
    [sym_call_arguments] = STATE(358),
    [sym_subset_arguments] = STATE(362),
    [sym_subset2_arguments] = STATE(370),
    [sym__open_parenthesis] = STATE(269),
    [sym__open_bracket] = STATE(270),
    [sym__open_bracket2] = STATE(271),
    [ts_builtin_sym_end] = ACTIONS(147),
    [sym_identifier] = ACTIONS(149),
    [anon_sym_BSLASH] = ACTIONS(147),
    [anon_sym_function] = ACTIONS(149),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(149),
    [anon_sym_for] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(149),
    [anon_sym_repeat] = ACTIONS(149),
    [anon_sym_QMARK] = ACTIONS(147),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_LT_DASH] = ACTIONS(19),
    [anon_sym_LT_LT_DASH] = ACTIONS(19),
    [anon_sym_COLON_EQ] = ACTIONS(19),
    [anon_sym_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_GT] = ACTIONS(23),
    [anon_sym_PIPE] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(27),
    [anon_sym_PIPE_PIPE] = ACTIONS(29),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(35),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(35),
    [anon_sym_BANG_EQ] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_STAR_STAR] = ACTIONS(41),
    [anon_sym_CARET] = ACTIONS(41),
    [aux_sym_binary_operator_token1] = ACTIONS(43),
    [anon_sym_PIPE_GT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(47),
    [sym__hex_literal] = ACTIONS(147),
    [sym__number_literal] = ACTIONS(149),
    [anon_sym_SQUOTE] = ACTIONS(147),
    [anon_sym_DQUOTE] = ACTIONS(147),
    [sym_dots] = ACTIONS(149),
    [sym_dot_dot_i] = ACTIONS(149),
    [sym_return] = ACTIONS(149),
    [sym_next] = ACTIONS(149),
    [sym_break] = ACTIONS(149),
    [sym_true] = ACTIONS(149),
    [sym_false] = ACTIONS(149),
    [sym_null] = ACTIONS(149),
    [sym_inf] = ACTIONS(149),
    [sym_nan] = ACTIONS(149),
    [anon_sym_NA] = ACTIONS(149),
    [anon_sym_NA_integer_] = ACTIONS(149),
    [anon_sym_NA_real_] = ACTIONS(149),
    [anon_sym_NA_complex_] = ACTIONS(149),
    [anon_sym_NA_character_] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(147),
    [sym__semicolon] = ACTIONS(147),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(147),
    [sym__external_open_parenthesis] = ACTIONS(51),
    [sym__external_open_brace] = ACTIONS(147),
    [sym__external_open_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(55),
  },
  [129] = {
    [sym_call_arguments] = STATE(339),
    [sym_subset_arguments] = STATE(376),
    [sym_subset2_arguments] = STATE(352),
    [sym__open_parenthesis] = STATE(275),
    [sym__open_bracket] = STATE(276),
    [sym__open_bracket2] = STATE(277),
    [sym_identifier] = ACTIONS(149),
    [anon_sym_BSLASH] = ACTIONS(147),
    [anon_sym_function] = ACTIONS(149),
    [anon_sym_EQ] = ACTIONS(149),
    [anon_sym_if] = ACTIONS(149),
    [anon_sym_for] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(149),
    [anon_sym_repeat] = ACTIONS(149),
    [anon_sym_QMARK] = ACTIONS(147),
    [anon_sym_TILDE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_PLUS] = ACTIONS(79),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(147),
    [anon_sym_LT_LT_DASH] = ACTIONS(147),
    [anon_sym_COLON_EQ] = ACTIONS(147),
    [anon_sym_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_GT] = ACTIONS(147),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(93),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(105),
    [aux_sym_binary_operator_token1] = ACTIONS(107),
    [anon_sym_PIPE_GT] = ACTIONS(107),
    [anon_sym_COLON] = ACTIONS(109),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_AT] = ACTIONS(111),
    [sym__hex_literal] = ACTIONS(147),
    [sym__number_literal] = ACTIONS(149),
    [anon_sym_SQUOTE] = ACTIONS(147),
    [anon_sym_DQUOTE] = ACTIONS(147),
    [sym_dots] = ACTIONS(149),
    [sym_dot_dot_i] = ACTIONS(149),
    [sym_return] = ACTIONS(149),
    [sym_next] = ACTIONS(149),
    [sym_break] = ACTIONS(149),
    [sym_true] = ACTIONS(149),
    [sym_false] = ACTIONS(149),
    [sym_null] = ACTIONS(149),
    [sym_inf] = ACTIONS(149),
    [sym_nan] = ACTIONS(149),
    [anon_sym_NA] = ACTIONS(149),
    [anon_sym_NA_integer_] = ACTIONS(149),
    [anon_sym_NA_real_] = ACTIONS(149),
    [anon_sym_NA_complex_] = ACTIONS(149),
    [anon_sym_NA_character_] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(147),
    [sym__semicolon] = ACTIONS(147),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_else] = ACTIONS(147),
    [sym__external_open_parenthesis] = ACTIONS(115),
    [sym__external_open_brace] = ACTIONS(147),
    [sym__external_close_brace] = ACTIONS(147),
    [sym__external_open_bracket] = ACTIONS(117),
    [sym__external_open_bracket2] = ACTIONS(119),
  },
  [130] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [131] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(239),
    [anon_sym_BSLASH] = ACTIONS(241),
    [anon_sym_function] = ACTIONS(239),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(239),
    [anon_sym_for] = ACTIONS(239),
    [anon_sym_while] = ACTIONS(239),
    [anon_sym_repeat] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(239),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(241),
    [sym__number_literal] = ACTIONS(239),
    [anon_sym_SQUOTE] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(241),
    [sym_dots] = ACTIONS(239),
    [sym_dot_dot_i] = ACTIONS(239),
    [sym_return] = ACTIONS(239),
    [sym_next] = ACTIONS(239),
    [sym_break] = ACTIONS(239),
    [sym_true] = ACTIONS(239),
    [sym_false] = ACTIONS(239),
    [sym_null] = ACTIONS(239),
    [sym_inf] = ACTIONS(239),
    [sym_nan] = ACTIONS(239),
    [anon_sym_NA] = ACTIONS(239),
    [anon_sym_NA_integer_] = ACTIONS(239),
    [anon_sym_NA_real_] = ACTIONS(239),
    [anon_sym_NA_complex_] = ACTIONS(239),
    [anon_sym_NA_character_] = ACTIONS(239),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(241),
    [sym__semicolon] = ACTIONS(241),
    [sym__raw_string_literal] = ACTIONS(241),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(241),
    [sym__external_close_brace] = ACTIONS(241),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [132] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(243),
    [anon_sym_BSLASH] = ACTIONS(245),
    [anon_sym_function] = ACTIONS(243),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(243),
    [anon_sym_for] = ACTIONS(243),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_repeat] = ACTIONS(243),
    [anon_sym_QMARK] = ACTIONS(245),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(243),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(245),
    [sym__number_literal] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [anon_sym_DQUOTE] = ACTIONS(245),
    [sym_dots] = ACTIONS(243),
    [sym_dot_dot_i] = ACTIONS(243),
    [sym_return] = ACTIONS(243),
    [sym_next] = ACTIONS(243),
    [sym_break] = ACTIONS(243),
    [sym_true] = ACTIONS(243),
    [sym_false] = ACTIONS(243),
    [sym_null] = ACTIONS(243),
    [sym_inf] = ACTIONS(243),
    [sym_nan] = ACTIONS(243),
    [anon_sym_NA] = ACTIONS(243),
    [anon_sym_NA_integer_] = ACTIONS(243),
    [anon_sym_NA_real_] = ACTIONS(243),
    [anon_sym_NA_complex_] = ACTIONS(243),
    [anon_sym_NA_character_] = ACTIONS(243),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(245),
    [sym__semicolon] = ACTIONS(245),
    [sym__raw_string_literal] = ACTIONS(245),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(245),
    [sym__external_close_brace] = ACTIONS(245),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [133] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(149),
    [anon_sym_BSLASH] = ACTIONS(147),
    [anon_sym_function] = ACTIONS(149),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(149),
    [anon_sym_for] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(149),
    [anon_sym_repeat] = ACTIONS(149),
    [anon_sym_QMARK] = ACTIONS(147),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(147),
    [sym__number_literal] = ACTIONS(149),
    [anon_sym_SQUOTE] = ACTIONS(147),
    [anon_sym_DQUOTE] = ACTIONS(147),
    [sym_dots] = ACTIONS(149),
    [sym_dot_dot_i] = ACTIONS(149),
    [sym_return] = ACTIONS(149),
    [sym_next] = ACTIONS(149),
    [sym_break] = ACTIONS(149),
    [sym_true] = ACTIONS(149),
    [sym_false] = ACTIONS(149),
    [sym_null] = ACTIONS(149),
    [sym_inf] = ACTIONS(149),
    [sym_nan] = ACTIONS(149),
    [anon_sym_NA] = ACTIONS(149),
    [anon_sym_NA_integer_] = ACTIONS(149),
    [anon_sym_NA_real_] = ACTIONS(149),
    [anon_sym_NA_complex_] = ACTIONS(149),
    [anon_sym_NA_character_] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(147),
    [sym__semicolon] = ACTIONS(147),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(147),
    [sym__external_close_brace] = ACTIONS(147),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [134] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(149),
    [anon_sym_BSLASH] = ACTIONS(147),
    [anon_sym_function] = ACTIONS(149),
    [anon_sym_EQ] = ACTIONS(149),
    [anon_sym_if] = ACTIONS(149),
    [anon_sym_for] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(149),
    [anon_sym_repeat] = ACTIONS(149),
    [anon_sym_QMARK] = ACTIONS(147),
    [anon_sym_TILDE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(147),
    [anon_sym_LT_LT_DASH] = ACTIONS(147),
    [anon_sym_COLON_EQ] = ACTIONS(147),
    [anon_sym_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_GT] = ACTIONS(147),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(147),
    [sym__number_literal] = ACTIONS(149),
    [anon_sym_SQUOTE] = ACTIONS(147),
    [anon_sym_DQUOTE] = ACTIONS(147),
    [sym_dots] = ACTIONS(149),
    [sym_dot_dot_i] = ACTIONS(149),
    [sym_return] = ACTIONS(149),
    [sym_next] = ACTIONS(149),
    [sym_break] = ACTIONS(149),
    [sym_true] = ACTIONS(149),
    [sym_false] = ACTIONS(149),
    [sym_null] = ACTIONS(149),
    [sym_inf] = ACTIONS(149),
    [sym_nan] = ACTIONS(149),
    [anon_sym_NA] = ACTIONS(149),
    [anon_sym_NA_integer_] = ACTIONS(149),
    [anon_sym_NA_real_] = ACTIONS(149),
    [anon_sym_NA_complex_] = ACTIONS(149),
    [anon_sym_NA_character_] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(147),
    [sym__semicolon] = ACTIONS(147),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(147),
    [sym__external_close_brace] = ACTIONS(147),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [135] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(149),
    [anon_sym_BSLASH] = ACTIONS(147),
    [anon_sym_function] = ACTIONS(149),
    [anon_sym_EQ] = ACTIONS(149),
    [anon_sym_if] = ACTIONS(149),
    [anon_sym_for] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(149),
    [anon_sym_repeat] = ACTIONS(149),
    [anon_sym_QMARK] = ACTIONS(147),
    [anon_sym_TILDE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(147),
    [anon_sym_LT_LT_DASH] = ACTIONS(147),
    [anon_sym_COLON_EQ] = ACTIONS(147),
    [anon_sym_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_GT] = ACTIONS(147),
    [anon_sym_PIPE] = ACTIONS(149),
    [anon_sym_AMP] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(147),
    [anon_sym_AMP_AMP] = ACTIONS(147),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(147),
    [sym__number_literal] = ACTIONS(149),
    [anon_sym_SQUOTE] = ACTIONS(147),
    [anon_sym_DQUOTE] = ACTIONS(147),
    [sym_dots] = ACTIONS(149),
    [sym_dot_dot_i] = ACTIONS(149),
    [sym_return] = ACTIONS(149),
    [sym_next] = ACTIONS(149),
    [sym_break] = ACTIONS(149),
    [sym_true] = ACTIONS(149),
    [sym_false] = ACTIONS(149),
    [sym_null] = ACTIONS(149),
    [sym_inf] = ACTIONS(149),
    [sym_nan] = ACTIONS(149),
    [anon_sym_NA] = ACTIONS(149),
    [anon_sym_NA_integer_] = ACTIONS(149),
    [anon_sym_NA_real_] = ACTIONS(149),
    [anon_sym_NA_complex_] = ACTIONS(149),
    [anon_sym_NA_character_] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(147),
    [sym__semicolon] = ACTIONS(147),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(147),
    [sym__external_close_brace] = ACTIONS(147),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [136] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(149),
    [anon_sym_BSLASH] = ACTIONS(147),
    [anon_sym_function] = ACTIONS(149),
    [anon_sym_EQ] = ACTIONS(149),
    [anon_sym_if] = ACTIONS(149),
    [anon_sym_for] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(149),
    [anon_sym_repeat] = ACTIONS(149),
    [anon_sym_QMARK] = ACTIONS(147),
    [anon_sym_TILDE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_PLUS] = ACTIONS(147),
    [anon_sym_DASH] = ACTIONS(149),
    [anon_sym_LT_DASH] = ACTIONS(147),
    [anon_sym_LT_LT_DASH] = ACTIONS(147),
    [anon_sym_COLON_EQ] = ACTIONS(147),
    [anon_sym_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_GT] = ACTIONS(147),
    [anon_sym_PIPE] = ACTIONS(149),
    [anon_sym_AMP] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(147),
    [anon_sym_AMP_AMP] = ACTIONS(147),
    [anon_sym_LT] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(147),
    [anon_sym_GT] = ACTIONS(149),
    [anon_sym_GT_EQ] = ACTIONS(147),
    [anon_sym_EQ_EQ] = ACTIONS(147),
    [anon_sym_BANG_EQ] = ACTIONS(147),
    [anon_sym_STAR] = ACTIONS(149),
    [anon_sym_SLASH] = ACTIONS(147),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(147),
    [anon_sym_PIPE_GT] = ACTIONS(147),
    [anon_sym_COLON] = ACTIONS(149),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(147),
    [sym__number_literal] = ACTIONS(149),
    [anon_sym_SQUOTE] = ACTIONS(147),
    [anon_sym_DQUOTE] = ACTIONS(147),
    [sym_dots] = ACTIONS(149),
    [sym_dot_dot_i] = ACTIONS(149),
    [sym_return] = ACTIONS(149),
    [sym_next] = ACTIONS(149),
    [sym_break] = ACTIONS(149),
    [sym_true] = ACTIONS(149),
    [sym_false] = ACTIONS(149),
    [sym_null] = ACTIONS(149),
    [sym_inf] = ACTIONS(149),
    [sym_nan] = ACTIONS(149),
    [anon_sym_NA] = ACTIONS(149),
    [anon_sym_NA_integer_] = ACTIONS(149),
    [anon_sym_NA_real_] = ACTIONS(149),
    [anon_sym_NA_complex_] = ACTIONS(149),
    [anon_sym_NA_character_] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(147),
    [sym__semicolon] = ACTIONS(147),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(147),
    [sym__external_close_brace] = ACTIONS(147),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [137] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [138] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [139] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [140] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [141] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [142] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [143] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [144] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [145] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(151),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [146] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(151),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(151),
    [anon_sym_PIPE_GT] = ACTIONS(151),
    [anon_sym_COLON] = ACTIONS(153),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [147] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(151),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(151),
    [anon_sym_PIPE_GT] = ACTIONS(151),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [148] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(151),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(151),
    [anon_sym_PIPE_GT] = ACTIONS(151),
    [anon_sym_COLON] = ACTIONS(153),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [149] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_BSLASH] = ACTIONS(155),
    [anon_sym_function] = ACTIONS(157),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(157),
    [anon_sym_repeat] = ACTIONS(157),
    [anon_sym_QMARK] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(155),
    [sym__number_literal] = ACTIONS(157),
    [anon_sym_SQUOTE] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(155),
    [sym_dots] = ACTIONS(157),
    [sym_dot_dot_i] = ACTIONS(157),
    [sym_return] = ACTIONS(157),
    [sym_next] = ACTIONS(157),
    [sym_break] = ACTIONS(157),
    [sym_true] = ACTIONS(157),
    [sym_false] = ACTIONS(157),
    [sym_null] = ACTIONS(157),
    [sym_inf] = ACTIONS(157),
    [sym_nan] = ACTIONS(157),
    [anon_sym_NA] = ACTIONS(157),
    [anon_sym_NA_integer_] = ACTIONS(157),
    [anon_sym_NA_real_] = ACTIONS(157),
    [anon_sym_NA_complex_] = ACTIONS(157),
    [anon_sym_NA_character_] = ACTIONS(157),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(155),
    [sym__semicolon] = ACTIONS(155),
    [sym__raw_string_literal] = ACTIONS(155),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(155),
    [sym__external_close_brace] = ACTIONS(155),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [150] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(161),
    [anon_sym_BSLASH] = ACTIONS(159),
    [anon_sym_function] = ACTIONS(161),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_while] = ACTIONS(161),
    [anon_sym_repeat] = ACTIONS(161),
    [anon_sym_QMARK] = ACTIONS(159),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(159),
    [sym__number_literal] = ACTIONS(161),
    [anon_sym_SQUOTE] = ACTIONS(159),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [sym_dots] = ACTIONS(161),
    [sym_dot_dot_i] = ACTIONS(161),
    [sym_return] = ACTIONS(161),
    [sym_next] = ACTIONS(161),
    [sym_break] = ACTIONS(161),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [sym_null] = ACTIONS(161),
    [sym_inf] = ACTIONS(161),
    [sym_nan] = ACTIONS(161),
    [anon_sym_NA] = ACTIONS(161),
    [anon_sym_NA_integer_] = ACTIONS(161),
    [anon_sym_NA_real_] = ACTIONS(161),
    [anon_sym_NA_complex_] = ACTIONS(161),
    [anon_sym_NA_character_] = ACTIONS(161),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(159),
    [sym__semicolon] = ACTIONS(159),
    [sym__raw_string_literal] = ACTIONS(159),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(159),
    [sym__external_close_brace] = ACTIONS(159),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [151] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [152] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [153] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [154] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(165),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(165),
    [anon_sym_LT_EQ] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(165),
    [anon_sym_GT_EQ] = ACTIONS(163),
    [anon_sym_EQ_EQ] = ACTIONS(163),
    [anon_sym_BANG_EQ] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [155] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [156] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [157] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [158] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [159] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(165),
    [anon_sym_LT_EQ] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(165),
    [anon_sym_GT_EQ] = ACTIONS(163),
    [anon_sym_EQ_EQ] = ACTIONS(163),
    [anon_sym_BANG_EQ] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [160] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(165),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(165),
    [anon_sym_LT_EQ] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(165),
    [anon_sym_GT_EQ] = ACTIONS(163),
    [anon_sym_EQ_EQ] = ACTIONS(163),
    [anon_sym_BANG_EQ] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(165),
    [anon_sym_SLASH] = ACTIONS(163),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [161] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(165),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(165),
    [anon_sym_LT_EQ] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(165),
    [anon_sym_GT_EQ] = ACTIONS(163),
    [anon_sym_EQ_EQ] = ACTIONS(163),
    [anon_sym_BANG_EQ] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(165),
    [anon_sym_SLASH] = ACTIONS(163),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(163),
    [anon_sym_PIPE_GT] = ACTIONS(163),
    [anon_sym_COLON] = ACTIONS(165),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [162] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(165),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(165),
    [anon_sym_LT_EQ] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(165),
    [anon_sym_GT_EQ] = ACTIONS(163),
    [anon_sym_EQ_EQ] = ACTIONS(163),
    [anon_sym_BANG_EQ] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(165),
    [anon_sym_SLASH] = ACTIONS(163),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(163),
    [anon_sym_PIPE_GT] = ACTIONS(163),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [163] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(165),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(165),
    [anon_sym_LT_EQ] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(165),
    [anon_sym_GT_EQ] = ACTIONS(163),
    [anon_sym_EQ_EQ] = ACTIONS(163),
    [anon_sym_BANG_EQ] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(165),
    [anon_sym_SLASH] = ACTIONS(163),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(163),
    [anon_sym_PIPE_GT] = ACTIONS(163),
    [anon_sym_COLON] = ACTIONS(165),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_close_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [164] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(169),
    [anon_sym_BSLASH] = ACTIONS(167),
    [anon_sym_function] = ACTIONS(169),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_repeat] = ACTIONS(169),
    [anon_sym_QMARK] = ACTIONS(167),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(169),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(167),
    [sym__number_literal] = ACTIONS(169),
    [anon_sym_SQUOTE] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(167),
    [sym_dots] = ACTIONS(169),
    [sym_dot_dot_i] = ACTIONS(169),
    [sym_return] = ACTIONS(169),
    [sym_next] = ACTIONS(169),
    [sym_break] = ACTIONS(169),
    [sym_true] = ACTIONS(169),
    [sym_false] = ACTIONS(169),
    [sym_null] = ACTIONS(169),
    [sym_inf] = ACTIONS(169),
    [sym_nan] = ACTIONS(169),
    [anon_sym_NA] = ACTIONS(169),
    [anon_sym_NA_integer_] = ACTIONS(169),
    [anon_sym_NA_real_] = ACTIONS(169),
    [anon_sym_NA_complex_] = ACTIONS(169),
    [anon_sym_NA_character_] = ACTIONS(169),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(167),
    [sym__semicolon] = ACTIONS(167),
    [sym__raw_string_literal] = ACTIONS(167),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(167),
    [sym__external_close_brace] = ACTIONS(167),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [165] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(313),
    [sym_identifier] = ACTIONS(315),
    [anon_sym_BSLASH] = ACTIONS(313),
    [anon_sym_function] = ACTIONS(315),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(315),
    [anon_sym_for] = ACTIONS(315),
    [anon_sym_while] = ACTIONS(315),
    [anon_sym_repeat] = ACTIONS(315),
    [anon_sym_QMARK] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(315),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(313),
    [sym__number_literal] = ACTIONS(315),
    [anon_sym_SQUOTE] = ACTIONS(313),
    [anon_sym_DQUOTE] = ACTIONS(313),
    [sym_dots] = ACTIONS(315),
    [sym_dot_dot_i] = ACTIONS(315),
    [sym_return] = ACTIONS(315),
    [sym_next] = ACTIONS(315),
    [sym_break] = ACTIONS(315),
    [sym_true] = ACTIONS(315),
    [sym_false] = ACTIONS(315),
    [sym_null] = ACTIONS(315),
    [sym_inf] = ACTIONS(315),
    [sym_nan] = ACTIONS(315),
    [anon_sym_NA] = ACTIONS(315),
    [anon_sym_NA_integer_] = ACTIONS(315),
    [anon_sym_NA_real_] = ACTIONS(315),
    [anon_sym_NA_complex_] = ACTIONS(315),
    [anon_sym_NA_character_] = ACTIONS(315),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(313),
    [sym__semicolon] = ACTIONS(313),
    [sym__raw_string_literal] = ACTIONS(313),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(313),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [166] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(173),
    [anon_sym_BSLASH] = ACTIONS(171),
    [anon_sym_function] = ACTIONS(173),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_while] = ACTIONS(173),
    [anon_sym_repeat] = ACTIONS(173),
    [anon_sym_QMARK] = ACTIONS(171),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(173),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(171),
    [sym__number_literal] = ACTIONS(173),
    [anon_sym_SQUOTE] = ACTIONS(171),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [sym_dots] = ACTIONS(173),
    [sym_dot_dot_i] = ACTIONS(173),
    [sym_return] = ACTIONS(173),
    [sym_next] = ACTIONS(173),
    [sym_break] = ACTIONS(173),
    [sym_true] = ACTIONS(173),
    [sym_false] = ACTIONS(173),
    [sym_null] = ACTIONS(173),
    [sym_inf] = ACTIONS(173),
    [sym_nan] = ACTIONS(173),
    [anon_sym_NA] = ACTIONS(173),
    [anon_sym_NA_integer_] = ACTIONS(173),
    [anon_sym_NA_real_] = ACTIONS(173),
    [anon_sym_NA_complex_] = ACTIONS(173),
    [anon_sym_NA_character_] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(171),
    [sym__semicolon] = ACTIONS(171),
    [sym__raw_string_literal] = ACTIONS(171),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(171),
    [sym__external_close_brace] = ACTIONS(171),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [167] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(177),
    [anon_sym_BSLASH] = ACTIONS(175),
    [anon_sym_function] = ACTIONS(177),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(177),
    [anon_sym_for] = ACTIONS(177),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_repeat] = ACTIONS(177),
    [anon_sym_QMARK] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(177),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(175),
    [sym__number_literal] = ACTIONS(177),
    [anon_sym_SQUOTE] = ACTIONS(175),
    [anon_sym_DQUOTE] = ACTIONS(175),
    [sym_dots] = ACTIONS(177),
    [sym_dot_dot_i] = ACTIONS(177),
    [sym_return] = ACTIONS(177),
    [sym_next] = ACTIONS(177),
    [sym_break] = ACTIONS(177),
    [sym_true] = ACTIONS(177),
    [sym_false] = ACTIONS(177),
    [sym_null] = ACTIONS(177),
    [sym_inf] = ACTIONS(177),
    [sym_nan] = ACTIONS(177),
    [anon_sym_NA] = ACTIONS(177),
    [anon_sym_NA_integer_] = ACTIONS(177),
    [anon_sym_NA_real_] = ACTIONS(177),
    [anon_sym_NA_complex_] = ACTIONS(177),
    [anon_sym_NA_character_] = ACTIONS(177),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(175),
    [sym__semicolon] = ACTIONS(175),
    [sym__raw_string_literal] = ACTIONS(175),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(175),
    [sym__external_close_brace] = ACTIONS(175),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [168] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(181),
    [anon_sym_BSLASH] = ACTIONS(179),
    [anon_sym_function] = ACTIONS(181),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(181),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_repeat] = ACTIONS(181),
    [anon_sym_QMARK] = ACTIONS(179),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(181),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(179),
    [sym__number_literal] = ACTIONS(181),
    [anon_sym_SQUOTE] = ACTIONS(179),
    [anon_sym_DQUOTE] = ACTIONS(179),
    [sym_dots] = ACTIONS(181),
    [sym_dot_dot_i] = ACTIONS(181),
    [sym_return] = ACTIONS(181),
    [sym_next] = ACTIONS(181),
    [sym_break] = ACTIONS(181),
    [sym_true] = ACTIONS(181),
    [sym_false] = ACTIONS(181),
    [sym_null] = ACTIONS(181),
    [sym_inf] = ACTIONS(181),
    [sym_nan] = ACTIONS(181),
    [anon_sym_NA] = ACTIONS(181),
    [anon_sym_NA_integer_] = ACTIONS(181),
    [anon_sym_NA_real_] = ACTIONS(181),
    [anon_sym_NA_complex_] = ACTIONS(181),
    [anon_sym_NA_character_] = ACTIONS(181),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(179),
    [sym__semicolon] = ACTIONS(179),
    [sym__raw_string_literal] = ACTIONS(179),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(179),
    [sym__external_close_brace] = ACTIONS(179),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [169] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(185),
    [anon_sym_BSLASH] = ACTIONS(183),
    [anon_sym_function] = ACTIONS(185),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(185),
    [anon_sym_for] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(185),
    [anon_sym_repeat] = ACTIONS(185),
    [anon_sym_QMARK] = ACTIONS(183),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(185),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(183),
    [sym__number_literal] = ACTIONS(185),
    [anon_sym_SQUOTE] = ACTIONS(183),
    [anon_sym_DQUOTE] = ACTIONS(183),
    [sym_dots] = ACTIONS(185),
    [sym_dot_dot_i] = ACTIONS(185),
    [sym_return] = ACTIONS(185),
    [sym_next] = ACTIONS(185),
    [sym_break] = ACTIONS(185),
    [sym_true] = ACTIONS(185),
    [sym_false] = ACTIONS(185),
    [sym_null] = ACTIONS(185),
    [sym_inf] = ACTIONS(185),
    [sym_nan] = ACTIONS(185),
    [anon_sym_NA] = ACTIONS(185),
    [anon_sym_NA_integer_] = ACTIONS(185),
    [anon_sym_NA_real_] = ACTIONS(185),
    [anon_sym_NA_complex_] = ACTIONS(185),
    [anon_sym_NA_character_] = ACTIONS(185),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(183),
    [sym__semicolon] = ACTIONS(183),
    [sym__raw_string_literal] = ACTIONS(183),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(183),
    [sym__external_close_brace] = ACTIONS(183),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [170] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(233),
    [sym_identifier] = ACTIONS(231),
    [anon_sym_BSLASH] = ACTIONS(233),
    [anon_sym_function] = ACTIONS(231),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(231),
    [anon_sym_for] = ACTIONS(231),
    [anon_sym_while] = ACTIONS(231),
    [anon_sym_repeat] = ACTIONS(231),
    [anon_sym_QMARK] = ACTIONS(233),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(231),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(233),
    [sym__number_literal] = ACTIONS(231),
    [anon_sym_SQUOTE] = ACTIONS(233),
    [anon_sym_DQUOTE] = ACTIONS(233),
    [sym_dots] = ACTIONS(231),
    [sym_dot_dot_i] = ACTIONS(231),
    [sym_return] = ACTIONS(231),
    [sym_next] = ACTIONS(231),
    [sym_break] = ACTIONS(231),
    [sym_true] = ACTIONS(231),
    [sym_false] = ACTIONS(231),
    [sym_null] = ACTIONS(231),
    [sym_inf] = ACTIONS(231),
    [sym_nan] = ACTIONS(231),
    [anon_sym_NA] = ACTIONS(231),
    [anon_sym_NA_integer_] = ACTIONS(231),
    [anon_sym_NA_real_] = ACTIONS(231),
    [anon_sym_NA_complex_] = ACTIONS(231),
    [anon_sym_NA_character_] = ACTIONS(231),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(233),
    [sym__semicolon] = ACTIONS(233),
    [sym__raw_string_literal] = ACTIONS(233),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(233),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [171] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(189),
    [anon_sym_BSLASH] = ACTIONS(187),
    [anon_sym_function] = ACTIONS(189),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(189),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(189),
    [anon_sym_repeat] = ACTIONS(189),
    [anon_sym_QMARK] = ACTIONS(187),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(189),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(187),
    [sym__number_literal] = ACTIONS(189),
    [anon_sym_SQUOTE] = ACTIONS(187),
    [anon_sym_DQUOTE] = ACTIONS(187),
    [sym_dots] = ACTIONS(189),
    [sym_dot_dot_i] = ACTIONS(189),
    [sym_return] = ACTIONS(189),
    [sym_next] = ACTIONS(189),
    [sym_break] = ACTIONS(189),
    [sym_true] = ACTIONS(189),
    [sym_false] = ACTIONS(189),
    [sym_null] = ACTIONS(189),
    [sym_inf] = ACTIONS(189),
    [sym_nan] = ACTIONS(189),
    [anon_sym_NA] = ACTIONS(189),
    [anon_sym_NA_integer_] = ACTIONS(189),
    [anon_sym_NA_real_] = ACTIONS(189),
    [anon_sym_NA_complex_] = ACTIONS(189),
    [anon_sym_NA_character_] = ACTIONS(189),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(187),
    [sym__semicolon] = ACTIONS(187),
    [sym__raw_string_literal] = ACTIONS(187),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(187),
    [sym__external_close_brace] = ACTIONS(187),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [172] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(193),
    [anon_sym_BSLASH] = ACTIONS(191),
    [anon_sym_function] = ACTIONS(193),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(193),
    [anon_sym_for] = ACTIONS(193),
    [anon_sym_while] = ACTIONS(193),
    [anon_sym_repeat] = ACTIONS(193),
    [anon_sym_QMARK] = ACTIONS(191),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(193),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(191),
    [sym__number_literal] = ACTIONS(193),
    [anon_sym_SQUOTE] = ACTIONS(191),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_dots] = ACTIONS(193),
    [sym_dot_dot_i] = ACTIONS(193),
    [sym_return] = ACTIONS(193),
    [sym_next] = ACTIONS(193),
    [sym_break] = ACTIONS(193),
    [sym_true] = ACTIONS(193),
    [sym_false] = ACTIONS(193),
    [sym_null] = ACTIONS(193),
    [sym_inf] = ACTIONS(193),
    [sym_nan] = ACTIONS(193),
    [anon_sym_NA] = ACTIONS(193),
    [anon_sym_NA_integer_] = ACTIONS(193),
    [anon_sym_NA_real_] = ACTIONS(193),
    [anon_sym_NA_complex_] = ACTIONS(193),
    [anon_sym_NA_character_] = ACTIONS(193),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(191),
    [sym__semicolon] = ACTIONS(191),
    [sym__raw_string_literal] = ACTIONS(191),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(191),
    [sym__external_close_brace] = ACTIONS(191),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [173] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(197),
    [anon_sym_BSLASH] = ACTIONS(195),
    [anon_sym_function] = ACTIONS(197),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_for] = ACTIONS(197),
    [anon_sym_while] = ACTIONS(197),
    [anon_sym_repeat] = ACTIONS(197),
    [anon_sym_QMARK] = ACTIONS(195),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(197),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(195),
    [sym__number_literal] = ACTIONS(197),
    [anon_sym_SQUOTE] = ACTIONS(195),
    [anon_sym_DQUOTE] = ACTIONS(195),
    [sym_dots] = ACTIONS(197),
    [sym_dot_dot_i] = ACTIONS(197),
    [sym_return] = ACTIONS(197),
    [sym_next] = ACTIONS(197),
    [sym_break] = ACTIONS(197),
    [sym_true] = ACTIONS(197),
    [sym_false] = ACTIONS(197),
    [sym_null] = ACTIONS(197),
    [sym_inf] = ACTIONS(197),
    [sym_nan] = ACTIONS(197),
    [anon_sym_NA] = ACTIONS(197),
    [anon_sym_NA_integer_] = ACTIONS(197),
    [anon_sym_NA_real_] = ACTIONS(197),
    [anon_sym_NA_complex_] = ACTIONS(197),
    [anon_sym_NA_character_] = ACTIONS(197),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(195),
    [sym__semicolon] = ACTIONS(195),
    [sym__raw_string_literal] = ACTIONS(195),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(195),
    [sym__external_close_brace] = ACTIONS(195),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [174] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(201),
    [anon_sym_BSLASH] = ACTIONS(199),
    [anon_sym_function] = ACTIONS(201),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(201),
    [anon_sym_for] = ACTIONS(201),
    [anon_sym_while] = ACTIONS(201),
    [anon_sym_repeat] = ACTIONS(201),
    [anon_sym_QMARK] = ACTIONS(199),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(199),
    [sym__number_literal] = ACTIONS(201),
    [anon_sym_SQUOTE] = ACTIONS(199),
    [anon_sym_DQUOTE] = ACTIONS(199),
    [sym_dots] = ACTIONS(201),
    [sym_dot_dot_i] = ACTIONS(201),
    [sym_return] = ACTIONS(201),
    [sym_next] = ACTIONS(201),
    [sym_break] = ACTIONS(201),
    [sym_true] = ACTIONS(201),
    [sym_false] = ACTIONS(201),
    [sym_null] = ACTIONS(201),
    [sym_inf] = ACTIONS(201),
    [sym_nan] = ACTIONS(201),
    [anon_sym_NA] = ACTIONS(201),
    [anon_sym_NA_integer_] = ACTIONS(201),
    [anon_sym_NA_real_] = ACTIONS(201),
    [anon_sym_NA_complex_] = ACTIONS(201),
    [anon_sym_NA_character_] = ACTIONS(201),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(199),
    [sym__semicolon] = ACTIONS(199),
    [sym__raw_string_literal] = ACTIONS(199),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(199),
    [sym__external_close_brace] = ACTIONS(199),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [175] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(205),
    [anon_sym_BSLASH] = ACTIONS(203),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(205),
    [anon_sym_while] = ACTIONS(205),
    [anon_sym_repeat] = ACTIONS(205),
    [anon_sym_QMARK] = ACTIONS(203),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(205),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(203),
    [sym__number_literal] = ACTIONS(205),
    [anon_sym_SQUOTE] = ACTIONS(203),
    [anon_sym_DQUOTE] = ACTIONS(203),
    [sym_dots] = ACTIONS(205),
    [sym_dot_dot_i] = ACTIONS(205),
    [sym_return] = ACTIONS(205),
    [sym_next] = ACTIONS(205),
    [sym_break] = ACTIONS(205),
    [sym_true] = ACTIONS(205),
    [sym_false] = ACTIONS(205),
    [sym_null] = ACTIONS(205),
    [sym_inf] = ACTIONS(205),
    [sym_nan] = ACTIONS(205),
    [anon_sym_NA] = ACTIONS(205),
    [anon_sym_NA_integer_] = ACTIONS(205),
    [anon_sym_NA_real_] = ACTIONS(205),
    [anon_sym_NA_complex_] = ACTIONS(205),
    [anon_sym_NA_character_] = ACTIONS(205),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(203),
    [sym__semicolon] = ACTIONS(203),
    [sym__raw_string_literal] = ACTIONS(203),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(203),
    [sym__external_close_brace] = ACTIONS(203),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [176] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(209),
    [anon_sym_BSLASH] = ACTIONS(207),
    [anon_sym_function] = ACTIONS(209),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(209),
    [anon_sym_for] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(209),
    [anon_sym_repeat] = ACTIONS(209),
    [anon_sym_QMARK] = ACTIONS(207),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(207),
    [sym__number_literal] = ACTIONS(209),
    [anon_sym_SQUOTE] = ACTIONS(207),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [sym_dots] = ACTIONS(209),
    [sym_dot_dot_i] = ACTIONS(209),
    [sym_return] = ACTIONS(209),
    [sym_next] = ACTIONS(209),
    [sym_break] = ACTIONS(209),
    [sym_true] = ACTIONS(209),
    [sym_false] = ACTIONS(209),
    [sym_null] = ACTIONS(209),
    [sym_inf] = ACTIONS(209),
    [sym_nan] = ACTIONS(209),
    [anon_sym_NA] = ACTIONS(209),
    [anon_sym_NA_integer_] = ACTIONS(209),
    [anon_sym_NA_real_] = ACTIONS(209),
    [anon_sym_NA_complex_] = ACTIONS(209),
    [anon_sym_NA_character_] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(207),
    [sym__semicolon] = ACTIONS(207),
    [sym__raw_string_literal] = ACTIONS(207),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_close_brace] = ACTIONS(207),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [177] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(213),
    [anon_sym_BSLASH] = ACTIONS(211),
    [anon_sym_function] = ACTIONS(213),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(213),
    [anon_sym_while] = ACTIONS(213),
    [anon_sym_repeat] = ACTIONS(213),
    [anon_sym_QMARK] = ACTIONS(211),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(211),
    [sym__number_literal] = ACTIONS(213),
    [anon_sym_SQUOTE] = ACTIONS(211),
    [anon_sym_DQUOTE] = ACTIONS(211),
    [sym_dots] = ACTIONS(213),
    [sym_dot_dot_i] = ACTIONS(213),
    [sym_return] = ACTIONS(213),
    [sym_next] = ACTIONS(213),
    [sym_break] = ACTIONS(213),
    [sym_true] = ACTIONS(213),
    [sym_false] = ACTIONS(213),
    [sym_null] = ACTIONS(213),
    [sym_inf] = ACTIONS(213),
    [sym_nan] = ACTIONS(213),
    [anon_sym_NA] = ACTIONS(213),
    [anon_sym_NA_integer_] = ACTIONS(213),
    [anon_sym_NA_real_] = ACTIONS(213),
    [anon_sym_NA_complex_] = ACTIONS(213),
    [anon_sym_NA_character_] = ACTIONS(213),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(211),
    [sym__semicolon] = ACTIONS(211),
    [sym__raw_string_literal] = ACTIONS(211),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(211),
    [sym__external_close_brace] = ACTIONS(211),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [178] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(217),
    [anon_sym_BSLASH] = ACTIONS(215),
    [anon_sym_function] = ACTIONS(217),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(217),
    [anon_sym_for] = ACTIONS(217),
    [anon_sym_while] = ACTIONS(217),
    [anon_sym_repeat] = ACTIONS(217),
    [anon_sym_QMARK] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(217),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(215),
    [sym__number_literal] = ACTIONS(217),
    [anon_sym_SQUOTE] = ACTIONS(215),
    [anon_sym_DQUOTE] = ACTIONS(215),
    [sym_dots] = ACTIONS(217),
    [sym_dot_dot_i] = ACTIONS(217),
    [sym_return] = ACTIONS(217),
    [sym_next] = ACTIONS(217),
    [sym_break] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_inf] = ACTIONS(217),
    [sym_nan] = ACTIONS(217),
    [anon_sym_NA] = ACTIONS(217),
    [anon_sym_NA_integer_] = ACTIONS(217),
    [anon_sym_NA_real_] = ACTIONS(217),
    [anon_sym_NA_complex_] = ACTIONS(217),
    [anon_sym_NA_character_] = ACTIONS(217),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(215),
    [sym__semicolon] = ACTIONS(215),
    [sym__raw_string_literal] = ACTIONS(215),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(215),
    [sym__external_close_brace] = ACTIONS(215),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [179] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(221),
    [anon_sym_BSLASH] = ACTIONS(219),
    [anon_sym_function] = ACTIONS(221),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(221),
    [anon_sym_for] = ACTIONS(221),
    [anon_sym_while] = ACTIONS(221),
    [anon_sym_repeat] = ACTIONS(221),
    [anon_sym_QMARK] = ACTIONS(219),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(219),
    [sym__number_literal] = ACTIONS(221),
    [anon_sym_SQUOTE] = ACTIONS(219),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_dots] = ACTIONS(221),
    [sym_dot_dot_i] = ACTIONS(221),
    [sym_return] = ACTIONS(221),
    [sym_next] = ACTIONS(221),
    [sym_break] = ACTIONS(221),
    [sym_true] = ACTIONS(221),
    [sym_false] = ACTIONS(221),
    [sym_null] = ACTIONS(221),
    [sym_inf] = ACTIONS(221),
    [sym_nan] = ACTIONS(221),
    [anon_sym_NA] = ACTIONS(221),
    [anon_sym_NA_integer_] = ACTIONS(221),
    [anon_sym_NA_real_] = ACTIONS(221),
    [anon_sym_NA_complex_] = ACTIONS(221),
    [anon_sym_NA_character_] = ACTIONS(221),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(219),
    [sym__semicolon] = ACTIONS(219),
    [sym__raw_string_literal] = ACTIONS(219),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(219),
    [sym__external_close_brace] = ACTIONS(219),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [180] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(143),
    [anon_sym_BSLASH] = ACTIONS(145),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_repeat] = ACTIONS(143),
    [anon_sym_QMARK] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(143),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(145),
    [sym__number_literal] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [anon_sym_DQUOTE] = ACTIONS(145),
    [sym_dots] = ACTIONS(143),
    [sym_dot_dot_i] = ACTIONS(143),
    [sym_return] = ACTIONS(143),
    [sym_next] = ACTIONS(143),
    [sym_break] = ACTIONS(143),
    [sym_true] = ACTIONS(143),
    [sym_false] = ACTIONS(143),
    [sym_null] = ACTIONS(143),
    [sym_inf] = ACTIONS(143),
    [sym_nan] = ACTIONS(143),
    [anon_sym_NA] = ACTIONS(143),
    [anon_sym_NA_integer_] = ACTIONS(143),
    [anon_sym_NA_real_] = ACTIONS(143),
    [anon_sym_NA_complex_] = ACTIONS(143),
    [anon_sym_NA_character_] = ACTIONS(143),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(145),
    [sym__semicolon] = ACTIONS(145),
    [sym__raw_string_literal] = ACTIONS(145),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(145),
    [sym__external_close_brace] = ACTIONS(145),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [181] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(225),
    [anon_sym_BSLASH] = ACTIONS(223),
    [anon_sym_function] = ACTIONS(225),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(225),
    [anon_sym_for] = ACTIONS(225),
    [anon_sym_while] = ACTIONS(225),
    [anon_sym_repeat] = ACTIONS(225),
    [anon_sym_QMARK] = ACTIONS(223),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(223),
    [sym__number_literal] = ACTIONS(225),
    [anon_sym_SQUOTE] = ACTIONS(223),
    [anon_sym_DQUOTE] = ACTIONS(223),
    [sym_dots] = ACTIONS(225),
    [sym_dot_dot_i] = ACTIONS(225),
    [sym_return] = ACTIONS(225),
    [sym_next] = ACTIONS(225),
    [sym_break] = ACTIONS(225),
    [sym_true] = ACTIONS(225),
    [sym_false] = ACTIONS(225),
    [sym_null] = ACTIONS(225),
    [sym_inf] = ACTIONS(225),
    [sym_nan] = ACTIONS(225),
    [anon_sym_NA] = ACTIONS(225),
    [anon_sym_NA_integer_] = ACTIONS(225),
    [anon_sym_NA_real_] = ACTIONS(225),
    [anon_sym_NA_complex_] = ACTIONS(225),
    [anon_sym_NA_character_] = ACTIONS(225),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(223),
    [sym__semicolon] = ACTIONS(223),
    [sym__raw_string_literal] = ACTIONS(223),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(223),
    [sym__external_close_brace] = ACTIONS(223),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [182] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(229),
    [anon_sym_BSLASH] = ACTIONS(227),
    [anon_sym_function] = ACTIONS(229),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(229),
    [anon_sym_for] = ACTIONS(229),
    [anon_sym_while] = ACTIONS(229),
    [anon_sym_repeat] = ACTIONS(229),
    [anon_sym_QMARK] = ACTIONS(227),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(229),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(227),
    [sym__number_literal] = ACTIONS(229),
    [anon_sym_SQUOTE] = ACTIONS(227),
    [anon_sym_DQUOTE] = ACTIONS(227),
    [sym_dots] = ACTIONS(229),
    [sym_dot_dot_i] = ACTIONS(229),
    [sym_return] = ACTIONS(229),
    [sym_next] = ACTIONS(229),
    [sym_break] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_inf] = ACTIONS(229),
    [sym_nan] = ACTIONS(229),
    [anon_sym_NA] = ACTIONS(229),
    [anon_sym_NA_integer_] = ACTIONS(229),
    [anon_sym_NA_real_] = ACTIONS(229),
    [anon_sym_NA_complex_] = ACTIONS(229),
    [anon_sym_NA_character_] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(227),
    [sym__semicolon] = ACTIONS(227),
    [sym__raw_string_literal] = ACTIONS(227),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(227),
    [sym__external_close_brace] = ACTIONS(227),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [183] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(237),
    [sym_identifier] = ACTIONS(235),
    [anon_sym_BSLASH] = ACTIONS(237),
    [anon_sym_function] = ACTIONS(235),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(235),
    [anon_sym_for] = ACTIONS(235),
    [anon_sym_while] = ACTIONS(235),
    [anon_sym_repeat] = ACTIONS(235),
    [anon_sym_QMARK] = ACTIONS(237),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(235),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(237),
    [sym__number_literal] = ACTIONS(235),
    [anon_sym_SQUOTE] = ACTIONS(237),
    [anon_sym_DQUOTE] = ACTIONS(237),
    [sym_dots] = ACTIONS(235),
    [sym_dot_dot_i] = ACTIONS(235),
    [sym_return] = ACTIONS(235),
    [sym_next] = ACTIONS(235),
    [sym_break] = ACTIONS(235),
    [sym_true] = ACTIONS(235),
    [sym_false] = ACTIONS(235),
    [sym_null] = ACTIONS(235),
    [sym_inf] = ACTIONS(235),
    [sym_nan] = ACTIONS(235),
    [anon_sym_NA] = ACTIONS(235),
    [anon_sym_NA_integer_] = ACTIONS(235),
    [anon_sym_NA_real_] = ACTIONS(235),
    [anon_sym_NA_complex_] = ACTIONS(235),
    [anon_sym_NA_character_] = ACTIONS(235),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(237),
    [sym__semicolon] = ACTIONS(237),
    [sym__raw_string_literal] = ACTIONS(237),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(237),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [184] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(237),
    [sym_identifier] = ACTIONS(235),
    [anon_sym_BSLASH] = ACTIONS(237),
    [anon_sym_function] = ACTIONS(235),
    [anon_sym_EQ] = ACTIONS(235),
    [anon_sym_if] = ACTIONS(235),
    [anon_sym_for] = ACTIONS(235),
    [anon_sym_while] = ACTIONS(235),
    [anon_sym_repeat] = ACTIONS(235),
    [anon_sym_QMARK] = ACTIONS(237),
    [anon_sym_TILDE] = ACTIONS(237),
    [anon_sym_BANG] = ACTIONS(235),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(237),
    [anon_sym_LT_LT_DASH] = ACTIONS(237),
    [anon_sym_COLON_EQ] = ACTIONS(237),
    [anon_sym_DASH_GT] = ACTIONS(235),
    [anon_sym_DASH_GT_GT] = ACTIONS(237),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(237),
    [sym__number_literal] = ACTIONS(235),
    [anon_sym_SQUOTE] = ACTIONS(237),
    [anon_sym_DQUOTE] = ACTIONS(237),
    [sym_dots] = ACTIONS(235),
    [sym_dot_dot_i] = ACTIONS(235),
    [sym_return] = ACTIONS(235),
    [sym_next] = ACTIONS(235),
    [sym_break] = ACTIONS(235),
    [sym_true] = ACTIONS(235),
    [sym_false] = ACTIONS(235),
    [sym_null] = ACTIONS(235),
    [sym_inf] = ACTIONS(235),
    [sym_nan] = ACTIONS(235),
    [anon_sym_NA] = ACTIONS(235),
    [anon_sym_NA_integer_] = ACTIONS(235),
    [anon_sym_NA_real_] = ACTIONS(235),
    [anon_sym_NA_complex_] = ACTIONS(235),
    [anon_sym_NA_character_] = ACTIONS(235),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(237),
    [sym__semicolon] = ACTIONS(237),
    [sym__raw_string_literal] = ACTIONS(237),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(237),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [185] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(237),
    [sym_identifier] = ACTIONS(235),
    [anon_sym_BSLASH] = ACTIONS(237),
    [anon_sym_function] = ACTIONS(235),
    [anon_sym_EQ] = ACTIONS(235),
    [anon_sym_if] = ACTIONS(235),
    [anon_sym_for] = ACTIONS(235),
    [anon_sym_while] = ACTIONS(235),
    [anon_sym_repeat] = ACTIONS(235),
    [anon_sym_QMARK] = ACTIONS(237),
    [anon_sym_TILDE] = ACTIONS(237),
    [anon_sym_BANG] = ACTIONS(235),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(237),
    [anon_sym_LT_LT_DASH] = ACTIONS(237),
    [anon_sym_COLON_EQ] = ACTIONS(237),
    [anon_sym_DASH_GT] = ACTIONS(235),
    [anon_sym_DASH_GT_GT] = ACTIONS(237),
    [anon_sym_PIPE] = ACTIONS(235),
    [anon_sym_AMP] = ACTIONS(235),
    [anon_sym_PIPE_PIPE] = ACTIONS(237),
    [anon_sym_AMP_AMP] = ACTIONS(237),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(237),
    [sym__number_literal] = ACTIONS(235),
    [anon_sym_SQUOTE] = ACTIONS(237),
    [anon_sym_DQUOTE] = ACTIONS(237),
    [sym_dots] = ACTIONS(235),
    [sym_dot_dot_i] = ACTIONS(235),
    [sym_return] = ACTIONS(235),
    [sym_next] = ACTIONS(235),
    [sym_break] = ACTIONS(235),
    [sym_true] = ACTIONS(235),
    [sym_false] = ACTIONS(235),
    [sym_null] = ACTIONS(235),
    [sym_inf] = ACTIONS(235),
    [sym_nan] = ACTIONS(235),
    [anon_sym_NA] = ACTIONS(235),
    [anon_sym_NA_integer_] = ACTIONS(235),
    [anon_sym_NA_real_] = ACTIONS(235),
    [anon_sym_NA_complex_] = ACTIONS(235),
    [anon_sym_NA_character_] = ACTIONS(235),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(237),
    [sym__semicolon] = ACTIONS(237),
    [sym__raw_string_literal] = ACTIONS(237),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(237),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [186] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(237),
    [sym_identifier] = ACTIONS(235),
    [anon_sym_BSLASH] = ACTIONS(237),
    [anon_sym_function] = ACTIONS(235),
    [anon_sym_EQ] = ACTIONS(235),
    [anon_sym_if] = ACTIONS(235),
    [anon_sym_for] = ACTIONS(235),
    [anon_sym_while] = ACTIONS(235),
    [anon_sym_repeat] = ACTIONS(235),
    [anon_sym_QMARK] = ACTIONS(237),
    [anon_sym_TILDE] = ACTIONS(237),
    [anon_sym_BANG] = ACTIONS(235),
    [anon_sym_PLUS] = ACTIONS(237),
    [anon_sym_DASH] = ACTIONS(235),
    [anon_sym_LT_DASH] = ACTIONS(237),
    [anon_sym_LT_LT_DASH] = ACTIONS(237),
    [anon_sym_COLON_EQ] = ACTIONS(237),
    [anon_sym_DASH_GT] = ACTIONS(235),
    [anon_sym_DASH_GT_GT] = ACTIONS(237),
    [anon_sym_PIPE] = ACTIONS(235),
    [anon_sym_AMP] = ACTIONS(235),
    [anon_sym_PIPE_PIPE] = ACTIONS(237),
    [anon_sym_AMP_AMP] = ACTIONS(237),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(235),
    [anon_sym_SLASH] = ACTIONS(237),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(237),
    [anon_sym_PIPE_GT] = ACTIONS(237),
    [anon_sym_COLON] = ACTIONS(235),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(237),
    [sym__number_literal] = ACTIONS(235),
    [anon_sym_SQUOTE] = ACTIONS(237),
    [anon_sym_DQUOTE] = ACTIONS(237),
    [sym_dots] = ACTIONS(235),
    [sym_dot_dot_i] = ACTIONS(235),
    [sym_return] = ACTIONS(235),
    [sym_next] = ACTIONS(235),
    [sym_break] = ACTIONS(235),
    [sym_true] = ACTIONS(235),
    [sym_false] = ACTIONS(235),
    [sym_null] = ACTIONS(235),
    [sym_inf] = ACTIONS(235),
    [sym_nan] = ACTIONS(235),
    [anon_sym_NA] = ACTIONS(235),
    [anon_sym_NA_integer_] = ACTIONS(235),
    [anon_sym_NA_real_] = ACTIONS(235),
    [anon_sym_NA_complex_] = ACTIONS(235),
    [anon_sym_NA_character_] = ACTIONS(235),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(237),
    [sym__semicolon] = ACTIONS(237),
    [sym__raw_string_literal] = ACTIONS(237),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(237),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [187] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(341),
    [anon_sym_BSLASH] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(341),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_for] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(341),
    [anon_sym_repeat] = ACTIONS(341),
    [anon_sym_QMARK] = ACTIONS(345),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(341),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(343),
    [sym__number_literal] = ACTIONS(341),
    [anon_sym_SQUOTE] = ACTIONS(343),
    [anon_sym_DQUOTE] = ACTIONS(343),
    [sym_dots] = ACTIONS(341),
    [sym_dot_dot_i] = ACTIONS(341),
    [sym_return] = ACTIONS(341),
    [sym_next] = ACTIONS(341),
    [sym_break] = ACTIONS(341),
    [sym_true] = ACTIONS(341),
    [sym_false] = ACTIONS(341),
    [sym_null] = ACTIONS(341),
    [sym_inf] = ACTIONS(341),
    [sym_nan] = ACTIONS(341),
    [anon_sym_NA] = ACTIONS(341),
    [anon_sym_NA_integer_] = ACTIONS(341),
    [anon_sym_NA_real_] = ACTIONS(341),
    [anon_sym_NA_complex_] = ACTIONS(341),
    [anon_sym_NA_character_] = ACTIONS(341),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(343),
    [sym__semicolon] = ACTIONS(343),
    [sym__raw_string_literal] = ACTIONS(343),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(343),
    [sym__external_close_brace] = ACTIONS(343),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [188] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(241),
    [sym_identifier] = ACTIONS(239),
    [anon_sym_BSLASH] = ACTIONS(241),
    [anon_sym_function] = ACTIONS(239),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(239),
    [anon_sym_for] = ACTIONS(239),
    [anon_sym_while] = ACTIONS(239),
    [anon_sym_repeat] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(239),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(241),
    [sym__number_literal] = ACTIONS(239),
    [anon_sym_SQUOTE] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(241),
    [sym_dots] = ACTIONS(239),
    [sym_dot_dot_i] = ACTIONS(239),
    [sym_return] = ACTIONS(239),
    [sym_next] = ACTIONS(239),
    [sym_break] = ACTIONS(239),
    [sym_true] = ACTIONS(239),
    [sym_false] = ACTIONS(239),
    [sym_null] = ACTIONS(239),
    [sym_inf] = ACTIONS(239),
    [sym_nan] = ACTIONS(239),
    [anon_sym_NA] = ACTIONS(239),
    [anon_sym_NA_integer_] = ACTIONS(239),
    [anon_sym_NA_real_] = ACTIONS(239),
    [anon_sym_NA_complex_] = ACTIONS(239),
    [anon_sym_NA_character_] = ACTIONS(239),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(241),
    [sym__semicolon] = ACTIONS(241),
    [sym__raw_string_literal] = ACTIONS(241),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(241),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [189] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(245),
    [sym_identifier] = ACTIONS(243),
    [anon_sym_BSLASH] = ACTIONS(245),
    [anon_sym_function] = ACTIONS(243),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(243),
    [anon_sym_for] = ACTIONS(243),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_repeat] = ACTIONS(243),
    [anon_sym_QMARK] = ACTIONS(245),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(243),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(245),
    [sym__number_literal] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [anon_sym_DQUOTE] = ACTIONS(245),
    [sym_dots] = ACTIONS(243),
    [sym_dot_dot_i] = ACTIONS(243),
    [sym_return] = ACTIONS(243),
    [sym_next] = ACTIONS(243),
    [sym_break] = ACTIONS(243),
    [sym_true] = ACTIONS(243),
    [sym_false] = ACTIONS(243),
    [sym_null] = ACTIONS(243),
    [sym_inf] = ACTIONS(243),
    [sym_nan] = ACTIONS(243),
    [anon_sym_NA] = ACTIONS(243),
    [anon_sym_NA_integer_] = ACTIONS(243),
    [anon_sym_NA_real_] = ACTIONS(243),
    [anon_sym_NA_complex_] = ACTIONS(243),
    [anon_sym_NA_character_] = ACTIONS(243),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(245),
    [sym__semicolon] = ACTIONS(245),
    [sym__raw_string_literal] = ACTIONS(245),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(245),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [190] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(147),
    [sym_identifier] = ACTIONS(149),
    [anon_sym_BSLASH] = ACTIONS(147),
    [anon_sym_function] = ACTIONS(149),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(149),
    [anon_sym_for] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(149),
    [anon_sym_repeat] = ACTIONS(149),
    [anon_sym_QMARK] = ACTIONS(147),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(147),
    [sym__number_literal] = ACTIONS(149),
    [anon_sym_SQUOTE] = ACTIONS(147),
    [anon_sym_DQUOTE] = ACTIONS(147),
    [sym_dots] = ACTIONS(149),
    [sym_dot_dot_i] = ACTIONS(149),
    [sym_return] = ACTIONS(149),
    [sym_next] = ACTIONS(149),
    [sym_break] = ACTIONS(149),
    [sym_true] = ACTIONS(149),
    [sym_false] = ACTIONS(149),
    [sym_null] = ACTIONS(149),
    [sym_inf] = ACTIONS(149),
    [sym_nan] = ACTIONS(149),
    [anon_sym_NA] = ACTIONS(149),
    [anon_sym_NA_integer_] = ACTIONS(149),
    [anon_sym_NA_real_] = ACTIONS(149),
    [anon_sym_NA_complex_] = ACTIONS(149),
    [anon_sym_NA_character_] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(147),
    [sym__semicolon] = ACTIONS(147),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(147),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [191] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(147),
    [sym_identifier] = ACTIONS(149),
    [anon_sym_BSLASH] = ACTIONS(147),
    [anon_sym_function] = ACTIONS(149),
    [anon_sym_EQ] = ACTIONS(149),
    [anon_sym_if] = ACTIONS(149),
    [anon_sym_for] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(149),
    [anon_sym_repeat] = ACTIONS(149),
    [anon_sym_QMARK] = ACTIONS(147),
    [anon_sym_TILDE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(147),
    [anon_sym_LT_LT_DASH] = ACTIONS(147),
    [anon_sym_COLON_EQ] = ACTIONS(147),
    [anon_sym_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_GT] = ACTIONS(147),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(147),
    [sym__number_literal] = ACTIONS(149),
    [anon_sym_SQUOTE] = ACTIONS(147),
    [anon_sym_DQUOTE] = ACTIONS(147),
    [sym_dots] = ACTIONS(149),
    [sym_dot_dot_i] = ACTIONS(149),
    [sym_return] = ACTIONS(149),
    [sym_next] = ACTIONS(149),
    [sym_break] = ACTIONS(149),
    [sym_true] = ACTIONS(149),
    [sym_false] = ACTIONS(149),
    [sym_null] = ACTIONS(149),
    [sym_inf] = ACTIONS(149),
    [sym_nan] = ACTIONS(149),
    [anon_sym_NA] = ACTIONS(149),
    [anon_sym_NA_integer_] = ACTIONS(149),
    [anon_sym_NA_real_] = ACTIONS(149),
    [anon_sym_NA_complex_] = ACTIONS(149),
    [anon_sym_NA_character_] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(147),
    [sym__semicolon] = ACTIONS(147),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(147),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [192] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(147),
    [sym_identifier] = ACTIONS(149),
    [anon_sym_BSLASH] = ACTIONS(147),
    [anon_sym_function] = ACTIONS(149),
    [anon_sym_EQ] = ACTIONS(149),
    [anon_sym_if] = ACTIONS(149),
    [anon_sym_for] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(149),
    [anon_sym_repeat] = ACTIONS(149),
    [anon_sym_QMARK] = ACTIONS(147),
    [anon_sym_TILDE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(147),
    [anon_sym_LT_LT_DASH] = ACTIONS(147),
    [anon_sym_COLON_EQ] = ACTIONS(147),
    [anon_sym_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_GT] = ACTIONS(147),
    [anon_sym_PIPE] = ACTIONS(149),
    [anon_sym_AMP] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(147),
    [anon_sym_AMP_AMP] = ACTIONS(147),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(147),
    [sym__number_literal] = ACTIONS(149),
    [anon_sym_SQUOTE] = ACTIONS(147),
    [anon_sym_DQUOTE] = ACTIONS(147),
    [sym_dots] = ACTIONS(149),
    [sym_dot_dot_i] = ACTIONS(149),
    [sym_return] = ACTIONS(149),
    [sym_next] = ACTIONS(149),
    [sym_break] = ACTIONS(149),
    [sym_true] = ACTIONS(149),
    [sym_false] = ACTIONS(149),
    [sym_null] = ACTIONS(149),
    [sym_inf] = ACTIONS(149),
    [sym_nan] = ACTIONS(149),
    [anon_sym_NA] = ACTIONS(149),
    [anon_sym_NA_integer_] = ACTIONS(149),
    [anon_sym_NA_real_] = ACTIONS(149),
    [anon_sym_NA_complex_] = ACTIONS(149),
    [anon_sym_NA_character_] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(147),
    [sym__semicolon] = ACTIONS(147),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(147),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [193] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(147),
    [sym_identifier] = ACTIONS(149),
    [anon_sym_BSLASH] = ACTIONS(147),
    [anon_sym_function] = ACTIONS(149),
    [anon_sym_EQ] = ACTIONS(149),
    [anon_sym_if] = ACTIONS(149),
    [anon_sym_for] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(149),
    [anon_sym_repeat] = ACTIONS(149),
    [anon_sym_QMARK] = ACTIONS(147),
    [anon_sym_TILDE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_PLUS] = ACTIONS(147),
    [anon_sym_DASH] = ACTIONS(149),
    [anon_sym_LT_DASH] = ACTIONS(147),
    [anon_sym_LT_LT_DASH] = ACTIONS(147),
    [anon_sym_COLON_EQ] = ACTIONS(147),
    [anon_sym_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_GT] = ACTIONS(147),
    [anon_sym_PIPE] = ACTIONS(149),
    [anon_sym_AMP] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(147),
    [anon_sym_AMP_AMP] = ACTIONS(147),
    [anon_sym_LT] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(147),
    [anon_sym_GT] = ACTIONS(149),
    [anon_sym_GT_EQ] = ACTIONS(147),
    [anon_sym_EQ_EQ] = ACTIONS(147),
    [anon_sym_BANG_EQ] = ACTIONS(147),
    [anon_sym_STAR] = ACTIONS(149),
    [anon_sym_SLASH] = ACTIONS(147),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(147),
    [anon_sym_PIPE_GT] = ACTIONS(147),
    [anon_sym_COLON] = ACTIONS(149),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(147),
    [sym__number_literal] = ACTIONS(149),
    [anon_sym_SQUOTE] = ACTIONS(147),
    [anon_sym_DQUOTE] = ACTIONS(147),
    [sym_dots] = ACTIONS(149),
    [sym_dot_dot_i] = ACTIONS(149),
    [sym_return] = ACTIONS(149),
    [sym_next] = ACTIONS(149),
    [sym_break] = ACTIONS(149),
    [sym_true] = ACTIONS(149),
    [sym_false] = ACTIONS(149),
    [sym_null] = ACTIONS(149),
    [sym_inf] = ACTIONS(149),
    [sym_nan] = ACTIONS(149),
    [anon_sym_NA] = ACTIONS(149),
    [anon_sym_NA_integer_] = ACTIONS(149),
    [anon_sym_NA_real_] = ACTIONS(149),
    [anon_sym_NA_complex_] = ACTIONS(149),
    [anon_sym_NA_character_] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(147),
    [sym__semicolon] = ACTIONS(147),
    [sym__raw_string_literal] = ACTIONS(147),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(147),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [194] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [195] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [196] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [197] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [198] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [199] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [200] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [201] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [202] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(151),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [203] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(151),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(151),
    [anon_sym_PIPE_GT] = ACTIONS(151),
    [anon_sym_COLON] = ACTIONS(153),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [204] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(151),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(151),
    [anon_sym_PIPE_GT] = ACTIONS(151),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [205] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(153),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_LT_DASH] = ACTIONS(151),
    [anon_sym_LT_LT_DASH] = ACTIONS(151),
    [anon_sym_COLON_EQ] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(153),
    [anon_sym_DASH_GT_GT] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(153),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(151),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(151),
    [anon_sym_PIPE_GT] = ACTIONS(151),
    [anon_sym_COLON] = ACTIONS(153),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [206] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(155),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_BSLASH] = ACTIONS(155),
    [anon_sym_function] = ACTIONS(157),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_for] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(157),
    [anon_sym_repeat] = ACTIONS(157),
    [anon_sym_QMARK] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(157),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(155),
    [sym__number_literal] = ACTIONS(157),
    [anon_sym_SQUOTE] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(155),
    [sym_dots] = ACTIONS(157),
    [sym_dot_dot_i] = ACTIONS(157),
    [sym_return] = ACTIONS(157),
    [sym_next] = ACTIONS(157),
    [sym_break] = ACTIONS(157),
    [sym_true] = ACTIONS(157),
    [sym_false] = ACTIONS(157),
    [sym_null] = ACTIONS(157),
    [sym_inf] = ACTIONS(157),
    [sym_nan] = ACTIONS(157),
    [anon_sym_NA] = ACTIONS(157),
    [anon_sym_NA_integer_] = ACTIONS(157),
    [anon_sym_NA_real_] = ACTIONS(157),
    [anon_sym_NA_complex_] = ACTIONS(157),
    [anon_sym_NA_character_] = ACTIONS(157),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(155),
    [sym__semicolon] = ACTIONS(155),
    [sym__raw_string_literal] = ACTIONS(155),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(155),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [207] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(159),
    [sym_identifier] = ACTIONS(161),
    [anon_sym_BSLASH] = ACTIONS(159),
    [anon_sym_function] = ACTIONS(161),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_while] = ACTIONS(161),
    [anon_sym_repeat] = ACTIONS(161),
    [anon_sym_QMARK] = ACTIONS(159),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(159),
    [sym__number_literal] = ACTIONS(161),
    [anon_sym_SQUOTE] = ACTIONS(159),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [sym_dots] = ACTIONS(161),
    [sym_dot_dot_i] = ACTIONS(161),
    [sym_return] = ACTIONS(161),
    [sym_next] = ACTIONS(161),
    [sym_break] = ACTIONS(161),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [sym_null] = ACTIONS(161),
    [sym_inf] = ACTIONS(161),
    [sym_nan] = ACTIONS(161),
    [anon_sym_NA] = ACTIONS(161),
    [anon_sym_NA_integer_] = ACTIONS(161),
    [anon_sym_NA_real_] = ACTIONS(161),
    [anon_sym_NA_complex_] = ACTIONS(161),
    [anon_sym_NA_character_] = ACTIONS(161),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(159),
    [sym__semicolon] = ACTIONS(159),
    [sym__raw_string_literal] = ACTIONS(159),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(159),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [208] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [209] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [210] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [211] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(165),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(165),
    [anon_sym_LT_EQ] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(165),
    [anon_sym_GT_EQ] = ACTIONS(163),
    [anon_sym_EQ_EQ] = ACTIONS(163),
    [anon_sym_BANG_EQ] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [212] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [213] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [214] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [215] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [216] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(165),
    [anon_sym_LT_EQ] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(165),
    [anon_sym_GT_EQ] = ACTIONS(163),
    [anon_sym_EQ_EQ] = ACTIONS(163),
    [anon_sym_BANG_EQ] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [217] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(165),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(165),
    [anon_sym_LT_EQ] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(165),
    [anon_sym_GT_EQ] = ACTIONS(163),
    [anon_sym_EQ_EQ] = ACTIONS(163),
    [anon_sym_BANG_EQ] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(165),
    [anon_sym_SLASH] = ACTIONS(163),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [218] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(165),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(165),
    [anon_sym_LT_EQ] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(165),
    [anon_sym_GT_EQ] = ACTIONS(163),
    [anon_sym_EQ_EQ] = ACTIONS(163),
    [anon_sym_BANG_EQ] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(165),
    [anon_sym_SLASH] = ACTIONS(163),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(163),
    [anon_sym_PIPE_GT] = ACTIONS(163),
    [anon_sym_COLON] = ACTIONS(165),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [219] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(165),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(165),
    [anon_sym_LT_EQ] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(165),
    [anon_sym_GT_EQ] = ACTIONS(163),
    [anon_sym_EQ_EQ] = ACTIONS(163),
    [anon_sym_BANG_EQ] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(165),
    [anon_sym_SLASH] = ACTIONS(163),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(163),
    [anon_sym_PIPE_GT] = ACTIONS(163),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [220] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(163),
    [sym_identifier] = ACTIONS(165),
    [anon_sym_BSLASH] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_EQ] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(165),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_while] = ACTIONS(165),
    [anon_sym_repeat] = ACTIONS(165),
    [anon_sym_QMARK] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(163),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(165),
    [anon_sym_LT_DASH] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(163),
    [anon_sym_COLON_EQ] = ACTIONS(163),
    [anon_sym_DASH_GT] = ACTIONS(165),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_PIPE_PIPE] = ACTIONS(163),
    [anon_sym_AMP_AMP] = ACTIONS(163),
    [anon_sym_LT] = ACTIONS(165),
    [anon_sym_LT_EQ] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(165),
    [anon_sym_GT_EQ] = ACTIONS(163),
    [anon_sym_EQ_EQ] = ACTIONS(163),
    [anon_sym_BANG_EQ] = ACTIONS(163),
    [anon_sym_STAR] = ACTIONS(165),
    [anon_sym_SLASH] = ACTIONS(163),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(163),
    [anon_sym_PIPE_GT] = ACTIONS(163),
    [anon_sym_COLON] = ACTIONS(165),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(163),
    [sym__number_literal] = ACTIONS(165),
    [anon_sym_SQUOTE] = ACTIONS(163),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_dots] = ACTIONS(165),
    [sym_dot_dot_i] = ACTIONS(165),
    [sym_return] = ACTIONS(165),
    [sym_next] = ACTIONS(165),
    [sym_break] = ACTIONS(165),
    [sym_true] = ACTIONS(165),
    [sym_false] = ACTIONS(165),
    [sym_null] = ACTIONS(165),
    [sym_inf] = ACTIONS(165),
    [sym_nan] = ACTIONS(165),
    [anon_sym_NA] = ACTIONS(165),
    [anon_sym_NA_integer_] = ACTIONS(165),
    [anon_sym_NA_real_] = ACTIONS(165),
    [anon_sym_NA_complex_] = ACTIONS(165),
    [anon_sym_NA_character_] = ACTIONS(165),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(163),
    [sym__semicolon] = ACTIONS(163),
    [sym__raw_string_literal] = ACTIONS(163),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(163),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [221] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(167),
    [sym_identifier] = ACTIONS(169),
    [anon_sym_BSLASH] = ACTIONS(167),
    [anon_sym_function] = ACTIONS(169),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_repeat] = ACTIONS(169),
    [anon_sym_QMARK] = ACTIONS(167),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(169),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(167),
    [sym__number_literal] = ACTIONS(169),
    [anon_sym_SQUOTE] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(167),
    [sym_dots] = ACTIONS(169),
    [sym_dot_dot_i] = ACTIONS(169),
    [sym_return] = ACTIONS(169),
    [sym_next] = ACTIONS(169),
    [sym_break] = ACTIONS(169),
    [sym_true] = ACTIONS(169),
    [sym_false] = ACTIONS(169),
    [sym_null] = ACTIONS(169),
    [sym_inf] = ACTIONS(169),
    [sym_nan] = ACTIONS(169),
    [anon_sym_NA] = ACTIONS(169),
    [anon_sym_NA_integer_] = ACTIONS(169),
    [anon_sym_NA_real_] = ACTIONS(169),
    [anon_sym_NA_complex_] = ACTIONS(169),
    [anon_sym_NA_character_] = ACTIONS(169),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(167),
    [sym__semicolon] = ACTIONS(167),
    [sym__raw_string_literal] = ACTIONS(167),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(167),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [222] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(171),
    [sym_identifier] = ACTIONS(173),
    [anon_sym_BSLASH] = ACTIONS(171),
    [anon_sym_function] = ACTIONS(173),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_while] = ACTIONS(173),
    [anon_sym_repeat] = ACTIONS(173),
    [anon_sym_QMARK] = ACTIONS(171),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(173),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(171),
    [sym__number_literal] = ACTIONS(173),
    [anon_sym_SQUOTE] = ACTIONS(171),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [sym_dots] = ACTIONS(173),
    [sym_dot_dot_i] = ACTIONS(173),
    [sym_return] = ACTIONS(173),
    [sym_next] = ACTIONS(173),
    [sym_break] = ACTIONS(173),
    [sym_true] = ACTIONS(173),
    [sym_false] = ACTIONS(173),
    [sym_null] = ACTIONS(173),
    [sym_inf] = ACTIONS(173),
    [sym_nan] = ACTIONS(173),
    [anon_sym_NA] = ACTIONS(173),
    [anon_sym_NA_integer_] = ACTIONS(173),
    [anon_sym_NA_real_] = ACTIONS(173),
    [anon_sym_NA_complex_] = ACTIONS(173),
    [anon_sym_NA_character_] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(171),
    [sym__semicolon] = ACTIONS(171),
    [sym__raw_string_literal] = ACTIONS(171),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(171),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [223] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(175),
    [sym_identifier] = ACTIONS(177),
    [anon_sym_BSLASH] = ACTIONS(175),
    [anon_sym_function] = ACTIONS(177),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(177),
    [anon_sym_for] = ACTIONS(177),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_repeat] = ACTIONS(177),
    [anon_sym_QMARK] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(177),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(175),
    [sym__number_literal] = ACTIONS(177),
    [anon_sym_SQUOTE] = ACTIONS(175),
    [anon_sym_DQUOTE] = ACTIONS(175),
    [sym_dots] = ACTIONS(177),
    [sym_dot_dot_i] = ACTIONS(177),
    [sym_return] = ACTIONS(177),
    [sym_next] = ACTIONS(177),
    [sym_break] = ACTIONS(177),
    [sym_true] = ACTIONS(177),
    [sym_false] = ACTIONS(177),
    [sym_null] = ACTIONS(177),
    [sym_inf] = ACTIONS(177),
    [sym_nan] = ACTIONS(177),
    [anon_sym_NA] = ACTIONS(177),
    [anon_sym_NA_integer_] = ACTIONS(177),
    [anon_sym_NA_real_] = ACTIONS(177),
    [anon_sym_NA_complex_] = ACTIONS(177),
    [anon_sym_NA_character_] = ACTIONS(177),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(175),
    [sym__semicolon] = ACTIONS(175),
    [sym__raw_string_literal] = ACTIONS(175),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(175),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [224] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(179),
    [sym_identifier] = ACTIONS(181),
    [anon_sym_BSLASH] = ACTIONS(179),
    [anon_sym_function] = ACTIONS(181),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(181),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_repeat] = ACTIONS(181),
    [anon_sym_QMARK] = ACTIONS(179),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(181),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(179),
    [sym__number_literal] = ACTIONS(181),
    [anon_sym_SQUOTE] = ACTIONS(179),
    [anon_sym_DQUOTE] = ACTIONS(179),
    [sym_dots] = ACTIONS(181),
    [sym_dot_dot_i] = ACTIONS(181),
    [sym_return] = ACTIONS(181),
    [sym_next] = ACTIONS(181),
    [sym_break] = ACTIONS(181),
    [sym_true] = ACTIONS(181),
    [sym_false] = ACTIONS(181),
    [sym_null] = ACTIONS(181),
    [sym_inf] = ACTIONS(181),
    [sym_nan] = ACTIONS(181),
    [anon_sym_NA] = ACTIONS(181),
    [anon_sym_NA_integer_] = ACTIONS(181),
    [anon_sym_NA_real_] = ACTIONS(181),
    [anon_sym_NA_complex_] = ACTIONS(181),
    [anon_sym_NA_character_] = ACTIONS(181),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(179),
    [sym__semicolon] = ACTIONS(179),
    [sym__raw_string_literal] = ACTIONS(179),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(179),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [225] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(183),
    [sym_identifier] = ACTIONS(185),
    [anon_sym_BSLASH] = ACTIONS(183),
    [anon_sym_function] = ACTIONS(185),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(185),
    [anon_sym_for] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(185),
    [anon_sym_repeat] = ACTIONS(185),
    [anon_sym_QMARK] = ACTIONS(183),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(185),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(183),
    [sym__number_literal] = ACTIONS(185),
    [anon_sym_SQUOTE] = ACTIONS(183),
    [anon_sym_DQUOTE] = ACTIONS(183),
    [sym_dots] = ACTIONS(185),
    [sym_dot_dot_i] = ACTIONS(185),
    [sym_return] = ACTIONS(185),
    [sym_next] = ACTIONS(185),
    [sym_break] = ACTIONS(185),
    [sym_true] = ACTIONS(185),
    [sym_false] = ACTIONS(185),
    [sym_null] = ACTIONS(185),
    [sym_inf] = ACTIONS(185),
    [sym_nan] = ACTIONS(185),
    [anon_sym_NA] = ACTIONS(185),
    [anon_sym_NA_integer_] = ACTIONS(185),
    [anon_sym_NA_real_] = ACTIONS(185),
    [anon_sym_NA_complex_] = ACTIONS(185),
    [anon_sym_NA_character_] = ACTIONS(185),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(183),
    [sym__semicolon] = ACTIONS(183),
    [sym__raw_string_literal] = ACTIONS(183),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(183),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [226] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(187),
    [sym_identifier] = ACTIONS(189),
    [anon_sym_BSLASH] = ACTIONS(187),
    [anon_sym_function] = ACTIONS(189),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(189),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(189),
    [anon_sym_repeat] = ACTIONS(189),
    [anon_sym_QMARK] = ACTIONS(187),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(189),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(187),
    [sym__number_literal] = ACTIONS(189),
    [anon_sym_SQUOTE] = ACTIONS(187),
    [anon_sym_DQUOTE] = ACTIONS(187),
    [sym_dots] = ACTIONS(189),
    [sym_dot_dot_i] = ACTIONS(189),
    [sym_return] = ACTIONS(189),
    [sym_next] = ACTIONS(189),
    [sym_break] = ACTIONS(189),
    [sym_true] = ACTIONS(189),
    [sym_false] = ACTIONS(189),
    [sym_null] = ACTIONS(189),
    [sym_inf] = ACTIONS(189),
    [sym_nan] = ACTIONS(189),
    [anon_sym_NA] = ACTIONS(189),
    [anon_sym_NA_integer_] = ACTIONS(189),
    [anon_sym_NA_real_] = ACTIONS(189),
    [anon_sym_NA_complex_] = ACTIONS(189),
    [anon_sym_NA_character_] = ACTIONS(189),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(187),
    [sym__semicolon] = ACTIONS(187),
    [sym__raw_string_literal] = ACTIONS(187),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(187),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [227] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(191),
    [sym_identifier] = ACTIONS(193),
    [anon_sym_BSLASH] = ACTIONS(191),
    [anon_sym_function] = ACTIONS(193),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(193),
    [anon_sym_for] = ACTIONS(193),
    [anon_sym_while] = ACTIONS(193),
    [anon_sym_repeat] = ACTIONS(193),
    [anon_sym_QMARK] = ACTIONS(191),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(193),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(191),
    [sym__number_literal] = ACTIONS(193),
    [anon_sym_SQUOTE] = ACTIONS(191),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_dots] = ACTIONS(193),
    [sym_dot_dot_i] = ACTIONS(193),
    [sym_return] = ACTIONS(193),
    [sym_next] = ACTIONS(193),
    [sym_break] = ACTIONS(193),
    [sym_true] = ACTIONS(193),
    [sym_false] = ACTIONS(193),
    [sym_null] = ACTIONS(193),
    [sym_inf] = ACTIONS(193),
    [sym_nan] = ACTIONS(193),
    [anon_sym_NA] = ACTIONS(193),
    [anon_sym_NA_integer_] = ACTIONS(193),
    [anon_sym_NA_real_] = ACTIONS(193),
    [anon_sym_NA_complex_] = ACTIONS(193),
    [anon_sym_NA_character_] = ACTIONS(193),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(191),
    [sym__semicolon] = ACTIONS(191),
    [sym__raw_string_literal] = ACTIONS(191),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(191),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [228] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(195),
    [sym_identifier] = ACTIONS(197),
    [anon_sym_BSLASH] = ACTIONS(195),
    [anon_sym_function] = ACTIONS(197),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_for] = ACTIONS(197),
    [anon_sym_while] = ACTIONS(197),
    [anon_sym_repeat] = ACTIONS(197),
    [anon_sym_QMARK] = ACTIONS(195),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(197),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(195),
    [sym__number_literal] = ACTIONS(197),
    [anon_sym_SQUOTE] = ACTIONS(195),
    [anon_sym_DQUOTE] = ACTIONS(195),
    [sym_dots] = ACTIONS(197),
    [sym_dot_dot_i] = ACTIONS(197),
    [sym_return] = ACTIONS(197),
    [sym_next] = ACTIONS(197),
    [sym_break] = ACTIONS(197),
    [sym_true] = ACTIONS(197),
    [sym_false] = ACTIONS(197),
    [sym_null] = ACTIONS(197),
    [sym_inf] = ACTIONS(197),
    [sym_nan] = ACTIONS(197),
    [anon_sym_NA] = ACTIONS(197),
    [anon_sym_NA_integer_] = ACTIONS(197),
    [anon_sym_NA_real_] = ACTIONS(197),
    [anon_sym_NA_complex_] = ACTIONS(197),
    [anon_sym_NA_character_] = ACTIONS(197),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(195),
    [sym__semicolon] = ACTIONS(195),
    [sym__raw_string_literal] = ACTIONS(195),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(195),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [229] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(199),
    [sym_identifier] = ACTIONS(201),
    [anon_sym_BSLASH] = ACTIONS(199),
    [anon_sym_function] = ACTIONS(201),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(201),
    [anon_sym_for] = ACTIONS(201),
    [anon_sym_while] = ACTIONS(201),
    [anon_sym_repeat] = ACTIONS(201),
    [anon_sym_QMARK] = ACTIONS(199),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(199),
    [sym__number_literal] = ACTIONS(201),
    [anon_sym_SQUOTE] = ACTIONS(199),
    [anon_sym_DQUOTE] = ACTIONS(199),
    [sym_dots] = ACTIONS(201),
    [sym_dot_dot_i] = ACTIONS(201),
    [sym_return] = ACTIONS(201),
    [sym_next] = ACTIONS(201),
    [sym_break] = ACTIONS(201),
    [sym_true] = ACTIONS(201),
    [sym_false] = ACTIONS(201),
    [sym_null] = ACTIONS(201),
    [sym_inf] = ACTIONS(201),
    [sym_nan] = ACTIONS(201),
    [anon_sym_NA] = ACTIONS(201),
    [anon_sym_NA_integer_] = ACTIONS(201),
    [anon_sym_NA_real_] = ACTIONS(201),
    [anon_sym_NA_complex_] = ACTIONS(201),
    [anon_sym_NA_character_] = ACTIONS(201),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(199),
    [sym__semicolon] = ACTIONS(199),
    [sym__raw_string_literal] = ACTIONS(199),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(199),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [230] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(203),
    [sym_identifier] = ACTIONS(205),
    [anon_sym_BSLASH] = ACTIONS(203),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(205),
    [anon_sym_while] = ACTIONS(205),
    [anon_sym_repeat] = ACTIONS(205),
    [anon_sym_QMARK] = ACTIONS(203),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(205),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(203),
    [sym__number_literal] = ACTIONS(205),
    [anon_sym_SQUOTE] = ACTIONS(203),
    [anon_sym_DQUOTE] = ACTIONS(203),
    [sym_dots] = ACTIONS(205),
    [sym_dot_dot_i] = ACTIONS(205),
    [sym_return] = ACTIONS(205),
    [sym_next] = ACTIONS(205),
    [sym_break] = ACTIONS(205),
    [sym_true] = ACTIONS(205),
    [sym_false] = ACTIONS(205),
    [sym_null] = ACTIONS(205),
    [sym_inf] = ACTIONS(205),
    [sym_nan] = ACTIONS(205),
    [anon_sym_NA] = ACTIONS(205),
    [anon_sym_NA_integer_] = ACTIONS(205),
    [anon_sym_NA_real_] = ACTIONS(205),
    [anon_sym_NA_complex_] = ACTIONS(205),
    [anon_sym_NA_character_] = ACTIONS(205),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(203),
    [sym__semicolon] = ACTIONS(203),
    [sym__raw_string_literal] = ACTIONS(203),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(203),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [231] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(207),
    [sym_identifier] = ACTIONS(209),
    [anon_sym_BSLASH] = ACTIONS(207),
    [anon_sym_function] = ACTIONS(209),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(209),
    [anon_sym_for] = ACTIONS(209),
    [anon_sym_while] = ACTIONS(209),
    [anon_sym_repeat] = ACTIONS(209),
    [anon_sym_QMARK] = ACTIONS(207),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(207),
    [sym__number_literal] = ACTIONS(209),
    [anon_sym_SQUOTE] = ACTIONS(207),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [sym_dots] = ACTIONS(209),
    [sym_dot_dot_i] = ACTIONS(209),
    [sym_return] = ACTIONS(209),
    [sym_next] = ACTIONS(209),
    [sym_break] = ACTIONS(209),
    [sym_true] = ACTIONS(209),
    [sym_false] = ACTIONS(209),
    [sym_null] = ACTIONS(209),
    [sym_inf] = ACTIONS(209),
    [sym_nan] = ACTIONS(209),
    [anon_sym_NA] = ACTIONS(209),
    [anon_sym_NA_integer_] = ACTIONS(209),
    [anon_sym_NA_real_] = ACTIONS(209),
    [anon_sym_NA_complex_] = ACTIONS(209),
    [anon_sym_NA_character_] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(207),
    [sym__semicolon] = ACTIONS(207),
    [sym__raw_string_literal] = ACTIONS(207),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [232] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(211),
    [sym_identifier] = ACTIONS(213),
    [anon_sym_BSLASH] = ACTIONS(211),
    [anon_sym_function] = ACTIONS(213),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(213),
    [anon_sym_while] = ACTIONS(213),
    [anon_sym_repeat] = ACTIONS(213),
    [anon_sym_QMARK] = ACTIONS(211),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(211),
    [sym__number_literal] = ACTIONS(213),
    [anon_sym_SQUOTE] = ACTIONS(211),
    [anon_sym_DQUOTE] = ACTIONS(211),
    [sym_dots] = ACTIONS(213),
    [sym_dot_dot_i] = ACTIONS(213),
    [sym_return] = ACTIONS(213),
    [sym_next] = ACTIONS(213),
    [sym_break] = ACTIONS(213),
    [sym_true] = ACTIONS(213),
    [sym_false] = ACTIONS(213),
    [sym_null] = ACTIONS(213),
    [sym_inf] = ACTIONS(213),
    [sym_nan] = ACTIONS(213),
    [anon_sym_NA] = ACTIONS(213),
    [anon_sym_NA_integer_] = ACTIONS(213),
    [anon_sym_NA_real_] = ACTIONS(213),
    [anon_sym_NA_complex_] = ACTIONS(213),
    [anon_sym_NA_character_] = ACTIONS(213),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(211),
    [sym__semicolon] = ACTIONS(211),
    [sym__raw_string_literal] = ACTIONS(211),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(211),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [233] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(215),
    [sym_identifier] = ACTIONS(217),
    [anon_sym_BSLASH] = ACTIONS(215),
    [anon_sym_function] = ACTIONS(217),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(217),
    [anon_sym_for] = ACTIONS(217),
    [anon_sym_while] = ACTIONS(217),
    [anon_sym_repeat] = ACTIONS(217),
    [anon_sym_QMARK] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(217),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(215),
    [sym__number_literal] = ACTIONS(217),
    [anon_sym_SQUOTE] = ACTIONS(215),
    [anon_sym_DQUOTE] = ACTIONS(215),
    [sym_dots] = ACTIONS(217),
    [sym_dot_dot_i] = ACTIONS(217),
    [sym_return] = ACTIONS(217),
    [sym_next] = ACTIONS(217),
    [sym_break] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_inf] = ACTIONS(217),
    [sym_nan] = ACTIONS(217),
    [anon_sym_NA] = ACTIONS(217),
    [anon_sym_NA_integer_] = ACTIONS(217),
    [anon_sym_NA_real_] = ACTIONS(217),
    [anon_sym_NA_complex_] = ACTIONS(217),
    [anon_sym_NA_character_] = ACTIONS(217),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(215),
    [sym__semicolon] = ACTIONS(215),
    [sym__raw_string_literal] = ACTIONS(215),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(215),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [234] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(219),
    [sym_identifier] = ACTIONS(221),
    [anon_sym_BSLASH] = ACTIONS(219),
    [anon_sym_function] = ACTIONS(221),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(221),
    [anon_sym_for] = ACTIONS(221),
    [anon_sym_while] = ACTIONS(221),
    [anon_sym_repeat] = ACTIONS(221),
    [anon_sym_QMARK] = ACTIONS(219),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(219),
    [sym__number_literal] = ACTIONS(221),
    [anon_sym_SQUOTE] = ACTIONS(219),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_dots] = ACTIONS(221),
    [sym_dot_dot_i] = ACTIONS(221),
    [sym_return] = ACTIONS(221),
    [sym_next] = ACTIONS(221),
    [sym_break] = ACTIONS(221),
    [sym_true] = ACTIONS(221),
    [sym_false] = ACTIONS(221),
    [sym_null] = ACTIONS(221),
    [sym_inf] = ACTIONS(221),
    [sym_nan] = ACTIONS(221),
    [anon_sym_NA] = ACTIONS(221),
    [anon_sym_NA_integer_] = ACTIONS(221),
    [anon_sym_NA_real_] = ACTIONS(221),
    [anon_sym_NA_complex_] = ACTIONS(221),
    [anon_sym_NA_character_] = ACTIONS(221),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(219),
    [sym__semicolon] = ACTIONS(219),
    [sym__raw_string_literal] = ACTIONS(219),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(219),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [235] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(145),
    [sym_identifier] = ACTIONS(143),
    [anon_sym_BSLASH] = ACTIONS(145),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_repeat] = ACTIONS(143),
    [anon_sym_QMARK] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(143),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(145),
    [sym__number_literal] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [anon_sym_DQUOTE] = ACTIONS(145),
    [sym_dots] = ACTIONS(143),
    [sym_dot_dot_i] = ACTIONS(143),
    [sym_return] = ACTIONS(143),
    [sym_next] = ACTIONS(143),
    [sym_break] = ACTIONS(143),
    [sym_true] = ACTIONS(143),
    [sym_false] = ACTIONS(143),
    [sym_null] = ACTIONS(143),
    [sym_inf] = ACTIONS(143),
    [sym_nan] = ACTIONS(143),
    [anon_sym_NA] = ACTIONS(143),
    [anon_sym_NA_integer_] = ACTIONS(143),
    [anon_sym_NA_real_] = ACTIONS(143),
    [anon_sym_NA_complex_] = ACTIONS(143),
    [anon_sym_NA_character_] = ACTIONS(143),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(145),
    [sym__semicolon] = ACTIONS(145),
    [sym__raw_string_literal] = ACTIONS(145),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(145),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [236] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(223),
    [sym_identifier] = ACTIONS(225),
    [anon_sym_BSLASH] = ACTIONS(223),
    [anon_sym_function] = ACTIONS(225),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(225),
    [anon_sym_for] = ACTIONS(225),
    [anon_sym_while] = ACTIONS(225),
    [anon_sym_repeat] = ACTIONS(225),
    [anon_sym_QMARK] = ACTIONS(223),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(223),
    [sym__number_literal] = ACTIONS(225),
    [anon_sym_SQUOTE] = ACTIONS(223),
    [anon_sym_DQUOTE] = ACTIONS(223),
    [sym_dots] = ACTIONS(225),
    [sym_dot_dot_i] = ACTIONS(225),
    [sym_return] = ACTIONS(225),
    [sym_next] = ACTIONS(225),
    [sym_break] = ACTIONS(225),
    [sym_true] = ACTIONS(225),
    [sym_false] = ACTIONS(225),
    [sym_null] = ACTIONS(225),
    [sym_inf] = ACTIONS(225),
    [sym_nan] = ACTIONS(225),
    [anon_sym_NA] = ACTIONS(225),
    [anon_sym_NA_integer_] = ACTIONS(225),
    [anon_sym_NA_real_] = ACTIONS(225),
    [anon_sym_NA_complex_] = ACTIONS(225),
    [anon_sym_NA_character_] = ACTIONS(225),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(223),
    [sym__semicolon] = ACTIONS(223),
    [sym__raw_string_literal] = ACTIONS(223),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(223),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [237] = {
    [sym_call_arguments] = STATE(377),
    [sym_subset_arguments] = STATE(378),
    [sym_subset2_arguments] = STATE(384),
    [sym__open_parenthesis] = STATE(264),
    [sym__open_bracket] = STATE(253),
    [sym__open_bracket2] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(227),
    [sym_identifier] = ACTIONS(229),
    [anon_sym_BSLASH] = ACTIONS(227),
    [anon_sym_function] = ACTIONS(229),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(229),
    [anon_sym_for] = ACTIONS(229),
    [anon_sym_while] = ACTIONS(229),
    [anon_sym_repeat] = ACTIONS(229),
    [anon_sym_QMARK] = ACTIONS(227),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(229),
    [anon_sym_PLUS] = ACTIONS(247),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(325),
    [anon_sym_DASH_GT_GT] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(337),
    [anon_sym_LT_EQ] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(255),
    [aux_sym_binary_operator_token1] = ACTIONS(257),
    [anon_sym_PIPE_GT] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [sym__hex_literal] = ACTIONS(227),
    [sym__number_literal] = ACTIONS(229),
    [anon_sym_SQUOTE] = ACTIONS(227),
    [anon_sym_DQUOTE] = ACTIONS(227),
    [sym_dots] = ACTIONS(229),
    [sym_dot_dot_i] = ACTIONS(229),
    [sym_return] = ACTIONS(229),
    [sym_next] = ACTIONS(229),
    [sym_break] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_inf] = ACTIONS(229),
    [sym_nan] = ACTIONS(229),
    [anon_sym_NA] = ACTIONS(229),
    [anon_sym_NA_integer_] = ACTIONS(229),
    [anon_sym_NA_real_] = ACTIONS(229),
    [anon_sym_NA_complex_] = ACTIONS(229),
    [anon_sym_NA_character_] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(227),
    [sym__semicolon] = ACTIONS(227),
    [sym__raw_string_literal] = ACTIONS(227),
    [sym__external_open_parenthesis] = ACTIONS(263),
    [sym__external_open_brace] = ACTIONS(227),
    [sym__external_open_bracket] = ACTIONS(265),
    [sym__external_open_bracket2] = ACTIONS(267),
  },
  [238] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(231),
    [anon_sym_BSLASH] = ACTIONS(233),
    [anon_sym_function] = ACTIONS(231),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(231),
    [anon_sym_for] = ACTIONS(231),
    [anon_sym_while] = ACTIONS(231),
    [anon_sym_repeat] = ACTIONS(231),
    [anon_sym_QMARK] = ACTIONS(233),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(231),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(233),
    [sym__number_literal] = ACTIONS(231),
    [anon_sym_SQUOTE] = ACTIONS(233),
    [anon_sym_DQUOTE] = ACTIONS(233),
    [sym_dots] = ACTIONS(231),
    [sym_dot_dot_i] = ACTIONS(231),
    [sym_return] = ACTIONS(231),
    [sym_next] = ACTIONS(231),
    [sym_break] = ACTIONS(231),
    [sym_true] = ACTIONS(231),
    [sym_false] = ACTIONS(231),
    [sym_null] = ACTIONS(231),
    [sym_inf] = ACTIONS(231),
    [sym_nan] = ACTIONS(231),
    [anon_sym_NA] = ACTIONS(231),
    [anon_sym_NA_integer_] = ACTIONS(231),
    [anon_sym_NA_real_] = ACTIONS(231),
    [anon_sym_NA_complex_] = ACTIONS(231),
    [anon_sym_NA_character_] = ACTIONS(231),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(233),
    [sym__semicolon] = ACTIONS(233),
    [sym__raw_string_literal] = ACTIONS(233),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(233),
    [sym__external_close_brace] = ACTIONS(233),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [239] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(235),
    [anon_sym_BSLASH] = ACTIONS(237),
    [anon_sym_function] = ACTIONS(235),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(235),
    [anon_sym_for] = ACTIONS(235),
    [anon_sym_while] = ACTIONS(235),
    [anon_sym_repeat] = ACTIONS(235),
    [anon_sym_QMARK] = ACTIONS(237),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(235),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(237),
    [sym__number_literal] = ACTIONS(235),
    [anon_sym_SQUOTE] = ACTIONS(237),
    [anon_sym_DQUOTE] = ACTIONS(237),
    [sym_dots] = ACTIONS(235),
    [sym_dot_dot_i] = ACTIONS(235),
    [sym_return] = ACTIONS(235),
    [sym_next] = ACTIONS(235),
    [sym_break] = ACTIONS(235),
    [sym_true] = ACTIONS(235),
    [sym_false] = ACTIONS(235),
    [sym_null] = ACTIONS(235),
    [sym_inf] = ACTIONS(235),
    [sym_nan] = ACTIONS(235),
    [anon_sym_NA] = ACTIONS(235),
    [anon_sym_NA_integer_] = ACTIONS(235),
    [anon_sym_NA_real_] = ACTIONS(235),
    [anon_sym_NA_complex_] = ACTIONS(235),
    [anon_sym_NA_character_] = ACTIONS(235),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(237),
    [sym__semicolon] = ACTIONS(237),
    [sym__raw_string_literal] = ACTIONS(237),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(237),
    [sym__external_close_brace] = ACTIONS(237),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [240] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(235),
    [anon_sym_BSLASH] = ACTIONS(237),
    [anon_sym_function] = ACTIONS(235),
    [anon_sym_EQ] = ACTIONS(235),
    [anon_sym_if] = ACTIONS(235),
    [anon_sym_for] = ACTIONS(235),
    [anon_sym_while] = ACTIONS(235),
    [anon_sym_repeat] = ACTIONS(235),
    [anon_sym_QMARK] = ACTIONS(237),
    [anon_sym_TILDE] = ACTIONS(237),
    [anon_sym_BANG] = ACTIONS(235),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(237),
    [anon_sym_LT_LT_DASH] = ACTIONS(237),
    [anon_sym_COLON_EQ] = ACTIONS(237),
    [anon_sym_DASH_GT] = ACTIONS(235),
    [anon_sym_DASH_GT_GT] = ACTIONS(237),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(237),
    [sym__number_literal] = ACTIONS(235),
    [anon_sym_SQUOTE] = ACTIONS(237),
    [anon_sym_DQUOTE] = ACTIONS(237),
    [sym_dots] = ACTIONS(235),
    [sym_dot_dot_i] = ACTIONS(235),
    [sym_return] = ACTIONS(235),
    [sym_next] = ACTIONS(235),
    [sym_break] = ACTIONS(235),
    [sym_true] = ACTIONS(235),
    [sym_false] = ACTIONS(235),
    [sym_null] = ACTIONS(235),
    [sym_inf] = ACTIONS(235),
    [sym_nan] = ACTIONS(235),
    [anon_sym_NA] = ACTIONS(235),
    [anon_sym_NA_integer_] = ACTIONS(235),
    [anon_sym_NA_real_] = ACTIONS(235),
    [anon_sym_NA_complex_] = ACTIONS(235),
    [anon_sym_NA_character_] = ACTIONS(235),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(237),
    [sym__semicolon] = ACTIONS(237),
    [sym__raw_string_literal] = ACTIONS(237),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(237),
    [sym__external_close_brace] = ACTIONS(237),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [241] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(235),
    [anon_sym_BSLASH] = ACTIONS(237),
    [anon_sym_function] = ACTIONS(235),
    [anon_sym_EQ] = ACTIONS(235),
    [anon_sym_if] = ACTIONS(235),
    [anon_sym_for] = ACTIONS(235),
    [anon_sym_while] = ACTIONS(235),
    [anon_sym_repeat] = ACTIONS(235),
    [anon_sym_QMARK] = ACTIONS(237),
    [anon_sym_TILDE] = ACTIONS(237),
    [anon_sym_BANG] = ACTIONS(235),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(237),
    [anon_sym_LT_LT_DASH] = ACTIONS(237),
    [anon_sym_COLON_EQ] = ACTIONS(237),
    [anon_sym_DASH_GT] = ACTIONS(235),
    [anon_sym_DASH_GT_GT] = ACTIONS(237),
    [anon_sym_PIPE] = ACTIONS(235),
    [anon_sym_AMP] = ACTIONS(235),
    [anon_sym_PIPE_PIPE] = ACTIONS(237),
    [anon_sym_AMP_AMP] = ACTIONS(237),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(237),
    [sym__number_literal] = ACTIONS(235),
    [anon_sym_SQUOTE] = ACTIONS(237),
    [anon_sym_DQUOTE] = ACTIONS(237),
    [sym_dots] = ACTIONS(235),
    [sym_dot_dot_i] = ACTIONS(235),
    [sym_return] = ACTIONS(235),
    [sym_next] = ACTIONS(235),
    [sym_break] = ACTIONS(235),
    [sym_true] = ACTIONS(235),
    [sym_false] = ACTIONS(235),
    [sym_null] = ACTIONS(235),
    [sym_inf] = ACTIONS(235),
    [sym_nan] = ACTIONS(235),
    [anon_sym_NA] = ACTIONS(235),
    [anon_sym_NA_integer_] = ACTIONS(235),
    [anon_sym_NA_real_] = ACTIONS(235),
    [anon_sym_NA_complex_] = ACTIONS(235),
    [anon_sym_NA_character_] = ACTIONS(235),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(237),
    [sym__semicolon] = ACTIONS(237),
    [sym__raw_string_literal] = ACTIONS(237),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(237),
    [sym__external_close_brace] = ACTIONS(237),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [242] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(235),
    [anon_sym_BSLASH] = ACTIONS(237),
    [anon_sym_function] = ACTIONS(235),
    [anon_sym_EQ] = ACTIONS(235),
    [anon_sym_if] = ACTIONS(235),
    [anon_sym_for] = ACTIONS(235),
    [anon_sym_while] = ACTIONS(235),
    [anon_sym_repeat] = ACTIONS(235),
    [anon_sym_QMARK] = ACTIONS(237),
    [anon_sym_TILDE] = ACTIONS(237),
    [anon_sym_BANG] = ACTIONS(235),
    [anon_sym_PLUS] = ACTIONS(237),
    [anon_sym_DASH] = ACTIONS(235),
    [anon_sym_LT_DASH] = ACTIONS(237),
    [anon_sym_LT_LT_DASH] = ACTIONS(237),
    [anon_sym_COLON_EQ] = ACTIONS(237),
    [anon_sym_DASH_GT] = ACTIONS(235),
    [anon_sym_DASH_GT_GT] = ACTIONS(237),
    [anon_sym_PIPE] = ACTIONS(235),
    [anon_sym_AMP] = ACTIONS(235),
    [anon_sym_PIPE_PIPE] = ACTIONS(237),
    [anon_sym_AMP_AMP] = ACTIONS(237),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(235),
    [anon_sym_SLASH] = ACTIONS(237),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(237),
    [anon_sym_PIPE_GT] = ACTIONS(237),
    [anon_sym_COLON] = ACTIONS(235),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(237),
    [sym__number_literal] = ACTIONS(235),
    [anon_sym_SQUOTE] = ACTIONS(237),
    [anon_sym_DQUOTE] = ACTIONS(237),
    [sym_dots] = ACTIONS(235),
    [sym_dot_dot_i] = ACTIONS(235),
    [sym_return] = ACTIONS(235),
    [sym_next] = ACTIONS(235),
    [sym_break] = ACTIONS(235),
    [sym_true] = ACTIONS(235),
    [sym_false] = ACTIONS(235),
    [sym_null] = ACTIONS(235),
    [sym_inf] = ACTIONS(235),
    [sym_nan] = ACTIONS(235),
    [anon_sym_NA] = ACTIONS(235),
    [anon_sym_NA_integer_] = ACTIONS(235),
    [anon_sym_NA_real_] = ACTIONS(235),
    [anon_sym_NA_complex_] = ACTIONS(235),
    [anon_sym_NA_character_] = ACTIONS(235),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(237),
    [sym__semicolon] = ACTIONS(237),
    [sym__raw_string_literal] = ACTIONS(237),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(237),
    [sym__external_close_brace] = ACTIONS(237),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [243] = {
    [sym_call_arguments] = STATE(413),
    [sym_subset_arguments] = STATE(427),
    [sym_subset2_arguments] = STATE(415),
    [sym__open_parenthesis] = STATE(260),
    [sym__open_bracket] = STATE(261),
    [sym__open_bracket2] = STATE(262),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_LT_DASH] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_DASH_GT_GT] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_LT_EQ] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_EQ] = ACTIONS(293),
    [anon_sym_EQ_EQ] = ACTIONS(293),
    [anon_sym_BANG_EQ] = ACTIONS(293),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_STAR_STAR] = ACTIONS(299),
    [anon_sym_CARET] = ACTIONS(299),
    [aux_sym_binary_operator_token1] = ACTIONS(301),
    [anon_sym_PIPE_GT] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(303),
    [anon_sym_DOLLAR] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(305),
    [sym__hex_literal] = ACTIONS(151),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(153),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(151),
    [sym__semicolon] = ACTIONS(151),
    [sym__raw_string_literal] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(307),
    [sym__external_open_brace] = ACTIONS(151),
    [sym__external_close_brace] = ACTIONS(151),
    [sym__external_open_bracket] = ACTIONS(309),
    [sym__external_open_bracket2] = ACTIONS(311),
  },
  [244] = {
    [sym_string] = STATE(373),
    [sym__single_quoted_string] = STATE(288),
    [sym__double_quoted_string] = STATE(289),
    [aux_sym_function_definition_repeat1] = STATE(307),
    [ts_builtin_sym_end] = ACTIONS(347),
    [sym_identifier] = ACTIONS(349),
    [anon_sym_BSLASH] = ACTIONS(347),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_EQ] = ACTIONS(351),
    [anon_sym_if] = ACTIONS(351),
    [anon_sym_for] = ACTIONS(351),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(351),
    [anon_sym_QMARK] = ACTIONS(347),
    [anon_sym_TILDE] = ACTIONS(347),
    [anon_sym_BANG] = ACTIONS(351),
    [anon_sym_PLUS] = ACTIONS(347),
    [anon_sym_DASH] = ACTIONS(351),
    [anon_sym_LT_DASH] = ACTIONS(347),
    [anon_sym_LT_LT_DASH] = ACTIONS(347),
    [anon_sym_COLON_EQ] = ACTIONS(347),
    [anon_sym_DASH_GT] = ACTIONS(351),
    [anon_sym_DASH_GT_GT] = ACTIONS(347),
    [anon_sym_PIPE] = ACTIONS(351),
    [anon_sym_AMP] = ACTIONS(351),
    [anon_sym_PIPE_PIPE] = ACTIONS(347),
    [anon_sym_AMP_AMP] = ACTIONS(347),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_LT_EQ] = ACTIONS(347),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_EQ] = ACTIONS(347),
    [anon_sym_EQ_EQ] = ACTIONS(347),
    [anon_sym_BANG_EQ] = ACTIONS(347),
    [anon_sym_STAR] = ACTIONS(351),
    [anon_sym_SLASH] = ACTIONS(347),
    [anon_sym_STAR_STAR] = ACTIONS(347),
    [anon_sym_CARET] = ACTIONS(347),
    [aux_sym_binary_operator_token1] = ACTIONS(347),
    [anon_sym_PIPE_GT] = ACTIONS(347),
    [anon_sym_COLON] = ACTIONS(351),
    [anon_sym_DOLLAR] = ACTIONS(347),
    [anon_sym_AT] = ACTIONS(347),
    [sym__hex_literal] = ACTIONS(347),
    [sym__number_literal] = ACTIONS(351),
    [anon_sym_SQUOTE] = ACTIONS(353),
    [anon_sym_DQUOTE] = ACTIONS(355),
    [sym_dots] = ACTIONS(349),
    [sym_dot_dot_i] = ACTIONS(349),
    [sym_return] = ACTIONS(351),
    [sym_next] = ACTIONS(351),
    [sym_break] = ACTIONS(351),
    [sym_true] = ACTIONS(351),
    [sym_false] = ACTIONS(351),
    [sym_null] = ACTIONS(351),
    [sym_inf] = ACTIONS(351),
    [sym_nan] = ACTIONS(351),
    [anon_sym_NA] = ACTIONS(351),
    [anon_sym_NA_integer_] = ACTIONS(351),
    [anon_sym_NA_real_] = ACTIONS(351),
    [anon_sym_NA_complex_] = ACTIONS(351),
    [anon_sym_NA_character_] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(347),
    [sym__semicolon] = ACTIONS(347),
    [sym__raw_string_literal] = ACTIONS(357),
    [sym__external_else] = ACTIONS(347),
    [sym__external_open_parenthesis] = ACTIONS(347),
    [sym__external_open_brace] = ACTIONS(347),
    [sym__external_open_bracket] = ACTIONS(347),
    [sym__external_open_bracket2] = ACTIONS(347),
  },
  [245] = {
    [sym_string] = STATE(341),
    [sym__single_quoted_string] = STATE(292),
    [sym__double_quoted_string] = STATE(293),
    [aux_sym_function_definition_repeat1] = STATE(318),
    [sym_identifier] = ACTIONS(359),
    [anon_sym_BSLASH] = ACTIONS(347),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_EQ] = ACTIONS(351),
    [anon_sym_if] = ACTIONS(351),
    [anon_sym_for] = ACTIONS(351),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(351),
    [anon_sym_QMARK] = ACTIONS(347),
    [anon_sym_TILDE] = ACTIONS(347),
    [anon_sym_BANG] = ACTIONS(351),
    [anon_sym_PLUS] = ACTIONS(347),
    [anon_sym_DASH] = ACTIONS(351),
    [anon_sym_LT_DASH] = ACTIONS(347),
    [anon_sym_LT_LT_DASH] = ACTIONS(347),
    [anon_sym_COLON_EQ] = ACTIONS(347),
    [anon_sym_DASH_GT] = ACTIONS(351),
    [anon_sym_DASH_GT_GT] = ACTIONS(347),
    [anon_sym_PIPE] = ACTIONS(351),
    [anon_sym_AMP] = ACTIONS(351),
    [anon_sym_PIPE_PIPE] = ACTIONS(347),
    [anon_sym_AMP_AMP] = ACTIONS(347),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_LT_EQ] = ACTIONS(347),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_EQ] = ACTIONS(347),
    [anon_sym_EQ_EQ] = ACTIONS(347),
    [anon_sym_BANG_EQ] = ACTIONS(347),
    [anon_sym_STAR] = ACTIONS(351),
    [anon_sym_SLASH] = ACTIONS(347),
    [anon_sym_STAR_STAR] = ACTIONS(347),
    [anon_sym_CARET] = ACTIONS(347),
    [aux_sym_binary_operator_token1] = ACTIONS(347),
    [anon_sym_PIPE_GT] = ACTIONS(347),
    [anon_sym_COLON] = ACTIONS(351),
    [anon_sym_DOLLAR] = ACTIONS(347),
    [anon_sym_AT] = ACTIONS(347),
    [sym__hex_literal] = ACTIONS(347),
    [sym__number_literal] = ACTIONS(351),
    [anon_sym_SQUOTE] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [sym_dots] = ACTIONS(359),
    [sym_dot_dot_i] = ACTIONS(359),
    [sym_return] = ACTIONS(351),
    [sym_next] = ACTIONS(351),
    [sym_break] = ACTIONS(351),
    [sym_true] = ACTIONS(351),
    [sym_false] = ACTIONS(351),
    [sym_null] = ACTIONS(351),
    [sym_inf] = ACTIONS(351),
    [sym_nan] = ACTIONS(351),
    [anon_sym_NA] = ACTIONS(351),
    [anon_sym_NA_integer_] = ACTIONS(351),
    [anon_sym_NA_real_] = ACTIONS(351),
    [anon_sym_NA_complex_] = ACTIONS(351),
    [anon_sym_NA_character_] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(347),
    [sym__semicolon] = ACTIONS(347),
    [sym__raw_string_literal] = ACTIONS(365),
    [sym__external_else] = ACTIONS(347),
    [sym__external_open_parenthesis] = ACTIONS(347),
    [sym__external_open_brace] = ACTIONS(347),
    [sym__external_close_brace] = ACTIONS(347),
    [sym__external_open_bracket] = ACTIONS(347),
    [sym__external_open_bracket2] = ACTIONS(347),
  },
  [246] = {
    [sym_string] = STATE(371),
    [sym__single_quoted_string] = STATE(292),
    [sym__double_quoted_string] = STATE(293),
    [aux_sym_function_definition_repeat1] = STATE(245),
    [sym_identifier] = ACTIONS(367),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(371),
    [anon_sym_EQ] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(371),
    [anon_sym_for] = ACTIONS(371),
    [anon_sym_while] = ACTIONS(371),
    [anon_sym_repeat] = ACTIONS(371),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(369),
    [anon_sym_BANG] = ACTIONS(371),
    [anon_sym_PLUS] = ACTIONS(369),
    [anon_sym_DASH] = ACTIONS(371),
    [anon_sym_LT_DASH] = ACTIONS(369),
    [anon_sym_LT_LT_DASH] = ACTIONS(369),
    [anon_sym_COLON_EQ] = ACTIONS(369),
    [anon_sym_DASH_GT] = ACTIONS(371),
    [anon_sym_DASH_GT_GT] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(371),
    [anon_sym_AMP] = ACTIONS(371),
    [anon_sym_PIPE_PIPE] = ACTIONS(369),
    [anon_sym_AMP_AMP] = ACTIONS(369),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_LT_EQ] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_EQ] = ACTIONS(369),
    [anon_sym_EQ_EQ] = ACTIONS(369),
    [anon_sym_BANG_EQ] = ACTIONS(369),
    [anon_sym_STAR] = ACTIONS(371),
    [anon_sym_SLASH] = ACTIONS(369),
    [anon_sym_STAR_STAR] = ACTIONS(369),
    [anon_sym_CARET] = ACTIONS(369),
    [aux_sym_binary_operator_token1] = ACTIONS(369),
    [anon_sym_PIPE_GT] = ACTIONS(369),
    [anon_sym_COLON] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [anon_sym_AT] = ACTIONS(369),
    [sym__hex_literal] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [sym_dots] = ACTIONS(367),
    [sym_dot_dot_i] = ACTIONS(367),
    [sym_return] = ACTIONS(371),
    [sym_next] = ACTIONS(371),
    [sym_break] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_inf] = ACTIONS(371),
    [sym_nan] = ACTIONS(371),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(373),
    [sym__semicolon] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(365),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(369),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_close_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(369),
    [sym__external_open_bracket2] = ACTIONS(369),
  },
  [247] = {
    [sym_string] = STATE(363),
    [sym__single_quoted_string] = STATE(288),
    [sym__double_quoted_string] = STATE(289),
    [aux_sym_function_definition_repeat1] = STATE(244),
    [ts_builtin_sym_end] = ACTIONS(369),
    [sym_identifier] = ACTIONS(375),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(371),
    [anon_sym_EQ] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(371),
    [anon_sym_for] = ACTIONS(371),
    [anon_sym_while] = ACTIONS(371),
    [anon_sym_repeat] = ACTIONS(371),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(369),
    [anon_sym_BANG] = ACTIONS(371),
    [anon_sym_PLUS] = ACTIONS(369),
    [anon_sym_DASH] = ACTIONS(371),
    [anon_sym_LT_DASH] = ACTIONS(369),
    [anon_sym_LT_LT_DASH] = ACTIONS(369),
    [anon_sym_COLON_EQ] = ACTIONS(369),
    [anon_sym_DASH_GT] = ACTIONS(371),
    [anon_sym_DASH_GT_GT] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(371),
    [anon_sym_AMP] = ACTIONS(371),
    [anon_sym_PIPE_PIPE] = ACTIONS(369),
    [anon_sym_AMP_AMP] = ACTIONS(369),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_LT_EQ] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_EQ] = ACTIONS(369),
    [anon_sym_EQ_EQ] = ACTIONS(369),
    [anon_sym_BANG_EQ] = ACTIONS(369),
    [anon_sym_STAR] = ACTIONS(371),
    [anon_sym_SLASH] = ACTIONS(369),
    [anon_sym_STAR_STAR] = ACTIONS(369),
    [anon_sym_CARET] = ACTIONS(369),
    [aux_sym_binary_operator_token1] = ACTIONS(369),
    [anon_sym_PIPE_GT] = ACTIONS(369),
    [anon_sym_COLON] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [anon_sym_AT] = ACTIONS(369),
    [sym__hex_literal] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(353),
    [anon_sym_DQUOTE] = ACTIONS(355),
    [sym_dots] = ACTIONS(375),
    [sym_dot_dot_i] = ACTIONS(375),
    [sym_return] = ACTIONS(371),
    [sym_next] = ACTIONS(371),
    [sym_break] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_inf] = ACTIONS(371),
    [sym_nan] = ACTIONS(371),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(377),
    [sym__semicolon] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(357),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(369),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(369),
    [sym__external_open_bracket2] = ACTIONS(369),
  },
  [248] = {
    [sym_function_definition] = STATE(1361),
    [sym_if_statement] = STATE(1361),
    [sym_for_statement] = STATE(1361),
    [sym_while_statement] = STATE(1361),
    [sym_repeat_statement] = STATE(1361),
    [sym_braced_expression] = STATE(1361),
    [sym_parenthesized_expression] = STATE(1361),
    [sym_call] = STATE(1361),
    [sym_subset] = STATE(1361),
    [sym_subset2] = STATE(1361),
    [sym_argument] = STATE(1839),
    [sym__argument_named] = STATE(2046),
    [sym__argument_unnamed] = STATE(2031),
    [sym__argument_value] = STATE(2030),
    [sym_unary_operator] = STATE(1361),
    [sym_binary_operator] = STATE(1361),
    [sym_extract_operator] = STATE(1361),
    [sym_namespace_operator] = STATE(1361),
    [sym_integer] = STATE(1361),
    [sym_complex] = STATE(1361),
    [sym_float] = STATE(1361),
    [sym__float_literal] = STATE(1620),
    [sym_string] = STATE(1630),
    [sym__single_quoted_string] = STATE(1624),
    [sym__double_quoted_string] = STATE(1625),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2059),
    [sym_na] = STATE(1361),
    [sym__expression] = STATE(1361),
    [sym__open_parenthesis] = STATE(1056),
    [sym__close_parenthesis] = STATE(1751),
    [sym__open_brace] = STATE(402),
    [aux_sym_call_arguments_repeat1] = STATE(1840),
    [sym_identifier] = ACTIONS(379),
    [anon_sym_BSLASH] = ACTIONS(381),
    [anon_sym_function] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_while] = ACTIONS(389),
    [anon_sym_repeat] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(395),
    [anon_sym_BANG] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [sym__hex_literal] = ACTIONS(401),
    [sym__number_literal] = ACTIONS(403),
    [anon_sym_SQUOTE] = ACTIONS(405),
    [anon_sym_DQUOTE] = ACTIONS(407),
    [sym_dots] = ACTIONS(379),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_return] = ACTIONS(409),
    [sym_next] = ACTIONS(409),
    [sym_break] = ACTIONS(409),
    [sym_true] = ACTIONS(409),
    [sym_false] = ACTIONS(409),
    [sym_null] = ACTIONS(411),
    [sym_inf] = ACTIONS(409),
    [sym_nan] = ACTIONS(409),
    [anon_sym_NA] = ACTIONS(413),
    [anon_sym_NA_integer_] = ACTIONS(413),
    [anon_sym_NA_real_] = ACTIONS(413),
    [anon_sym_NA_complex_] = ACTIONS(413),
    [anon_sym_NA_character_] = ACTIONS(413),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(415),
    [sym__raw_string_literal] = ACTIONS(417),
    [sym__external_open_parenthesis] = ACTIONS(419),
    [sym__external_close_parenthesis] = ACTIONS(421),
    [sym__external_open_brace] = ACTIONS(423),
  },
  [249] = {
    [sym_function_definition] = STATE(1552),
    [sym_if_statement] = STATE(1552),
    [sym_for_statement] = STATE(1552),
    [sym_while_statement] = STATE(1552),
    [sym_repeat_statement] = STATE(1552),
    [sym_braced_expression] = STATE(1552),
    [sym_parenthesized_expression] = STATE(1552),
    [sym_call] = STATE(1552),
    [sym_subset] = STATE(1552),
    [sym_subset2] = STATE(1552),
    [sym_argument] = STATE(1939),
    [sym__argument_named] = STATE(2040),
    [sym__argument_unnamed] = STATE(2035),
    [sym__argument_value] = STATE(2047),
    [sym_unary_operator] = STATE(1552),
    [sym_binary_operator] = STATE(1552),
    [sym_extract_operator] = STATE(1552),
    [sym_namespace_operator] = STATE(1552),
    [sym_integer] = STATE(1552),
    [sym_complex] = STATE(1552),
    [sym_float] = STATE(1552),
    [sym__float_literal] = STATE(1610),
    [sym_string] = STATE(1627),
    [sym__single_quoted_string] = STATE(1604),
    [sym__double_quoted_string] = STATE(1632),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2054),
    [sym_na] = STATE(1552),
    [sym__expression] = STATE(1552),
    [sym__open_parenthesis] = STATE(1069),
    [sym__open_brace] = STATE(422),
    [sym__close_bracket2] = STATE(1679),
    [aux_sym_call_arguments_repeat1] = STATE(1850),
    [sym_identifier] = ACTIONS(425),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_function] = ACTIONS(429),
    [anon_sym_if] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_repeat] = ACTIONS(437),
    [anon_sym_QMARK] = ACTIONS(439),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_PLUS] = ACTIONS(445),
    [anon_sym_DASH] = ACTIONS(445),
    [sym__hex_literal] = ACTIONS(447),
    [sym__number_literal] = ACTIONS(449),
    [anon_sym_SQUOTE] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(453),
    [sym_dots] = ACTIONS(425),
    [sym_dot_dot_i] = ACTIONS(425),
    [sym_return] = ACTIONS(455),
    [sym_next] = ACTIONS(455),
    [sym_break] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_null] = ACTIONS(457),
    [sym_inf] = ACTIONS(455),
    [sym_nan] = ACTIONS(455),
    [anon_sym_NA] = ACTIONS(459),
    [anon_sym_NA_integer_] = ACTIONS(459),
    [anon_sym_NA_real_] = ACTIONS(459),
    [anon_sym_NA_complex_] = ACTIONS(459),
    [anon_sym_NA_character_] = ACTIONS(459),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(461),
    [sym__raw_string_literal] = ACTIONS(463),
    [sym__external_open_parenthesis] = ACTIONS(465),
    [sym__external_open_brace] = ACTIONS(467),
    [sym__external_close_bracket2] = ACTIONS(469),
  },
  [250] = {
    [sym_string] = STATE(435),
    [sym__single_quoted_string] = STATE(316),
    [sym__double_quoted_string] = STATE(317),
    [aux_sym_function_definition_repeat1] = STATE(334),
    [sym_identifier] = ACTIONS(471),
    [anon_sym_BSLASH] = ACTIONS(347),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_EQ] = ACTIONS(351),
    [anon_sym_if] = ACTIONS(351),
    [anon_sym_for] = ACTIONS(351),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(351),
    [anon_sym_QMARK] = ACTIONS(347),
    [anon_sym_TILDE] = ACTIONS(347),
    [anon_sym_BANG] = ACTIONS(351),
    [anon_sym_PLUS] = ACTIONS(347),
    [anon_sym_DASH] = ACTIONS(351),
    [anon_sym_LT_DASH] = ACTIONS(347),
    [anon_sym_LT_LT_DASH] = ACTIONS(347),
    [anon_sym_COLON_EQ] = ACTIONS(347),
    [anon_sym_DASH_GT] = ACTIONS(351),
    [anon_sym_DASH_GT_GT] = ACTIONS(347),
    [anon_sym_PIPE] = ACTIONS(351),
    [anon_sym_AMP] = ACTIONS(351),
    [anon_sym_PIPE_PIPE] = ACTIONS(347),
    [anon_sym_AMP_AMP] = ACTIONS(347),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_LT_EQ] = ACTIONS(347),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_EQ] = ACTIONS(347),
    [anon_sym_EQ_EQ] = ACTIONS(347),
    [anon_sym_BANG_EQ] = ACTIONS(347),
    [anon_sym_STAR] = ACTIONS(351),
    [anon_sym_SLASH] = ACTIONS(347),
    [anon_sym_STAR_STAR] = ACTIONS(347),
    [anon_sym_CARET] = ACTIONS(347),
    [aux_sym_binary_operator_token1] = ACTIONS(347),
    [anon_sym_PIPE_GT] = ACTIONS(347),
    [anon_sym_COLON] = ACTIONS(351),
    [anon_sym_DOLLAR] = ACTIONS(347),
    [anon_sym_AT] = ACTIONS(347),
    [sym__hex_literal] = ACTIONS(347),
    [sym__number_literal] = ACTIONS(351),
    [anon_sym_SQUOTE] = ACTIONS(473),
    [anon_sym_DQUOTE] = ACTIONS(475),
    [sym_dots] = ACTIONS(471),
    [sym_dot_dot_i] = ACTIONS(471),
    [sym_return] = ACTIONS(351),
    [sym_next] = ACTIONS(351),
    [sym_break] = ACTIONS(351),
    [sym_true] = ACTIONS(351),
    [sym_false] = ACTIONS(351),
    [sym_null] = ACTIONS(351),
    [sym_inf] = ACTIONS(351),
    [sym_nan] = ACTIONS(351),
    [anon_sym_NA] = ACTIONS(351),
    [anon_sym_NA_integer_] = ACTIONS(351),
    [anon_sym_NA_real_] = ACTIONS(351),
    [anon_sym_NA_complex_] = ACTIONS(351),
    [anon_sym_NA_character_] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(347),
    [sym__semicolon] = ACTIONS(347),
    [sym__raw_string_literal] = ACTIONS(477),
    [sym__external_open_parenthesis] = ACTIONS(347),
    [sym__external_open_brace] = ACTIONS(347),
    [sym__external_close_brace] = ACTIONS(347),
    [sym__external_open_bracket] = ACTIONS(347),
    [sym__external_open_bracket2] = ACTIONS(347),
  },
  [251] = {
    [sym_string] = STATE(420),
    [sym__single_quoted_string] = STATE(308),
    [sym__double_quoted_string] = STATE(309),
    [aux_sym_function_definition_repeat1] = STATE(354),
    [ts_builtin_sym_end] = ACTIONS(347),
    [sym_identifier] = ACTIONS(479),
    [anon_sym_BSLASH] = ACTIONS(347),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_EQ] = ACTIONS(351),
    [anon_sym_if] = ACTIONS(351),
    [anon_sym_for] = ACTIONS(351),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(351),
    [anon_sym_QMARK] = ACTIONS(347),
    [anon_sym_TILDE] = ACTIONS(347),
    [anon_sym_BANG] = ACTIONS(351),
    [anon_sym_PLUS] = ACTIONS(347),
    [anon_sym_DASH] = ACTIONS(351),
    [anon_sym_LT_DASH] = ACTIONS(347),
    [anon_sym_LT_LT_DASH] = ACTIONS(347),
    [anon_sym_COLON_EQ] = ACTIONS(347),
    [anon_sym_DASH_GT] = ACTIONS(351),
    [anon_sym_DASH_GT_GT] = ACTIONS(347),
    [anon_sym_PIPE] = ACTIONS(351),
    [anon_sym_AMP] = ACTIONS(351),
    [anon_sym_PIPE_PIPE] = ACTIONS(347),
    [anon_sym_AMP_AMP] = ACTIONS(347),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_LT_EQ] = ACTIONS(347),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_EQ] = ACTIONS(347),
    [anon_sym_EQ_EQ] = ACTIONS(347),
    [anon_sym_BANG_EQ] = ACTIONS(347),
    [anon_sym_STAR] = ACTIONS(351),
    [anon_sym_SLASH] = ACTIONS(347),
    [anon_sym_STAR_STAR] = ACTIONS(347),
    [anon_sym_CARET] = ACTIONS(347),
    [aux_sym_binary_operator_token1] = ACTIONS(347),
    [anon_sym_PIPE_GT] = ACTIONS(347),
    [anon_sym_COLON] = ACTIONS(351),
    [anon_sym_DOLLAR] = ACTIONS(347),
    [anon_sym_AT] = ACTIONS(347),
    [sym__hex_literal] = ACTIONS(347),
    [sym__number_literal] = ACTIONS(351),
    [anon_sym_SQUOTE] = ACTIONS(481),
    [anon_sym_DQUOTE] = ACTIONS(483),
    [sym_dots] = ACTIONS(479),
    [sym_dot_dot_i] = ACTIONS(479),
    [sym_return] = ACTIONS(351),
    [sym_next] = ACTIONS(351),
    [sym_break] = ACTIONS(351),
    [sym_true] = ACTIONS(351),
    [sym_false] = ACTIONS(351),
    [sym_null] = ACTIONS(351),
    [sym_inf] = ACTIONS(351),
    [sym_nan] = ACTIONS(351),
    [anon_sym_NA] = ACTIONS(351),
    [anon_sym_NA_integer_] = ACTIONS(351),
    [anon_sym_NA_real_] = ACTIONS(351),
    [anon_sym_NA_complex_] = ACTIONS(351),
    [anon_sym_NA_character_] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(347),
    [sym__semicolon] = ACTIONS(347),
    [sym__raw_string_literal] = ACTIONS(485),
    [sym__external_open_parenthesis] = ACTIONS(347),
    [sym__external_open_brace] = ACTIONS(347),
    [sym__external_open_bracket] = ACTIONS(347),
    [sym__external_open_bracket2] = ACTIONS(347),
  },
  [252] = {
    [sym_string] = STATE(361),
    [sym__single_quoted_string] = STATE(292),
    [sym__double_quoted_string] = STATE(293),
    [sym_identifier] = ACTIONS(487),
    [anon_sym_BSLASH] = ACTIONS(489),
    [anon_sym_function] = ACTIONS(491),
    [anon_sym_EQ] = ACTIONS(491),
    [anon_sym_if] = ACTIONS(491),
    [anon_sym_for] = ACTIONS(491),
    [anon_sym_while] = ACTIONS(491),
    [anon_sym_repeat] = ACTIONS(491),
    [anon_sym_QMARK] = ACTIONS(489),
    [anon_sym_TILDE] = ACTIONS(489),
    [anon_sym_BANG] = ACTIONS(491),
    [anon_sym_PLUS] = ACTIONS(489),
    [anon_sym_DASH] = ACTIONS(491),
    [anon_sym_LT_DASH] = ACTIONS(489),
    [anon_sym_LT_LT_DASH] = ACTIONS(489),
    [anon_sym_COLON_EQ] = ACTIONS(489),
    [anon_sym_DASH_GT] = ACTIONS(491),
    [anon_sym_DASH_GT_GT] = ACTIONS(489),
    [anon_sym_PIPE] = ACTIONS(491),
    [anon_sym_AMP] = ACTIONS(491),
    [anon_sym_PIPE_PIPE] = ACTIONS(489),
    [anon_sym_AMP_AMP] = ACTIONS(489),
    [anon_sym_LT] = ACTIONS(491),
    [anon_sym_LT_EQ] = ACTIONS(489),
    [anon_sym_GT] = ACTIONS(491),
    [anon_sym_GT_EQ] = ACTIONS(489),
    [anon_sym_EQ_EQ] = ACTIONS(489),
    [anon_sym_BANG_EQ] = ACTIONS(489),
    [anon_sym_STAR] = ACTIONS(491),
    [anon_sym_SLASH] = ACTIONS(489),
    [anon_sym_STAR_STAR] = ACTIONS(489),
    [anon_sym_CARET] = ACTIONS(489),
    [aux_sym_binary_operator_token1] = ACTIONS(489),
    [anon_sym_PIPE_GT] = ACTIONS(489),
    [anon_sym_COLON] = ACTIONS(491),
    [anon_sym_DOLLAR] = ACTIONS(489),
    [anon_sym_AT] = ACTIONS(489),
    [sym__hex_literal] = ACTIONS(489),
    [sym__number_literal] = ACTIONS(491),
    [anon_sym_SQUOTE] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [sym_dots] = ACTIONS(487),
    [sym_dot_dot_i] = ACTIONS(487),
    [sym_return] = ACTIONS(491),
    [sym_next] = ACTIONS(491),
    [sym_break] = ACTIONS(491),
    [sym_true] = ACTIONS(491),
    [sym_false] = ACTIONS(491),
    [sym_null] = ACTIONS(491),
    [sym_inf] = ACTIONS(491),
    [sym_nan] = ACTIONS(491),
    [anon_sym_NA] = ACTIONS(491),
    [anon_sym_NA_integer_] = ACTIONS(491),
    [anon_sym_NA_real_] = ACTIONS(491),
    [anon_sym_NA_complex_] = ACTIONS(491),
    [anon_sym_NA_character_] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(489),
    [sym__semicolon] = ACTIONS(489),
    [sym__raw_string_literal] = ACTIONS(365),
    [sym__external_else] = ACTIONS(489),
    [sym__external_open_parenthesis] = ACTIONS(489),
    [sym__external_open_brace] = ACTIONS(489),
    [sym__external_close_brace] = ACTIONS(489),
    [sym__external_open_bracket] = ACTIONS(489),
    [sym__external_open_bracket2] = ACTIONS(489),
  },
  [253] = {
    [sym_function_definition] = STATE(1575),
    [sym_if_statement] = STATE(1575),
    [sym_for_statement] = STATE(1575),
    [sym_while_statement] = STATE(1575),
    [sym_repeat_statement] = STATE(1575),
    [sym_braced_expression] = STATE(1575),
    [sym_parenthesized_expression] = STATE(1575),
    [sym_call] = STATE(1575),
    [sym_subset] = STATE(1575),
    [sym_subset2] = STATE(1575),
    [sym_argument] = STATE(1846),
    [sym__argument_named] = STATE(2032),
    [sym__argument_unnamed] = STATE(2045),
    [sym__argument_value] = STATE(2043),
    [sym_unary_operator] = STATE(1575),
    [sym_binary_operator] = STATE(1575),
    [sym_extract_operator] = STATE(1575),
    [sym_namespace_operator] = STATE(1575),
    [sym_integer] = STATE(1575),
    [sym_complex] = STATE(1575),
    [sym_float] = STATE(1575),
    [sym__float_literal] = STATE(1626),
    [sym_string] = STATE(1628),
    [sym__single_quoted_string] = STATE(1629),
    [sym__double_quoted_string] = STATE(1611),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2071),
    [sym_na] = STATE(1575),
    [sym__expression] = STATE(1575),
    [sym__open_parenthesis] = STATE(1064),
    [sym__open_brace] = STATE(418),
    [sym__close_bracket] = STATE(443),
    [aux_sym_call_arguments_repeat1] = STATE(1964),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(495),
    [anon_sym_function] = ACTIONS(497),
    [anon_sym_if] = ACTIONS(499),
    [anon_sym_for] = ACTIONS(501),
    [anon_sym_while] = ACTIONS(503),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_QMARK] = ACTIONS(507),
    [anon_sym_TILDE] = ACTIONS(509),
    [anon_sym_BANG] = ACTIONS(511),
    [anon_sym_PLUS] = ACTIONS(513),
    [anon_sym_DASH] = ACTIONS(513),
    [sym__hex_literal] = ACTIONS(515),
    [sym__number_literal] = ACTIONS(517),
    [anon_sym_SQUOTE] = ACTIONS(519),
    [anon_sym_DQUOTE] = ACTIONS(521),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(493),
    [sym_return] = ACTIONS(523),
    [sym_next] = ACTIONS(523),
    [sym_break] = ACTIONS(523),
    [sym_true] = ACTIONS(523),
    [sym_false] = ACTIONS(523),
    [sym_null] = ACTIONS(525),
    [sym_inf] = ACTIONS(523),
    [sym_nan] = ACTIONS(523),
    [anon_sym_NA] = ACTIONS(527),
    [anon_sym_NA_integer_] = ACTIONS(527),
    [anon_sym_NA_real_] = ACTIONS(527),
    [anon_sym_NA_complex_] = ACTIONS(527),
    [anon_sym_NA_character_] = ACTIONS(527),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(529),
    [sym__raw_string_literal] = ACTIONS(531),
    [sym__external_open_parenthesis] = ACTIONS(533),
    [sym__external_open_brace] = ACTIONS(535),
    [sym__external_close_bracket] = ACTIONS(537),
  },
  [254] = {
    [sym_string] = STATE(340),
    [sym__single_quoted_string] = STATE(288),
    [sym__double_quoted_string] = STATE(289),
    [ts_builtin_sym_end] = ACTIONS(489),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_BSLASH] = ACTIONS(489),
    [anon_sym_function] = ACTIONS(491),
    [anon_sym_EQ] = ACTIONS(491),
    [anon_sym_if] = ACTIONS(491),
    [anon_sym_for] = ACTIONS(491),
    [anon_sym_while] = ACTIONS(491),
    [anon_sym_repeat] = ACTIONS(491),
    [anon_sym_QMARK] = ACTIONS(489),
    [anon_sym_TILDE] = ACTIONS(489),
    [anon_sym_BANG] = ACTIONS(491),
    [anon_sym_PLUS] = ACTIONS(489),
    [anon_sym_DASH] = ACTIONS(491),
    [anon_sym_LT_DASH] = ACTIONS(489),
    [anon_sym_LT_LT_DASH] = ACTIONS(489),
    [anon_sym_COLON_EQ] = ACTIONS(489),
    [anon_sym_DASH_GT] = ACTIONS(491),
    [anon_sym_DASH_GT_GT] = ACTIONS(489),
    [anon_sym_PIPE] = ACTIONS(491),
    [anon_sym_AMP] = ACTIONS(491),
    [anon_sym_PIPE_PIPE] = ACTIONS(489),
    [anon_sym_AMP_AMP] = ACTIONS(489),
    [anon_sym_LT] = ACTIONS(491),
    [anon_sym_LT_EQ] = ACTIONS(489),
    [anon_sym_GT] = ACTIONS(491),
    [anon_sym_GT_EQ] = ACTIONS(489),
    [anon_sym_EQ_EQ] = ACTIONS(489),
    [anon_sym_BANG_EQ] = ACTIONS(489),
    [anon_sym_STAR] = ACTIONS(491),
    [anon_sym_SLASH] = ACTIONS(489),
    [anon_sym_STAR_STAR] = ACTIONS(489),
    [anon_sym_CARET] = ACTIONS(489),
    [aux_sym_binary_operator_token1] = ACTIONS(489),
    [anon_sym_PIPE_GT] = ACTIONS(489),
    [anon_sym_COLON] = ACTIONS(491),
    [anon_sym_DOLLAR] = ACTIONS(489),
    [anon_sym_AT] = ACTIONS(489),
    [sym__hex_literal] = ACTIONS(489),
    [sym__number_literal] = ACTIONS(491),
    [anon_sym_SQUOTE] = ACTIONS(353),
    [anon_sym_DQUOTE] = ACTIONS(355),
    [sym_dots] = ACTIONS(539),
    [sym_dot_dot_i] = ACTIONS(539),
    [sym_return] = ACTIONS(491),
    [sym_next] = ACTIONS(491),
    [sym_break] = ACTIONS(491),
    [sym_true] = ACTIONS(491),
    [sym_false] = ACTIONS(491),
    [sym_null] = ACTIONS(491),
    [sym_inf] = ACTIONS(491),
    [sym_nan] = ACTIONS(491),
    [anon_sym_NA] = ACTIONS(491),
    [anon_sym_NA_integer_] = ACTIONS(491),
    [anon_sym_NA_real_] = ACTIONS(491),
    [anon_sym_NA_complex_] = ACTIONS(491),
    [anon_sym_NA_character_] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(489),
    [sym__semicolon] = ACTIONS(489),
    [sym__raw_string_literal] = ACTIONS(357),
    [sym__external_else] = ACTIONS(489),
    [sym__external_open_parenthesis] = ACTIONS(489),
    [sym__external_open_brace] = ACTIONS(489),
    [sym__external_open_bracket] = ACTIONS(489),
    [sym__external_open_bracket2] = ACTIONS(489),
  },
  [255] = {
    [sym_function_definition] = STATE(1361),
    [sym_if_statement] = STATE(1361),
    [sym_for_statement] = STATE(1361),
    [sym_while_statement] = STATE(1361),
    [sym_repeat_statement] = STATE(1361),
    [sym_braced_expression] = STATE(1361),
    [sym_parenthesized_expression] = STATE(1361),
    [sym_call] = STATE(1361),
    [sym_subset] = STATE(1361),
    [sym_subset2] = STATE(1361),
    [sym_argument] = STATE(1902),
    [sym__argument_named] = STATE(2046),
    [sym__argument_unnamed] = STATE(2031),
    [sym__argument_value] = STATE(2030),
    [sym_unary_operator] = STATE(1361),
    [sym_binary_operator] = STATE(1361),
    [sym_extract_operator] = STATE(1361),
    [sym_namespace_operator] = STATE(1361),
    [sym_integer] = STATE(1361),
    [sym_complex] = STATE(1361),
    [sym_float] = STATE(1361),
    [sym__float_literal] = STATE(1620),
    [sym_string] = STATE(1630),
    [sym__single_quoted_string] = STATE(1624),
    [sym__double_quoted_string] = STATE(1625),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2059),
    [sym_na] = STATE(1361),
    [sym__expression] = STATE(1361),
    [sym__open_parenthesis] = STATE(1056),
    [sym__close_parenthesis] = STATE(1713),
    [sym__open_brace] = STATE(402),
    [aux_sym_call_arguments_repeat1] = STATE(1908),
    [sym_identifier] = ACTIONS(379),
    [anon_sym_BSLASH] = ACTIONS(381),
    [anon_sym_function] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_while] = ACTIONS(389),
    [anon_sym_repeat] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(395),
    [anon_sym_BANG] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [sym__hex_literal] = ACTIONS(401),
    [sym__number_literal] = ACTIONS(403),
    [anon_sym_SQUOTE] = ACTIONS(405),
    [anon_sym_DQUOTE] = ACTIONS(407),
    [sym_dots] = ACTIONS(379),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_return] = ACTIONS(409),
    [sym_next] = ACTIONS(409),
    [sym_break] = ACTIONS(409),
    [sym_true] = ACTIONS(409),
    [sym_false] = ACTIONS(409),
    [sym_null] = ACTIONS(411),
    [sym_inf] = ACTIONS(409),
    [sym_nan] = ACTIONS(409),
    [anon_sym_NA] = ACTIONS(413),
    [anon_sym_NA_integer_] = ACTIONS(413),
    [anon_sym_NA_real_] = ACTIONS(413),
    [anon_sym_NA_complex_] = ACTIONS(413),
    [anon_sym_NA_character_] = ACTIONS(413),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(415),
    [sym__raw_string_literal] = ACTIONS(417),
    [sym__external_open_parenthesis] = ACTIONS(419),
    [sym__external_close_parenthesis] = ACTIONS(541),
    [sym__external_open_brace] = ACTIONS(423),
  },
  [256] = {
    [sym_function_definition] = STATE(1575),
    [sym_if_statement] = STATE(1575),
    [sym_for_statement] = STATE(1575),
    [sym_while_statement] = STATE(1575),
    [sym_repeat_statement] = STATE(1575),
    [sym_braced_expression] = STATE(1575),
    [sym_parenthesized_expression] = STATE(1575),
    [sym_call] = STATE(1575),
    [sym_subset] = STATE(1575),
    [sym_subset2] = STATE(1575),
    [sym_argument] = STATE(1810),
    [sym__argument_named] = STATE(2032),
    [sym__argument_unnamed] = STATE(2045),
    [sym__argument_value] = STATE(2043),
    [sym_unary_operator] = STATE(1575),
    [sym_binary_operator] = STATE(1575),
    [sym_extract_operator] = STATE(1575),
    [sym_namespace_operator] = STATE(1575),
    [sym_integer] = STATE(1575),
    [sym_complex] = STATE(1575),
    [sym_float] = STATE(1575),
    [sym__float_literal] = STATE(1626),
    [sym_string] = STATE(1628),
    [sym__single_quoted_string] = STATE(1629),
    [sym__double_quoted_string] = STATE(1611),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2071),
    [sym_na] = STATE(1575),
    [sym__expression] = STATE(1575),
    [sym__open_parenthesis] = STATE(1064),
    [sym__open_brace] = STATE(418),
    [sym__close_bracket] = STATE(1714),
    [aux_sym_call_arguments_repeat1] = STATE(1838),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(495),
    [anon_sym_function] = ACTIONS(497),
    [anon_sym_if] = ACTIONS(499),
    [anon_sym_for] = ACTIONS(501),
    [anon_sym_while] = ACTIONS(503),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_QMARK] = ACTIONS(507),
    [anon_sym_TILDE] = ACTIONS(509),
    [anon_sym_BANG] = ACTIONS(511),
    [anon_sym_PLUS] = ACTIONS(513),
    [anon_sym_DASH] = ACTIONS(513),
    [sym__hex_literal] = ACTIONS(515),
    [sym__number_literal] = ACTIONS(517),
    [anon_sym_SQUOTE] = ACTIONS(519),
    [anon_sym_DQUOTE] = ACTIONS(521),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(493),
    [sym_return] = ACTIONS(523),
    [sym_next] = ACTIONS(523),
    [sym_break] = ACTIONS(523),
    [sym_true] = ACTIONS(523),
    [sym_false] = ACTIONS(523),
    [sym_null] = ACTIONS(525),
    [sym_inf] = ACTIONS(523),
    [sym_nan] = ACTIONS(523),
    [anon_sym_NA] = ACTIONS(527),
    [anon_sym_NA_integer_] = ACTIONS(527),
    [anon_sym_NA_real_] = ACTIONS(527),
    [anon_sym_NA_complex_] = ACTIONS(527),
    [anon_sym_NA_character_] = ACTIONS(527),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(529),
    [sym__raw_string_literal] = ACTIONS(531),
    [sym__external_open_parenthesis] = ACTIONS(533),
    [sym__external_open_brace] = ACTIONS(535),
    [sym__external_close_bracket] = ACTIONS(543),
  },
  [257] = {
    [sym_function_definition] = STATE(1552),
    [sym_if_statement] = STATE(1552),
    [sym_for_statement] = STATE(1552),
    [sym_while_statement] = STATE(1552),
    [sym_repeat_statement] = STATE(1552),
    [sym_braced_expression] = STATE(1552),
    [sym_parenthesized_expression] = STATE(1552),
    [sym_call] = STATE(1552),
    [sym_subset] = STATE(1552),
    [sym_subset2] = STATE(1552),
    [sym_argument] = STATE(1830),
    [sym__argument_named] = STATE(2040),
    [sym__argument_unnamed] = STATE(2035),
    [sym__argument_value] = STATE(2047),
    [sym_unary_operator] = STATE(1552),
    [sym_binary_operator] = STATE(1552),
    [sym_extract_operator] = STATE(1552),
    [sym_namespace_operator] = STATE(1552),
    [sym_integer] = STATE(1552),
    [sym_complex] = STATE(1552),
    [sym_float] = STATE(1552),
    [sym__float_literal] = STATE(1610),
    [sym_string] = STATE(1627),
    [sym__single_quoted_string] = STATE(1604),
    [sym__double_quoted_string] = STATE(1632),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2054),
    [sym_na] = STATE(1552),
    [sym__expression] = STATE(1552),
    [sym__open_parenthesis] = STATE(1069),
    [sym__open_brace] = STATE(422),
    [sym__close_bracket2] = STATE(1734),
    [aux_sym_call_arguments_repeat1] = STATE(1808),
    [sym_identifier] = ACTIONS(425),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_function] = ACTIONS(429),
    [anon_sym_if] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_repeat] = ACTIONS(437),
    [anon_sym_QMARK] = ACTIONS(439),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_PLUS] = ACTIONS(445),
    [anon_sym_DASH] = ACTIONS(445),
    [sym__hex_literal] = ACTIONS(447),
    [sym__number_literal] = ACTIONS(449),
    [anon_sym_SQUOTE] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(453),
    [sym_dots] = ACTIONS(425),
    [sym_dot_dot_i] = ACTIONS(425),
    [sym_return] = ACTIONS(455),
    [sym_next] = ACTIONS(455),
    [sym_break] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_null] = ACTIONS(457),
    [sym_inf] = ACTIONS(455),
    [sym_nan] = ACTIONS(455),
    [anon_sym_NA] = ACTIONS(459),
    [anon_sym_NA_integer_] = ACTIONS(459),
    [anon_sym_NA_real_] = ACTIONS(459),
    [anon_sym_NA_complex_] = ACTIONS(459),
    [anon_sym_NA_character_] = ACTIONS(459),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(461),
    [sym__raw_string_literal] = ACTIONS(463),
    [sym__external_open_parenthesis] = ACTIONS(465),
    [sym__external_open_brace] = ACTIONS(467),
    [sym__external_close_bracket2] = ACTIONS(545),
  },
  [258] = {
    [sym_function_definition] = STATE(1552),
    [sym_if_statement] = STATE(1552),
    [sym_for_statement] = STATE(1552),
    [sym_while_statement] = STATE(1552),
    [sym_repeat_statement] = STATE(1552),
    [sym_braced_expression] = STATE(1552),
    [sym_parenthesized_expression] = STATE(1552),
    [sym_call] = STATE(1552),
    [sym_subset] = STATE(1552),
    [sym_subset2] = STATE(1552),
    [sym_argument] = STATE(1819),
    [sym__argument_named] = STATE(2040),
    [sym__argument_unnamed] = STATE(2035),
    [sym__argument_value] = STATE(2047),
    [sym_unary_operator] = STATE(1552),
    [sym_binary_operator] = STATE(1552),
    [sym_extract_operator] = STATE(1552),
    [sym_namespace_operator] = STATE(1552),
    [sym_integer] = STATE(1552),
    [sym_complex] = STATE(1552),
    [sym_float] = STATE(1552),
    [sym__float_literal] = STATE(1610),
    [sym_string] = STATE(1627),
    [sym__single_quoted_string] = STATE(1604),
    [sym__double_quoted_string] = STATE(1632),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2054),
    [sym_na] = STATE(1552),
    [sym__expression] = STATE(1552),
    [sym__open_parenthesis] = STATE(1069),
    [sym__open_brace] = STATE(422),
    [sym__close_bracket2] = STATE(387),
    [aux_sym_call_arguments_repeat1] = STATE(1857),
    [sym_identifier] = ACTIONS(425),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_function] = ACTIONS(429),
    [anon_sym_if] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_repeat] = ACTIONS(437),
    [anon_sym_QMARK] = ACTIONS(439),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_PLUS] = ACTIONS(445),
    [anon_sym_DASH] = ACTIONS(445),
    [sym__hex_literal] = ACTIONS(447),
    [sym__number_literal] = ACTIONS(449),
    [anon_sym_SQUOTE] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(453),
    [sym_dots] = ACTIONS(425),
    [sym_dot_dot_i] = ACTIONS(425),
    [sym_return] = ACTIONS(455),
    [sym_next] = ACTIONS(455),
    [sym_break] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_null] = ACTIONS(457),
    [sym_inf] = ACTIONS(455),
    [sym_nan] = ACTIONS(455),
    [anon_sym_NA] = ACTIONS(459),
    [anon_sym_NA_integer_] = ACTIONS(459),
    [anon_sym_NA_real_] = ACTIONS(459),
    [anon_sym_NA_complex_] = ACTIONS(459),
    [anon_sym_NA_character_] = ACTIONS(459),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(461),
    [sym__raw_string_literal] = ACTIONS(463),
    [sym__external_open_parenthesis] = ACTIONS(465),
    [sym__external_open_brace] = ACTIONS(467),
    [sym__external_close_bracket2] = ACTIONS(547),
  },
  [259] = {
    [sym_string] = STATE(405),
    [sym__single_quoted_string] = STATE(316),
    [sym__double_quoted_string] = STATE(317),
    [aux_sym_function_definition_repeat1] = STATE(250),
    [sym_identifier] = ACTIONS(549),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(371),
    [anon_sym_EQ] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(371),
    [anon_sym_for] = ACTIONS(371),
    [anon_sym_while] = ACTIONS(371),
    [anon_sym_repeat] = ACTIONS(371),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(369),
    [anon_sym_BANG] = ACTIONS(371),
    [anon_sym_PLUS] = ACTIONS(369),
    [anon_sym_DASH] = ACTIONS(371),
    [anon_sym_LT_DASH] = ACTIONS(369),
    [anon_sym_LT_LT_DASH] = ACTIONS(369),
    [anon_sym_COLON_EQ] = ACTIONS(369),
    [anon_sym_DASH_GT] = ACTIONS(371),
    [anon_sym_DASH_GT_GT] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(371),
    [anon_sym_AMP] = ACTIONS(371),
    [anon_sym_PIPE_PIPE] = ACTIONS(369),
    [anon_sym_AMP_AMP] = ACTIONS(369),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_LT_EQ] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_EQ] = ACTIONS(369),
    [anon_sym_EQ_EQ] = ACTIONS(369),
    [anon_sym_BANG_EQ] = ACTIONS(369),
    [anon_sym_STAR] = ACTIONS(371),
    [anon_sym_SLASH] = ACTIONS(369),
    [anon_sym_STAR_STAR] = ACTIONS(369),
    [anon_sym_CARET] = ACTIONS(369),
    [aux_sym_binary_operator_token1] = ACTIONS(369),
    [anon_sym_PIPE_GT] = ACTIONS(369),
    [anon_sym_COLON] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [anon_sym_AT] = ACTIONS(369),
    [sym__hex_literal] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(473),
    [anon_sym_DQUOTE] = ACTIONS(475),
    [sym_dots] = ACTIONS(549),
    [sym_dot_dot_i] = ACTIONS(549),
    [sym_return] = ACTIONS(371),
    [sym_next] = ACTIONS(371),
    [sym_break] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_inf] = ACTIONS(371),
    [sym_nan] = ACTIONS(371),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(551),
    [sym__semicolon] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(477),
    [sym__external_open_parenthesis] = ACTIONS(369),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_close_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(369),
    [sym__external_open_bracket2] = ACTIONS(369),
  },
  [260] = {
    [sym_function_definition] = STATE(1361),
    [sym_if_statement] = STATE(1361),
    [sym_for_statement] = STATE(1361),
    [sym_while_statement] = STATE(1361),
    [sym_repeat_statement] = STATE(1361),
    [sym_braced_expression] = STATE(1361),
    [sym_parenthesized_expression] = STATE(1361),
    [sym_call] = STATE(1361),
    [sym_subset] = STATE(1361),
    [sym_subset2] = STATE(1361),
    [sym_argument] = STATE(1906),
    [sym__argument_named] = STATE(2046),
    [sym__argument_unnamed] = STATE(2031),
    [sym__argument_value] = STATE(2030),
    [sym_unary_operator] = STATE(1361),
    [sym_binary_operator] = STATE(1361),
    [sym_extract_operator] = STATE(1361),
    [sym_namespace_operator] = STATE(1361),
    [sym_integer] = STATE(1361),
    [sym_complex] = STATE(1361),
    [sym_float] = STATE(1361),
    [sym__float_literal] = STATE(1620),
    [sym_string] = STATE(1630),
    [sym__single_quoted_string] = STATE(1624),
    [sym__double_quoted_string] = STATE(1625),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2059),
    [sym_na] = STATE(1361),
    [sym__expression] = STATE(1361),
    [sym__open_parenthesis] = STATE(1056),
    [sym__close_parenthesis] = STATE(423),
    [sym__open_brace] = STATE(402),
    [aux_sym_call_arguments_repeat1] = STATE(1921),
    [sym_identifier] = ACTIONS(379),
    [anon_sym_BSLASH] = ACTIONS(381),
    [anon_sym_function] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_while] = ACTIONS(389),
    [anon_sym_repeat] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(395),
    [anon_sym_BANG] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [sym__hex_literal] = ACTIONS(401),
    [sym__number_literal] = ACTIONS(403),
    [anon_sym_SQUOTE] = ACTIONS(405),
    [anon_sym_DQUOTE] = ACTIONS(407),
    [sym_dots] = ACTIONS(379),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_return] = ACTIONS(409),
    [sym_next] = ACTIONS(409),
    [sym_break] = ACTIONS(409),
    [sym_true] = ACTIONS(409),
    [sym_false] = ACTIONS(409),
    [sym_null] = ACTIONS(411),
    [sym_inf] = ACTIONS(409),
    [sym_nan] = ACTIONS(409),
    [anon_sym_NA] = ACTIONS(413),
    [anon_sym_NA_integer_] = ACTIONS(413),
    [anon_sym_NA_real_] = ACTIONS(413),
    [anon_sym_NA_complex_] = ACTIONS(413),
    [anon_sym_NA_character_] = ACTIONS(413),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(415),
    [sym__raw_string_literal] = ACTIONS(417),
    [sym__external_open_parenthesis] = ACTIONS(419),
    [sym__external_close_parenthesis] = ACTIONS(553),
    [sym__external_open_brace] = ACTIONS(423),
  },
  [261] = {
    [sym_function_definition] = STATE(1575),
    [sym_if_statement] = STATE(1575),
    [sym_for_statement] = STATE(1575),
    [sym_while_statement] = STATE(1575),
    [sym_repeat_statement] = STATE(1575),
    [sym_braced_expression] = STATE(1575),
    [sym_parenthesized_expression] = STATE(1575),
    [sym_call] = STATE(1575),
    [sym_subset] = STATE(1575),
    [sym_subset2] = STATE(1575),
    [sym_argument] = STATE(1899),
    [sym__argument_named] = STATE(2032),
    [sym__argument_unnamed] = STATE(2045),
    [sym__argument_value] = STATE(2043),
    [sym_unary_operator] = STATE(1575),
    [sym_binary_operator] = STATE(1575),
    [sym_extract_operator] = STATE(1575),
    [sym_namespace_operator] = STATE(1575),
    [sym_integer] = STATE(1575),
    [sym_complex] = STATE(1575),
    [sym_float] = STATE(1575),
    [sym__float_literal] = STATE(1626),
    [sym_string] = STATE(1628),
    [sym__single_quoted_string] = STATE(1629),
    [sym__double_quoted_string] = STATE(1611),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2071),
    [sym_na] = STATE(1575),
    [sym__expression] = STATE(1575),
    [sym__open_parenthesis] = STATE(1064),
    [sym__open_brace] = STATE(418),
    [sym__close_bracket] = STATE(424),
    [aux_sym_call_arguments_repeat1] = STATE(1866),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(495),
    [anon_sym_function] = ACTIONS(497),
    [anon_sym_if] = ACTIONS(499),
    [anon_sym_for] = ACTIONS(501),
    [anon_sym_while] = ACTIONS(503),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_QMARK] = ACTIONS(507),
    [anon_sym_TILDE] = ACTIONS(509),
    [anon_sym_BANG] = ACTIONS(511),
    [anon_sym_PLUS] = ACTIONS(513),
    [anon_sym_DASH] = ACTIONS(513),
    [sym__hex_literal] = ACTIONS(515),
    [sym__number_literal] = ACTIONS(517),
    [anon_sym_SQUOTE] = ACTIONS(519),
    [anon_sym_DQUOTE] = ACTIONS(521),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(493),
    [sym_return] = ACTIONS(523),
    [sym_next] = ACTIONS(523),
    [sym_break] = ACTIONS(523),
    [sym_true] = ACTIONS(523),
    [sym_false] = ACTIONS(523),
    [sym_null] = ACTIONS(525),
    [sym_inf] = ACTIONS(523),
    [sym_nan] = ACTIONS(523),
    [anon_sym_NA] = ACTIONS(527),
    [anon_sym_NA_integer_] = ACTIONS(527),
    [anon_sym_NA_real_] = ACTIONS(527),
    [anon_sym_NA_complex_] = ACTIONS(527),
    [anon_sym_NA_character_] = ACTIONS(527),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(529),
    [sym__raw_string_literal] = ACTIONS(531),
    [sym__external_open_parenthesis] = ACTIONS(533),
    [sym__external_open_brace] = ACTIONS(535),
    [sym__external_close_bracket] = ACTIONS(555),
  },
  [262] = {
    [sym_function_definition] = STATE(1552),
    [sym_if_statement] = STATE(1552),
    [sym_for_statement] = STATE(1552),
    [sym_while_statement] = STATE(1552),
    [sym_repeat_statement] = STATE(1552),
    [sym_braced_expression] = STATE(1552),
    [sym_parenthesized_expression] = STATE(1552),
    [sym_call] = STATE(1552),
    [sym_subset] = STATE(1552),
    [sym_subset2] = STATE(1552),
    [sym_argument] = STATE(1867),
    [sym__argument_named] = STATE(2040),
    [sym__argument_unnamed] = STATE(2035),
    [sym__argument_value] = STATE(2047),
    [sym_unary_operator] = STATE(1552),
    [sym_binary_operator] = STATE(1552),
    [sym_extract_operator] = STATE(1552),
    [sym_namespace_operator] = STATE(1552),
    [sym_integer] = STATE(1552),
    [sym_complex] = STATE(1552),
    [sym_float] = STATE(1552),
    [sym__float_literal] = STATE(1610),
    [sym_string] = STATE(1627),
    [sym__single_quoted_string] = STATE(1604),
    [sym__double_quoted_string] = STATE(1632),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2054),
    [sym_na] = STATE(1552),
    [sym__expression] = STATE(1552),
    [sym__open_parenthesis] = STATE(1069),
    [sym__open_brace] = STATE(422),
    [sym__close_bracket2] = STATE(429),
    [aux_sym_call_arguments_repeat1] = STATE(1896),
    [sym_identifier] = ACTIONS(425),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_function] = ACTIONS(429),
    [anon_sym_if] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_repeat] = ACTIONS(437),
    [anon_sym_QMARK] = ACTIONS(439),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_PLUS] = ACTIONS(445),
    [anon_sym_DASH] = ACTIONS(445),
    [sym__hex_literal] = ACTIONS(447),
    [sym__number_literal] = ACTIONS(449),
    [anon_sym_SQUOTE] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(453),
    [sym_dots] = ACTIONS(425),
    [sym_dot_dot_i] = ACTIONS(425),
    [sym_return] = ACTIONS(455),
    [sym_next] = ACTIONS(455),
    [sym_break] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_null] = ACTIONS(457),
    [sym_inf] = ACTIONS(455),
    [sym_nan] = ACTIONS(455),
    [anon_sym_NA] = ACTIONS(459),
    [anon_sym_NA_integer_] = ACTIONS(459),
    [anon_sym_NA_real_] = ACTIONS(459),
    [anon_sym_NA_complex_] = ACTIONS(459),
    [anon_sym_NA_character_] = ACTIONS(459),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(461),
    [sym__raw_string_literal] = ACTIONS(463),
    [sym__external_open_parenthesis] = ACTIONS(465),
    [sym__external_open_brace] = ACTIONS(467),
    [sym__external_close_bracket2] = ACTIONS(557),
  },
  [263] = {
    [sym_string] = STATE(401),
    [sym__single_quoted_string] = STATE(308),
    [sym__double_quoted_string] = STATE(309),
    [aux_sym_function_definition_repeat1] = STATE(251),
    [ts_builtin_sym_end] = ACTIONS(369),
    [sym_identifier] = ACTIONS(559),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(371),
    [anon_sym_EQ] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(371),
    [anon_sym_for] = ACTIONS(371),
    [anon_sym_while] = ACTIONS(371),
    [anon_sym_repeat] = ACTIONS(371),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(369),
    [anon_sym_BANG] = ACTIONS(371),
    [anon_sym_PLUS] = ACTIONS(369),
    [anon_sym_DASH] = ACTIONS(371),
    [anon_sym_LT_DASH] = ACTIONS(369),
    [anon_sym_LT_LT_DASH] = ACTIONS(369),
    [anon_sym_COLON_EQ] = ACTIONS(369),
    [anon_sym_DASH_GT] = ACTIONS(371),
    [anon_sym_DASH_GT_GT] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(371),
    [anon_sym_AMP] = ACTIONS(371),
    [anon_sym_PIPE_PIPE] = ACTIONS(369),
    [anon_sym_AMP_AMP] = ACTIONS(369),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_LT_EQ] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_EQ] = ACTIONS(369),
    [anon_sym_EQ_EQ] = ACTIONS(369),
    [anon_sym_BANG_EQ] = ACTIONS(369),
    [anon_sym_STAR] = ACTIONS(371),
    [anon_sym_SLASH] = ACTIONS(369),
    [anon_sym_STAR_STAR] = ACTIONS(369),
    [anon_sym_CARET] = ACTIONS(369),
    [aux_sym_binary_operator_token1] = ACTIONS(369),
    [anon_sym_PIPE_GT] = ACTIONS(369),
    [anon_sym_COLON] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [anon_sym_AT] = ACTIONS(369),
    [sym__hex_literal] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(481),
    [anon_sym_DQUOTE] = ACTIONS(483),
    [sym_dots] = ACTIONS(559),
    [sym_dot_dot_i] = ACTIONS(559),
    [sym_return] = ACTIONS(371),
    [sym_next] = ACTIONS(371),
    [sym_break] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_inf] = ACTIONS(371),
    [sym_nan] = ACTIONS(371),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(561),
    [sym__semicolon] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(485),
    [sym__external_open_parenthesis] = ACTIONS(369),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(369),
    [sym__external_open_bracket2] = ACTIONS(369),
  },
  [264] = {
    [sym_function_definition] = STATE(1361),
    [sym_if_statement] = STATE(1361),
    [sym_for_statement] = STATE(1361),
    [sym_while_statement] = STATE(1361),
    [sym_repeat_statement] = STATE(1361),
    [sym_braced_expression] = STATE(1361),
    [sym_parenthesized_expression] = STATE(1361),
    [sym_call] = STATE(1361),
    [sym_subset] = STATE(1361),
    [sym_subset2] = STATE(1361),
    [sym_argument] = STATE(1895),
    [sym__argument_named] = STATE(2046),
    [sym__argument_unnamed] = STATE(2031),
    [sym__argument_value] = STATE(2030),
    [sym_unary_operator] = STATE(1361),
    [sym_binary_operator] = STATE(1361),
    [sym_extract_operator] = STATE(1361),
    [sym_namespace_operator] = STATE(1361),
    [sym_integer] = STATE(1361),
    [sym_complex] = STATE(1361),
    [sym_float] = STATE(1361),
    [sym__float_literal] = STATE(1620),
    [sym_string] = STATE(1630),
    [sym__single_quoted_string] = STATE(1624),
    [sym__double_quoted_string] = STATE(1625),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2059),
    [sym_na] = STATE(1361),
    [sym__expression] = STATE(1361),
    [sym__open_parenthesis] = STATE(1056),
    [sym__close_parenthesis] = STATE(442),
    [sym__open_brace] = STATE(402),
    [aux_sym_call_arguments_repeat1] = STATE(1834),
    [sym_identifier] = ACTIONS(379),
    [anon_sym_BSLASH] = ACTIONS(381),
    [anon_sym_function] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_while] = ACTIONS(389),
    [anon_sym_repeat] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(395),
    [anon_sym_BANG] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [sym__hex_literal] = ACTIONS(401),
    [sym__number_literal] = ACTIONS(403),
    [anon_sym_SQUOTE] = ACTIONS(405),
    [anon_sym_DQUOTE] = ACTIONS(407),
    [sym_dots] = ACTIONS(379),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_return] = ACTIONS(409),
    [sym_next] = ACTIONS(409),
    [sym_break] = ACTIONS(409),
    [sym_true] = ACTIONS(409),
    [sym_false] = ACTIONS(409),
    [sym_null] = ACTIONS(411),
    [sym_inf] = ACTIONS(409),
    [sym_nan] = ACTIONS(409),
    [anon_sym_NA] = ACTIONS(413),
    [anon_sym_NA_integer_] = ACTIONS(413),
    [anon_sym_NA_real_] = ACTIONS(413),
    [anon_sym_NA_complex_] = ACTIONS(413),
    [anon_sym_NA_character_] = ACTIONS(413),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(415),
    [sym__raw_string_literal] = ACTIONS(417),
    [sym__external_open_parenthesis] = ACTIONS(419),
    [sym__external_close_parenthesis] = ACTIONS(563),
    [sym__external_open_brace] = ACTIONS(423),
  },
  [265] = {
    [sym_function_definition] = STATE(1552),
    [sym_if_statement] = STATE(1552),
    [sym_for_statement] = STATE(1552),
    [sym_while_statement] = STATE(1552),
    [sym_repeat_statement] = STATE(1552),
    [sym_braced_expression] = STATE(1552),
    [sym_parenthesized_expression] = STATE(1552),
    [sym_call] = STATE(1552),
    [sym_subset] = STATE(1552),
    [sym_subset2] = STATE(1552),
    [sym_argument] = STATE(1892),
    [sym__argument_named] = STATE(2040),
    [sym__argument_unnamed] = STATE(2035),
    [sym__argument_value] = STATE(2047),
    [sym_unary_operator] = STATE(1552),
    [sym_binary_operator] = STATE(1552),
    [sym_extract_operator] = STATE(1552),
    [sym_namespace_operator] = STATE(1552),
    [sym_integer] = STATE(1552),
    [sym_complex] = STATE(1552),
    [sym_float] = STATE(1552),
    [sym__float_literal] = STATE(1610),
    [sym_string] = STATE(1627),
    [sym__single_quoted_string] = STATE(1604),
    [sym__double_quoted_string] = STATE(1632),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2054),
    [sym_na] = STATE(1552),
    [sym__expression] = STATE(1552),
    [sym__open_parenthesis] = STATE(1069),
    [sym__open_brace] = STATE(422),
    [sym__close_bracket2] = STATE(1733),
    [aux_sym_call_arguments_repeat1] = STATE(1820),
    [sym_identifier] = ACTIONS(425),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_function] = ACTIONS(429),
    [anon_sym_if] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_repeat] = ACTIONS(437),
    [anon_sym_QMARK] = ACTIONS(439),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_PLUS] = ACTIONS(445),
    [anon_sym_DASH] = ACTIONS(445),
    [sym__hex_literal] = ACTIONS(447),
    [sym__number_literal] = ACTIONS(449),
    [anon_sym_SQUOTE] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(453),
    [sym_dots] = ACTIONS(425),
    [sym_dot_dot_i] = ACTIONS(425),
    [sym_return] = ACTIONS(455),
    [sym_next] = ACTIONS(455),
    [sym_break] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_null] = ACTIONS(457),
    [sym_inf] = ACTIONS(455),
    [sym_nan] = ACTIONS(455),
    [anon_sym_NA] = ACTIONS(459),
    [anon_sym_NA_integer_] = ACTIONS(459),
    [anon_sym_NA_real_] = ACTIONS(459),
    [anon_sym_NA_complex_] = ACTIONS(459),
    [anon_sym_NA_character_] = ACTIONS(459),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(461),
    [sym__raw_string_literal] = ACTIONS(463),
    [sym__external_open_parenthesis] = ACTIONS(465),
    [sym__external_open_brace] = ACTIONS(467),
    [sym__external_close_bracket2] = ACTIONS(565),
  },
  [266] = {
    [sym_function_definition] = STATE(1361),
    [sym_if_statement] = STATE(1361),
    [sym_for_statement] = STATE(1361),
    [sym_while_statement] = STATE(1361),
    [sym_repeat_statement] = STATE(1361),
    [sym_braced_expression] = STATE(1361),
    [sym_parenthesized_expression] = STATE(1361),
    [sym_call] = STATE(1361),
    [sym_subset] = STATE(1361),
    [sym_subset2] = STATE(1361),
    [sym_argument] = STATE(1886),
    [sym__argument_named] = STATE(2046),
    [sym__argument_unnamed] = STATE(2031),
    [sym__argument_value] = STATE(2030),
    [sym_unary_operator] = STATE(1361),
    [sym_binary_operator] = STATE(1361),
    [sym_extract_operator] = STATE(1361),
    [sym_namespace_operator] = STATE(1361),
    [sym_integer] = STATE(1361),
    [sym_complex] = STATE(1361),
    [sym_float] = STATE(1361),
    [sym__float_literal] = STATE(1620),
    [sym_string] = STATE(1630),
    [sym__single_quoted_string] = STATE(1624),
    [sym__double_quoted_string] = STATE(1625),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2059),
    [sym_na] = STATE(1361),
    [sym__expression] = STATE(1361),
    [sym__open_parenthesis] = STATE(1056),
    [sym__close_parenthesis] = STATE(1768),
    [sym__open_brace] = STATE(402),
    [aux_sym_call_arguments_repeat1] = STATE(1887),
    [sym_identifier] = ACTIONS(379),
    [anon_sym_BSLASH] = ACTIONS(381),
    [anon_sym_function] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_while] = ACTIONS(389),
    [anon_sym_repeat] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(395),
    [anon_sym_BANG] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [sym__hex_literal] = ACTIONS(401),
    [sym__number_literal] = ACTIONS(403),
    [anon_sym_SQUOTE] = ACTIONS(405),
    [anon_sym_DQUOTE] = ACTIONS(407),
    [sym_dots] = ACTIONS(379),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_return] = ACTIONS(409),
    [sym_next] = ACTIONS(409),
    [sym_break] = ACTIONS(409),
    [sym_true] = ACTIONS(409),
    [sym_false] = ACTIONS(409),
    [sym_null] = ACTIONS(411),
    [sym_inf] = ACTIONS(409),
    [sym_nan] = ACTIONS(409),
    [anon_sym_NA] = ACTIONS(413),
    [anon_sym_NA_integer_] = ACTIONS(413),
    [anon_sym_NA_real_] = ACTIONS(413),
    [anon_sym_NA_complex_] = ACTIONS(413),
    [anon_sym_NA_character_] = ACTIONS(413),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(415),
    [sym__raw_string_literal] = ACTIONS(417),
    [sym__external_open_parenthesis] = ACTIONS(419),
    [sym__external_close_parenthesis] = ACTIONS(567),
    [sym__external_open_brace] = ACTIONS(423),
  },
  [267] = {
    [sym_function_definition] = STATE(1575),
    [sym_if_statement] = STATE(1575),
    [sym_for_statement] = STATE(1575),
    [sym_while_statement] = STATE(1575),
    [sym_repeat_statement] = STATE(1575),
    [sym_braced_expression] = STATE(1575),
    [sym_parenthesized_expression] = STATE(1575),
    [sym_call] = STATE(1575),
    [sym_subset] = STATE(1575),
    [sym_subset2] = STATE(1575),
    [sym_argument] = STATE(1909),
    [sym__argument_named] = STATE(2032),
    [sym__argument_unnamed] = STATE(2045),
    [sym__argument_value] = STATE(2043),
    [sym_unary_operator] = STATE(1575),
    [sym_binary_operator] = STATE(1575),
    [sym_extract_operator] = STATE(1575),
    [sym_namespace_operator] = STATE(1575),
    [sym_integer] = STATE(1575),
    [sym_complex] = STATE(1575),
    [sym_float] = STATE(1575),
    [sym__float_literal] = STATE(1626),
    [sym_string] = STATE(1628),
    [sym__single_quoted_string] = STATE(1629),
    [sym__double_quoted_string] = STATE(1611),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2071),
    [sym_na] = STATE(1575),
    [sym__expression] = STATE(1575),
    [sym__open_parenthesis] = STATE(1064),
    [sym__open_brace] = STATE(418),
    [sym__close_bracket] = STATE(1769),
    [aux_sym_call_arguments_repeat1] = STATE(1922),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(495),
    [anon_sym_function] = ACTIONS(497),
    [anon_sym_if] = ACTIONS(499),
    [anon_sym_for] = ACTIONS(501),
    [anon_sym_while] = ACTIONS(503),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_QMARK] = ACTIONS(507),
    [anon_sym_TILDE] = ACTIONS(509),
    [anon_sym_BANG] = ACTIONS(511),
    [anon_sym_PLUS] = ACTIONS(513),
    [anon_sym_DASH] = ACTIONS(513),
    [sym__hex_literal] = ACTIONS(515),
    [sym__number_literal] = ACTIONS(517),
    [anon_sym_SQUOTE] = ACTIONS(519),
    [anon_sym_DQUOTE] = ACTIONS(521),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(493),
    [sym_return] = ACTIONS(523),
    [sym_next] = ACTIONS(523),
    [sym_break] = ACTIONS(523),
    [sym_true] = ACTIONS(523),
    [sym_false] = ACTIONS(523),
    [sym_null] = ACTIONS(525),
    [sym_inf] = ACTIONS(523),
    [sym_nan] = ACTIONS(523),
    [anon_sym_NA] = ACTIONS(527),
    [anon_sym_NA_integer_] = ACTIONS(527),
    [anon_sym_NA_real_] = ACTIONS(527),
    [anon_sym_NA_complex_] = ACTIONS(527),
    [anon_sym_NA_character_] = ACTIONS(527),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(529),
    [sym__raw_string_literal] = ACTIONS(531),
    [sym__external_open_parenthesis] = ACTIONS(533),
    [sym__external_open_brace] = ACTIONS(535),
    [sym__external_close_bracket] = ACTIONS(569),
  },
  [268] = {
    [sym_function_definition] = STATE(1552),
    [sym_if_statement] = STATE(1552),
    [sym_for_statement] = STATE(1552),
    [sym_while_statement] = STATE(1552),
    [sym_repeat_statement] = STATE(1552),
    [sym_braced_expression] = STATE(1552),
    [sym_parenthesized_expression] = STATE(1552),
    [sym_call] = STATE(1552),
    [sym_subset] = STATE(1552),
    [sym_subset2] = STATE(1552),
    [sym_argument] = STATE(1925),
    [sym__argument_named] = STATE(2040),
    [sym__argument_unnamed] = STATE(2035),
    [sym__argument_value] = STATE(2047),
    [sym_unary_operator] = STATE(1552),
    [sym_binary_operator] = STATE(1552),
    [sym_extract_operator] = STATE(1552),
    [sym_namespace_operator] = STATE(1552),
    [sym_integer] = STATE(1552),
    [sym_complex] = STATE(1552),
    [sym_float] = STATE(1552),
    [sym__float_literal] = STATE(1610),
    [sym_string] = STATE(1627),
    [sym__single_quoted_string] = STATE(1604),
    [sym__double_quoted_string] = STATE(1632),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2054),
    [sym_na] = STATE(1552),
    [sym__expression] = STATE(1552),
    [sym__open_parenthesis] = STATE(1069),
    [sym__open_brace] = STATE(422),
    [sym__close_bracket2] = STATE(1773),
    [aux_sym_call_arguments_repeat1] = STATE(1943),
    [sym_identifier] = ACTIONS(425),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_function] = ACTIONS(429),
    [anon_sym_if] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_repeat] = ACTIONS(437),
    [anon_sym_QMARK] = ACTIONS(439),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_PLUS] = ACTIONS(445),
    [anon_sym_DASH] = ACTIONS(445),
    [sym__hex_literal] = ACTIONS(447),
    [sym__number_literal] = ACTIONS(449),
    [anon_sym_SQUOTE] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(453),
    [sym_dots] = ACTIONS(425),
    [sym_dot_dot_i] = ACTIONS(425),
    [sym_return] = ACTIONS(455),
    [sym_next] = ACTIONS(455),
    [sym_break] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_null] = ACTIONS(457),
    [sym_inf] = ACTIONS(455),
    [sym_nan] = ACTIONS(455),
    [anon_sym_NA] = ACTIONS(459),
    [anon_sym_NA_integer_] = ACTIONS(459),
    [anon_sym_NA_real_] = ACTIONS(459),
    [anon_sym_NA_complex_] = ACTIONS(459),
    [anon_sym_NA_character_] = ACTIONS(459),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(461),
    [sym__raw_string_literal] = ACTIONS(463),
    [sym__external_open_parenthesis] = ACTIONS(465),
    [sym__external_open_brace] = ACTIONS(467),
    [sym__external_close_bracket2] = ACTIONS(571),
  },
  [269] = {
    [sym_function_definition] = STATE(1361),
    [sym_if_statement] = STATE(1361),
    [sym_for_statement] = STATE(1361),
    [sym_while_statement] = STATE(1361),
    [sym_repeat_statement] = STATE(1361),
    [sym_braced_expression] = STATE(1361),
    [sym_parenthesized_expression] = STATE(1361),
    [sym_call] = STATE(1361),
    [sym_subset] = STATE(1361),
    [sym_subset2] = STATE(1361),
    [sym_argument] = STATE(1941),
    [sym__argument_named] = STATE(2046),
    [sym__argument_unnamed] = STATE(2031),
    [sym__argument_value] = STATE(2030),
    [sym_unary_operator] = STATE(1361),
    [sym_binary_operator] = STATE(1361),
    [sym_extract_operator] = STATE(1361),
    [sym_namespace_operator] = STATE(1361),
    [sym_integer] = STATE(1361),
    [sym_complex] = STATE(1361),
    [sym_float] = STATE(1361),
    [sym__float_literal] = STATE(1620),
    [sym_string] = STATE(1630),
    [sym__single_quoted_string] = STATE(1624),
    [sym__double_quoted_string] = STATE(1625),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2059),
    [sym_na] = STATE(1361),
    [sym__expression] = STATE(1361),
    [sym__open_parenthesis] = STATE(1056),
    [sym__close_parenthesis] = STATE(365),
    [sym__open_brace] = STATE(402),
    [aux_sym_call_arguments_repeat1] = STATE(1945),
    [sym_identifier] = ACTIONS(379),
    [anon_sym_BSLASH] = ACTIONS(381),
    [anon_sym_function] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_while] = ACTIONS(389),
    [anon_sym_repeat] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(395),
    [anon_sym_BANG] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [sym__hex_literal] = ACTIONS(401),
    [sym__number_literal] = ACTIONS(403),
    [anon_sym_SQUOTE] = ACTIONS(405),
    [anon_sym_DQUOTE] = ACTIONS(407),
    [sym_dots] = ACTIONS(379),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_return] = ACTIONS(409),
    [sym_next] = ACTIONS(409),
    [sym_break] = ACTIONS(409),
    [sym_true] = ACTIONS(409),
    [sym_false] = ACTIONS(409),
    [sym_null] = ACTIONS(411),
    [sym_inf] = ACTIONS(409),
    [sym_nan] = ACTIONS(409),
    [anon_sym_NA] = ACTIONS(413),
    [anon_sym_NA_integer_] = ACTIONS(413),
    [anon_sym_NA_real_] = ACTIONS(413),
    [anon_sym_NA_complex_] = ACTIONS(413),
    [anon_sym_NA_character_] = ACTIONS(413),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(415),
    [sym__raw_string_literal] = ACTIONS(417),
    [sym__external_open_parenthesis] = ACTIONS(419),
    [sym__external_close_parenthesis] = ACTIONS(573),
    [sym__external_open_brace] = ACTIONS(423),
  },
  [270] = {
    [sym_function_definition] = STATE(1575),
    [sym_if_statement] = STATE(1575),
    [sym_for_statement] = STATE(1575),
    [sym_while_statement] = STATE(1575),
    [sym_repeat_statement] = STATE(1575),
    [sym_braced_expression] = STATE(1575),
    [sym_parenthesized_expression] = STATE(1575),
    [sym_call] = STATE(1575),
    [sym_subset] = STATE(1575),
    [sym_subset2] = STATE(1575),
    [sym_argument] = STATE(1937),
    [sym__argument_named] = STATE(2032),
    [sym__argument_unnamed] = STATE(2045),
    [sym__argument_value] = STATE(2043),
    [sym_unary_operator] = STATE(1575),
    [sym_binary_operator] = STATE(1575),
    [sym_extract_operator] = STATE(1575),
    [sym_namespace_operator] = STATE(1575),
    [sym_integer] = STATE(1575),
    [sym_complex] = STATE(1575),
    [sym_float] = STATE(1575),
    [sym__float_literal] = STATE(1626),
    [sym_string] = STATE(1628),
    [sym__single_quoted_string] = STATE(1629),
    [sym__double_quoted_string] = STATE(1611),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2071),
    [sym_na] = STATE(1575),
    [sym__expression] = STATE(1575),
    [sym__open_parenthesis] = STATE(1064),
    [sym__open_brace] = STATE(418),
    [sym__close_bracket] = STATE(366),
    [aux_sym_call_arguments_repeat1] = STATE(1953),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(495),
    [anon_sym_function] = ACTIONS(497),
    [anon_sym_if] = ACTIONS(499),
    [anon_sym_for] = ACTIONS(501),
    [anon_sym_while] = ACTIONS(503),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_QMARK] = ACTIONS(507),
    [anon_sym_TILDE] = ACTIONS(509),
    [anon_sym_BANG] = ACTIONS(511),
    [anon_sym_PLUS] = ACTIONS(513),
    [anon_sym_DASH] = ACTIONS(513),
    [sym__hex_literal] = ACTIONS(515),
    [sym__number_literal] = ACTIONS(517),
    [anon_sym_SQUOTE] = ACTIONS(519),
    [anon_sym_DQUOTE] = ACTIONS(521),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(493),
    [sym_return] = ACTIONS(523),
    [sym_next] = ACTIONS(523),
    [sym_break] = ACTIONS(523),
    [sym_true] = ACTIONS(523),
    [sym_false] = ACTIONS(523),
    [sym_null] = ACTIONS(525),
    [sym_inf] = ACTIONS(523),
    [sym_nan] = ACTIONS(523),
    [anon_sym_NA] = ACTIONS(527),
    [anon_sym_NA_integer_] = ACTIONS(527),
    [anon_sym_NA_real_] = ACTIONS(527),
    [anon_sym_NA_complex_] = ACTIONS(527),
    [anon_sym_NA_character_] = ACTIONS(527),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(529),
    [sym__raw_string_literal] = ACTIONS(531),
    [sym__external_open_parenthesis] = ACTIONS(533),
    [sym__external_open_brace] = ACTIONS(535),
    [sym__external_close_bracket] = ACTIONS(575),
  },
  [271] = {
    [sym_function_definition] = STATE(1552),
    [sym_if_statement] = STATE(1552),
    [sym_for_statement] = STATE(1552),
    [sym_while_statement] = STATE(1552),
    [sym_repeat_statement] = STATE(1552),
    [sym_braced_expression] = STATE(1552),
    [sym_parenthesized_expression] = STATE(1552),
    [sym_call] = STATE(1552),
    [sym_subset] = STATE(1552),
    [sym_subset2] = STATE(1552),
    [sym_argument] = STATE(1828),
    [sym__argument_named] = STATE(2040),
    [sym__argument_unnamed] = STATE(2035),
    [sym__argument_value] = STATE(2047),
    [sym_unary_operator] = STATE(1552),
    [sym_binary_operator] = STATE(1552),
    [sym_extract_operator] = STATE(1552),
    [sym_namespace_operator] = STATE(1552),
    [sym_integer] = STATE(1552),
    [sym_complex] = STATE(1552),
    [sym_float] = STATE(1552),
    [sym__float_literal] = STATE(1610),
    [sym_string] = STATE(1627),
    [sym__single_quoted_string] = STATE(1604),
    [sym__double_quoted_string] = STATE(1632),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2054),
    [sym_na] = STATE(1552),
    [sym__expression] = STATE(1552),
    [sym__open_parenthesis] = STATE(1069),
    [sym__open_brace] = STATE(422),
    [sym__close_bracket2] = STATE(367),
    [aux_sym_call_arguments_repeat1] = STATE(1831),
    [sym_identifier] = ACTIONS(425),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_function] = ACTIONS(429),
    [anon_sym_if] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_repeat] = ACTIONS(437),
    [anon_sym_QMARK] = ACTIONS(439),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_PLUS] = ACTIONS(445),
    [anon_sym_DASH] = ACTIONS(445),
    [sym__hex_literal] = ACTIONS(447),
    [sym__number_literal] = ACTIONS(449),
    [anon_sym_SQUOTE] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(453),
    [sym_dots] = ACTIONS(425),
    [sym_dot_dot_i] = ACTIONS(425),
    [sym_return] = ACTIONS(455),
    [sym_next] = ACTIONS(455),
    [sym_break] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_null] = ACTIONS(457),
    [sym_inf] = ACTIONS(455),
    [sym_nan] = ACTIONS(455),
    [anon_sym_NA] = ACTIONS(459),
    [anon_sym_NA_integer_] = ACTIONS(459),
    [anon_sym_NA_real_] = ACTIONS(459),
    [anon_sym_NA_complex_] = ACTIONS(459),
    [anon_sym_NA_character_] = ACTIONS(459),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(461),
    [sym__raw_string_literal] = ACTIONS(463),
    [sym__external_open_parenthesis] = ACTIONS(465),
    [sym__external_open_brace] = ACTIONS(467),
    [sym__external_close_bracket2] = ACTIONS(577),
  },
  [272] = {
    [sym_function_definition] = STATE(1361),
    [sym_if_statement] = STATE(1361),
    [sym_for_statement] = STATE(1361),
    [sym_while_statement] = STATE(1361),
    [sym_repeat_statement] = STATE(1361),
    [sym_braced_expression] = STATE(1361),
    [sym_parenthesized_expression] = STATE(1361),
    [sym_call] = STATE(1361),
    [sym_subset] = STATE(1361),
    [sym_subset2] = STATE(1361),
    [sym_argument] = STATE(1822),
    [sym__argument_named] = STATE(2046),
    [sym__argument_unnamed] = STATE(2031),
    [sym__argument_value] = STATE(2030),
    [sym_unary_operator] = STATE(1361),
    [sym_binary_operator] = STATE(1361),
    [sym_extract_operator] = STATE(1361),
    [sym_namespace_operator] = STATE(1361),
    [sym_integer] = STATE(1361),
    [sym_complex] = STATE(1361),
    [sym_float] = STATE(1361),
    [sym__float_literal] = STATE(1620),
    [sym_string] = STATE(1630),
    [sym__single_quoted_string] = STATE(1624),
    [sym__double_quoted_string] = STATE(1625),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2059),
    [sym_na] = STATE(1361),
    [sym__expression] = STATE(1361),
    [sym__open_parenthesis] = STATE(1056),
    [sym__close_parenthesis] = STATE(1639),
    [sym__open_brace] = STATE(402),
    [aux_sym_call_arguments_repeat1] = STATE(1823),
    [sym_identifier] = ACTIONS(379),
    [anon_sym_BSLASH] = ACTIONS(381),
    [anon_sym_function] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_while] = ACTIONS(389),
    [anon_sym_repeat] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(395),
    [anon_sym_BANG] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [sym__hex_literal] = ACTIONS(401),
    [sym__number_literal] = ACTIONS(403),
    [anon_sym_SQUOTE] = ACTIONS(405),
    [anon_sym_DQUOTE] = ACTIONS(407),
    [sym_dots] = ACTIONS(379),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_return] = ACTIONS(409),
    [sym_next] = ACTIONS(409),
    [sym_break] = ACTIONS(409),
    [sym_true] = ACTIONS(409),
    [sym_false] = ACTIONS(409),
    [sym_null] = ACTIONS(411),
    [sym_inf] = ACTIONS(409),
    [sym_nan] = ACTIONS(409),
    [anon_sym_NA] = ACTIONS(413),
    [anon_sym_NA_integer_] = ACTIONS(413),
    [anon_sym_NA_real_] = ACTIONS(413),
    [anon_sym_NA_complex_] = ACTIONS(413),
    [anon_sym_NA_character_] = ACTIONS(413),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(415),
    [sym__raw_string_literal] = ACTIONS(417),
    [sym__external_open_parenthesis] = ACTIONS(419),
    [sym__external_close_parenthesis] = ACTIONS(579),
    [sym__external_open_brace] = ACTIONS(423),
  },
  [273] = {
    [sym_function_definition] = STATE(1575),
    [sym_if_statement] = STATE(1575),
    [sym_for_statement] = STATE(1575),
    [sym_while_statement] = STATE(1575),
    [sym_repeat_statement] = STATE(1575),
    [sym_braced_expression] = STATE(1575),
    [sym_parenthesized_expression] = STATE(1575),
    [sym_call] = STATE(1575),
    [sym_subset] = STATE(1575),
    [sym_subset2] = STATE(1575),
    [sym_argument] = STATE(1871),
    [sym__argument_named] = STATE(2032),
    [sym__argument_unnamed] = STATE(2045),
    [sym__argument_value] = STATE(2043),
    [sym_unary_operator] = STATE(1575),
    [sym_binary_operator] = STATE(1575),
    [sym_extract_operator] = STATE(1575),
    [sym_namespace_operator] = STATE(1575),
    [sym_integer] = STATE(1575),
    [sym_complex] = STATE(1575),
    [sym_float] = STATE(1575),
    [sym__float_literal] = STATE(1626),
    [sym_string] = STATE(1628),
    [sym__single_quoted_string] = STATE(1629),
    [sym__double_quoted_string] = STATE(1611),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2071),
    [sym_na] = STATE(1575),
    [sym__expression] = STATE(1575),
    [sym__open_parenthesis] = STATE(1064),
    [sym__open_brace] = STATE(418),
    [sym__close_bracket] = STATE(1640),
    [aux_sym_call_arguments_repeat1] = STATE(1809),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(495),
    [anon_sym_function] = ACTIONS(497),
    [anon_sym_if] = ACTIONS(499),
    [anon_sym_for] = ACTIONS(501),
    [anon_sym_while] = ACTIONS(503),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_QMARK] = ACTIONS(507),
    [anon_sym_TILDE] = ACTIONS(509),
    [anon_sym_BANG] = ACTIONS(511),
    [anon_sym_PLUS] = ACTIONS(513),
    [anon_sym_DASH] = ACTIONS(513),
    [sym__hex_literal] = ACTIONS(515),
    [sym__number_literal] = ACTIONS(517),
    [anon_sym_SQUOTE] = ACTIONS(519),
    [anon_sym_DQUOTE] = ACTIONS(521),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(493),
    [sym_return] = ACTIONS(523),
    [sym_next] = ACTIONS(523),
    [sym_break] = ACTIONS(523),
    [sym_true] = ACTIONS(523),
    [sym_false] = ACTIONS(523),
    [sym_null] = ACTIONS(525),
    [sym_inf] = ACTIONS(523),
    [sym_nan] = ACTIONS(523),
    [anon_sym_NA] = ACTIONS(527),
    [anon_sym_NA_integer_] = ACTIONS(527),
    [anon_sym_NA_real_] = ACTIONS(527),
    [anon_sym_NA_complex_] = ACTIONS(527),
    [anon_sym_NA_character_] = ACTIONS(527),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(529),
    [sym__raw_string_literal] = ACTIONS(531),
    [sym__external_open_parenthesis] = ACTIONS(533),
    [sym__external_open_brace] = ACTIONS(535),
    [sym__external_close_bracket] = ACTIONS(581),
  },
  [274] = {
    [sym_function_definition] = STATE(1552),
    [sym_if_statement] = STATE(1552),
    [sym_for_statement] = STATE(1552),
    [sym_while_statement] = STATE(1552),
    [sym_repeat_statement] = STATE(1552),
    [sym_braced_expression] = STATE(1552),
    [sym_parenthesized_expression] = STATE(1552),
    [sym_call] = STATE(1552),
    [sym_subset] = STATE(1552),
    [sym_subset2] = STATE(1552),
    [sym_argument] = STATE(1884),
    [sym__argument_named] = STATE(2040),
    [sym__argument_unnamed] = STATE(2035),
    [sym__argument_value] = STATE(2047),
    [sym_unary_operator] = STATE(1552),
    [sym_binary_operator] = STATE(1552),
    [sym_extract_operator] = STATE(1552),
    [sym_namespace_operator] = STATE(1552),
    [sym_integer] = STATE(1552),
    [sym_complex] = STATE(1552),
    [sym_float] = STATE(1552),
    [sym__float_literal] = STATE(1610),
    [sym_string] = STATE(1627),
    [sym__single_quoted_string] = STATE(1604),
    [sym__double_quoted_string] = STATE(1632),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2054),
    [sym_na] = STATE(1552),
    [sym__expression] = STATE(1552),
    [sym__open_parenthesis] = STATE(1069),
    [sym__open_brace] = STATE(422),
    [sym__close_bracket2] = STATE(1685),
    [aux_sym_call_arguments_repeat1] = STATE(1849),
    [sym_identifier] = ACTIONS(425),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_function] = ACTIONS(429),
    [anon_sym_if] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_repeat] = ACTIONS(437),
    [anon_sym_QMARK] = ACTIONS(439),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_PLUS] = ACTIONS(445),
    [anon_sym_DASH] = ACTIONS(445),
    [sym__hex_literal] = ACTIONS(447),
    [sym__number_literal] = ACTIONS(449),
    [anon_sym_SQUOTE] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(453),
    [sym_dots] = ACTIONS(425),
    [sym_dot_dot_i] = ACTIONS(425),
    [sym_return] = ACTIONS(455),
    [sym_next] = ACTIONS(455),
    [sym_break] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_null] = ACTIONS(457),
    [sym_inf] = ACTIONS(455),
    [sym_nan] = ACTIONS(455),
    [anon_sym_NA] = ACTIONS(459),
    [anon_sym_NA_integer_] = ACTIONS(459),
    [anon_sym_NA_real_] = ACTIONS(459),
    [anon_sym_NA_complex_] = ACTIONS(459),
    [anon_sym_NA_character_] = ACTIONS(459),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(461),
    [sym__raw_string_literal] = ACTIONS(463),
    [sym__external_open_parenthesis] = ACTIONS(465),
    [sym__external_open_brace] = ACTIONS(467),
    [sym__external_close_bracket2] = ACTIONS(583),
  },
  [275] = {
    [sym_function_definition] = STATE(1361),
    [sym_if_statement] = STATE(1361),
    [sym_for_statement] = STATE(1361),
    [sym_while_statement] = STATE(1361),
    [sym_repeat_statement] = STATE(1361),
    [sym_braced_expression] = STATE(1361),
    [sym_parenthesized_expression] = STATE(1361),
    [sym_call] = STATE(1361),
    [sym_subset] = STATE(1361),
    [sym_subset2] = STATE(1361),
    [sym_argument] = STATE(1842),
    [sym__argument_named] = STATE(2046),
    [sym__argument_unnamed] = STATE(2031),
    [sym__argument_value] = STATE(2030),
    [sym_unary_operator] = STATE(1361),
    [sym_binary_operator] = STATE(1361),
    [sym_extract_operator] = STATE(1361),
    [sym_namespace_operator] = STATE(1361),
    [sym_integer] = STATE(1361),
    [sym_complex] = STATE(1361),
    [sym_float] = STATE(1361),
    [sym__float_literal] = STATE(1620),
    [sym_string] = STATE(1630),
    [sym__single_quoted_string] = STATE(1624),
    [sym__double_quoted_string] = STATE(1625),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2059),
    [sym_na] = STATE(1361),
    [sym__expression] = STATE(1361),
    [sym__open_parenthesis] = STATE(1056),
    [sym__close_parenthesis] = STATE(328),
    [sym__open_brace] = STATE(402),
    [aux_sym_call_arguments_repeat1] = STATE(1843),
    [sym_identifier] = ACTIONS(379),
    [anon_sym_BSLASH] = ACTIONS(381),
    [anon_sym_function] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_while] = ACTIONS(389),
    [anon_sym_repeat] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(395),
    [anon_sym_BANG] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [sym__hex_literal] = ACTIONS(401),
    [sym__number_literal] = ACTIONS(403),
    [anon_sym_SQUOTE] = ACTIONS(405),
    [anon_sym_DQUOTE] = ACTIONS(407),
    [sym_dots] = ACTIONS(379),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_return] = ACTIONS(409),
    [sym_next] = ACTIONS(409),
    [sym_break] = ACTIONS(409),
    [sym_true] = ACTIONS(409),
    [sym_false] = ACTIONS(409),
    [sym_null] = ACTIONS(411),
    [sym_inf] = ACTIONS(409),
    [sym_nan] = ACTIONS(409),
    [anon_sym_NA] = ACTIONS(413),
    [anon_sym_NA_integer_] = ACTIONS(413),
    [anon_sym_NA_real_] = ACTIONS(413),
    [anon_sym_NA_complex_] = ACTIONS(413),
    [anon_sym_NA_character_] = ACTIONS(413),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(415),
    [sym__raw_string_literal] = ACTIONS(417),
    [sym__external_open_parenthesis] = ACTIONS(419),
    [sym__external_close_parenthesis] = ACTIONS(585),
    [sym__external_open_brace] = ACTIONS(423),
  },
  [276] = {
    [sym_function_definition] = STATE(1575),
    [sym_if_statement] = STATE(1575),
    [sym_for_statement] = STATE(1575),
    [sym_while_statement] = STATE(1575),
    [sym_repeat_statement] = STATE(1575),
    [sym_braced_expression] = STATE(1575),
    [sym_parenthesized_expression] = STATE(1575),
    [sym_call] = STATE(1575),
    [sym_subset] = STATE(1575),
    [sym_subset2] = STATE(1575),
    [sym_argument] = STATE(1915),
    [sym__argument_named] = STATE(2032),
    [sym__argument_unnamed] = STATE(2045),
    [sym__argument_value] = STATE(2043),
    [sym_unary_operator] = STATE(1575),
    [sym_binary_operator] = STATE(1575),
    [sym_extract_operator] = STATE(1575),
    [sym_namespace_operator] = STATE(1575),
    [sym_integer] = STATE(1575),
    [sym_complex] = STATE(1575),
    [sym_float] = STATE(1575),
    [sym__float_literal] = STATE(1626),
    [sym_string] = STATE(1628),
    [sym__single_quoted_string] = STATE(1629),
    [sym__double_quoted_string] = STATE(1611),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2071),
    [sym_na] = STATE(1575),
    [sym__expression] = STATE(1575),
    [sym__open_parenthesis] = STATE(1064),
    [sym__open_brace] = STATE(418),
    [sym__close_bracket] = STATE(329),
    [aux_sym_call_arguments_repeat1] = STATE(1917),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(495),
    [anon_sym_function] = ACTIONS(497),
    [anon_sym_if] = ACTIONS(499),
    [anon_sym_for] = ACTIONS(501),
    [anon_sym_while] = ACTIONS(503),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_QMARK] = ACTIONS(507),
    [anon_sym_TILDE] = ACTIONS(509),
    [anon_sym_BANG] = ACTIONS(511),
    [anon_sym_PLUS] = ACTIONS(513),
    [anon_sym_DASH] = ACTIONS(513),
    [sym__hex_literal] = ACTIONS(515),
    [sym__number_literal] = ACTIONS(517),
    [anon_sym_SQUOTE] = ACTIONS(519),
    [anon_sym_DQUOTE] = ACTIONS(521),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(493),
    [sym_return] = ACTIONS(523),
    [sym_next] = ACTIONS(523),
    [sym_break] = ACTIONS(523),
    [sym_true] = ACTIONS(523),
    [sym_false] = ACTIONS(523),
    [sym_null] = ACTIONS(525),
    [sym_inf] = ACTIONS(523),
    [sym_nan] = ACTIONS(523),
    [anon_sym_NA] = ACTIONS(527),
    [anon_sym_NA_integer_] = ACTIONS(527),
    [anon_sym_NA_real_] = ACTIONS(527),
    [anon_sym_NA_complex_] = ACTIONS(527),
    [anon_sym_NA_character_] = ACTIONS(527),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(529),
    [sym__raw_string_literal] = ACTIONS(531),
    [sym__external_open_parenthesis] = ACTIONS(533),
    [sym__external_open_brace] = ACTIONS(535),
    [sym__external_close_bracket] = ACTIONS(587),
  },
  [277] = {
    [sym_function_definition] = STATE(1552),
    [sym_if_statement] = STATE(1552),
    [sym_for_statement] = STATE(1552),
    [sym_while_statement] = STATE(1552),
    [sym_repeat_statement] = STATE(1552),
    [sym_braced_expression] = STATE(1552),
    [sym_parenthesized_expression] = STATE(1552),
    [sym_call] = STATE(1552),
    [sym_subset] = STATE(1552),
    [sym_subset2] = STATE(1552),
    [sym_argument] = STATE(1918),
    [sym__argument_named] = STATE(2040),
    [sym__argument_unnamed] = STATE(2035),
    [sym__argument_value] = STATE(2047),
    [sym_unary_operator] = STATE(1552),
    [sym_binary_operator] = STATE(1552),
    [sym_extract_operator] = STATE(1552),
    [sym_namespace_operator] = STATE(1552),
    [sym_integer] = STATE(1552),
    [sym_complex] = STATE(1552),
    [sym_float] = STATE(1552),
    [sym__float_literal] = STATE(1610),
    [sym_string] = STATE(1627),
    [sym__single_quoted_string] = STATE(1604),
    [sym__double_quoted_string] = STATE(1632),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2054),
    [sym_na] = STATE(1552),
    [sym__expression] = STATE(1552),
    [sym__open_parenthesis] = STATE(1069),
    [sym__open_brace] = STATE(422),
    [sym__close_bracket2] = STATE(330),
    [aux_sym_call_arguments_repeat1] = STATE(1920),
    [sym_identifier] = ACTIONS(425),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_function] = ACTIONS(429),
    [anon_sym_if] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_repeat] = ACTIONS(437),
    [anon_sym_QMARK] = ACTIONS(439),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_PLUS] = ACTIONS(445),
    [anon_sym_DASH] = ACTIONS(445),
    [sym__hex_literal] = ACTIONS(447),
    [sym__number_literal] = ACTIONS(449),
    [anon_sym_SQUOTE] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(453),
    [sym_dots] = ACTIONS(425),
    [sym_dot_dot_i] = ACTIONS(425),
    [sym_return] = ACTIONS(455),
    [sym_next] = ACTIONS(455),
    [sym_break] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_null] = ACTIONS(457),
    [sym_inf] = ACTIONS(455),
    [sym_nan] = ACTIONS(455),
    [anon_sym_NA] = ACTIONS(459),
    [anon_sym_NA_integer_] = ACTIONS(459),
    [anon_sym_NA_real_] = ACTIONS(459),
    [anon_sym_NA_complex_] = ACTIONS(459),
    [anon_sym_NA_character_] = ACTIONS(459),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(461),
    [sym__raw_string_literal] = ACTIONS(463),
    [sym__external_open_parenthesis] = ACTIONS(465),
    [sym__external_open_brace] = ACTIONS(467),
    [sym__external_close_bracket2] = ACTIONS(589),
  },
  [278] = {
    [sym_function_definition] = STATE(1361),
    [sym_if_statement] = STATE(1361),
    [sym_for_statement] = STATE(1361),
    [sym_while_statement] = STATE(1361),
    [sym_repeat_statement] = STATE(1361),
    [sym_braced_expression] = STATE(1361),
    [sym_parenthesized_expression] = STATE(1361),
    [sym_call] = STATE(1361),
    [sym_subset] = STATE(1361),
    [sym_subset2] = STATE(1361),
    [sym_argument] = STATE(1861),
    [sym__argument_named] = STATE(2046),
    [sym__argument_unnamed] = STATE(2031),
    [sym__argument_value] = STATE(2030),
    [sym_unary_operator] = STATE(1361),
    [sym_binary_operator] = STATE(1361),
    [sym_extract_operator] = STATE(1361),
    [sym_namespace_operator] = STATE(1361),
    [sym_integer] = STATE(1361),
    [sym_complex] = STATE(1361),
    [sym_float] = STATE(1361),
    [sym__float_literal] = STATE(1620),
    [sym_string] = STATE(1630),
    [sym__single_quoted_string] = STATE(1624),
    [sym__double_quoted_string] = STATE(1625),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2059),
    [sym_na] = STATE(1361),
    [sym__expression] = STATE(1361),
    [sym__open_parenthesis] = STATE(1056),
    [sym__close_parenthesis] = STATE(1704),
    [sym__open_brace] = STATE(402),
    [aux_sym_call_arguments_repeat1] = STATE(1862),
    [sym_identifier] = ACTIONS(379),
    [anon_sym_BSLASH] = ACTIONS(381),
    [anon_sym_function] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_while] = ACTIONS(389),
    [anon_sym_repeat] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(395),
    [anon_sym_BANG] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [sym__hex_literal] = ACTIONS(401),
    [sym__number_literal] = ACTIONS(403),
    [anon_sym_SQUOTE] = ACTIONS(405),
    [anon_sym_DQUOTE] = ACTIONS(407),
    [sym_dots] = ACTIONS(379),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_return] = ACTIONS(409),
    [sym_next] = ACTIONS(409),
    [sym_break] = ACTIONS(409),
    [sym_true] = ACTIONS(409),
    [sym_false] = ACTIONS(409),
    [sym_null] = ACTIONS(411),
    [sym_inf] = ACTIONS(409),
    [sym_nan] = ACTIONS(409),
    [anon_sym_NA] = ACTIONS(413),
    [anon_sym_NA_integer_] = ACTIONS(413),
    [anon_sym_NA_real_] = ACTIONS(413),
    [anon_sym_NA_complex_] = ACTIONS(413),
    [anon_sym_NA_character_] = ACTIONS(413),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(415),
    [sym__raw_string_literal] = ACTIONS(417),
    [sym__external_open_parenthesis] = ACTIONS(419),
    [sym__external_close_parenthesis] = ACTIONS(591),
    [sym__external_open_brace] = ACTIONS(423),
  },
  [279] = {
    [sym_function_definition] = STATE(1575),
    [sym_if_statement] = STATE(1575),
    [sym_for_statement] = STATE(1575),
    [sym_while_statement] = STATE(1575),
    [sym_repeat_statement] = STATE(1575),
    [sym_braced_expression] = STATE(1575),
    [sym_parenthesized_expression] = STATE(1575),
    [sym_call] = STATE(1575),
    [sym_subset] = STATE(1575),
    [sym_subset2] = STATE(1575),
    [sym_argument] = STATE(1901),
    [sym__argument_named] = STATE(2032),
    [sym__argument_unnamed] = STATE(2045),
    [sym__argument_value] = STATE(2043),
    [sym_unary_operator] = STATE(1575),
    [sym_binary_operator] = STATE(1575),
    [sym_extract_operator] = STATE(1575),
    [sym_namespace_operator] = STATE(1575),
    [sym_integer] = STATE(1575),
    [sym_complex] = STATE(1575),
    [sym_float] = STATE(1575),
    [sym__float_literal] = STATE(1626),
    [sym_string] = STATE(1628),
    [sym__single_quoted_string] = STATE(1629),
    [sym__double_quoted_string] = STATE(1611),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2071),
    [sym_na] = STATE(1575),
    [sym__expression] = STATE(1575),
    [sym__open_parenthesis] = STATE(1064),
    [sym__open_brace] = STATE(418),
    [sym__close_bracket] = STATE(1705),
    [aux_sym_call_arguments_repeat1] = STATE(1914),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(495),
    [anon_sym_function] = ACTIONS(497),
    [anon_sym_if] = ACTIONS(499),
    [anon_sym_for] = ACTIONS(501),
    [anon_sym_while] = ACTIONS(503),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_QMARK] = ACTIONS(507),
    [anon_sym_TILDE] = ACTIONS(509),
    [anon_sym_BANG] = ACTIONS(511),
    [anon_sym_PLUS] = ACTIONS(513),
    [anon_sym_DASH] = ACTIONS(513),
    [sym__hex_literal] = ACTIONS(515),
    [sym__number_literal] = ACTIONS(517),
    [anon_sym_SQUOTE] = ACTIONS(519),
    [anon_sym_DQUOTE] = ACTIONS(521),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(493),
    [sym_return] = ACTIONS(523),
    [sym_next] = ACTIONS(523),
    [sym_break] = ACTIONS(523),
    [sym_true] = ACTIONS(523),
    [sym_false] = ACTIONS(523),
    [sym_null] = ACTIONS(525),
    [sym_inf] = ACTIONS(523),
    [sym_nan] = ACTIONS(523),
    [anon_sym_NA] = ACTIONS(527),
    [anon_sym_NA_integer_] = ACTIONS(527),
    [anon_sym_NA_real_] = ACTIONS(527),
    [anon_sym_NA_complex_] = ACTIONS(527),
    [anon_sym_NA_character_] = ACTIONS(527),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(529),
    [sym__raw_string_literal] = ACTIONS(531),
    [sym__external_open_parenthesis] = ACTIONS(533),
    [sym__external_open_brace] = ACTIONS(535),
    [sym__external_close_bracket] = ACTIONS(593),
  },
  [280] = {
    [sym_function_definition] = STATE(1552),
    [sym_if_statement] = STATE(1552),
    [sym_for_statement] = STATE(1552),
    [sym_while_statement] = STATE(1552),
    [sym_repeat_statement] = STATE(1552),
    [sym_braced_expression] = STATE(1552),
    [sym_parenthesized_expression] = STATE(1552),
    [sym_call] = STATE(1552),
    [sym_subset] = STATE(1552),
    [sym_subset2] = STATE(1552),
    [sym_argument] = STATE(1916),
    [sym__argument_named] = STATE(2040),
    [sym__argument_unnamed] = STATE(2035),
    [sym__argument_value] = STATE(2047),
    [sym_unary_operator] = STATE(1552),
    [sym_binary_operator] = STATE(1552),
    [sym_extract_operator] = STATE(1552),
    [sym_namespace_operator] = STATE(1552),
    [sym_integer] = STATE(1552),
    [sym_complex] = STATE(1552),
    [sym_float] = STATE(1552),
    [sym__float_literal] = STATE(1610),
    [sym_string] = STATE(1627),
    [sym__single_quoted_string] = STATE(1604),
    [sym__double_quoted_string] = STATE(1632),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2054),
    [sym_na] = STATE(1552),
    [sym__expression] = STATE(1552),
    [sym__open_parenthesis] = STATE(1069),
    [sym__open_brace] = STATE(422),
    [sym__close_bracket2] = STATE(1706),
    [aux_sym_call_arguments_repeat1] = STATE(1919),
    [sym_identifier] = ACTIONS(425),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_function] = ACTIONS(429),
    [anon_sym_if] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_repeat] = ACTIONS(437),
    [anon_sym_QMARK] = ACTIONS(439),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_PLUS] = ACTIONS(445),
    [anon_sym_DASH] = ACTIONS(445),
    [sym__hex_literal] = ACTIONS(447),
    [sym__number_literal] = ACTIONS(449),
    [anon_sym_SQUOTE] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(453),
    [sym_dots] = ACTIONS(425),
    [sym_dot_dot_i] = ACTIONS(425),
    [sym_return] = ACTIONS(455),
    [sym_next] = ACTIONS(455),
    [sym_break] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_null] = ACTIONS(457),
    [sym_inf] = ACTIONS(455),
    [sym_nan] = ACTIONS(455),
    [anon_sym_NA] = ACTIONS(459),
    [anon_sym_NA_integer_] = ACTIONS(459),
    [anon_sym_NA_real_] = ACTIONS(459),
    [anon_sym_NA_complex_] = ACTIONS(459),
    [anon_sym_NA_character_] = ACTIONS(459),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(461),
    [sym__raw_string_literal] = ACTIONS(463),
    [sym__external_open_parenthesis] = ACTIONS(465),
    [sym__external_open_brace] = ACTIONS(467),
    [sym__external_close_bracket2] = ACTIONS(595),
  },
  [281] = {
    [sym_function_definition] = STATE(1361),
    [sym_if_statement] = STATE(1361),
    [sym_for_statement] = STATE(1361),
    [sym_while_statement] = STATE(1361),
    [sym_repeat_statement] = STATE(1361),
    [sym_braced_expression] = STATE(1361),
    [sym_parenthesized_expression] = STATE(1361),
    [sym_call] = STATE(1361),
    [sym_subset] = STATE(1361),
    [sym_subset2] = STATE(1361),
    [sym_argument] = STATE(1807),
    [sym__argument_named] = STATE(2046),
    [sym__argument_unnamed] = STATE(2031),
    [sym__argument_value] = STATE(2030),
    [sym_unary_operator] = STATE(1361),
    [sym_binary_operator] = STATE(1361),
    [sym_extract_operator] = STATE(1361),
    [sym_namespace_operator] = STATE(1361),
    [sym_integer] = STATE(1361),
    [sym_complex] = STATE(1361),
    [sym_float] = STATE(1361),
    [sym__float_literal] = STATE(1620),
    [sym_string] = STATE(1630),
    [sym__single_quoted_string] = STATE(1624),
    [sym__double_quoted_string] = STATE(1625),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2059),
    [sym_na] = STATE(1361),
    [sym__expression] = STATE(1361),
    [sym__open_parenthesis] = STATE(1056),
    [sym__close_parenthesis] = STATE(1642),
    [sym__open_brace] = STATE(402),
    [aux_sym_call_arguments_repeat1] = STATE(1879),
    [sym_identifier] = ACTIONS(379),
    [anon_sym_BSLASH] = ACTIONS(381),
    [anon_sym_function] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_while] = ACTIONS(389),
    [anon_sym_repeat] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(393),
    [anon_sym_TILDE] = ACTIONS(395),
    [anon_sym_BANG] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [sym__hex_literal] = ACTIONS(401),
    [sym__number_literal] = ACTIONS(403),
    [anon_sym_SQUOTE] = ACTIONS(405),
    [anon_sym_DQUOTE] = ACTIONS(407),
    [sym_dots] = ACTIONS(379),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_return] = ACTIONS(409),
    [sym_next] = ACTIONS(409),
    [sym_break] = ACTIONS(409),
    [sym_true] = ACTIONS(409),
    [sym_false] = ACTIONS(409),
    [sym_null] = ACTIONS(411),
    [sym_inf] = ACTIONS(409),
    [sym_nan] = ACTIONS(409),
    [anon_sym_NA] = ACTIONS(413),
    [anon_sym_NA_integer_] = ACTIONS(413),
    [anon_sym_NA_real_] = ACTIONS(413),
    [anon_sym_NA_complex_] = ACTIONS(413),
    [anon_sym_NA_character_] = ACTIONS(413),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(415),
    [sym__raw_string_literal] = ACTIONS(417),
    [sym__external_open_parenthesis] = ACTIONS(419),
    [sym__external_close_parenthesis] = ACTIONS(597),
    [sym__external_open_brace] = ACTIONS(423),
  },
  [282] = {
    [sym_function_definition] = STATE(1575),
    [sym_if_statement] = STATE(1575),
    [sym_for_statement] = STATE(1575),
    [sym_while_statement] = STATE(1575),
    [sym_repeat_statement] = STATE(1575),
    [sym_braced_expression] = STATE(1575),
    [sym_parenthesized_expression] = STATE(1575),
    [sym_call] = STATE(1575),
    [sym_subset] = STATE(1575),
    [sym_subset2] = STATE(1575),
    [sym_argument] = STATE(1923),
    [sym__argument_named] = STATE(2032),
    [sym__argument_unnamed] = STATE(2045),
    [sym__argument_value] = STATE(2043),
    [sym_unary_operator] = STATE(1575),
    [sym_binary_operator] = STATE(1575),
    [sym_extract_operator] = STATE(1575),
    [sym_namespace_operator] = STATE(1575),
    [sym_integer] = STATE(1575),
    [sym_complex] = STATE(1575),
    [sym_float] = STATE(1575),
    [sym__float_literal] = STATE(1626),
    [sym_string] = STATE(1628),
    [sym__single_quoted_string] = STATE(1629),
    [sym__double_quoted_string] = STATE(1611),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2071),
    [sym_na] = STATE(1575),
    [sym__expression] = STATE(1575),
    [sym__open_parenthesis] = STATE(1064),
    [sym__open_brace] = STATE(418),
    [sym__close_bracket] = STATE(1673),
    [aux_sym_call_arguments_repeat1] = STATE(1935),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(495),
    [anon_sym_function] = ACTIONS(497),
    [anon_sym_if] = ACTIONS(499),
    [anon_sym_for] = ACTIONS(501),
    [anon_sym_while] = ACTIONS(503),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_QMARK] = ACTIONS(507),
    [anon_sym_TILDE] = ACTIONS(509),
    [anon_sym_BANG] = ACTIONS(511),
    [anon_sym_PLUS] = ACTIONS(513),
    [anon_sym_DASH] = ACTIONS(513),
    [sym__hex_literal] = ACTIONS(515),
    [sym__number_literal] = ACTIONS(517),
    [anon_sym_SQUOTE] = ACTIONS(519),
    [anon_sym_DQUOTE] = ACTIONS(521),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(493),
    [sym_return] = ACTIONS(523),
    [sym_next] = ACTIONS(523),
    [sym_break] = ACTIONS(523),
    [sym_true] = ACTIONS(523),
    [sym_false] = ACTIONS(523),
    [sym_null] = ACTIONS(525),
    [sym_inf] = ACTIONS(523),
    [sym_nan] = ACTIONS(523),
    [anon_sym_NA] = ACTIONS(527),
    [anon_sym_NA_integer_] = ACTIONS(527),
    [anon_sym_NA_real_] = ACTIONS(527),
    [anon_sym_NA_complex_] = ACTIONS(527),
    [anon_sym_NA_character_] = ACTIONS(527),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(529),
    [sym__raw_string_literal] = ACTIONS(531),
    [sym__external_open_parenthesis] = ACTIONS(533),
    [sym__external_open_brace] = ACTIONS(535),
    [sym__external_close_bracket] = ACTIONS(599),
  },
  [283] = {
    [sym_function_definition] = STATE(1575),
    [sym_if_statement] = STATE(1575),
    [sym_for_statement] = STATE(1575),
    [sym_while_statement] = STATE(1575),
    [sym_repeat_statement] = STATE(1575),
    [sym_braced_expression] = STATE(1575),
    [sym_parenthesized_expression] = STATE(1575),
    [sym_call] = STATE(1575),
    [sym_subset] = STATE(1575),
    [sym_subset2] = STATE(1575),
    [sym_argument] = STATE(1853),
    [sym__argument_named] = STATE(2032),
    [sym__argument_unnamed] = STATE(2045),
    [sym__argument_value] = STATE(2043),
    [sym_unary_operator] = STATE(1575),
    [sym_binary_operator] = STATE(1575),
    [sym_extract_operator] = STATE(1575),
    [sym_namespace_operator] = STATE(1575),
    [sym_integer] = STATE(1575),
    [sym_complex] = STATE(1575),
    [sym_float] = STATE(1575),
    [sym__float_literal] = STATE(1626),
    [sym_string] = STATE(1628),
    [sym__single_quoted_string] = STATE(1629),
    [sym__double_quoted_string] = STATE(1611),
    [sym__argument_name_string_or_identifier_or_null] = STATE(2071),
    [sym_na] = STATE(1575),
    [sym__expression] = STATE(1575),
    [sym__open_parenthesis] = STATE(1064),
    [sym__open_brace] = STATE(418),
    [sym__close_bracket] = STATE(1721),
    [aux_sym_call_arguments_repeat1] = STATE(1854),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(495),
    [anon_sym_function] = ACTIONS(497),
    [anon_sym_if] = ACTIONS(499),
    [anon_sym_for] = ACTIONS(501),
    [anon_sym_while] = ACTIONS(503),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_QMARK] = ACTIONS(507),
    [anon_sym_TILDE] = ACTIONS(509),
    [anon_sym_BANG] = ACTIONS(511),
    [anon_sym_PLUS] = ACTIONS(513),
    [anon_sym_DASH] = ACTIONS(513),
    [sym__hex_literal] = ACTIONS(515),
    [sym__number_literal] = ACTIONS(517),
    [anon_sym