% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_valinvec.R
\name{recode_valinvec}
\alias{recode_valinvec}
\title{Recode a variable}
\usage{
recode_valinvec(data, var, recode_map, new_var)
}
\arguments{
\item{data}{A data frame or tibble.}

\item{var}{A variable to be recoded.}

\item{recode_map}{A named vector specifying the recode map.}

\item{new_var}{Name of the new variable holding the recoded values.}
}
\value{
A data frame or tibble with the new variable added.
}
\description{
Recode a specified variable in a data frame or tibble based on a provided recode map. 
If the recode map is empty, the original variable is retained under a new name.
}
\examples{
# Example data
print(sailor_students)

# Define a recode map for gender
recode_map_gender <- c("Female" = "F", "Male" = "M", "Other" = "X")

# Recode gender
sailor_students_recoded <- 
recode_valinvec(sailor_students, gender, recode_map_gender, recode_gender)

# A tibble with a recoded gender variable
print(sailor_students_recoded)
}
