% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{expected_shortfall}
\alias{expected_shortfall}
\alias{expected_shortfall.gogarch.predict}
\alias{expected_shortfall.dcc.predict}
\alias{expected_shortfall.cgarch.predict}
\alias{expected_shortfall.gogarch.simulate}
\alias{expected_shortfall.dcc.simulate}
\alias{expected_shortfall.cgarch.simulate}
\title{Expected Shortfall (ES) method for predicted and simulated objects}
\usage{
expected_shortfall(object, ...)

\method{expected_shortfall}{gogarch.predict}(object, weights = NULL, alpha = 0.05, ...)

\method{expected_shortfall}{dcc.predict}(object, weights = NULL, alpha = 0.05, ...)

\method{expected_shortfall}{cgarch.predict}(object, weights = NULL, alpha = 0.05, ...)

\method{expected_shortfall}{gogarch.simulate}(object, weights = NULL, alpha = 0.05, ...)

\method{expected_shortfall}{dcc.simulate}(object, weights = NULL, alpha = 0.05, ...)

\method{expected_shortfall}{cgarch.simulate}(object, weights = NULL, alpha = 0.05, ...)
}
\arguments{
\item{object}{an object generated from the predict or simulate methods.}

\item{...}{not used.}

\item{weights}{a vector of weights of length equal to the number of series. If
NULL then an equal weight vector is used.}

\item{alpha}{the quantile level for the value at risk.
for the GOGARCH model.}
}
\value{
a matrix of the expected shortfall. For predict type input objects this will be an xts
matrix with index the forecast dates.
}
\description{
Expected Shortfall (ES) method for predicted and simulated objects
}
