% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.cgarch.estimate}
\alias{predict.cgarch.estimate}
\alias{predict}
\alias{predict.dcc.estimate}
\alias{predict.gogarch.estimate}
\title{Model Prediction}
\usage{
\method{predict}{cgarch.estimate}(
  object,
  h = 1,
  nsim = 1000,
  sim_method = c("parametric", "bootstrap"),
  forc_dates = NULL,
  cond_mean = NULL,
  seed = NULL,
  ...
)

\method{predict}{dcc.estimate}(
  object,
  h = 1,
  nsim = 1000,
  sim_method = c("parametric", "bootstrap"),
  forc_dates = NULL,
  cond_mean = NULL,
  seed = NULL,
  ...
)

\method{predict}{gogarch.estimate}(
  object,
  h = 1,
  nsim = 1000,
  sim_method = c("parametric", "bootstrap"),
  forc_dates = NULL,
  cond_mean = NULL,
  seed = NULL,
  ...
)
}
\arguments{
\item{object}{an estimated object from one of the models in the package.}

\item{h}{the forecast horizon.}

\item{nsim}{the number of sample paths to generate.}

\item{sim_method}{white noise method for generating random sample for the
multivariate distribution. The default \dQuote{parametric} samples random normal
variates whilst the \dQuote{bootstrap} samples from the whitened innovations
of the fitted model.}

\item{forc_dates}{an optional vector of forecast dates equal to h. If NULL will
use the implied periodicity of the data to generate a regular sequence of dates
after the last available date in the data.}

\item{cond_mean}{an optional matrix (h x n_series) of the predicted conditional
mean for the series which is used to recenter the simulated predictive distribution.}

\item{seed}{an integer that will be used in a call to set.seed before simulating.}

\item{...}{no additional arguments currently supported.}
}
\value{
A prediction class object for which methods exists for extracting
relevant statistics such as the correlation, covariance, etc.
}
\description{
Prediction function for estimated objects.
}
\details{
For the Copula GARCH model, the prediction is based on simulation due to the
nonlinear transformation present in the model.
}
