% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle_tpexp.R
\name{mle_tpexp}
\alias{mle_tpexp}
\title{Maximum likelihood estimation for the two-parameter exponential dist.}
\source{
Zheng, M. (2013). \emph{Penalized Maximum Likelihood Estimation of Two-Parameter Exponential Distributions [Master’s thesis]}.
 \url{https://scse.d.umn.edu/sites/scse.d.umn.edu/files/mengjie-thesis_masters-1.pdf}
}
\usage{
mle_tpexp(x, theta = 0, beta = 1)
}
\arguments{
\item{x}{vector of quantile (or a data set).}

\item{theta}{location parameter, where \eqn{\theta > 0}.}

\item{beta}{scale parameter, where \eqn{\beta > 0} and \eqn{rate=1/\beta}.}
}
\value{
the estimate three values for the two-parameter exponential dist. as follows:
\code{theta.hat}  gives the estimate location parameter,
\code{beta.hat}   gives the estimate scale parameter,
and \code{lamda.hat} gives the estimate the rate.
}
\description{
To estimate the location (or shift) and scale parameters for  the two-parameter exponential distribution
based on maximum likelihood method. See detail in \code{source}
}
\examples{
x1 <- c(25,43,53,65,76,86,95,115,132,150) # test a data set
mle_tpexp(x1)
x2 <- c(20,15,10,25,35,30,40,70,50,60,90,100,80,5) # test a data set
mle_tpexp(x2)

}
