% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.twoway.R
\name{as.twoway}
\alias{as.twoway}
\alias{as.twoway.matrix}
\title{Create an initial twoway object representing the data before fitting}
\usage{
as.twoway(x, ...)

\method{as.twoway}{matrix}(x, ..., name = deparse(substitute(x)),
  responseName = name, varNames = names(dimnames(x)))
}
\arguments{
\item{x}{a numeric matrix or numeric data frame with rownames}

\item{...}{other arguments, unused here}

\item{name}{Name of the data matrix}

\item{responseName}{Name of the response variable}

\item{varNames}{Names of the row and column variables}
}
\value{
An object of class \code{c("twoway")} with all effects(roweff, coleff, overall) set to zero, and \code{method="Initial"}
}
\description{
Create an initial twoway object representing the data before fitting

Method for matrix input
}
\examples{
data(taskRT)
as.twoway(taskRT)

}
\author{
Richard M. Heiberger

Richard M. Heiberger
}
