% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmrsIndoItsdo.R
\name{bmrsIndoItsdo}
\alias{bmrsIndoItsdo}
\title{BMRS Initial Demand Outturn API Service}
\usage{
bmrsIndoItsdo(
  fromdate,
  todate,
  apikey,
  batchsize = 60,
  apiurl = "https://api.bmreports.com/BMRS/INDOITSDO/v1"
)
}
\arguments{
\item{fromdate}{A character object specifying the start date. Date is inclusive.}

\item{todate}{A character object specifying the end date. Date is inclusive.}

\item{apikey}{A character object specifying the API key. This is also known as scripting key on Elexon's website.}

\item{batchsize}{An interger value indicating the batch size of each API call. (Number of days included in one call)}

\item{apiurl}{A character object which points to the BMRS INDO/ITSDO API. Under most circumstances users do not have to change this. Default to 'https://api.bmreports.com/BMRS/INDOITSDO/v1'}
}
\value{
A dataframe object containing API response data.
}
\description{
This function connects to the Elexon's BMRS API to retrieve Initial Demand Outturn (INDO) and Initial Transmission System Demand Out-Turn (ITSDO) data. Internet connection must be available.
}
\details{
The function submits a request to the API. The response is in CSV format which function will parse internally and returns a R dataframe object. The data returned by this API is identical to the data displayed on BMRS dashboard \url{https://www.bmreports.com/bmrs/?q=demand/initialdemandoutturn}.
}
\examples{
\dontrun{
# Invoke the API (requires internet connection at this step)
response <- bmrsIndoItsdo(fromdate = "2020-01-01",
                          todate =  "2020-01-10",
                          apikey = "your api key goes here")

# Visualise the results on a chart
library(ggplot2)
ggplot(response, aes(x=publishtime, y=value,colour=recordtype)) +
  geom_line()
}
}
\references{
\itemize{
\item BMRS API and Data Push User Guide\cr
\url{https://www.elexon.co.uk/documents/training-guidance/bsc-guidance-notes/bmrs-api-and-data-push-user-guide-2/}
\item Scripting Guide\cr
\url{https://www.elexonportal.co.uk/scripting}
\item Initial Demand Outturn (INDO)\cr
\url{https://www.bmreports.com/bmrs/?q=help/glossary#INDO}
\item Initial Transmission System Demand Out-Turn (ITSDO)\cr
\url{https://www.bmreports.com/bmrs/?q=help/glossary#ITSDO}
}
}
\author{
Timothy Wong, \email{timothy.wong@hotmail.co.uk}
}
