% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{importDesign}
\alias{importDesign}
\title{Import experimental design meta data such as replicates, treatments, categorical variables.}
\usage{
importDesign(object, file, delim = NULL)
}
\arguments{
\item{object}{UMI.experiment to which to add metadata}

\item{file}{File containing meta data}

\item{delim}{Column separator. Default is NULL (automatically determine delimiter)}
}
\value{
A UMIexperiment object
}
\description{
Import experimental design meta data such as replicates, treatments, categorical variables.
}
\examples{
library(umiAnalyzer)

main <- system.file("extdata", package = "umiAnalyzer")

simsen <- createUmiExperiment(main)

metaData <- system.file("extdata", "metadata.txt", package = "umiAnalyzer")

simsen <- importDesign(object = simsen,file = metaData)

# Retrieve meta data
design <- getMetaData(object = simsen, attributeName = "design")
design


}
