% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{saveConsData}
\alias{saveConsData}
\title{Save consensus data}
\usage{
saveConsData(
  object,
  save = FALSE,
  fileName = "consensus_data.csv",
  outDir = getwd(),
  delim = ";"
)
}
\arguments{
\item{object}{UMIexperiment object}

\item{save}{Logical. Should data be saved to file? Default is FALSE.}

\item{fileName}{String. Name of the file to be saved. Default is 'consensus_data.csv'}

\item{outDir}{output directory, defaults to working directory}

\item{delim}{Single character string, either ';' or ',' or tab}
}
\value{
A data table
}
\description{
If save is set to TRUE data will be written to a csv file otherwise consensus data will
be returned as a tibble.
}
\examples{
library(umiAnalyzer)

main = system.file('extdata', package = 'umiAnalyzer')

samples <- list.dirs(path = main, full.names = FALSE, recursive = FALSE)

example <- createUmiExperiment(experimentName = 'example',mainDir = main,sampleNames = samples)

consensus_data <- saveConsData(object = example)
consensus_data


}
