% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Aberystwyth.R
\docType{data}
\name{aberystwyth_1}
\alias{aberystwyth_1}
\title{Primary corporate colors of Aberystwyth University, Wales}
\format{
An object of class \code{character} of length 2.
}
\source{
\href{https://aber.ac.uk/en/}{Aberystwyth University}'s 
\href{https://www.aber.ac.uk/en/gmsr/brand/colours-fonts/}{Corporate colours}.
}
\usage{
aberystwyth_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{aberystwyth_1} provides the two primary corporate colours 
of \href{https://aber.ac.uk/en/}{Aberystwyth University}, Wales, UK.
}
\details{
The 2 primary colours of \href{https://aber.ac.uk/en/}{Aberystwyth University} are 
\code{Yellow}, defined as CMYK 0% 20% 100% 0%, Pantone 123C, 
RGB 255 205 00, or HEX "#ffcc00", and 
\code{Navy}, defined as CMYK 100% 95% 35% 30%, Pantone 2766C, 
RGB 36 39 83, or HEX "#242753".

\code{aberystwyth_1} uses the HEX color definitions.


\href{https://aber.ac.uk/en/}{Aberystwyth University}'s primary colour palette 
retains the historical ethos of Aberystwyth which is important to the brand.

The colours are confident and strong and help Aberystwyth retain its image 
as a reputable, internationally-recognised research-based university.
}
\examples{
aberystwyth_1
unikn::seecol(aberystwyth_1, main = "Primary colours of Aberystwyth University") # view colours

}
\seealso{
\code{\link{aberystwyth_2}} for secondary colours of Aberystwyth University;
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Welsh university color palettes: 
\code{\link{aberystwyth_2}},
\code{\link{bangor_1}},
\code{\link{bangor_2}},
\code{\link{bangor_3}},
\code{\link{bangor_4}},
\code{\link{cardiff_1}},
\code{\link{cardiff_2}}
}
\author{
\strong{unicol}, 2023-09-11.
}
\concept{Welsh university color palettes}
\keyword{datasets}
