% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETH.R
\docType{data}
\name{eth_1}
\alias{eth_1}
\title{Default colors of the ETH Zurich, CH}
\format{
An object of class \code{character} of length 7.
}
\source{
Color definitions are based on 
\url{https://ethz.ch/de.html/staffnet/en/service/communication/corporate-design/digital-media/web-colours.html}.
}
\usage{
eth_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{eth_1} provides the seven default colors  
of the \href{https://ethz.ch/de.html/}{ETH Zürich}, Switzerland.
}
\details{
Lighter shades of the ETH Zurich colors are provided by \code{\link{eth_2}}. 

The Swiss abbreviation "ETH" stands for "Eidgenössische Technische Hochschule".
}
\examples{
eth_1
unikn::seecol(eth_1, main = "Default colors of the ETH Zürich")  # view color palette
unikn::demopal(eth_1, type = 3, main = "Using the default colors of ETH Zurich")

}
\seealso{
\code{\link{eth_2}} and \code{\link{eth_3}} for alternative colors of the ETH Zurich;  
\code{\link[unikn]{seecol}} for viewing and comparing color palettes; 
\code{\link[unikn]{usecol}} for using color palettes; 
\code{\link[unikn]{simcol}} for finding similar colors; 
\code{\link[unikn]{newpal}} for defining new color palettes; 
\code{\link[unikn]{grepal}} for finding named colors.

Other Swiss university color palettes: 
\code{\link{eth_2}},
\code{\link{eth_3}}
}
\author{
\strong{unicol}, 2022-12-30.
}
\concept{Swiss university color palettes}
\keyword{datasets}
