% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETH.R
\docType{data}
\name{eth_3}
\alias{eth_3}
\title{Black and grey colors of the ETH Zurich, CH}
\format{
An object of class \code{character} of length 7.
}
\source{
Color definitions are based on 
\url{https://ethz.ch/de.html/staffnet/en/service/communication/corporate-design/digital-media/web-colours.html}.
}
\usage{
eth_3
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{eth_3} provides the black and gray colors  
used by the \href{https://ethz.ch/de.html/}{ETH Zürich}, Switzerland.
}
\details{
The color \code{"black"} and six shades of gray can be used to visually structure content 
and delineate different elements. 

Note that \code{eth_3} mixes colors of 
varying opacity / transparency levels.
}
\examples{
eth_3
unikn::seecol(eth_3, main = "Black and grey colors of the ETH Zurich")  # view color palette
unikn::demopal(eth_3, type = 2, main = "Black and gray colors of ETH Zürich")

}
\seealso{
\code{\link{eth_1}} and \code{\link{eth_2}} for alternative colors of the ETH Zurich;  
\code{\link[unikn]{seecol}} for viewing and comparing color palettes; 
\code{\link[unikn]{usecol}} for using color palettes; 
\code{\link[unikn]{simcol}} for finding similar colors; 
\code{\link[unikn]{newpal}} for defining new color palettes; 
\code{\link[unikn]{grepal}} for finding named colors.

Other Swiss university color palettes: 
\code{\link{eth_1}},
\code{\link{eth_2}}
}
\author{
\strong{unicol}, 2022-12-30.
}
\concept{Swiss university color palettes}
\keyword{datasets}
