<!-- badges: start -->
  
  [![Build Status](https://travis-ci.org/sheejamk/valueEQ5D.svg?branch=master)](https://travis-ci.org/sheejamk/valueEQ5D)
<!-- badges: end -->
      
<!-- badges: start -->
   [![Codecov test coverage](https://codecov.io/gh/sheejamk/valueEQ5D/branch/master/graph/badge.svg)](https://codecov.io/gh/sheejamk/valueEQ5D?branch=master)
    <!-- badges: end -->
  
# valueEQ5D
EQ-5D is a standardized instrument developed by the EuroQol(R) Group as a measure of health-related quality of life that can be used in a wide range of health conditions and treatments (https://euroqol.org/eq-5d-instruments/). The EQ-5D consists of a descriptive system and a visual analog scale (VAS).

The descriptive system comprises five dimensions: mobility, self-care, usual activities, pain/discomfort and anxiety /depression. The EQ-5D VAS records the patients, self-rated health on a vertical visual analogue scale. This can be used as a quantitative measure of health outcome that reflects the patients own judgment. The scores on these five dimensions can be presented as a health profile or can be converted to a single summary index number (utility) reflecting preferably compared to other health profiles.

This package can be used for valuing the adult EQ-5D descriptive system scores - both 5L and 3L for different countries.EQ-5D-5L scores can be valued for the following countries: Canada,China,England,Germany, Hong Kong, Indonesia, Ireland,Japan,Korea,Malaysia,Netherlands,Spain,Taiwan,Thailand,and Uruguay while EQ-5D-3L scores can be valued for the countries Belgium, Brazil, Canada, Chile, Denmark, Europe, Finland, France, Germany, Hungary, Italy, Japan, Korea, Netherlands, New Zealand, Poland, Portugal, Slovenia, Spain, Taiwan, Thailand, UK, USA, Zimbabwe, and Trinidad and Tobago. The 5L descriptive scores can be mapped to 3L index values for UK using the National Institute of Care and Excellence (NICE) recommended Van Hout et al. method. 

User needs to provide the column names of the data where the responses to EQ-5D questions are recorded. The modified data with the index values can be downloaded after analysis. The age and gender specific analysis can also be obtained.

Additionally there is a shiny web app which can be accessed at [shinyapps.io]  https://heapps.shinyapps.io/ScoreEQ5D/) 


**Usage**<br/>
See the User Guide Vignette for examples on using the package to value EQ-5D scores

**Installation**<br/>
You can install the released version from [CRAN](https://CRAN.R-project.org) with the command:

install.packages("valueEQ5D") 

Alternatively, the latest release can be installed from www.github.com/sheejamk/valueEQ5D

