% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel_models.R
\name{fit_mundlak_cre}
\alias{fit_mundlak_cre}
\title{Fit Mundlak Correlated Random Effects Model}
\usage{
fit_mundlak_cre(panel_data, include_time_fe = TRUE, robust_se = TRUE)
}
\arguments{
\item{panel_data}{Data frame in panel format.}

\item{include_time_fe}{Logical. Include time fixed effects. Default TRUE.}

\item{robust_se}{Logical. Compute robust standard errors. Default TRUE.}
}
\value{
A list containing:
\describe{
  \item{model}{The fitted plm model object}
  \item{summary}{Model summary}
  \item{panel_data_augmented}{Panel data with Mundlak transformations}
  \item{coeftest_robust}{Robust coefficient tests}
  \item{variance_components}{Random effects variance components}
  \item{metrics}{In-sample evaluation metrics}
}
}
\description{
Fits a Mundlak (CRE) model that decomposes effects into within and
between components, allowing for correlation between unit effects
and regressors.
}
\details{
The Mundlak transformation adds sector-level means of the regressors
to a random effects model, allowing consistent estimation even when
the random effects are correlated with the regressors.
}
\examples{
\donttest{
if (requireNamespace("plm", quietly = TRUE)) {
  set.seed(123)
  panel <- data.frame(
    year = rep(2000:2009, 5),
    sector = rep(LETTERS[1:5], each = 10),
    log_direct = rnorm(50, 5, 0.5),
    log_production = rnorm(50, 5, 0.5)
  )
  panel$log_production <- panel$log_direct * 0.95 + rnorm(50, 0, 0.1)

  result <- fit_mundlak_cre(panel)
  print(result$variance_components)
}
}

}
