% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preparation.R
\name{prepare_panel_data}
\alias{prepare_panel_data}
\title{Prepare Panel Data from Wide Format Matrices}
\usage{
prepare_panel_data(direct_prices, production_prices, log_transform = TRUE)
}
\arguments{
\item{direct_prices}{Data frame with direct prices (labor value-based).
First column must be 'Year', remaining columns are sector values.}

\item{production_prices}{Data frame with prices of production.
Must have same structure as direct_prices.}

\item{log_transform}{Logical. Apply natural log transformation. Default TRUE.}
}
\value{
A data frame in panel (long) format with columns:
\describe{
  \item{year}{Year of observation}
  \item{sector}{Sector identifier}
  \item{sector_id}{Numeric sector identifier}
  \item{time}{Time index (year minus minimum year plus 1)}
  \item{direct_price}{Direct price value}
  \item{production_price}{Price of production value}
  \item{log_direct}{Log of direct price (if log_transform = TRUE)}
  \item{log_production}{Log of production price (if log_transform = TRUE)}
}
}
\description{
Converts wide-format price matrices (with Year as first column and sectors
as subsequent columns) into long-format panel data suitable for panel
regression analysis.
}
\examples{
set.seed(123)
years <- 2000:2010
sectors <- c("Agriculture", "Manufacturing", "Services")

direct <- data.frame(
  Year = years,
  Agriculture = 100 + cumsum(rnorm(11)),
  Manufacturing = 120 + cumsum(rnorm(11)),
  Services = 90 + cumsum(rnorm(11))
)

production <- data.frame(
  Year = years,
  Agriculture = 102 + cumsum(rnorm(11)),
  Manufacturing = 118 + cumsum(rnorm(11)),
  Services = 92 + cumsum(rnorm(11))
)

panel <- prepare_panel_data(direct, production)
head(panel)

}
