% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_comparison.R
\name{run_full_analysis}
\alias{run_full_analysis}
\title{Run Complete Analysis Pipeline}
\usage{
run_full_analysis(
  direct_prices,
  production_prices,
  run_bayesian = FALSE,
  run_cv = TRUE,
  run_breaks = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{direct_prices}{Data frame with direct prices.}

\item{production_prices}{Data frame with production prices.}

\item{run_bayesian}{Logical. Run Bayesian models. Default FALSE.}

\item{run_cv}{Logical. Run cross-validation. Default TRUE.}

\item{run_breaks}{Logical. Run structural break tests. Default TRUE.}

\item{verbose}{Logical. Print progress. Default TRUE.}
}
\value{
A list with all analysis results.
}
\description{
Convenience function to run the full analysis pipeline.
}
\examples{
\donttest{
set.seed(123)
years <- 2000:2019
sectors <- LETTERS[1:5]

direct <- data.frame(Year = years)
production <- data.frame(Year = years)
for (s in sectors) {
  direct[[s]] <- 100 + cumsum(rnorm(20, 2, 1))
  production[[s]] <- 102 + cumsum(rnorm(20, 2, 1))
}

if (requireNamespace("plm", quietly = TRUE)) {
  results <- run_full_analysis(
    direct, production,
    run_bayesian = FALSE,
    run_cv = FALSE
  )
  print(results$comparison)
}
}

}
