% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vs_read_vcf.R
\name{vs_read_vcf}
\alias{vs_read_vcf}
\title{Reading a VCF file}
\usage{
vs_read_vcf(vsc, path)
}
\arguments{
\item{vsc}{A variantspark connection.}

\item{path}{The file's path.}
}
\value{
spark_jobj, shell_jobj
}
\description{
The Variant Call Format (VCF) specifies the format of a text file used in
bioinformatics for storing gene sequence variations. The format has been developed
with the advent of large-scale genotyping and DNA sequencing projects, such as
the 1000 Genomes Project. The \code{vs_read_vcf()} reads this format and returns
a \code{jobj} object from \code{VCFFeatureSource} scala class.
}
\examples{
 
\dontrun{
library(sparklyr)

sc <- spark_connect(master = "local")
vsc <- vs_context(sc)

hipster_vcf <- vs_read_vcf(vsc, 
                           system.file("extdata/hipster.vcf.bz2",
                                       package = "variantspark"))

hipster_vcf 
}

}
