% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{v_pie}
\alias{v_pie}
\title{Create a Pie Chart}
\usage{
v_pie(
  vc,
  mapping = NULL,
  data = NULL,
  name = NULL,
  label = list(visible = TRUE),
  ...,
  serie_id = NULL,
  data_id = NULL
)
}
\arguments{
\item{vc}{A chart initialized with \code{\link[=vchart]{vchart()}}.}

\item{mapping}{Default list of aesthetic mappings to use for chart.}

\item{data}{Default dataset to use for chart. If not already
a \code{data.frame}, it will be coerced to with \code{as.data.frame}.}

\item{name}{Name for the serie, only used for single serie (no \code{color}/\code{fill} aesthetic supplied).}

\item{label}{Options for displaying labels on the pie chart.}

\item{...}{Additional parameters for the serie.}

\item{data_id, serie_id}{ID for the data/serie, can be used to further customize the chart with \code{\link[=v_specs]{v_specs()}}.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Create a Pie Chart
}
\examples{

library(vchartr)

# Basic Pie Chart
subset(world_electricity, year == 2023 & type == "total") \%>\%
  vchart() \%>\% 
  v_pie(aes(x = source, y = generation))

# Use custom colors
subset(world_electricity, year == 2023 & type == "total") \%>\%
  vchart() \%>\% 
  v_pie(aes(x = source, y = generation)) \%>\%
  v_scale_color_manual(c(
    "Low carbon" = "#a3be8c",
    "Fossil fuels" = "#4C566A"
  ))

# Customize tooltip
subset(world_electricity, year == 2023 & type == "total") \%>\%
  vchart() \%>\% 
  v_pie(aes(x = source, y = generation)) \%>\%
  v_specs_tooltip(
    mark = list(
      content = list(
        list(
          key = JS("datum => datum['x']"),
          value = JS("datum => Math.round(datum['y']) + ' TWh'")
        ),
        list(
          hasShape = FALSE,
          key = "Proportion",
          value = JS("datum => datum._percent_ + '\%'")
        )
      )
    )
  )


# Nested Pie Chart
vchart() \%>\% 
  v_pie(
    data = subset(world_electricity, year == 2023 & type == "total"),
    mapping = aes(x = source, y = generation),
    outerRadius = 0.65,
    innerRadius = 0,
    label = list(
      visible = TRUE,
      position = "inside",
      rotate = FALSE,
      style = list(fill = "white")
    ),
    pie = list(
      style = list(
        stroke = "#FFFFFF",
        lineWidth = 2
      )
    )
  ) \%>\% 
  v_pie(
    data = subset(world_electricity, year == 2023 & type == "detail"),
    mapping = aes(x = source, y = generation),
    outerRadius = 0.8,
    innerRadius = 0.67,
    pie = list(
      style = list(
        stroke = "#FFFFFF",
        lineWidth = 2
      )
    )
  ) 
}
